# Copyright (C) 2004-2006, The Perl Foundation.
# $Id: auto.pm 21224 2007-09-12 18:42:55Z paultcochrane $

=head1 NAME

config/gen/cpu/x86_64/auto.pl

=head1 DESCRIPTION

Adds -fPIC to x86_64 (AMD64) ccflags, if necessary.

=cut

package gen::cpu::x86_64::auto;

use strict;
use warnings;

sub runstep {
    my ( $self, $conf ) = @_;

    my $ccflags = $conf->data->get('ccflags');
    $conf->data->add( ' ', ccflags => "-fPIC" ) unless $ccflags =~ /-fPIC/;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
