/* string_funcs.h
 *  Copyright (C) 2001-2003, The Perl Foundation.
 *  SVN Info
 *     $Id: string_primitives.h 19833 2007-07-13 22:02:25Z petdance $
 *  Overview:
 *     This is the api header for the string subsystem
 *  Data Structure and Algorithms:
 *  History:
 *  Notes:
 *  References:
 */

#ifndef PARROT_STRING_PRIMITIVES_H_GUARD
#define PARROT_STRING_PRIMITIVES_H_GUARD

#ifdef PARROT_IN_CORE

/* HEADERIZER BEGIN: src/string_primitives.c */

PARROT_API
UINTVAL Parrot_char_digit_value( SHIM_INTERP, UINTVAL character );

PARROT_API
void string_fill_from_buffer( PARROT_INTERP,
    NOTNULL(const void *buffer),
    UINTVAL len,
    const char *encoding_name,
    NULLOK(STRING *s) )
        __attribute__nonnull__(1)
        __attribute__nonnull__(2);

PARROT_API
void string_set_data_directory( PARROT_INTERP, const char *dir )
        __attribute__nonnull__(1);

PARROT_API
Parrot_UInt4 string_unescape_one( PARROT_INTERP,
    NOTNULL(UINTVAL *offset),
    STRING *string )
        __attribute__nonnull__(1)
        __attribute__nonnull__(2);

/* HEADERIZER END: src/string_primitives.c */

#endif /* PARROT_IN_CORE */
#endif /* PARROT_STRING_PRIMITIVES_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
