'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) send.n 1.18 96/08/27 13:21:47
'\" 
.so man.macros
.TH send n 4.0 Tk "Partially Converted Methods"
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
send \- Execute a command in a different application
.SH SYNOPSIS
$result = \fI$widget\fR->\fBsend\fR(?\fIoptions\fR,?\fIapp\fR=>\fIcmd\fR?\fIarg arg ...\fR?)

.SH DESCRIPTION
This method arranges for \fIcmd\fR (and \fIarg\fRs) to be 'sent' to the
application named by \fIapp\fR.  It returns the result or
an error (hence above should probably be 'wrapped' in \fBeval{}\fR and $@ tested).
\fIApp\fR may be the name of any application whose main window is
on the display containing the sender's main window;  it need not
be within the same process.
If no \fIarg\fR arguments are present, then the string to be sent
is contained entirely within the \fIcmd\fR argument.  If one or
more \fIarg\fRs are present, they are concatenated separated by white space to
form the string to be sent.
.PP
If the initial arguments of the call begin with ``\-''
.VS
they are treated as options.  The following options are
currently defined:
.TP
\fB\-async\fR
Requests asynchronous invocation.  In this case the \fBsend\fR
command will complete immediately without waiting for \fIcmd\fR
to complete in the target application;  no result will be available
and errors in the sent command will be ignored.
If the target application is in the same process as the sending
application then the \fB\-async\fR option is ignored.
.TP
\fB\-\^\-\fR
Serves no purpose except to terminate the list of options.  This
option is needed only if \fIapp\fR could contain a leading ``\-''
character.

.SH "APPLICATION NAMES"
.PP
The name of an application is set initially from the name of the
program or script that created the application.
You can query and change the name of an application with the
\fBappname\fR method.

.SH "WHAT IS A SEND"
The \fBsend\fP mechanism was designed to allow Tcl/Tk applications 
to send Tcl Scripts to each other. This does not map very well onto perl/Tk.
Perl/Tk "sends" a string to \fIapp\fR, what happens as a result of this
depends on the receiving application. If the other application is a Tcl/Tk4.*
application it will be treated as a Tcl Script. If the "other" application is 
perl/Tk application (including sends to self) then the string is 
passed as an argument to a method call of the following form:
.br
\fI$mainwindow\fR->\fBReceive(\fIstring\fR);
.br
There is a default (AutoLoaded) \fBTk::Receive\fR which returns an error to the 
sending application. A particular application may define its own
\fBReceive\fR method in any class in \fBMainWindow\fR's inheritance tree
to do whatever it sees fit. For example it could \fBeval\fR the string,
possibly in a \fBSafe\fR "compartment". 
.PP
If a Tcl/Tk application "sends" anything to a perl/Tk application
then the perl/Tk application would have to attempt to interpret the 
incoming string as a Tcl Script. Simple cases are should not be too hard to
emulate (split on white space and treat first element as "command" and other 
elements as arguments). 

.SH SECURITY
.PP
The \fBsend\fR command is potentially a serious security loophole,
since any application that can connect to your X server can send
scripts to your applications. Hence the default behaviour outlined above.
(With the availability of \fBSafe\fR it may make sense to relax default behaviour
 a little.)
.PP
Unmonitored \fBeval\fR'ing of these incoming "scripts" can cause perl to
read and write files and invoke subprocesses under your name.
Host-based access control such as that provided by \fBxhost\fR
is particularly insecure, since it allows anyone with an account
on particular hosts to connect to your server, and if disabled it
allows anyone anywhere to connect to your server.
In order to provide at least a small amount of
security, core Tk checks the access control being used by the server
and rejects incoming sends unless (a) \fBxhost\fR-style access control
is enabled (i.e. only certain hosts can establish connections) and (b) the
list of enabled hosts is empty.
This means that applications cannot connect to your server unless
they use some other form of authorization
such as that provide by \fBxauth\fR.

.SH "SEE ALSO"
Perl's \fBeval\fP
perl's \fBSafe\fP Module
system's administrator/corporate security guidelines etc.

.SH KEYWORDS
application, name, remote execution, security, send
