'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) place.n 1.9 95/06/07 21:15:30
'\" 
.so man.macros
.TH place n "" Tk "Tk Geometry Management"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
place \- Geometry manager for fixed or rubber-sheet placement
.SH SYNOPSIS
\fI$slave\fR->\fBplace\fR(\fIoption\fR => \fIvalue\fR?,\fIoption\fR => \fIvalue ...\fR?)
.sp
\fI$slave\fR->\fBplaceForget\fR
.sp
\fI$slave\fR->\fBplaceInfo\fR
.sp
\fI$master\fR->\fBplaceSlaves\fR
.BE

.SH DESCRIPTION
.PP
The placer is a geometry manager for Tk.
It provides simple fixed placement of windows, where you specify
the exact size and location of one window, called the \fIslave\fR,
within another window, called the \fImaster\fR.
The placer also provides rubber-sheet placement, where you specify the
size and location of the slave in terms of the dimensions of
the master, so that the slave changes size and location
in response to changes in the size of the master.
Lastly, the placer allows you to mix these styles of placement so
that, for example, the slave has a fixed width and height but is
centered inside the master.
.PP
The \fBplace\fR method arranges for the placer
to manage the geometry of \fI$slave\fR.
The remaining arguments consist of one or more \fIoption\fR => \fIvalue\fR
pairs that specify the way in which \fI$slave\fR's
geometry is managed.
If the placer is already managing \fI$slave\fR, then the
\fIoption\fR => \fIvalue\fR pairs modify the configuration for \fI$slave\fR.
The \fBplace\fR method returns an empty string as result.
The following \fIoption\fR => \fIvalue\fR pairs are supported:
.TP
\fB\-in\fR => \fImaster\fR
\fIMaster\fR specifes the path name of the window relative
to which $widget\fR is to be placed.
\fIMaster\fR must either be $widget\fR's parent or a descendant
of $widget\fR's parent.
In addition, \fImaster\fR and $widget\fR must both be descendants
of the same top-level window.
These restrictions are necessary to guarantee
that $widget\fR is visible whenever \fImaster\fR is visible.
If this option isn't specified then the master defaults to
$widget\fR's parent.
.TP
\fB\-x\fR => \fIlocation\fR
\fILocation\fR specifies the x-coordinate within the master window
of the anchor point for $widget\fR.
The location is specified in screen units (i.e. any of the forms
accepted by \fBTk_GetPixels\fR) and need not lie within the bounds
of the master window.
.TP
\fB\-relx\fR => \fIlocation\fR
\fILocation\fR specifies the x-coordinate within the master window
of the anchor point for $widget\fR.
In this case the location is specified in a relative fashion
as a floating-point number:  0.0 corresponds to the left edge
of the master and 1.0 corresponds to the right edge of the master.
\fILocation\fR need not be in the range 0.0\-1.0.
.VS
If both \fB\-x\fR and \fB\-relx\fR are specified for a slave
then their values are summed.  For example, \fB\-relx 0.5 \-x \-2\fR
positions the left edge of the slave 2 pixels to the left of the
center of its master.
.VE
.TP
\fB\-y\fR => \fIlocation\fR
\fILocation\fR specifies the y-coordinate within the master window
of the anchor point for $widget\fR.
The location is specified in screen units (i.e. any of the forms
accepted by \fBTk_GetPixels\fR) and need not lie within the bounds
of the master window.
.TP
\fB\-rely\fR => \fIlocation\fR
\fILocation\fR specifies the y-coordinate within the master window
of the anchor point for $widget\fR.
In this case the value is specified in a relative fashion
as a floating-point number:  0.0 corresponds to the top edge
of the master and 1.0 corresponds to the bottom edge of the master.
\fILocation\fR need not be in the range 0.0\-1.0.
.VS
If both \fB\-y\fR and \fB\-rely\fR are specified for a slave
then their values are summed.  For example, \fB\-rely 0.5 \-x 3\fR
positions the top edge of the slave 3 pixels below the
center of its master.
.VE
.TP
\fB\-anchor\fR => \fIwhere\fR
\fIWhere\fR specifies which point of $widget\fR is to be positioned
at the (x,y) location selected by the \fB\-x\fR, \fB\-y\fR,
\fB\-relx\fR, and \fB\-rely\fR options.
The anchor point is in terms of the outer area of $widget\fR
including its border, if any.
Thus if \fIwhere\fR is \fBse\fR then the lower-right corner of
$widget\fR's border will appear at the given (x,y) location
in the master.
The anchor position defaults to \fBnw\fR.
.TP
\fB\-width\fR => \fIsize\fR
\fISize\fR specifies the width for $widget\fR in screen units
(i.e. any of the forms accepted by \fBTk_GetPixels\fR).
The width will be the outer width of $widget\fR including its
border, if any.
If \fIsize\fR is an empty string, or if no \fB\-width\fR
or \fB\-relwidth\fR option is specified, then the width requested
internally by the window will be used.
.TP
\fB\-relwidth\fR => \fIsize\fR
\fISize\fR specifies the width for $widget\fR.
In this case the width is specified as a floating-point number
relative to the width of the master: 0.5 means $widget\fR will
be half as wide as the master, 1.0 means $widget\fR will have
the same width as the master, and so on.
.VS
If both \fB\-width\fR and \fB\-relwidth\fR are specified for a slave,
their values are summed.  For example, \fB\-relwidth 1.0 \-width 5\fR
makes the slave 5 pixels wider than the master.
.VE
.TP
\fB\-height\fR => \fIsize\fR
\fISize\fR specifies the height for $widget\fR in screen units
(i.e. any of the forms accepted by \fBTk_GetPixels\fR).
The height will be the outer dimension of $widget\fR including its
border, if any.
If \fIsize\fR is an empty string, or if no \fB\-height\fR or
\fB\-relheight\fR option is specified, then the height requested
internally by the window will be used.
.TP
\fB\-relheight\fR => \fIsize\fR
\fISize\fR specifies the height for $widget\fR.
In this case the height is specified as a floating-point number
relative to the height of the master: 0.5 means $widget\fR will
be half as high as the master, 1.0 means $widget\fR will have
the same height as the master, and so on.
.VS
If both \fB\-height\fR and \fB\-relheight\fR are specified for a slave,
their values are summed.  For example, \fB\-relheight 1.0 \-height \-2\fR
makes the slave 2 pixels shorter than the master.
.VE
.TP
\fB\-bordermode\fR => \fImode\fR
\fIMode\fR determines the degree to which borders within the
master are used in determining the placement of the slave.
The default and most common value is \fBinside\fR.
In this case the placer considers the area of the master to
be the innermost area of the master, inside any border:
an option of \fB\-x 0\fR corresponds to an x-coordinate just
inside the border and an option of \fB\-relwidth 1.0\fR
means $widget\fR will fill the area inside the master's
border.
If \fImode\fR is \fBoutside\fR then the placer considers
the area of the master to include its border;
this mode is typically used when placing $widget\fR
outside its master, as with the options \fB\-x 0 \-y 0 \-anchor ne\fR.
Lastly, \fImode\fR may be specified as \fBignore\fR, in which
case borders are ignored:  the area of the master is considered
to be its official X area, which includes any internal border but
no external border.  A bordermode of \fBignore\fR is probably
not very useful.
.PP
If the same value is specified separately with
two different options, such as \fB\-x\fR and \fB\-relx\fR, then
the most recent option is used and the older one is ignored.
.PP
The \fBplaceSlaves\fR method returns a list of all the slave
windows for which \fI$master\fR is the master.
If there are no slaves for \fI$master\fR then an empty list is
returned.
.PP
The \fBplaceForget\fR method causes the placer to stop managing
the geometry of \fI$slave\fR.  As a side effect of this command
\fI$slave\fR will be unmapped so that it doesn't appear on the
screen.
If \fI$slave\fR isn't currently managed by the placer then the
command has no effect.
\fBplaceForget\fR returns an empty string as result.
.PP
The \fBplaceInfo\fR method returns a list giving the current
configuration of \fI$slave\fR.
The list consists of \fIoption\fR=>\fIvalue\fR pairs in exactly the
same form as might be specified to the \fBplace\fR
command.
If the configuration of a window has been retrieved with
\fBplaceInfo\fR, that configuration can be restored later by
first using \fBplaceForget\fR to erase any existing information
for the window and then invoking \fBplace\fR with
the saved information.

.SH "FINE POINTS"
.PP
It is not necessary for the master window to be the parent
of the slave window.
This feature is useful in at least two situations.
First, for complex window layouts it means you can create a
hierarchy of subwindows whose only purpose
is to assist in the layout of the parent.
The ``real children'' of the parent (i.e. the windows that
are significant for the application's user interface) can be
children of the parent yet be placed inside the windows
of the geometry-management hierarchy.
This means that the path names of the ``real children''
don't reflect the geometry-management hierarchy and users
can specify options for the real children
without being aware of the structure of the geometry-management
hierarchy.
.PP
A second reason for having a master different than the slave's
parent is to tie two siblings together.
For example, the placer can be used to force a window always to
be positioned centered just below one of its
siblings by specifying the configuration
.DS C
\fB\-in \fIsibling\fB \-relx 0.5 \-rely 1.0 \-anchor n \-bordermode outside\fR
.DE
Whenever the sibling is repositioned in the future, the slave
will be repositioned as well.
.PP
Unlike many other geometry managers (such as the packer)
the placer does not make any attempt to manipulate the geometry of
the master windows or the parents of slave windows (i.e. it doesn't
set their requested sizes).
To control the sizes of these windows, make them windows like
frames and canvases that provide configuration options for this purpose.

.SH KEYWORDS
geometry manager, height, location, master, place, rubber sheet, slave, width
