#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

/* op_free is both Perl_op_free and a function in opusfile */
#undef op_free
#include <opus/opusfile.h>

#include "const-c.inc"

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile		PREFIX = op_

PROTOTYPES: ENABLE
INCLUDE: const-xs.inc

OggOpusFile*
op_open_file(path)
	const char *path;
PREINIT:
	int err;
CODE:
	RETVAL = op_open_file(path, &err);
	if(err)
		croak("op_open_file returned error %d\n", err);
OUTPUT:
	RETVAL

void
DESTROY(of)
	OggOpusFile *of;
CODE:
	op_free(of);

const OpusHead*
op_head(of, li = -1)
	OggOpusFile *of;
	int li;

const OpusTags*
op_tags(of, li = -1)
	OggOpusFile *of;
	int li;

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile::Tags		PREFIX = opus_tags_

int
opus_tags_query_count(tags, tag)
	const OpusTags* tags;
	const char* tag;

const char*
opus_tags_query(tags, tag, count = 0)
	const OpusTags* tags;
	const char* tag;
	int count;

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile::PictureTag		PREFIX = opus_picture_tag_

const OpusPictureTag*
opus_picture_tag_parse(tag)
	const char *tag;
PREINIT:
	OpusPictureTag *pic;
	int err;
CODE:
	Newx(pic, 1, OpusPictureTag);
	if(err = opus_picture_tag_parse(pic, tag))
		croak("opus_picture_tag_parse returned error %d\n", err);
	RETVAL = pic;
OUTPUT:
	RETVAL

void
DESTROY(pic)
	const OpusPictureTag* pic
CODE:
	Safefree(pic);

int
type(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->type;
OUTPUT:
	RETVAL

const char*
mime_type(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->mime_type;
OUTPUT:
	RETVAL

const char*
description(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->description;
OUTPUT:
	RETVAL

int
width(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->width;
OUTPUT:
	RETVAL

int
height(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->height;
OUTPUT:
	RETVAL

int
depth(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->depth;
OUTPUT:
	RETVAL

int
colors(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->colors;
OUTPUT:
	RETVAL

int
data_length(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->data_length;
OUTPUT:
	RETVAL

SV*
data(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = newSVpvn(pic->data, pic->data_length);
OUTPUT:
	RETVAL

int
format(pic)
	const OpusPictureTag *pic;
CODE:
	RETVAL = pic->format;
OUTPUT:
	RETVAL

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile::Head

int
version(head)
	const OpusHead* head;
CODE:
	RETVAL = head->version;
OUTPUT:
	RETVAL

int
channel_count(head)
	const OpusHead* head;
CODE:
	RETVAL = head->channel_count;
OUTPUT:
	RETVAL

unsigned
pre_skip(head)
	const OpusHead* head;
CODE:
	RETVAL = head->pre_skip;
OUTPUT:
	RETVAL

unsigned
input_sample_rate(head)
	const OpusHead* head;
CODE:
	RETVAL = head->input_sample_rate;
OUTPUT:
	RETVAL

int
mapping_family(head)
	const OpusHead* head;
CODE:
	RETVAL = head->mapping_family;
OUTPUT:
	RETVAL

int
stream_count(head)
	const OpusHead* head;
CODE:
	RETVAL = head->stream_count;
OUTPUT:
	RETVAL

int
coupled_count(head)
	const OpusHead* head;
CODE:
	RETVAL = head->coupled_count;
OUTPUT:
	RETVAL

int
mapping(head, k)
	const OpusHead* head;
	int k;
CODE:
	RETVAL = (int) head->mapping[k];
OUTPUT:
	RETVAL
