use strict;
package Mail::Box::Tie::HASH;
our $VERSION = 2.029;  # Part of Mail::Box

use Carp;

sub TIEHASH(@)
{   my ($class, $folder) = @_;
    croak "No folder specified to tie to."
        unless ref $folder && $folder->isa('Mail::Box');

    bless { MBT_folder => $folder, MBT_type => 'HASH' }, $class;
}

sub FETCH($) { shift->{MBT_folder}->messageId(shift) }

sub STORE($$)
{   my ($self, $key, $basicmsg) = @_;

    carp "Use undef as key, because the message-id of the message is used."
        if defined $key && $key ne 'undef';

    $self->{MBT_folder}->addMessages($basicmsg);
}

sub FIRSTKEY()
{   my $self   = shift;
    my $folder = $self->{MBT_folder};

    $self->{MBT_each_index} = 0;
    $self->NEXTKEY();
}

sub NEXTKEY($)
{   my $self   = shift;
    my $folder = $self->{MBT_folder};
    my $nrmsgs = $folder->messages;

    my $msg;
    while(1)
    {   my $index = $self->{MBT_each_index}++;
        return undef if $index >= $nrmsgs;

        $msg      = $folder->message($index);
        last unless $msg->deleted;
    }

    $msg->messageId;
}

sub EXISTS($)
{   my $folder = shift->{MBT_folder};
    my $msgid  = shift;
    my $msg    = $folder->messageId($msgid);
    defined $msg && ! $msg->deleted;
}

sub DELETE($)
{    my ($self, $msgid) = @_;
     $self->{MBT_folder}->messageId($msgid)->delete;
}

sub CLEAR()
{   my $folder = shift->{MBT_folder};
    $_->delete foreach $folder->messages;
}

1;
