#!/usr/bin/perl -w

# Copyright 2010 Kevin Ryde

# This file is part of Math-Image.
#
# Math-Image is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-Image is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-Image.  If not, see <http://www.gnu.org/licenses/>.

use 5.010;
use strict;
use warnings;

use Smart::Comments;

{
  require Image::Xpm;
  require App::MathImage::Image::Base::Other;
  my $image = Image::Xpm->new (-width => 50,
                               -height => 2);
  $image->line (0,0, 6,1, '#FFFF0000FFFF');
  print App::MathImage::Image::Base::Other::save_string($image);
  exit 0;
}

{
  require Image::Xpm;
  require App::MathImage::Image::Base::Other;
  my $image = Image::Xpm->new
    (-file => '/usr/share/emacs/22.3/etc/images/gud/up.xpm');
  $image->line (0,0, 6,1, 'orange');
  print App::MathImage::Image::Base::Other::save_string($image);
  exit 0;
}
