# Copyright 2015 Kevin Ryde

# This file is part of Test-VariousBits.
#
# Test-VariousBits is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 3, or (at your option) any
# later version.
#
# Test-VariousBits is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with Test-VariousBits.  If not, see <http://www.gnu.org/licenses/>.


package Test::VariousBits;
use vars '$VERSION';
$VERSION = 5;

1;
__END__

=for stopwords Ryde Test-VariousBits

=head1 NAME

Test::VariousBits - some various test modules

=head1 DESCRIPTION

This is a dist placeholder module for a collection of test modules.

=over

=item *

C<Module::Util::Masked> -- have C<Module::Util> recognise module masking

=item *

C<Test::Weaken::ExtraBits> -- various extras for C<Test::Weaken>

=item *

C<Test::Without::GD> -- pretend some C<GD> file formats not available

=item *

C<Test::Without::Shm> -- pretend C<shmget()> etc not available

=back

=head1 SEE ALSO

L<Module::Util::Masked>,
L<Test::Weaken::ExtraBits>,
L<Test::Without::GD>,
L<Test::Without::Shm>

=head1 HOME PAGE

L<http://user42.tuxfamily.org/test-variousbits/index.html>

=head1 COPYRIGHT

Copyright 2015 Kevin Ryde

Test-VariousBits is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 3, or (at your option) any
later version.

Test-VariousBits is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with Test-VariousBits.  If not, see L<http://www.gnu.org/licenses/>.

=cut
