#!/usr/bin/perl -w

# Copyright 2010 Kevin Ryde

# This file is part of Gtk2-Ex-WidgetBits.
#
# Gtk2-Ex-WidgetBits is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Gtk2-Ex-WidgetBits is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Gtk2-Ex-WidgetBits.  If not, see <http://www.gnu.org/licenses/>.

use 5.008;
use strict;
use warnings;
use Gtk2::Ex::TreeModel::ImplBits 'random_stamp';
use Test::More tests => 100;

use lib 't';
use MyTestHelpers;
MyTestHelpers::nowarnings();

{
  my $obj = {};
  foreach (1 .. 50) {
    my $old = $obj->{'stamp'};
    random_stamp($obj);
    cmp_ok ($obj->{'stamp'}, '>=', 1);
    isnt ($obj->{'stamp'}, $old, 'random_stamp() different from old');
  }
}

exit 0;
