#-----------------------------------------------------------------------
# Copyright (C) 2001-2003 Jrn Reder <joern AT zyn.de>.
# All Rights Reserved. See file COPYRIGHT for details.
# 
# This program is part of Video::DVDRip, which is free software; you can
# redistribute it and/or modify it under the same terms as Perl itself.
#-----------------------------------------------------------------------

package Video::DVDRip;

$VERSION = "0.50.10";

use base Video::DVDRip::Base;

use Carp;
use FileHandle;
require 5.006;

%Video::DVDRip::container_formats = (
	'avi'       => "AVI",
	'ogg'       => "OGG",
	'vcd'       => "(S)VCD",
);

%Video::DVDRip::deinterlace_filters = (
	0          => "No deinterlacing",
	1          => "Interpolate scanlines (fast)",
	2          => "Handled by encoder (may segfault)",
	3          => "Zoom to full frame (slow)",
	'32detect' => "Automatic deinterlacing of single frames",
	'smart'    => "Smart deinterlacing",
);

%Video::DVDRip::antialias_filters = (
	0 => "No antialiasing",
	1 => "Process de-interlace effects",
	2 => "Process resize effects",
	3 => "Process full frame (slow)",
);

%Video::DVDRip::audio_filters = (
	'rescale'   => "None, volume rescale only",
	'a52drc'    => "Range compression (liba52 filter)",
	'normalize' => "Normalizing (mplayer filter)",
);

$Video::DVDRIP::scratch_width   = 1024;
$Video::DVDRIP::scratch_height  = 768;

1;

__END__

=head1 NAME

Video::DVDRip - GUI for copying DVDs, based on an open Low Level API

=head1 DESCRIPTION

This Perl module consists currently of two major components:

  1. A low level OO style API for ripping and transcoding
     DVD video, which is based on Thomas Oestreichs program
     transcode, a Linux Video Stream Processing Tool.
     This API is currently well undocumented.

  2. A Gtk+ based Perl program called 'dvd::rip' which provides
     a nice GUI to control all necessary steps from ripping,
     adjusting all parameters and transcoding the video to
     the format you desire.

The distribution name is derived from the Perl namespace it occupies:
Video::DVDRip. Although the DVD Ripper GUI is called dvd::rip, because
it's shorter and easier to pronounce (if you omit the colons... ;)

You'll find all information regarding installation and usage of
dvd::rip in the README file shipped with the distribution or
on the dvd::rip homepage:

  http://www.exit1.org/dvdrip/

=head1 COPYRIGHT

Copyright (C) 2001-2002 by Joern Reder, All Rights Reserved.

This library is free software; you can redistribute it
and/or modify it under the same terms as Perl itself.

=head1 SEE ALSO

perl(1).

=cut
