package CDN::Edgecast::Client::auto::Reporting::Type::Directory;
BEGIN {
  $CDN::Edgecast::Client::auto::Reporting::Type::Directory::VERSION = '0.01.00';
}
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'EC:WebServices' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %strDirName_of :ATTR(:get<strDirName>);
my %lngBytes_of :ATTR(:get<lngBytes>);
my %lngAvgDuration_of :ATTR(:get<lngAvgDuration>);
my %lngHits_of :ATTR(:get<lngHits>);

__PACKAGE__->_factory(
    [ qw(        strDirName
        lngBytes
        lngAvgDuration
        lngHits

    ) ],
    {
        'strDirName' => \%strDirName_of,
        'lngBytes' => \%lngBytes_of,
        'lngAvgDuration' => \%lngAvgDuration_of,
        'lngHits' => \%lngHits_of,
    },
    {
        'strDirName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'lngBytes' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'lngAvgDuration' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'lngHits' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'strDirName' => 'strDirName',
        'lngBytes' => 'lngBytes',
        'lngAvgDuration' => 'lngAvgDuration',
        'lngHits' => 'lngHits',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

CDN::Edgecast::Client::auto::Reporting::Type::Directory

=head1 VERSION

version 0.01.00

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Directory from the namespace EC:WebServices.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * strDirName


=item * lngBytes


=item * lngAvgDuration


=item * lngHits




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # CDN::Edgecast::Client::auto::Reporting::Type::Directory
   strDirName =>  $some_value, # string
   lngBytes =>  $some_value, # long
   lngAvgDuration =>  $some_value, # long
   lngHits =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut