#############################################################
# This file was automatically generated on 2019-08-23.      #
#                                                           #
# Perl Bindings Version 2.1.24                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletCANV2 - Communicates with CAN bus devices

=cut

package Tinkerforge::BrickletCANV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a CAN Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2107;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a CAN Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'CAN Bricklet 2.0';

=item CALLBACK_FRAME_READ_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_READ_LOW_LEVEL callback.

=cut

use constant CALLBACK_FRAME_READ_LOW_LEVEL => 16;

=item CALLBACK_FRAME_READ

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_READ callback.

=cut

use constant CALLBACK_FRAME_READ => -16;

=item FUNCTION_WRITE_FRAME_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FRAME_LOW_LEVEL => 1;

=item FUNCTION_READ_FRAME_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_FRAME_LOW_LEVEL => 2;

=item FUNCTION_SET_FRAME_READ_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_READ_CALLBACK_CONFIGURATION => 3;

=item FUNCTION_GET_FRAME_READ_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_READ_CALLBACK_CONFIGURATION => 4;

=item FUNCTION_SET_TRANSCEIVER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TRANSCEIVER_CONFIGURATION => 5;

=item FUNCTION_GET_TRANSCEIVER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TRANSCEIVER_CONFIGURATION => 6;

=item FUNCTION_SET_QUEUE_CONFIGURATION_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_QUEUE_CONFIGURATION_LOW_LEVEL => 7;

=item FUNCTION_GET_QUEUE_CONFIGURATION_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_QUEUE_CONFIGURATION_LOW_LEVEL => 8;

=item FUNCTION_SET_READ_FILTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_READ_FILTER_CONFIGURATION => 9;

=item FUNCTION_GET_READ_FILTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_READ_FILTER_CONFIGURATION => 10;

=item FUNCTION_GET_ERROR_LOG_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_LOG_LOW_LEVEL => 11;

=item FUNCTION_SET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COMMUNICATION_LED_CONFIG => 12;

=item FUNCTION_GET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COMMUNICATION_LED_CONFIG => 13;

=item FUNCTION_SET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ERROR_LED_CONFIG => 14;

=item FUNCTION_GET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_LED_CONFIG => 15;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant FRAME_TYPE_STANDARD_DATA => 0;
use constant FRAME_TYPE_STANDARD_REMOTE => 1;
use constant FRAME_TYPE_EXTENDED_DATA => 2;
use constant FRAME_TYPE_EXTENDED_REMOTE => 3;
use constant TRANSCEIVER_MODE_NORMAL => 0;
use constant TRANSCEIVER_MODE_LOOPBACK => 1;
use constant TRANSCEIVER_MODE_READ_ONLY => 2;
use constant FILTER_MODE_ACCEPT_ALL => 0;
use constant FILTER_MODE_MATCH_STANDARD_ONLY => 1;
use constant FILTER_MODE_MATCH_EXTENDED_ONLY => 2;
use constant FILTER_MODE_MATCH_STANDARD_AND_EXTENDED => 3;
use constant TRANSCEIVER_STATE_ACTIVE => 0;
use constant TRANSCEIVER_STATE_PASSIVE => 1;
use constant TRANSCEIVER_STATE_DISABLED => 2;
use constant COMMUNICATION_LED_CONFIG_OFF => 0;
use constant COMMUNICATION_LED_CONFIG_ON => 1;
use constant COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION => 3;
use constant ERROR_LED_CONFIG_OFF => 0;
use constant ERROR_LED_CONFIG_ON => 1;
use constant ERROR_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant ERROR_LED_CONFIG_SHOW_TRANSCEIVER_STATE => 3;
use constant ERROR_LED_CONFIG_SHOW_ERROR => 4;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_WRITE_FRAME_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_FRAME_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_READ_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_READ_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TRANSCEIVER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TRANSCEIVER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_QUEUE_CONFIGURATION_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_QUEUE_CONFIGURATION_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_READ_FILTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_READ_FILTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_LOG_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_FRAME_READ_LOW_LEVEL} = 'C L C C15';

	$self->{high_level_callbacks}->{&CALLBACK_FRAME_READ} = shared_clone([shared_clone({stream_length => 2, stream_chunk_data => 3}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 1}), undef]);

	bless($self, $class);

	return $self;
}


=item write_frame_low_level()

Writes a data or remote frame to the write queue to be transmitted over the
CAN transceiver.

The Bricklet supports the standard 11-bit (CAN 2.0A) and the additional extended
29-bit (CAN 2.0B) identifiers. For standard frames the Bricklet uses bit 0 to 10
from the ``identifier`` parameter as standard 11-bit identifier. For extended
frames the Bricklet uses bit 0 to 28 from the ``identifier`` parameter as
extended 29-bit identifier.

The ``data`` parameter can be up to 15 bytes long. For data frames up to 8 bytes
will be used as the actual data. The length (DLC) field in the data or remote
frame will be set to the actual length of the ``data`` parameter. This allows
to transmit data and remote frames with excess length. For remote frames only
the length of the ``data`` parameter is used. The actual ``data`` bytes are
ignored.

Returns *true* if the frame was successfully added to the write queue. Returns
*false* if the frame could not be added because write queue is already full or
because the write buffer or the write backlog are configured with a size of
zero (see :func:`Set Queue Configuration`).

The write queue can overflow if frames are written to it at a higher rate
than the Bricklet can transmitted them over the CAN transceiver. This may
happen if the CAN transceiver is configured as read-only or is using a low baud
rate (see :func:`Set Transceiver Configuration`). It can also happen if the CAN
bus is congested and the frame cannot be transmitted because it constantly loses
arbitration or because the CAN transceiver is currently disabled due to a high
write error level (see :func:`Get Error Log`).

=cut

sub write_frame_low_level
{
	my ($self, $frame_type, $identifier, $data_length, $data_data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FRAME_LOW_LEVEL, [$frame_type, $identifier, $data_length, $data_data], 'C L C C15', '?');
}

=item read_frame_low_level()

Tries to read the next data or remote frame from the read queue and returns it.
If a frame was successfully read, then the ``success`` return value is set to
*true* and the other return values contain the frame. If the read queue is
empty and no frame could be read, then the ``success`` return value is set to
*false* and the other return values contain invalid data.

The ``identifier`` return value follows the identifier format described for
:func:`Write Frame`.

The ``data`` return value can be up to 15 bytes long. For data frames up to the
first 8 bytes are the actual received data. All bytes after the 8th byte are
always zero and only there to indicate the length of a data or remote frame
with excess length. For remote frames the length of the ``data`` return value
represents the requested length. The actual ``data`` bytes are always zero.

A configurable read filter can be used to define which frames should be
received by the CAN transceiver and put into the read queue (see
:func:`Set Read Filter Configuration`).

Instead of polling with this function, you can also use callbacks. See the
:func:`Set Frame Read Callback Configuration` function and the :cb:`Frame Read`
callback.

=cut

sub read_frame_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_FRAME_LOW_LEVEL, [], '', '? C L C C15');
}

=item set_frame_read_callback_configuration()

Enables and disables the :cb:`Frame Read` callback.

By default the callback is disabled.

=cut

sub set_frame_read_callback_configuration
{
	my ($self, $enabled) = @_;

	$self->_send_request(&FUNCTION_SET_FRAME_READ_CALLBACK_CONFIGURATION, [$enabled], '?', '');
}

=item get_frame_read_callback_configuration()

Returns *true* if the :cb:`Frame Read` callback is enabled, *false* otherwise.

=cut

sub get_frame_read_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_FRAME_READ_CALLBACK_CONFIGURATION, [], '', '?');
}

=item set_transceiver_configuration()

Sets the transceiver configuration for the CAN bus communication.

The baud rate can be configured in bit/s between 10 and 1000 kbit/s and the
sample point can be configured in 1/10 % between 50 and 90 %.

The CAN transceiver has three different modes:

* Normal: Reads from and writes to the CAN bus and performs active bus
  error detection and acknowledgement.
* Loopback: All reads and writes are performed internally. The transceiver
  is disconnected from the actual CAN bus.
* Read-Only: Only reads from the CAN bus, but does neither active bus error
  detection nor acknowledgement. Only the receiving part of the transceiver
  is connected to the CAN bus.

The default is: 125 kbit/s, 62.5 % and normal transceiver mode.

=cut

sub set_transceiver_configuration
{
	my ($self, $baud_rate, $sample_point, $transceiver_mode) = @_;

	$self->_send_request(&FUNCTION_SET_TRANSCEIVER_CONFIGURATION, [$baud_rate, $sample_point, $transceiver_mode], 'L S C', '');
}

=item get_transceiver_configuration()

Returns the configuration as set by :func:`Set Transceiver Configuration`.

=cut

sub get_transceiver_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TRANSCEIVER_CONFIGURATION, [], '', 'L S C');
}

=item set_queue_configuration_low_level()

Sets the write and read queue configuration.

The CAN transceiver has 32 buffers in total in hardware for transmitting and
receiving frames. Additionally, the Bricklet has a backlog for 768 frames in
total in software. The buffers and the backlog can be freely assigned to the
write and read queues.

:func:`Write Frame` writes a frame into the write backlog. The Bricklet moves
the frame from the backlog into a free write buffer. The CAN transceiver then
transmits the frame from the write buffer to the CAN bus. If there are no
write buffers (``write_buffer_size`` is zero) or there is no write backlog
(``write_backlog_size`` is zero) then no frames can be transmitted and
:func:`Write Frame` returns always *false*.

The CAN transceiver receives a frame from the CAN bus and stores it into a
free read buffer. The Bricklet moves the frame from the read buffer into the
read backlog. :func:`Read Frame` reads the frame from the read backlog and
returns it. If there are no read buffers (``read_buffer_sizes`` is empty) or
there is no read backlog (``read_backlog_size`` is zero) then no frames can be
received and :func:`Read Frame` returns always *false*.

There can be multiple read buffers, because the CAN transceiver cannot receive
data and remote frames into the same read buffer. A positive read buffer size
represents a data frame read buffer and a negative read buffer size represents
a remote frame read buffer. A read buffer size of zero is not allowed. By
default the first read buffer is configured for data frames and the second read
buffer is configured for remote frame. There can be up to 32 different read
buffers, assuming that no write buffer is used. Each read buffer has its own
filter configuration (see :func:`Set Read Filter Configuration`).

A valid queue configuration fulfills these conditions::

 write_buffer_size + read_buffer_size_0 + read_buffer_size_1 + ... + read_buffer_size_31 <= 32
 write_backlog_size + read_backlog_size <= 768

The write buffer timeout has three different modes that define how a failed
frame transmission should be handled:

* Single-Shot (< 0): Only one transmission attempt will be made. If the
  transmission fails then the frame is discarded.
* Infinite (= 0): Infinite transmission attempts will be made. The frame will
  never be discarded.
* Milliseconds (> 0): A limited number of transmission attempts will be made.
  If the frame could not be transmitted successfully after the configured
  number of milliseconds then the frame is discarded.

The current content of the queues is lost when this function is called.

The default is:

* 8 write buffers,
* infinite write timeout,
* 383 write backlog frames,
* 16 read buffers for data frames,
* 8 read buffers for remote frames and
* 383 read backlog frames.

=cut

sub set_queue_configuration_low_level
{
	my ($self, $write_buffer_size, $write_buffer_timeout, $write_backlog_size, $read_buffer_sizes_length, $read_buffer_sizes_data, $read_backlog_size) = @_;

	$self->_send_request(&FUNCTION_SET_QUEUE_CONFIGURATION_LOW_LEVEL, [$write_buffer_size, $write_buffer_timeout, $write_backlog_size, $read_buffer_sizes_length, $read_buffer_sizes_data, $read_backlog_size], 'C l S C c32 S', '');
}

=item get_queue_configuration_low_level()

Returns the queue configuration as set by :func:`Set Queue Configuration`.

=cut

sub get_queue_configuration_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_QUEUE_CONFIGURATION_LOW_LEVEL, [], '', 'C l S C c32 S');
}

=item set_read_filter_configuration()

Set the read filter configuration for the given read buffer index. This can be
used to define which frames should be received by the CAN transceiver and put
into the read buffer.

The read filter has four different modes that define if and how the filter mask
and the filter identifier are applied:

* Accept-All: All frames are received.
* Match-Standard-Only: Only standard frames with a matching identifier are
  received.
* Match-Extended-Only: Only extended frames with a matching identifier are
  received.
* Match-Standard-And-Extended: Standard and extended frames with a matching
  identifier are received.

The filter mask and filter identifier are used as bit masks. Their usage
depends on the mode:

* Accept-All: Mask and identifier are ignored.
* Match-Standard-Only: Bit 0 to 10 (11 bits) of filter mask and filter
  identifier are used to match the 11-bit identifier of standard frames.
* Match-Extended-Only: Bit 0 to 28 (29 bits) of filter mask and filter
  identifier are used to match the 29-bit identifier of extended frames.
* Match-Standard-And-Extended: Bit 18 to 28 (11 bits) of filter mask and filter
  identifier are used to match the 11-bit identifier of standard frames, bit 0
  to 17 (18 bits) are ignored in this case. Bit 0 to 28 (29 bits) of filter
  mask and filter identifier are used to match the 29-bit identifier of extended
  frames.

The filter mask and filter identifier are applied in this way: The filter mask
is used to select the frame identifier bits that should be compared to the
corresponding filter identifier bits. All unselected bits are automatically
accepted. All selected bits have to match the filter identifier to be accepted.
If all bits for the selected mode are accepted then the frame is accepted and
is added to the read buffer.

.. csv-table::
 :header: "Filter Mask Bit", "Filter Identifier Bit", "Frame Identifier Bit", "Result"
 :widths: 10, 10, 10, 10

 0, X, X, Accept
 1, 0, 0, Accept
 1, 0, 1, Reject
 1, 1, 0, Reject
 1, 1, 1, Accept

For example, to receive standard frames with identifier 0x123 only, the mode
can be set to Match-Standard-Only with 0x7FF as mask and 0x123 as identifier.
The mask of 0x7FF selects all 11 identifier bits for matching so that the
identifier has to be exactly 0x123 to be accepted.

To accept identifier 0x123 and identifier 0x456 at the same time, just set
filter 2 to 0x456 and keep mask and filter 1 unchanged.

There can be up to 32 different read filters configured at the same time,
because there can be up to 32 read buffer (see :func:`Set Queue Configuration`).

The default mode is accept-all for all read buffers.

=cut

sub set_read_filter_configuration
{
	my ($self, $buffer_index, $filter_mode, $filter_mask, $filter_identifier) = @_;

	$self->_send_request(&FUNCTION_SET_READ_FILTER_CONFIGURATION, [$buffer_index, $filter_mode, $filter_mask, $filter_identifier], 'C C L L', '');
}

=item get_read_filter_configuration()

Returns the read filter configuration as set by :func:`Set Read Filter Configuration`.

=cut

sub get_read_filter_configuration
{
	my ($self, $buffer_index) = @_;

	return $self->_send_request(&FUNCTION_GET_READ_FILTER_CONFIGURATION, [$buffer_index], 'C', 'C L L');
}

=item get_error_log_low_level()

Returns information about different kinds of errors.

The write and read error levels indicate the current level of stuffing, form,
acknowledgement, bit and checksum errors during CAN bus write and read
operations. For each of this error kinds there is also an individual counter.

When the write error level extends 255 then the CAN transceiver gets disabled
and no frames can be transmitted or received anymore. The CAN transceiver will
automatically be activated again after the CAN bus is idle for a while.

The write buffer timeout, read buffer and backlog overflow counts represents the
number of these errors:

* A write buffer timeout occurs if a frame could not be transmitted before the
  configured write buffer timeout expired (see :func:`Set Queue Configuration`).
* A read buffer overflow occurs if a read buffer of the CAN transceiver
  still contains the last received frame when the next frame arrives. In this
  case the last received frame is lost. This happens if the CAN transceiver
  receives more frames than the Bricklet can handle. Using the read filter
  (see :func:`Set Read Filter Configuration`) can help to reduce the amount of
  received frames. This count is not exact, but a lower bound, because the
  Bricklet might not able detect all overflows if they occur in rapid succession.
* A read backlog overflow occurs if the read backlog of the Bricklet is already
  full when the next frame should be read from a read buffer of the CAN
  transceiver. In this case the frame in the read buffer is lost. This
  happens if the CAN transceiver receives more frames to be added to the read
  backlog than are removed from the read backlog using the :func:`Read Frame`
  function. Using the :cb:`Frame Read` callback ensures that the read backlog
  can not overflow.

The read buffer overflow counter counts the overflows of all configured read
buffers. Which read buffer exactly suffered from an overflow can be figured
out from the read buffer overflow occurrence list
(``read_buffer_overflow_error_occurred``).

=cut

sub get_error_log_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ERROR_LOG_LOW_LEVEL, [], '', 'C C C L L L L L L L L C ?32 L');
}

=item set_communication_led_config()

Sets the communication LED configuration. By default the LED shows
CAN-Bus traffic, it flickers once for every 40 transmitted or received frames.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_communication_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_COMMUNICATION_LED_CONFIG, [$config], 'C', '');
}

=item get_communication_led_config()

Returns the configuration as set by :func:`Set Communication LED Config`

=cut

sub get_communication_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_COMMUNICATION_LED_CONFIG, [], '', 'C');
}

=item set_error_led_config()

Sets the error LED configuration.

By default (show-transceiver-state) the error LED turns on if the CAN
transceiver is passive or disabled state (see :func:`Get Error Log`). If
the CAN transceiver is in active state the LED turns off.

If the LED is configured as show-error then the error LED turns on if any error
occurs. If you call this function with the show-error option again, the LED will
turn off until the next error occurs.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_error_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_ERROR_LED_CONFIG, [$config], 'C', '');
}

=item get_error_led_config()

Returns the configuration as set by :func:`Set Error LED Config`.

=cut

sub get_error_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ERROR_LED_CONFIG, [], '', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item write_frame()

Writes a data or remote frame to the write queue to be transmitted over the
CAN transceiver.

The Bricklet supports the standard 11-bit (CAN 2.0A) and the additional extended
29-bit (CAN 2.0B) identifiers. For standard frames the Bricklet uses bit 0 to 10
from the ``identifier`` parameter as standard 11-bit identifier. For extended
frames the Bricklet uses bit 0 to 28 from the ``identifier`` parameter as
extended 29-bit identifier.

The ``data`` parameter can be up to 15 bytes long. For data frames up to 8 bytes
will be used as the actual data. The length (DLC) field in the data or remote
frame will be set to the actual length of the ``data`` parameter. This allows
to transmit data and remote frames with excess length. For remote frames only
the length of the ``data`` parameter is used. The actual ``data`` bytes are
ignored.

Returns *true* if the frame was successfully added to the write queue. Returns
*false* if the frame could not be added because write queue is already full or
because the write buffer or the write backlog are configured with a size of
zero (see :func:`Set Queue Configuration`).

The write queue can overflow if frames are written to it at a higher rate
than the Bricklet can transmitted them over the CAN transceiver. This may
happen if the CAN transceiver is configured as read-only or is using a low baud
rate (see :func:`Set Transceiver Configuration`). It can also happen if the CAN
bus is congested and the frame cannot be transmitted because it constantly loses
arbitration or because the CAN transceiver is currently disabled due to a high
write error level (see :func:`Get Error Log`).

=cut

sub write_frame
{
    my ($self, $frame_type, $identifier, $data) = @_;
    my $data_length = scalar(@{$data});
    my $data_data = [];

    push(@{$data_data}, @{$data}); # copy so we can potentially extend it

    if($data_length > 15)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Data can be at most 15 items long'));
    }

    if($data_length < 15)
    {
        push(@{$data_data}, (0) x (15 - $data_length));
    }

    return $self->write_frame_low_level($frame_type, $identifier, $data_length, $data_data);
}

=item read_frame()

Tries to read the next data or remote frame from the read queue and returns it.
If a frame was successfully read, then the ``success`` return value is set to
*true* and the other return values contain the frame. If the read queue is
empty and no frame could be read, then the ``success`` return value is set to
*false* and the other return values contain invalid data.

The ``identifier`` return value follows the identifier format described for
:func:`Write Frame`.

The ``data`` return value can be up to 15 bytes long. For data frames up to the
first 8 bytes are the actual received data. All bytes after the 8th byte are
always zero and only there to indicate the length of a data or remote frame
with excess length. For remote frames the length of the ``data`` return value
represents the requested length. The actual ``data`` bytes are always zero.

A configurable read filter can be used to define which frames should be
received by the CAN transceiver and put into the read queue (see
:func:`Set Read Filter Configuration`).

Instead of polling with this function, you can also use callbacks. See the
:func:`Set Frame Read Callback Configuration` function and the :cb:`Frame Read`
callback.

=cut

sub read_frame
{
    my ($self) = @_;
    my @ret = $self->read_frame_low_level();

    splice(@{$ret[4]}, $ret[3]);

    return ($ret[0], $ret[1], $ret[2], $ret[4]);
}

=item set_queue_configuration()

Sets the write and read queue configuration.

The CAN transceiver has 32 buffers in total in hardware for transmitting and
receiving frames. Additionally, the Bricklet has a backlog for 768 frames in
total in software. The buffers and the backlog can be freely assigned to the
write and read queues.

:func:`Write Frame` writes a frame into the write backlog. The Bricklet moves
the frame from the backlog into a free write buffer. The CAN transceiver then
transmits the frame from the write buffer to the CAN bus. If there are no
write buffers (``write_buffer_size`` is zero) or there is no write backlog
(``write_backlog_size`` is zero) then no frames can be transmitted and
:func:`Write Frame` returns always *false*.

The CAN transceiver receives a frame from the CAN bus and stores it into a
free read buffer. The Bricklet moves the frame from the read buffer into the
read backlog. :func:`Read Frame` reads the frame from the read backlog and
returns it. If there are no read buffers (``read_buffer_sizes`` is empty) or
there is no read backlog (``read_backlog_size`` is zero) then no frames can be
received and :func:`Read Frame` returns always *false*.

There can be multiple read buffers, because the CAN transceiver cannot receive
data and remote frames into the same read buffer. A positive read buffer size
represents a data frame read buffer and a negative read buffer size represents
a remote frame read buffer. A read buffer size of zero is not allowed. By
default the first read buffer is configured for data frames and the second read
buffer is configured for remote frame. There can be up to 32 different read
buffers, assuming that no write buffer is used. Each read buffer has its own
filter configuration (see :func:`Set Read Filter Configuration`).

A valid queue configuration fulfills these conditions::

 write_buffer_size + read_buffer_size_0 + read_buffer_size_1 + ... + read_buffer_size_31 <= 32
 write_backlog_size + read_backlog_size <= 768

The write buffer timeout has three different modes that define how a failed
frame transmission should be handled:

* Single-Shot (< 0): Only one transmission attempt will be made. If the
  transmission fails then the frame is discarded.
* Infinite (= 0): Infinite transmission attempts will be made. The frame will
  never be discarded.
* Milliseconds (> 0): A limited number of transmission attempts will be made.
  If the frame could not be transmitted successfully after the configured
  number of milliseconds then the frame is discarded.

The current content of the queues is lost when this function is called.

The default is:

* 8 write buffers,
* infinite write timeout,
* 383 write backlog frames,
* 16 read buffers for data frames,
* 8 read buffers for remote frames and
* 383 read backlog frames.

=cut

sub set_queue_configuration
{
    my ($self, $write_buffer_size, $write_buffer_timeout, $write_backlog_size, $read_buffer_sizes, $read_backlog_size) = @_;
    my $read_buffer_sizes_length = scalar(@{$read_buffer_sizes});
    my $read_buffer_sizes_data = [];

    push(@{$read_buffer_sizes_data}, @{$read_buffer_sizes}); # copy so we can potentially extend it

    if($read_buffer_sizes_length > 32)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Read Buffer Sizes can be at most 32 items long'));
    }

    if($read_buffer_sizes_length < 32)
    {
        push(@{$read_buffer_sizes_data}, (0) x (32 - $read_buffer_sizes_length));
    }

    return $self->set_queue_configuration_low_level($write_buffer_size, $write_buffer_timeout, $write_backlog_size, $read_buffer_sizes_length, $read_buffer_sizes_data, $read_backlog_size);
}

=item get_queue_configuration()

Returns the queue configuration as set by :func:`Set Queue Configuration`.

=cut

sub get_queue_configuration
{
    my ($self) = @_;
    my @ret = $self->get_queue_configuration_low_level();

    splice(@{$ret[4]}, $ret[3]);

    return ($ret[0], $ret[1], $ret[2], $ret[4], $ret[5]);
}

=item get_error_log()

Returns information about different kinds of errors.

The write and read error levels indicate the current level of stuffing, form,
acknowledgement, bit and checksum errors during CAN bus write and read
operations. For each of this error kinds there is also an individual counter.

When the write error level extends 255 then the CAN transceiver gets disabled
and no frames can be transmitted or received anymore. The CAN transceiver will
automatically be activated again after the CAN bus is idle for a while.

The write buffer timeout, read buffer and backlog overflow counts represents the
number of these errors:

* A write buffer timeout occurs if a frame could not be transmitted before the
  configured write buffer timeout expired (see :func:`Set Queue Configuration`).
* A read buffer overflow occurs if a read buffer of the CAN transceiver
  still contains the last received frame when the next frame arrives. In this
  case the last received frame is lost. This happens if the CAN transceiver
  receives more frames than the Bricklet can handle. Using the read filter
  (see :func:`Set Read Filter Configuration`) can help to reduce the amount of
  received frames. This count is not exact, but a lower bound, because the
  Bricklet might not able detect all overflows if they occur in rapid succession.
* A read backlog overflow occurs if the read backlog of the Bricklet is already
  full when the next frame should be read from a read buffer of the CAN
  transceiver. In this case the frame in the read buffer is lost. This
  happens if the CAN transceiver receives more frames to be added to the read
  backlog than are removed from the read backlog using the :func:`Read Frame`
  function. Using the :cb:`Frame Read` callback ensures that the read backlog
  can not overflow.

The read buffer overflow counter counts the overflows of all configured read
buffers. Which read buffer exactly suffered from an overflow can be figured
out from the read buffer overflow occurrence list
(``read_buffer_overflow_error_occurred``).

=cut

sub get_error_log
{
    my ($self) = @_;
    my @ret = $self->get_error_log_low_level();

    splice(@{$ret[12]}, $ret[11]);

    return ($ret[0], $ret[1], $ret[2], $ret[3], $ret[4], $ret[5], $ret[6], $ret[7], $ret[8], $ret[9], $ret[10], $ret[12], $ret[13]);
}

=back
=cut

1;
