package CGI::Kwiki::Config_yaml;
$VERSION = '0.17';
use strict;
use base 'CGI::Kwiki';

sub new {
    my ($class) = @_;
    my $self = bless {}, $class;
    return $self;
}

sub directory { '.' }
sub suffix { '.yaml' }
sub render_template {
    my ($self, $template) = @_;
    my $config_classes = '';
    for my $class (grep {not /^(new|config_)/} CGI::Kwiki::classes()) {
        my $Class = $class;
        $Class =~ s/(.)/\u$1/;
        $Class = uc($class) if $class eq 'cgi';
        $config_classes .= 
          sprintf "%-18s CGI::Kwiki::%s\n", "${class}_class:", $Class;
    }
    return $self->render($template,
        date => scalar(gmtime),
        config_classes => $config_classes,
        class => ref($self),
    );
}

sub parse_file {
    my ($self, $file) = @_;
    local(*CONFIG, $/);
    open CONFIG, $file
      or die "Can't open $file for input:\n$!";
    return $self->parse(<CONFIG>);
}

sub parse {
    my ($self, $yaml) = @_;
    my $hash = {};
    for (split /\n/, $yaml) {
        next if /\s*#/;
        next unless /: /;
        next unless /^\S/;
        next unless /(.*?)\s*:\s+(.*?)\s*$/;
        $hash->{$1} = $2;
    }
    return $hash;
}

1;

__DATA__

=head1 NAME 

CGI::Kwiki::Config_yaml - Simplistic YAML Config Parser for CGI::Kwiki

=head1 DESCRIPTION

See installed kwiki pages for more information.

=head1 AUTHOR

Brian Ingerson <INGY@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2003. Brian Ingerson. All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

See http://www.perl.com/perl/misc/Artistic.html

=cut

__config__
# Kwiki Configuration File originally generated by [% class %] 
# on [% date %] GMT
# 
# This config file uses the YAML data format. (http://www.yaml.org)

# These classes control all the aspects of Kwiki behavior. To change a
# certain Kwiki behaviour, change one of these classes to a module of
# your own. Your module should subclass the default class and override
# whatever methods you deem necessary.
[% config_classes %]

top_page:      HomePage
kwiki_image:
title_prefix:  My Kwiki
