/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of SFColor.xs. Do not edit this file, edit SFColor.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SFColor.xs"
#ifndef bool
#include <iostream.h>
#endif
extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "INLINE.h"
}
#ifdef bool
#undef bool
#include <iostream.h>
#endif


#define PI 3.141592653589793238462643383279502884197168
#define _max(a,b)     (a > b ? a : b)
#define _min(a,b)     (a < b ? a : b)
#define _minmax(v,a,b) _min(_max(v, a), b)

class SFColor {
	public:
		double r;
		double g;
		double b;

	public:
		SFColor (const double r=0, const double g=0, const double b=0) { setValue(r,g,b); }

		inline const SFColor* copy () { return new SFColor(r,g,b); }
		
		inline void setValue (const double r, const double g, const double b) {
			this->r = _minmax(r, 0,1);
			this->g = _minmax(g, 0,1);
			this->b = _minmax(b, 0,1);
		}
		
		inline void getValue () {
			Inline_Stack_Vars;
			Inline_Stack_Reset;
				Inline_Stack_Push(sv_2mortal(newSVnv(r)));
				Inline_Stack_Push(sv_2mortal(newSVnv(g)));
				Inline_Stack_Push(sv_2mortal(newSVnv(b)));
			Inline_Stack_Done;
		}
		
		inline void setRed   (const double r) { this->r = _minmax(r, 0,1); }
		inline void setGreen (const double g) { this->g = _minmax(g, 0,1); }
		inline void setBlue  (const double b) { this->b = _minmax(b, 0,1); }

		inline const double getRed   () { return r; }
		inline const double getGreen () { return g; }
		inline const double getBlue  () { return b; }
	
		void setHSV (double h, double s, double v) {
			// H is given on [0, 2 * Pi]. S and V are given on [0, 1]. 
			// RGB are each returned on [0, 1]. 
		
			if ( s == 0 ) {
				// achromatic (grey)
				r = g = b = v;
				return;
			}
		
			h *= 180 / PI;
		
			h /= 60;                             // sector 0 to 5
			double i = floor( h );
			double f = h - i;							 // factorial part of h
			double p = v * ( 1 - s );
			double q = v * ( 1 - s * f );
			double t = v * ( 1 - s * ( 1 - f ) );
		
			if (i == 0) return setValue (v, t, p);
			if (i == 1) return setValue (q, v, p);
			if (i == 2) return setValue (p, v, t);
			if (i == 3) return setValue (p, q, v);
			if (i == 4) return setValue (t, p, v);
			return setValue (v, p, q);
		} 
		
		void getHSV () {
			double h, s, v;
		
			double min = _min( r, _min( g, b ) );
			double max = _max( r, _max( g, b ) );
			v = max;                                       // v
		
			double delta = max - min;
		
			if ( max != 0 && delta != 0 ) {
				s = delta / max;                            // s
			} else {
				// r = g = b = 0                            // s = 0, h is undefined
				s = 0;
				h = 0;
				Inline_Stack_Vars;
				Inline_Stack_Reset;
					Inline_Stack_Push(sv_2mortal(newSVnv(h)));
					Inline_Stack_Push(sv_2mortal(newSVnv(s)));
					Inline_Stack_Push(sv_2mortal(newSVnv(v)));
				Inline_Stack_Done;
				return;
			}
		
			if ( r == max ) {
				h = ( g - b ) / delta;                     // between yellow & magenta
			} else if ( g == max ) {
				h = 2 + ( b - r ) / delta;                 // between cyan & yellow
			} else {
				h = 4 + ( r - g ) / delta;                 // between magenta & cyan
			}
		
			h *= PI * 1/3;                                // radiants
			if( h < 0 ) {
				h += 2 * PI;
			}
		
			Inline_Stack_Vars;
			Inline_Stack_Reset;
				Inline_Stack_Push(sv_2mortal(newSVnv(h)));
				Inline_Stack_Push(sv_2mortal(newSVnv(s)));
				Inline_Stack_Push(sv_2mortal(newSVnv(v)));
			Inline_Stack_Done;
			return;
		}
		
		inline const SFColor* negate (SV* s=0) {
			return new SFColor(
				-r,
				-g,
				-b
			);
		}
		
		inline const SFColor* add (SFColor* v, SV* s=0) {
			return new SFColor(
				r + v->r,
				g + v->g,
				b + v->b
			);
		}
		
		inline const SFColor* subtract (SFColor* v, SV* s=0) {
			return new SFColor(
				r - v->r,
				g - v->g,
				b - v->b
			);
		}

		inline const SFColor* multiply (SFColor* v, SV* s=0) {
			return new SFColor(
				r * v->r,
				g * v->g,
				b * v->b
			);
		}

		inline const SFColor* lighten (const double v, SV* s=0) {
			return new SFColor(
				r * v,
				g * v,
				b * v
			);
		}
		
		inline const SFColor* divide (SFColor* v, SV* s=0) {
			return new SFColor(
				r / v->r,
				g / v->g,
				b / v->b
			);
		}

		inline const SFColor* darken (const double v, SV* s=0) {
			return new SFColor(
				r / v,
				g / v,
				b / v
			);
		}

};


#line 197 "SFColor.c"
XS(XS_main__SFColor_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_new)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::new(CLASS, ...)");
    {
#line 194 "SFColor.xs"
	double	r;
	double	g;
	double	b;
#line 209 "SFColor.c"
	char *	CLASS = (char *)SvPV_nolen(ST(0));
	SFColor *	RETVAL;
#line 198 "SFColor.xs"
switch(items-1) {
case 1:
	r = (double)SvNV(ST(1));
	RETVAL = new SFColor(r);
	break; /* case 1 */
case 2:
	r = (double)SvNV(ST(1));
	g = (double)SvNV(ST(2));
	RETVAL = new SFColor(r,g);
	break; /* case 2 */
case 3:
	r = (double)SvNV(ST(1));
	g = (double)SvNV(ST(2));
	b = (double)SvNV(ST(3));
	RETVAL = new SFColor(r,g,b);
	break; /* case 3 */
default:
	RETVAL = new SFColor();
} /* switch(items) */ 
#line 232 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_copy); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_copy)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::copy(THIS)");
    {
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 223 "SFColor.xs"
	RETVAL = const_cast<SFColor *>(THIS->copy());
#line 260 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_setValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_setValue)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: main::SFColor::setValue(THIS, r, g, b)");
    SP -= items;
    {
	double	r = (double)SvNV(ST(1));
	double	g = (double)SvNV(ST(2));
	double	b = (double)SvNV(ST(3));
#line 233 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 282 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 235 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setValue(r,g,b);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 302 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_getValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_getValue)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::getValue(THIS)");
    SP -= items;
    {
#line 248 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 318 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 250 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->getValue();
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 338 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_setRed); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_setRed)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::setRed(THIS, r)");
    SP -= items;
    {
	double	r = (double)SvNV(ST(1));
#line 264 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 355 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 266 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setRed(r);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 375 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_setGreen); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_setGreen)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::setGreen(THIS, g)");
    SP -= items;
    {
	double	g = (double)SvNV(ST(1));
#line 280 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 392 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 282 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setGreen(g);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 412 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_setBlue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_setBlue)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::setBlue(THIS, b)");
    SP -= items;
    {
	double	b = (double)SvNV(ST(1));
#line 296 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 429 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 298 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setBlue(b);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 449 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_getRed); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_getRed)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::getRed(THIS)");
    {
	SFColor *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 311 "SFColor.xs"
	RETVAL = THIS->getRed();
#line 475 "SFColor.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColor_getGreen); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_getGreen)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::getGreen(THIS)");
    {
	SFColor *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 318 "SFColor.xs"
	RETVAL = THIS->getGreen();
#line 501 "SFColor.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColor_getBlue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_getBlue)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::getBlue(THIS)");
    {
	SFColor *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 325 "SFColor.xs"
	RETVAL = THIS->getBlue();
#line 527 "SFColor.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColor_setHSV); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_setHSV)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: main::SFColor::setHSV(THIS, h, s, v)");
    SP -= items;
    {
	double	h = (double)SvNV(ST(1));
	double	s = (double)SvNV(ST(2));
	double	v = (double)SvNV(ST(3));
#line 335 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 546 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 337 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setHSV(h,s,v);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 566 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_getHSV); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_getHSV)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::getHSV(THIS)");
    SP -= items;
    {
#line 350 "SFColor.xs"
	I32 *	__temp_markstack_ptr;
#line 582 "SFColor.c"
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 352 "SFColor.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->getHSV();
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 602 "SFColor.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColor_negate); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_negate)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::negate(THIS, ...)");
    {
#line 365 "SFColor.xs"
	SV *	s;
#line 617 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 367 "SFColor.xs"
switch(items-1) {
case 1:
	s = ST(1);
	RETVAL = const_cast<SFColor *>(THIS->negate(s));
	break; /* case 1 */
default:
	RETVAL = const_cast<SFColor *>(THIS->negate());
} /* switch(items) */ 
#line 637 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_add); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_add)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::add(THIS, v, ...)");
    {
	SFColor *	v;
#line 382 "SFColor.xs"
	SV *	s;
#line 656 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColor *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColor::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 384 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->add(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->add(v));
} /* switch(items) */ 
#line 684 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_subtract); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_subtract)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::subtract(THIS, v, ...)");
    {
	SFColor *	v;
#line 399 "SFColor.xs"
	SV *	s;
#line 703 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColor *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColor::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 401 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->subtract(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->subtract(v));
} /* switch(items) */ 
#line 731 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_multiply); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_multiply)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::multiply(THIS, v, ...)");
    {
	SFColor *	v;
#line 416 "SFColor.xs"
	SV *	s;
#line 750 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColor *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColor::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 418 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->multiply(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->multiply(v));
} /* switch(items) */ 
#line 778 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_lighten); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_lighten)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::lighten(THIS, v, ...)");
    {
	double	v = (double)SvNV(ST(1));
#line 433 "SFColor.xs"
	SV *	s;
#line 797 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 435 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->lighten(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->lighten(v));
} /* switch(items) */ 
#line 817 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_divide); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_divide)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::divide(THIS, v, ...)");
    {
	SFColor *	v;
#line 450 "SFColor.xs"
	SV *	s;
#line 836 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColor *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColor::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 452 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->divide(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->divide(v));
} /* switch(items) */ 
#line 864 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_darken); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_darken)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColor::darken(THIS, v, ...)");
    {
	double	v = (double)SvNV(ST(1));
#line 467 "SFColor.xs"
	SV *	s;
#line 883 "SFColor.c"
	SFColor *	THIS;
	SFColor *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 469 "SFColor.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColor *>(THIS->darken(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColor *>(THIS->darken(v));
} /* switch(items) */ 
#line 903 "SFColor.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColor", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColor_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColor_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColor::DESTROY(THIS)");
    {
	SFColor *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColor *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColor::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };

	delete THIS;
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_SFColor); /* prototype to pass -Wmissing-prototypes */
XS(boot_SFColor)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("main::SFColor::new", XS_main__SFColor_new, file);
        newXS("main::SFColor::copy", XS_main__SFColor_copy, file);
        newXS("main::SFColor::setValue", XS_main__SFColor_setValue, file);
        newXS("main::SFColor::getValue", XS_main__SFColor_getValue, file);
        newXS("main::SFColor::setRed", XS_main__SFColor_setRed, file);
        newXS("main::SFColor::setGreen", XS_main__SFColor_setGreen, file);
        newXS("main::SFColor::setBlue", XS_main__SFColor_setBlue, file);
        newXS("main::SFColor::getRed", XS_main__SFColor_getRed, file);
        newXS("main::SFColor::getGreen", XS_main__SFColor_getGreen, file);
        newXS("main::SFColor::getBlue", XS_main__SFColor_getBlue, file);
        newXS("main::SFColor::setHSV", XS_main__SFColor_setHSV, file);
        newXS("main::SFColor::getHSV", XS_main__SFColor_getHSV, file);
        newXS("main::SFColor::negate", XS_main__SFColor_negate, file);
        newXS("main::SFColor::add", XS_main__SFColor_add, file);
        newXS("main::SFColor::subtract", XS_main__SFColor_subtract, file);
        newXS("main::SFColor::multiply", XS_main__SFColor_multiply, file);
        newXS("main::SFColor::lighten", XS_main__SFColor_lighten, file);
        newXS("main::SFColor::divide", XS_main__SFColor_divide, file);
        newXS("main::SFColor::darken", XS_main__SFColor_darken, file);
        newXS("main::SFColor::DESTROY", XS_main__SFColor_DESTROY, file);
    XSRETURN_YES;
}

