package SFNode;
use strict;
use warnings;

#use AutoSplit; autosplit('SFNode', './auto/', 0, 1, 1);

use rlib "../";

use SFScalar;
use base qw(SFScalar);

use X3DGenerator;
use X3DError;

use AutoLoader;
our $AUTOLOAD;

sub AUTOLOAD {
	my $this = shift;

	my $node = $this->getValue;
	return X3DError::UnknownField $this, $AUTOLOAD unless ref $node;
	return warn unless ref $node;

	$X3DNode::AUTOLOAD = $AUTOLOAD;
	return $node->AUTOLOAD(@_);
}

use overload
  "<=>"  => sub { $_[1] == $_[0]->getValue ? 0 : 1 },
  "=="   => sub { $_[1] == $_[0]->getValue },
  "!="   => sub { $_[1] != $_[0]->getValue },
  "bool" => sub { ref $_[0]->getValue },
  '""' => \&toString,
  ;

sub setValue {
	my $this = shift;
	$this->SUPER::setValue(shift || 0);
}

sub toString {    #X3DError::Debug;
	return $_[0]->getValue || $X3DGenerator::NULL;
}

1;
__END__
