package X3D;
use strict;
use warnings;

our $VERSION = 0.01;

use rlib 'X3D';

use X3DBrowser;

use base qw(Exporter);

our @EXPORT = qw(createBrowser getBrowser Browser);

sub createBrowser { X3DBrowser->createBrowser }
sub getBrowser    { X3DBrowser->getBrowser }
sub Browser       { X3D::getBrowser }

1;
__END__

=head1 NAME

X3D - X3D Developer Toolkits

=head1 SYNOPSIS

	use X3D;
	
	my $scene = Browser->createX3DFromString("Group{}");

	print $scene;
	
	Browser->replaceWorld( $scene );

	Browser->startTime(time);

=head1 DESCRIPTION


=head1 SEE ALSO

http://www.web3d.org/

=head1 AUTHOR

Holger Seelig <holger.seelig@yahoo.de>

=cut
