use strict;
use warnings;

use Test::More;
use WWW::YahooJapan::KanaAddress;

#===============================================================================
# Constants
#===============================================================================
my @addresses = (
[
  ['', 'Ի', '5'],
  ['礦Ȥ', '礦Ȥʤ礦', 'ܤ󤮣礦'],
],
[
  ['긩', 'Į', '裱ϳ'],
  ['Ƥ', 'ϤФ礦', 'ߤʤߤϤФ'],
],
[
  ['̳ƻ', 'ڻ', '32'],
  ['ۤäɤ', 'äݤ夦', 'ߤʤߤ󤸤礦ˤ'],
],
);

#===============================================================================
# Main
#===============================================================================

plan tests => scalar(@addresses);
     
my $yahoo = WWW::YahooJapan::KanaAddress->new();
foreach my $r (@addresses){
	ok(eq_array([ $yahoo->search(@{ $r->[0] }) ], $r->[1]));
}
