# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

# this code is written in Unicode/UTF-8 char-set
# including Japanese characters.

use strict;
use warnings;

use Test::More tests => 10;

use utf8;
# use Encode;

BEGIN {
	use_ok( 'Lingua::JA::Fold', qw(length_full length_half) )
};

my $text = 'かんじ	漢字';
my $obj = Lingua::JA::Fold->new($text);
isa_ok($obj, 'Lingua::JA::Fold');
########################################################################
# replace a [TAB] with 4 of [SPACE]s.
$obj->tab2space(4);
my $got = $obj->output;
my $expected = 'かんじ    漢字';
is ($got, $expected,
	'method tab2space($i)');
########################################################################
# convert half width 'Kana' letters to full width ones.
$text = 'ｱｲｳｴｵ';
my $obj2 = Lingua::JA::Fold->new($text);
$obj2->kana_half2full;
$got = $obj2->output;
$expected = 'アイウエオ';
is ($got, $expected,
	'method kana_half2full');
########################################################################
# count length in full-width
$text = 'abcdeかんじ漢字ｱｲｳｴｵ｡';
$got = length_full($text);
is ($got, 10.5,
	'func. length_full($text): for ascii + kanji + half_width_kana');
########################################################################
# count length in half-width
$got = length_half($text);
is ($got, 21,
	'func. length_half($text): for ascii + kanji + half_width_kana');
########################################################################
# fold the text under 2 full width letters par a line.
my $obj3 = Lingua::JA::Fold->new($text);
$obj3->fold(2);
$got = $obj3->output;
$expected = 'abcd
eか
んじ
漢字
ｱｲｳｴ
ｵ｡';
is ($got, $expected,
	'method fold($i): for a short text');

########################################################################
# long text trial

$text = <<'EOF';
apougaobuaEmailアドレスｱｲｳｴｵ｡も必須です（こちらから返事をする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。改行は、原則として段落を変えたい時のみ使用するgaoubaようにしてください。
aaaa手a動で行を折り返して長さを揃える必要はありません。 作成中に誤って消してしまった場合はショックが大きいものです。特ｶｷｸｹｺに長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安aaa全です。
※短い行※
 Emailアドレスも必須です（こちらから返事をoubabaする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。改行は、原則として段落を変えたい時のみ使用するようにしてください。aaaa手a動で行を折り返して長さを揃える必要はありません。作成中に誤って消してしまった場合はショックが大きいもagaのです。
特にagabb長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安全です。Emailアドレスも必須です（こちらかｱｲｳｴｵ｡ら返事をする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。 改行は、原則として段落を変えたい時のみ使用するようにしてください。aaaa手a動で行を折り返して長さを揃える必要はありません。 
作成中に誤って消してしまった場合はショックが大きいものです。特に長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安全です。
EOF

$expected = <<'EOF';
apougaobuaEmailアドレスｱｲｳｴｵ｡も必須です
（こちらから返事をする際に必要となります
ので、アドレスの記入ミスをなさらぬようご
注意下さい）。改行は、原則として段落を変
えたい時のみ使用するgaoubaようにしてくだ
さい。
aaaa手a動で行を折り返して長さを揃える必
要はありません。 作成中に誤って消してし
まった場合はショックが大きいものです。特
ｶｷｸｹｺに長文の場合などは、一旦、テキスト
エディタやワープロ等で原稿を作成してから
、それをメールの書き込み欄にコピー＆ペー
ストして送信するやり方にすれば安aaa全で
す。
※短い行※
 Emailアドレスも必須です（こちらから返事
をoubabaする際に必要となりますので、アド
レスの記入ミスをなさらぬようご注意下さい
）。改行は、原則として段落を変えたい時の
み使用するようにしてください。aaaa手a動
で行を折り返して長さを揃える必要はありま
せん。作成中に誤って消してしまった場合は
ショックが大きいもagaのです。
特にagabb長文の場合などは、一旦、テキス
トエディタやワープロ等で原稿を作成してか
ら、それをメールの書き込み欄にコピー＆ペ
ーストして送信するやり方にすれば安全です
。Emailアドレスも必須です（こちらかｱｲｳｴｵ
｡ら返事をする際に必要となりますので、ア
ドレスの記入ミスをなさらぬようご注意下さ
い）。 改行は、原則として段落を変えたい
時のみ使用するようにしてください。aaaa手
a動で行を折り返して長さを揃える必要はあ
りません。 
作成中に誤って消してしまった場合はショッ
クが大きいものです。特に長文の場合などは
、一旦、テキストエディタやワープロ等で原
稿を作成してから、それをメールの書き込み
欄にコピー＆ペーストして送信するやり方に
すれば安全です。
EOF

my $obj4 = Lingua::JA::Fold->new($text);
$obj4->fold(20);
$got = $obj4->output;
is ($got, $expected,
	'method fold($i): for a long text');

########################################################################
# long text trial (alternative)

$expected = <<'EOF';
apougaobuaEmailアドレスｱ
ｲｳｴｵ｡も必須です（こちらから返事をす
る際に必要となりますので、アドレスの記入
ミスをなさらぬようご注意下さい）。改行は
、原則として段落を変えたい時のみ使用する
gaoubaようにしてください。
aaaa手a動で行を折り返して長さを揃え
る必要はありません。 作成中に誤って消し
てしまった場合はショックが大きいものです
。特ｶｷｸｹｺに長文の場合などは、一旦、
テキストエディタやワープロ等で原稿を作成
してから、それをメールの書き込み欄にコピ
ー＆ペーストして送信するやり方にすれば安
aaa全です。
※短い行※
 Emailアドレスも必須です（こちらか
ら返事をoubabaする際に必要となりま
すので、アドレスの記入ミスをなさらぬよう
ご注意下さい）。改行は、原則として段落を
変えたい時のみ使用するようにしてください
。aaaa手a動で行を折り返して長さを揃
える必要はありません。作成中に誤って消し
てしまった場合はショックが大きいもaga
のです。
特にagabb長文の場合などは、一旦、テ
キストエディタやワープロ等で原稿を作成し
てから、それをメールの書き込み欄にコピー
＆ペーストして送信するやり方にすれば安全
です。Emailアドレスも必須です（こち
らかｱｲｳｴｵ｡ら返事をする際に必要とな
りますので、アドレスの記入ミスをなさらぬ
ようご注意下さい）。 改行は、原則として
段落を変えたい時のみ使用するようにしてく
ださい。aaaa手a動で行を折り返して長
さを揃える必要はありません。 
作成中に誤って消してしまった場合はショッ
クが大きいものです。特に長文の場合などは
、一旦、テキストエディタやワープロ等で原
稿を作成してから、それをメールの書き込み
欄にコピー＆ペーストして送信するやり方に
すれば安全です。
EOF

my $obj5 = Lingua::JA::Fold->new($text);
$obj5->fold_easy(20);
$got = $obj5->output;
is ($got, $expected,
	'method fold_easy(i): ignore difference whether full or half');

########################################################################
# fold_ex($i) (reflect forbidden ruls)

$text = <<'EOF';
(４)符号　記号ともいう。句読点をはじめ、表記上の符号には、すべて一マスをあてる。感嘆符！疑問符？カギ「」カッコ（）ヤマ型カッコ〈〉など。注意すべきことは、文の中止、あるいは終止が行末にきたときは、次の行頭に打たず、行末の文字と一緒に書きこむということである。閉じる符号――）」』など――も同様に扱う。つまり、テン「、」まる「。」や閉じる符号は、行頭には据えないということである。その他、行頭に据えないものとして、くりかえし記号（々ゝ）などがある。「！？」は、行頭に書いて差しつかえない。ただ、「！？」の下は、すぐ下にカギの受けがくるとき以外は、一マスあけることになっている。句読点の下を一マスあけた原稿をよくみかけるが、これはあけない。

１２３４５６７
１２３４５６７

１２３４５６７、
１２３４５６７，
１２３４５６７。
１２３４５６７．
１２３４５６７」
１２３４５６７’
１２３４５６７』
１２３４５６７”
１２３４５６７〟
１２３４５６７）
１２３４５６７】
１２３４５６７〉
１２３４５６７》
１２３４５６７］
１２３４５６７〕
１２３４５６７｝
１２３４５６７々
１２３４５６７ゝ
１２３４５６７ゞ
１２３４５６７ヽ
１２３４５６７ヾ
１２３４５６７〃

１２３４５６７、，。．」’』”〟）】〉》］〕｝々ゝゞヽヾ〃

１２aiueo３４、
１２ｱｲｳｴｵ３４，
EOF

$expected = <<'EOF';
(４)符号　記号
ともいう。句読
点をはじめ、表
記上の符号には、
すべて一マスを
あてる。感嘆符
！疑問符？カギ
「」カッコ（）
ヤマ型カッコ〈〉
など。注意すべ
きことは、文の
中止、あるいは
終止が行末にき
たときは、次の
行頭に打たず、
行末の文字と一
緒に書きこむと
いうことである。
閉じる符号――）」』
など――も同様
に扱う。つまり、
テン「、」まる
「。」や閉じる
符号は、行頭に
は据えないとい
うことである。
その他、行頭に
据えないものと
して、くりかえ
し記号（々ゝ）
などがある。「
！？」は、行頭
に書いて差しつ
かえない。ただ、
「！？」の下は、
すぐ下にカギの
受けがくるとき
以外は、一マス
あけることにな
っている。句読
点の下を一マス
あけた原稿をよ
くみかけるが、
これはあけない。

１２３４５６７
１２３４５６７

１２３４５６７、
１２３４５６７，
１２３４５６７。
１２３４５６７．
１２３４５６７」
１２３４５６７’
１２３４５６７』
１２３４５６７”
１２３４５６７〟
１２３４５６７）
１２３４５６７】
１２３４５６７〉
１２３４５６７》
１２３４５６７］
１２３４５６７〕
１２３４５６７｝
１２３４５６７々
１２３４５６７ゝ
１２３４５６７ゞ
１２３４５６７ヽ
１２３４５６７ヾ
１２３４５６７〃

１２３４５６７、，。．」’』”〟）】〉》］〕｝々ゝゞヽヾ〃

１２aiueo３４、
１２ｱｲｳｴｵ３４，
EOF

my $obj6 = Lingua::JA::Fold->new($text);
$obj6->fold_ex(7);
$got = $obj6->output;

is ($got, $expected,
	'method fold_ex($i)');
