package Lemonldap::NG::Portal::Password::REST;

use strict;
use Mouse;
use Lemonldap::NG::Portal::Main::Constants qw(
  PE_ERROR
  PE_PASSWORD_OK
);

extends 'Lemonldap::NG::Portal::Password::Base',
  'Lemonldap::NG::Portal::Lib::REST';

our $VERSION = '1.9.99_2.0alpha1';

sub init {
    my ($self) = @_;
    unless ($self->conf->{restPwdConfirmUrl}
        and $self->conf->{restPwdModifyUrl} )
    {
        $self->logger->error('Missing REST password URL');
        return 0;
    }
    return $self->SUPER::init;
}

sub confirm {
    my ( $self, $req, $pwd ) = @_;
    my $res = eval {
        $self->restCall( $self->conf->{restPwdConfirmUrl},
            { user => $req->user, password => $pwd } );
    };
    if ($@) {
        $self->logger("Pwd confirm error: $@");
        return 0;
    }
    return ( $res->{result} ? 1 : 0 );
}

sub modifyPassword {
    my ( $self, $req, $pwd ) = @_;
    my $res = eval {
        $self->restCall( $self->conf->{restPwdModifyUrl},
            { user => $req->user, password => $pwd } );
    };
    if ($@) {
        $self->logger("Pwd confirm error: $@");
        return PE_ERROR;
    }
    return ( $res->{result} ? PE_PASSWORD_OK : PE_ERROR );
}

1;
