package Lemonldap::NG::Portal::Auth::Remote;

use strict;
use Mouse;
use Lemonldap::NG::Portal::Main::Constants qw(PE_OK);

our $VERSION = '1.9.99_2.0alpha1';

extends 'Lemonldap::NG::Portal::Auth::Base',
  'Lemonldap::NG::Portal::Lib::Remote';

# RUNNING METHODS

sub extractFormInfo {
    my ( $self, $req ) = @_;
    my $r = $self->checkRemoteId($req);
    return $r unless ( $r == PE_OK );
    $req->{user} =
      $req->datas->{rSessionInfo}->{ $self->conf->{remoteUserField} || 'uid' };
    $req->datas->{password} = $req->datas->{rSessionInfo}->{'_password'};
    PE_OK;
}

sub authenticate {
    PE_OK;
}

sub setAuthSessionInfo {
    my ( $self, $req ) = @_;

    # Store password (deleted in checkRemoteId() if local policy does not accept
    # stored passwords)
    $req->{sessionInfo}->{'_password'} = $req->datas->{'password'};
    $req->{sessionInfo}->{authenticationLevel} =
      $req->datas->{rSessionInfo}->{authenticationLevel};
    PE_OK;
}

sub authLogout {
    PE_OK;
}

sub getDisplayType {
    return "logo";
}

1;
