package Lemonldap::NG::Portal::Plugins::CDA;

use strict;
use Mouse;

our $VERSION = '1.9.99_02';

extends 'Lemonldap::NG::Common::Module';

# INTERFACE

sub afterDatas {
    return 'changeUrldc';
}

# RUNNING METHOD

sub changeUrldc {
    my ( $self, $req ) = @_;
    my $urldc = $req->{urldc};
    if (    $req->id
        and $urldc !~ m#^https?://[^/]*$self->{conf}->{domain}(:\d+)?/#oi
        and $self->p->isTrustedUrl($urldc) )
    {
        my $ssl = $urldc =~ /^https/;
        $self->logger->debug('CDA request');

        # Create CDA session
        if ( my $cdaSession = $self->getApacheSession( undef, kind => "CDA" ) )
        {
            my $cdaInfos = { '_utime' => time };
            if ( $self->{conf}->{securedCookie} < 2 or $ssl ) {
                $cdaInfos->{cookie_value} = $req->id;
                $cdaInfos->{cookie_name}  = $self->{conf}->{cookieName};
            }
            else {
                $cdaInfos->{cookie_value} =
                  $req->{sessionInfo}->{_httpSession};
                $cdaInfos->{cookie_name} = $self->{conf}->{cookieName} . "http";
            }

            $self->updateSession( $cdaInfos, $cdaSession->id );

            $req->{urldc} .=
                ( $urldc =~ /\?/ ? '&' : '?' )
              . $self->{conf}->{cookieName} . "cda="
              . $cdaSession->id;

            $self->logger->debug( "CDA redirection to " . $req->{urldc} );
        }
        else {
            $self->logger->error("Unable to create CDA session");
            return PE_APACHESESSIONERROR;
        }
    }
    PE_OK;
}

1;
