package Lemonldap::NG::Portal::Auth::Radius;

use strict;
use Mouse;
use Authen::Radius;
use Lemonldap::NG::Portal::Main::Constants qw(
  PE_BADCREDENTIALS
  PE_OK
  PE_RADIUSCONNECTFAILED
);

extends qw(Lemonldap::NG::Portal::Auth::_WebForm);

our $VERSION = '1.9.99_02';

# PROPERTIES

has radius => ( is => 'rw' );

has authnLevel => (
    is      => 'rw',
    default => sub {
        $_[0]->conf->{radiusAuthnLevel};
    }
);

sub initRadius {
    $_[0]->radius(
        Authen::Radius->new(
            Host   => $_[0]->conf->{radiusServer},
            Secret => $_[0]->conf->{radiusSecret}
        )
    );
}

# INITIALIZATION

sub init {
    my $self = shift;
    unless ( $self->initRadius ) {
        $self->error('Radius connect failed');
    }
    return 1;
}

# RUNNING METHODS

sub authenticate {
    my ( $self, $req ) = @_;
    $self->initRadius unless ( $self->radius );
    return PE_RADIUSCONNECTFAILED unless ( $self->radius );

    my $res = $self->radius->check_pwd( $req->user, $req->datas->{password} );
    unless ( $res == 1 ) {
        $self->userLogger->warn("Unable to authenticate $req->{user} !");
        return PE_BADCREDENTIALS;
    }
    return PE_OK;
}

sub authLogout {
    PE_OK;
}

1;
