package App::Manoc::DB::Search::Result::Logon;

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use App::Manoc::IPAddress::IPv4;

extends 'App::Manoc::DB::Search::Result::Item';

has 'ipaddress' => (
    is       => 'ro',
    isa      => 'App::Manoc::IPAddress::IPv4',
    required => 1,
);

has 'username' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

around BUILDARGS => sub {
    my $orig  = shift;
    my $class = shift;

    if ( @_ == 1 && ref( $_[0] ) eq 'HASH' ) {
        my $args = $_[0];
        my $addr = $args->{ipaddress};
        if ( $addr && !ref($addr) ) {
            $args->{ipaddress} = App::Manoc::IPAddress::IPv4->new($addr);
        }
        return $class->$orig($args);
    }

    return $class->$orig(@_);
};

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search::Result::Logon

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
