#!/usr/bin/perl

# Build.PL
#  Script to build and install this distribution
#
# $Id: Build.PL 5759 2009-03-25 21:33:58Z FREQUENCY@cpan.org $
#
# This package and its contents are released by the author into the
# Public Domain, to the full extent permissible by law. For additional
# information, please see the included `LICENSE' file.

use strict;
use warnings;

use Module::Build;

my $builder = Module::Build->new(
  module_name           => 'Math::Random::ISAAC',
  license               => 'unrestricted',
  dist_author           => 'Jonathan Yu <frequency@cpan.org>',
  dist_version_from     => 'lib/Math/Random/ISAAC.pm',
  dynamic_config        => 0,
  create_readme         => 1,
  recursive_test_files  => 1,
  sign                  => 1,
  create_packlist       => 1,

  # Maintain compatibility with ExtUtils::MakeMaker installations
  create_makefile_pl    => 'passthrough',

  requires => {
    'perl'              => 5.006,

    # Pragmatic and special modules
    'Carp'              => 1.04,
    'version'           => 0.76,
    'warnings'          => 0,
    'strict'            => 0,
    'integer'           => 0,

    # The tests are based on Test::More
    'Test::More'        => 0.62,
  },
  build_requires => {
    # User tests for good functionality
    'Test::NoWarnings'        => 0.084,
  },
  recommends => {
    # The XS version of this module
    'Math::Random::ISAAC::XS'       => 0,

    # Author tests
    'Test::Perl::Critic'            => 1.01,
    'Perl::Critic'                  => 1.096,
    'Test::YAML::Meta'              => 0.11,
    'Test::Kwalitee'                => 1.01,
    'Test::Signature'               => 1.10,
    'Test::Pod'                     => 1.14,
    'Test::Pod::Coverage'           => 1.04,
    'Test::Portability::Files'      => 0.05,
    'Test::MinimumVersion'          => 0.008,
    'Test::LeakTrace'               => 0.07,
    'Statistics::Test::RandomWalk'  => 0,
    'Test::Without::Module'         => 0.17,
    'Test::DistManifest'            => 1.001002,
  },
  conflicts => {
  },

  add_to_cleanup => [ 'Math-Random-ISAAC-*' ],
  script_files => [],

  meta_merge => {
    resources => {
      # Custom resources (must begin with an uppercase letter)
      Ratings      => 'http://cpanratings.perl.org/d/Math-Random-ISAAC',

      # Official keys (homepage, license, bugtracker)
      repository   => 'http://svn.ali.as/cpan/trunk/Math-Random-ISAAC',
      bugtracker   => 'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Math-Random-ISAAC',
      license      => 'http://edwardsamuels.com/copyright/beyond/articles/public.html',
    },
  },
);

$builder->create_build_script();
