# NAME

App::Akter - Akter is a Perl5 lightweigt task runner

# SYNOPSIS

    $ akter
    $ akter --file=/path/to/akterfile

The akterfile looks like this:

    requires IO::All;


    # creating tasks
    task 'foo' => sub {
        my $self = shift;

        # setting a param
        param(foo => 'bar');


        # output text
        say "doing something";
        warn "test with warn here";
    };

    task 'bar' => sub {
        my $self = shift;

        # geting and output param
        my $key = 'foo';
        say "param $key => " . param($key) . "";


        # output text
        say "doing something";
        warn "warn here";


        # show task list
        say dumper $self->task_list;
    };

    task 'using io-all module here' => sub {
            "this is a simple test" >> io("test.log");
    };


# DESCRIPTION

Akter is a lightweight Perl5 multi-purpose task runner.

This is designed to be simple to use and provide a simple way to write
scripts for automate project tasks.

# INSTALLATION

Run `cpanm App::Akter` on your console.

# DEPENDENCIES

perl 5.10 or later.

# FUCTURE FEATURES

    * task group
    * condition to start task
    * native log control
    * methods that control task workflow
    * event callbacks


# COPYRIGHT

Copyright 2015 - Daniel Vinciguerra

# LICENSE

This software is licensed under the same terms as Perl.

