#!/usr/bin/perl -w -I ../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Effect;
  
  use Moose;
  use Moose::Util::TypeConstraints;
  
  enum 'FX', [qw(fade chorus delay echo echos flanger overdrive phaser)];

  has 'fx' => (
    is => 'rw',
    isa => 'FX',
  );

  sub BUILD {
    my $self = shift;
    # set default synthesizer
    my @classparts = split(/::/,ref($self));
    $self->fx(lc($classparts[-1]));
  }
}

1;
