#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use Path::Tiny;
use lib 'lib';

# try to import every .pm file in /lib
my $dir = path('lib/');

my $iter = $dir->iterator({
            recurse         => 1,
            follow_symlinks => 0,
           });

while (my $path = $iter->())
{
  next if $path->is_dir || $path !~ /\.pm$/;
  eval { require $path };
  ok !$@, "import $path $@";
}

done_testing;
