#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::Weight_for_Height::Child::Male;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

1;

# wtstat, sex = 1

__DATA__

77	-0.999294215	10.27440527	0.077115837
77.5	-0.979897716	10.38901871	0.076995353
78.5	-0.943555181	10.61724901	0.076769511
79.5	-0.91080778	10.84432907	0.076564374
80.5	-0.882026316	11.07048885	0.076380766
81.5	-0.857561667	11.29597453	0.076219662
82.5	-0.837750377	11.52104655	0.07608215
83.5	-0.822919198	11.74597768	0.075969382
84.5	-0.813388595	11.97105103	0.075882537
85.5	-0.809475279	12.19655799	0.075822785
86.5	-0.811493792	12.4227963	0.075791244
87.5	-0.8197572	12.65006791	0.075788944
88.5	-0.834576932	12.87867701	0.07581679
89.5	-0.856261805	13.10892794	0.075875517
90.5	-0.885116299	13.34112314	0.075965652
91.5	-0.921432943	13.5755615	0.076087468
92.5	-0.965501267	13.81253552	0.076240931
93.5	-1.017588552	14.05233041	0.076425662
94.5	-1.077941994	14.29522185	0.07664088
95.5	-1.146773671	14.54147499	0.076885365
96.5	-1.224269596	14.79134177	0.07715739
97.5	-1.310558831	15.04506152	0.077454707
98.5	-1.405713355	15.30285949	0.077774507
99.5	-1.509717075	15.56494815	0.078113436
100.5	-1.622491233	15.83152429	0.078467542
101.5	-1.743825743	16.10277448	0.078832409
102.5	-1.873365511	16.37887678	0.079203258
103.5	-2.010641647	16.65999867	0.079574978
104.5	-2.154957918	16.94630912	0.079942558
105.5	-2.305458316	17.23797444	0.08030117
106.5	-2.461019713	17.53517134	0.080646757
107.5	-2.62033059	17.83808212	0.080976208
108.5	-2.781787762	18.14690821	0.0812881
109.5	-2.943638944	18.46185811	0.081582687
110.5	-3.103888502	18.78315936	0.081862656
111.5	-3.260482798	19.11103983	0.082132791
112.5	-3.411305599	19.44572803	0.082400213
113.5	-3.554288672	19.78744004	0.082674023
114.5	-3.687600863	20.13635563	0.082964333
115.5	-3.809599339	20.49262111	0.083282267
116.5	-3.919005213	20.85632542	0.083638758
117.5	-4.014882272	21.2274989	0.084044246
118.5	-4.096683061	21.60610366	0.084508001
119.5	-4.164160421	21.9920407	0.085038256
120.5	-4.217425718	22.3851382	0.085641503
121.5	-4.256802224	22.78516628	0.086323118

__END__

=head1 NAME

Medical::Growth::NHANES_2000::Weight_for_Height::Child::Male

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Child', sex => 'Male',
    measure => 'Weight for Height')->pct_for_value($wt,$ht);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for weight-for-height
tables for boys ages 2-20 years.

Weight values are expressed in kilograms, and height values in centimeters.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
