package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step ':inter';

$description=<<'END';
Parrot sometimes has experimental systems.  I'll now ask about
any that currently exist.  Answer 'n' unless you know otherwise.
END

@args=qw(defaults expnetwork);

sub runstep {
  my $net=$_[1] || 'n';

  $net=prompt("Enable experimental networking?", $net) unless defined $_[0];

  if($net =~ /n/i) {
    $net=0;
  }
  else {
    $net=1;
  }
  
  Configure::Data->set(expnetworking => $net);
}

1;