package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step;


$description = "Determining architecture, OS and JIT capability...";

@args=qw(jitcapable);

sub runstep {
  my $archname                 =  $Config{archname};
  my ($cpuarch, $osname)       =  split('-', $archname);

  if (!defined $osname) {
    ($osname, $cpuarch) = ($cpuarch, "");
  }

  Configure::Data->set(
    archname    => $archname,
    cpuarch     => $cpuarch,
    osname      => $osname,
  );

  my $jitarchname              =  "$cpuarch-$osname";
  $jitarchname                 =~ s/i[456]86/i386/i;
  $jitarchname                 =~ s/-(net|free|open)bsd$/-bsd/i;
  my $jitcapable               =  0;

  if (-e "lib/Parrot/Jit/$jitarchname.pm") {
    $jitcapable = 1;
  }

  $jitcapable = $_[0] if defined $_[0];

  if($jitcapable) {
    my($jitcpuarch, $jitosname) =  split('-', $jitarchname);

    Configure::Data->set(
      jitarchname => $jitarchname,
      jitcpuarch  => $jitcpuarch,
      jitosname   => $jitosname,
      jitcapable  => 1,
      cc_hasjit   => " -DHAS_JIT -D" . uc $jitcpuarch,
      jit_h       => "\$(INC)/jit.h",
      jit_struct_h=> "\$(INC)/jit_struct.h",
      jit_o       => "jit\$(O)"
    );
  }
  else {
    Configure::Data->set(
      jitarchname => "i386-nojit",
      jitcpuarch  => "i386",
      jitosname   => "nojit",
      jitcapable  => 0,
      cc_hasjit   => '',
      jit_h       => '',
      jit_struct_h=> '',
      jit_o       => ''
    );
  }
}

1;