use strict;
use warnings;
use 5.022;

use feature qw /postderef signatures/;

package Vote::Count::Approval;
$Vote::Count::Approval::VERSION = '0.001'; # TRIAL
use Moose::Role;

no warnings 'experimental';
# use Data::Printer;

sub Approval ( $self, $active=undef ) {
  my %BallotSet = $self->BallotSet()->%*;
  my %ballots = ( $BallotSet{'ballots'}->%* );
# p %ballots;
  $active = $BallotSet{'choices'} unless defined $active ;
# p $active;
  my %approval = ( map { $_ => 0 } keys( $active->%* ));
    for my $b ( keys %ballots ) {
# warn "checkijng $b";
# p $ballots{$b};
# return {};
      my @votes = $ballots{$b}->{'votes'}->@* ;
      for my $v ( @votes ) {
        if ( defined $approval{$v} ) {
          $approval{$v} += $ballots{$b}{'count'};
        }
      }
    }
  return Vote::Count::RankCount->Rank( \%approval );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Vote::Count::Approval

=head1 VERSION

version 0.001

=head1 AUTHOR

John Karr <brainbuz@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by John Karr.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
