#!perl

use strict;
use warnings;

use Test::More tests => 15;
use Test::Exception;

use Auth::Kokolores::Response;

my $r;
lives_ok {
  $r = Auth::Kokolores::Response->new(
    message => 'OK',
  );
} 'create Auth::Kokolores::Response object';
isa_ok( $r, 'Auth::Kokolores::Response');

cmp_ok( $r->message, 'eq', 'OK', '->message must be "OK"');
cmp_ok( $r->as_string, 'eq', pack("nA3", 3, "OK\0"), 'SASL string OK');
cmp_ok( "$r", 'eq', pack("nA3", 3, "OK\0"), 'stringified version');

lives_ok {
  $r = Auth::Kokolores::Response->new_OK;
} 'create Auth::Kokolores::Response object';
isa_ok( $r, 'Auth::Kokolores::Response');

cmp_ok( $r->message, 'eq', 'OK', '->message must be "OK"');
cmp_ok( $r->as_string, 'eq', pack("nA3", 3, "OK\0"), 'SASL string OK');
cmp_ok( "$r", 'eq', pack("nA3", 3, "OK\0"), 'stringified version');

lives_ok {
  $r = Auth::Kokolores::Response->new_NO;
} 'create Auth::Kokolores::Response object';
isa_ok( $r, 'Auth::Kokolores::Response');

cmp_ok( $r->message, 'eq', 'NO', '->message must be "NO"');
cmp_ok( $r->as_string, 'eq', pack("nA3", 3, "NO\0"), 'SASL string NO');
cmp_ok( "$r", 'eq', pack("nA3", 3, "NO\0"), 'stringified version');

