#!perl

use strict;
use warnings;
$|=1;
use Test::More tests => 1;
use DBI;
#use DBD::SQLite;
use File::Spec;
use File::Path;
use File::Basename;

# rebuild cpanstats db

my $f = File::Spec->catfile('t','_DBDIR','test.db');
unlink $f if -f $f;
mkpath( dirname($f) );

my $dbh = DBI->connect("dbi:SQLite:dbname=$f", '', '', {AutoCommit=>1});
$dbh->do(q{
  CREATE TABLE cpanstats (
                          id            INTEGER PRIMARY KEY,
                          guid          TEXT,
                          state         TEXT,
                          postdate      TEXT,
                          tester        TEXT,
                          dist          TEXT,
                          version       TEXT,
                          platform      TEXT,
                          perl          TEXT,
                          osname        TEXT,
                          osvers        TEXT,
                          fulldate      TEXT
  )
});

while(<DATA>){
  chomp;
  $dbh->do('INSERT INTO cpanstats ( id, guid, state, postdate, tester, dist, version, platform, perl, osname, osvers, fulldate ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )', {}, split(/\|/,$_) );
}

$dbh->do(q{ CREATE INDEX distverstate ON cpanstats (dist, version, state) });
$dbh->do(q{ CREATE INDEX ixdate ON cpanstats (postdate) });
$dbh->do(q{ CREATE INDEX ixperl ON cpanstats (perl) });
$dbh->do(q{ CREATE INDEX ixplat ON cpanstats (platform) });

my ($ct) = $dbh->selectrow_array('select count(*) from cpanstats');

$dbh->disconnect;

is($ct, 10976, "row count for cpanstats");

#select * from cpanstats where state='cpan' and dist in ('AEAE', 'AI-NeuralNet-BackProp', 'AI-NeuralNet-Mesh', 'AI-NeuralNet-SOM', 'AOL-TOC', 'Abstract-Meta-Class', 'Acme', 'Acme-Anything', 'Acme-BOPE', 'Acme-Brainfuck', 'Acme-Buffy', 'Acme-CPANAuthors-Canadian', 'Acme-CPANAuthors-CodeRepos', 'Acme-CPANAuthors-French', 'Acme-CPANAuthors-Japanese');
# sqlite> select * from cpanstats where postdate=200901 order by dist limit 20;
# id|guid|state|postdate|tester|dist|version|platform|perl|osname|osvers|date
__DATA__
4769141|4769141-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907250807
4768761|4768761-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907250645
4768746|4768746-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907250643
4766868|4766868-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241805
4766801|4766801-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241803
4766786|4766786-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241803
4766403|4766403-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241753
4766103|4766103-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241744
4766061|4766061-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241743
4765898|4765898-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241739
4765868|4765868-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241738
4765251|4765251-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241720
4764927|4764927-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241711
4764914|4764914-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241710
4764659|4764659-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241703
4764609|4764609-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241702
4764421|4764421-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241657
4764354|4764354-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241656
4763897|4763897-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241645
4763676|4763676-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241638
4763621|4763621-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241636
4763613|4763613-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241636
4763542|4763542-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241634
4762584|4762584-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241609
4762464|4762464-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241607
4762393|4762393-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241606
4762347|4762347-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241605
4762041|4762041-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241600
4762008|4762008-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241600
4761762|4761762-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.8|solaris|2.10|200907242024
4761682|4761682-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241554
4760155|4760155-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907241627
4756952|4756952-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907240354
4756950|4756950-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907240353
4756165|4756165-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907240025
4755922|4755922-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240018
4755852|4755852-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240016
4755743|4755743-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240010
4754970|4754970-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907231932
4754831|4754831-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907231926
4754597|4754597-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907231913
4754377|4754377-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907231902
4754291|4754291-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907231858
4753804|4753804-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232249
4753583|4753583-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232155
4753443|4753443-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232117
4753442|4753442-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232117
4753414|4753414-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232115
4753154|4753154-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753153|4753153-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753150|4753150-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753146|4753146-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232019
4753145|4753145-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232019
4753138|4753138-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232018
4753070|4753070-b19f-3f77-b713-d32bba55d77f|fail|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232005
4753063|4753063-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232004
4753036|4753036-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231959
4753031|4753031-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231959
4753028|4753028-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231958
4753025|4753025-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231958
4753018|4753018-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231956
4753016|4753016-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231956
4753008|4753008-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231954
4753007|4753007-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231955
4753006|4753006-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231954
4752911|4752911-b19f-3f77-b713-d32bba55d77f|pass|200907|woody@2143.net|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.6.27-gentoo-r8|200907231842
4752887|4752887-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231938
4752635|4752635-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231851
4752626|4752626-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231850
4752050|4752050-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907231816
4750475|4750475-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231355
4749847|4749847-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231204
4749845|4749845-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231204
4749843|4749843-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231203
4748817|4748817-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907230904
4748811|4748811-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907230902
4748175|4748175-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907230505
4747966|4747966-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230311
4747831|4747831-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230304
4747512|4747512-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230257
4747503|4747503-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230257
4747293|4747293-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230253
4747096|4747096-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230250
4746987|4746987-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230248
4746594|4746594-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907230240
4746497|4746497-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230238
4744652|4744652-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|Test-JSON-Meta|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907222351
4743941|4743941-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.7|solaris|2.10|200907221924
4743355|4743355-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221809
4743019|4743019-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.7|solaris|2.10|200907221641
4742638|4742638-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907221724
4742629|4742629-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907221722
4742396|4742396-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221549
4742019|4742019-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220946
4741950|4741950-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220944
4741803|4741803-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221427
4741801|4741801-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.7|solaris|2.10|200907221403
4741754|4741754-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741749|4741749-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741729|4741729-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741637|4741637-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.7|solaris|2.10|200907221355
4741609|4741609-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.7|solaris|2.10|200907221354
4741603|4741603-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.7|solaris|2.10|200907221354
4741501|4741501-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220916
4740659|4740659-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220840
4739689|4739689-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|Test-JSON-Meta|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200907221336
4739282|4739282-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.02|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907221304
4739099|4739099-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200907221242
4737204|4737204-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220001
4736615|4736615-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907220351
4736406|4736406-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220347
4736276|4736276-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220344
4736271|4736271-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220344
4736083|4736083-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907220341
4735903|4735903-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220337
4735866|4735866-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220337
4735847|4735847-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220336
4734594|4734594-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211931
4733422|4733422-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211908
4732528|4732528-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211846
4732484|4732484-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211844
4731521|4731521-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211806
4731235|4731235-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211758
4731180|4731180-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211756
4731063|4731063-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211752
4730766|4730766-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211737
4730600|4730600-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211739
4729977|4729977-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211723
4729746|4729746-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211716
4729733|4729733-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211715
4729323|4729323-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211704
4729094|4729094-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211658
4729063|4729063-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211658
4728791|4728791-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211650
4727799|4727799-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211740
4727785|4727785-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211739
4727781|4727781-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211739
4727767|4727767-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211736
4727009|4727009-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211511
4727007|4727007-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211510
4726695|4726695-b19f-3f77-b713-d32bba55d77f|pass|200907|andy@hexten.net|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200907211420
4724251|4724251-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907210627
4722716|4722716-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200907210110
4722667|4722667-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200907210059
4722507|4722507-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.6|solaris|2.10|200907202310
4721610|4721610-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201739
4721175|4721175-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201729
4720349|4720349-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201708
4719799|4719799-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907202254
4718903|4718903-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201633
4718061|4718061-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201938
4717977|4717977-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201608
4717971|4717971-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201608
4717841|4717841-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201604
4717840|4717840-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201604
4717650|4717650-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201559
4717523|4717523-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201555
4717414|4717414-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201552
4717354|4717354-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201550
4717210|4717210-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201545
4716961|4716961-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201539
4716884|4716884-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201538
4716291|4716291-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201524
4716121|4716121-b19f-3f77-b713-d32bba55d77f|pass|200907|justin.d.hunter@gmail.com|Regexp-Log-Common|0.05|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201204
4715956|4715956-b19f-3f77-b713-d32bba55d77f|pass|200907|justin.d.hunter@gmail.com|Test-JSON-Meta|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201138
4715946|4715946-b19f-3f77-b713-d32bba55d77f|pass|200907|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.02|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201137
4715881|4715881-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.6|solaris|2.10|200907201905
4715146|4715146-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201606
4715137|4715137-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907201838
4715036|4715036-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907201825
4714761|4714761-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.6|solaris|2.10|200907201625
4714727|4714727-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.6|solaris|2.10|200907201622
4714725|4714725-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.6|solaris|2.10|200907201621
4714719|4714719-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.6|solaris|2.10|200907201621
4714550|4714550-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200907201726
4714238|4714238-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200907201656
4714112|4714112-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201406
4714106|4714106-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201404
4714096|4714096-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201403
4714091|4714091-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201403
4713794|4713794-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907201615
4713502|4713502-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907202328
4713493|4713493-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.07|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907202327
4712770|4712770-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200907201326
4712529|4712529-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907201248
4712402|4712402-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200907201229
4711987|4711987-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907201135
4711623|4711623-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|CPAN-Testers-Data-Uploads|0.07|i686-linux|5.10.0|linux|2.6.24-24-generic|200907200946
4711622|4711622-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|CPAN-Testers-Data-Release|0.02|i686-linux|5.10.0|linux|2.6.24-24-generic|200907200946
4711257|4711257-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200907200956
4710624|4710624-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200907200812
4710570|4710570-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200907200801
4710561|4710561-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200907200759
4710334|4710334-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200907200713
4710276|4710276-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200907200705
4709196|4709196-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200334
4709166|4709166-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907200334
4709053|4709053-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200907200531
4708666|4708666-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907200325
4708510|4708510-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907200323
4708507|4708507-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200323
4707788|4707788-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907200311
4707722|4707722-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200310
4707593|4707593-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200907200503
4706860|4706860-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200907200317
4706677|4706677-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200907200246
4706564|4706564-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907200033
4705646|4705646-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200907200004
4705157|4705157-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907192255
4704623|4704623-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200907192124
4704613|4704613-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200907192122
4704602|4704602-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200520
4704247|4704247-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907192019
4703956|4703956-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200907191928
4703803|4703803-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200256
4703399|4703399-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200907191740
4703369|4703369-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200907191737
4703173|4703173-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200110
4703072|4703072-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200907191655
4703064|4703064-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200907191653
4703043|4703043-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200907191647
4702627|4702627-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907191015
4702290|4702290-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907191009
4701521|4701521-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907190958
4701469|4701469-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190951
4700908|4700908-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907191548
4700904|4700904-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190948
4700614|4700614-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907191544
4700190|4700190-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190938
4699966|4699966-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190934
4699667|4699667-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190930
4699363|4699363-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200907191525
4698678|4698678-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190916
4698599|4698599-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190856
4698493|4698493-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190913
4698354|4698354-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190910
4698270|4698270-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190909
4697695|4697695-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190900
4697278|4697278-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190852
4697076|4697076-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907191437
4696678|4696678-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907191334
4696602|4696602-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907191329
4696103|4696103-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200907191221
4695948|4695948-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907191202
4695911|4695911-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907191158
4695795|4695795-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907191141
4695761|4695761-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907191137
4695391|4695391-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200907191053
4695251|4695251-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200907191033
4694869|4694869-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200907190908
4694865|4694865-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200907190907
4694789|4694789-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200907190841
4694764|4694764-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907190835
4694734|4694734-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200907190829
4694566|4694566-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200907190754
4694543|4694543-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200907190749
4694363|4694363-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200907190718
4694300|4694300-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200907190701
4693851|4693851-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200907190637
4693690|4693690-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190034
4693587|4693587-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200907190631
4693532|4693532-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190030
4692997|4692997-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190017
4692958|4692958-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190016
4691279|4691279-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200907190527
4691192|4691192-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190324
4691136|4691136-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190323
4691117|4691117-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190322
4691059|4691059-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190320
4690944|4690944-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190317
4690606|4690606-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190308
4690575|4690575-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190307
4690423|4690423-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190302
4690163|4690163-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190255
4689962|4689962-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190249
4689882|4689882-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190247
4689760|4689760-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190244
4689620|4689620-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190240
4689519|4689519-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190237
4689332|4689332-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190232
4688456|4688456-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190207
4688273|4688273-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190202
4688265|4688265-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190202
4688141|4688141-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190158
4687942|4687942-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190152
4686813|4686813-b19f-3f77-b713-d32bba55d77f|pass|200907|barthex@linux.e-cen.pl ("Bartosz Talaga")|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.2.26|200907182305
4685176|4685176-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.5|solaris|2.10|200907182043
4684775|4684775-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.5|solaris|2.10|200907181939
4684759|4684759-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181853
4684564|4684564-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181810
4684107|4684107-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|alpha-netbsd|5.10.0|netbsd|4.0.1|200907181656
4684054|4684054-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200907181650
4683824|4683824-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|IP35-irix-64int|5.8.8|irix|6.5|200907181821
4683778|4683778-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181615
4683762|4683762-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181613
4683755|4683755-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181612
4683753|4683753-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181612
4683651|4683651-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907190203
4683640|4683640-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.07|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907190202
4683604|4683604-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.5|solaris|2.10|200907181642
4683576|4683576-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.5|solaris|2.10|200907181639
4683567|4683567-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.5|solaris|2.10|200907181638
4683565|4683565-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.5|solaris|2.10|200907181638
4683375|4683375-b19f-3f77-b713-d32bba55d77f|pass|200907|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200907181724
4683178|4683178-b19f-3f77-b713-d32bba55d77f|pass|200907|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907182300
4683137|4683137-b19f-3f77-b713-d32bba55d77f|pass|200907|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907182256
4682844|4682844-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907180918
4682791|4682791-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907180911
4682630|4682630-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907181439
4682621|4682621-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907181438
4682617|4682617-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907181437
4682612|4682612-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907181437
4682608|4682608-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907181436
4682607|4682607-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200907181436
4682605|4682605-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907181436
4682596|4682596-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907181434
4682590|4682590-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907181432
4681890|4681890-b19f-3f77-b713-d32bba55d77f|fail|200907|castaway@desert-island.demon.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.20.1insel|200907172316
4679711|4679711-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907180121
4679350|4679350-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180115
4679184|4679184-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180112
4678934|4678934-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180108
4678275|4678275-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180057
4678274|4678274-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907180057
4678204|4678204-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180055
4677274|4677274-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180039
4677074|4677074-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180036
4676667|4676667-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180029
4675557|4675557-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180010
4675477|4675477-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180009
4675269|4675269-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180005
4674911|4674911-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180359
4674783|4674783-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180357
4674753|4674753-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180356
4674717|4674717-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180356
4674666|4674666-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180355
4674440|4674440-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180351
4674032|4674032-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|Test-CPAN-Meta|0.13|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907180305
4669811|4669811-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171915
4669797|4669797-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171913
4669691|4669691-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171858
4669685|4669685-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171857
4669671|4669671-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171856
4668932|4668932-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Test-JSON-Meta|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200907171639
4667381|4667381-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170959
4667374|4667374-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907171004
4667357|4667357-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907171004
4667309|4667309-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.17|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170703
4667239|4667239-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907171001
4667218|4667218-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.65|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170700
4667182|4667182-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171559
4666899|4666899-b19f-3f77-b713-d32bba55d77f|pass|200907|mw487.yahoo.com@gmail.com|Test-JSON-Meta|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200907170853
4666873|4666873-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170953
4666863|4666863-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170952
4666842|4666842-b19f-3f77-b713-d32bba55d77f|pass|200907|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Release|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200907170852
4666049|4666049-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170934
4665946|4665946-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170931
4665882|4665882-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170930
4665459|4665459-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.37|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170619
4665318|4665318-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170916
4665187|4665187-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170913
4664905|4664905-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170906
4664867|4664867-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|CPAN-Testers-Data-Release|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170606
4664559|4664559-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170859
4664289|4664289-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170855
4664230|4664230-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170854
4664046|4664046-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170850
4663991|4663991-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170849
4663445|4663445-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170840
4663114|4663114-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170834
4663094|4663094-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170833
4663084|4663084-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170833
4662815|4662815-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170829
4662756|4662756-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170828
4662346|4662346-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Parser|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170521
4662333|4662333-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170821
4662090|4662090-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170817
4661943|4661943-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170814
4661576|4661576-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170808
4661408|4661408-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200907171154
4661377|4661377-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907170650
4661326|4661326-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|IP35-irix-64int|5.8.8|irix|6.5|200907171346
4661308|4661308-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907171244
4661303|4661303-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907171244
4661297|4661297-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200907171243
4661292|4661292-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907171243
4661268|4661268-b19f-3f77-b713-d32bba55d77f|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907171241
4661045|4661045-b19f-3f77-b713-d32bba55d77f|pass|200907|mw487.yahoo.com@gmail.com|Test-JSON-Meta|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200907170609
4660521|4660521-b19f-3f77-b713-d32bba55d77f|pass|200907|imacat@mail.imacat.idv.tw|Test-JSON-Meta|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907171757
4660214|4660214-b19f-3f77-b713-d32bba55d77f|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200907171115
4660210|4660210-b19f-3f77-b713-d32bba55d77f|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris-64int|5.10.0|solaris|2.11|200907171114
4659809|4659809-b19f-3f77-b713-d32bba55d77f|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.02|i86pc-solaris-64int|5.8.9|solaris|2.11|200907171025
4659447|4659447-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170049
4659393|4659393-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Finance-Currency-Convert-XE|0.15|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907170845
4659059|4659059-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Release|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200907170806
4659057|4659057-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Release|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200907170806
4659028|4659028-b19f-3f77-b713-d32bba55d77f|pass|200907|rbo@cpan.org|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris|5.10.0|solaris|2.11|200907170857
4659000|4659000-b19f-3f77-b713-d32bba55d77f|pass|200907|rbo@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.10.0|solaris|2.11|200907170851
4658892|4658892-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.07|amd64-freebsd|5.8.8|freebsd|7.0-release|200907170806
4658886|4658886-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.07|amd64-freebsd|5.8.9|freebsd|7.0-release|200907170806
4658072|4658072-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker5@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170324
4658069|4658069-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170324
4657959|4657959-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170317
4657584|4657584-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170311
4657290|4657290-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170306
4657288|4657288-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170306
4657087|4657087-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170302
4656829|4656829-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170258
4655950|4655950-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170243
4655720|4655720-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170239
4655542|4655542-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170236
4655436|4655436-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170234
4655174|4655174-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170230
4655170|4655170-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170230
4655087|4655087-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170228
4655059|4655059-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170228
4654990|4654990-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170227
4654503|4654503-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170219
4654394|4654394-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170217
4653528|4653528-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.5100rc1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170202
4653415|4653415-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170200
4653248|4653248-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170157
4653224|4653224-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170157
4652897|4652897-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170151
4652871|4652871-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170150
4652248|4652248-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170140
4652130|4652130-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170138
4652030|4652030-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170136
4649799|4649799-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.10.0|solaris|2.10|200907162118
4649790|4649790-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris|5.10.0|solaris|2.10|200907162116
4649787|4649787-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.10.0|solaris|2.10|200907162115
4649786|4649786-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.10.0|solaris|2.10|200907162115
4648750|4648750-b19f-3f77-b713-d32bba55d77f|cpan|200907|BARBIE|CPAN-Testers-Data-Uploads|0.07||0|||200907162011
4648605|4648605-b19f-3f77-b713-d32bba55d77f|cpan|200907|BARBIE|CPAN-Testers-Data-Release|0.02||0|||200907161947
4648160|4648160-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907170259
4648043|4648043-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.4|solaris|2.10|200907161738
4647731|4647731-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907170216
4647463|4647463-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.4|solaris|2.10|200907161634
4647422|4647422-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161641
4647023|4647023-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161544
4645959|4645959-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.4|solaris|2.10|200907161335
4645949|4645949-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200907161345
4645862|4645862-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907162236
4645674|4645674-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161311
4645621|4645621-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-JSON-Meta|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907162207
4644592|4644592-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200907161104
4644539|4644539-b19f-3f77-b713-d32bba55d77f|pass|200907|JOST@cpan.org ("Josts Smokehouse")|Test-JSON-Meta|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200907161157
4643340|4643340-b19f-3f77-b713-d32bba55d77f|pass|200907|JOST@cpan.org ("Josts Smokehouse")|Test-JSON-Meta|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200907160955
4643132|4643132-b19f-3f77-b713-d32bba55d77f|pass|200907|rbo@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.10.0|solaris|2.11|200907160934
4642844|4642844-b19f-3f77-b713-d32bba55d77f|pass|200907|rbo@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.10.0|solaris|2.11|200907160855
4642166|4642166-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-JSON-Meta|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907161514
4641996|4641996-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160021
4641151|4641151-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160008
4641011|4641011-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160005
4639451|4639451-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160337
4639197|4639197-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4639185|4639185-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4639175|4639175-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4638324|4638324-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160315
4638128|4638128-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907160310
4637656|4637656-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160259
4637598|4637598-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160258
4637176|4637176-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160247
4636300|4636300-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907160227
4636135|4636135-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160223
4635947|4635947-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160218
4635798|4635798-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907160213
4632851|4632851-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|Test-JSON-Meta|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200907152123
4632807|4632807-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|Test-JSON-Meta|0.01|i86pc-solaris|5.10.0|solaris|2.10|200907152054
4632560|4632560-b19f-3f77-b713-d32bba55d77f|pass|200907|srezic@cpan.org|Test-JSON-Meta|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200907152123
4630963|4630963-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151437
4630959|4630959-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151437
4630583|4630583-b19f-3f77-b713-d32bba55d77f|cpan|200907|BARBIE|Test-JSON-Meta|0.01||0|||200907152028
4630224|4630224-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907151420
4630172|4630172-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151419
4628980|4628980-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151350
4628861|4628861-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907151347
4628846|4628846-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907151347
4628217|4628217-b19f-3f77-b713-d32bba55d77f|pass|200907|jeff@zeroclue.com|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907151030
4627063|4627063-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151259
4626824|4626824-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151252
4625965|4625965-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151223
4625718|4625718-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151213
4625640|4625640-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151211
4625562|4625562-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151208
4625260|4625260-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151200
4624907|4624907-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.24-24-generic|200907151650
4624796|4624796-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151147
4624507|4624507-b19f-3f77-b713-d32bba55d77f|pass|200907|brian@minton.name|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.4-dsa-dl380-oldxeon|200907151126
4621697|4621697-b19f-3f77-b713-d32bba55d77f|pass|200907|paul@mystery-land.net|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.30.1-dsa-ia32|200907150950
4618242|4618242-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150320
4617961|4617961-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.5100@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150309
4617690|4617690-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907150258
4617351|4617351-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150246
4617298|4617298-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150244
4615167|4615167-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker8@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150153
4614742|4614742-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150145
4612617|4612617-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907141850
4612005|4612005-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141824
4610946|4610946-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker7@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141726
4610682|4610682-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141704
4610490|4610490-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.10.0|solaris|2.10|200907142145
4610263|4610263-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907141640
4609584|4609584-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141602
4608233|4608233-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141511
4608020|4608020-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141505
4607915|4607915-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150503
4607512|4607512-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141452
4607409|4607409-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141449
4607056|4607056-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141441
4607011|4607011-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141440
4606996|4606996-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141440
4606715|4606715-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150433
4606706|4606706-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150433
4606490|4606490-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150413
4605401|4605401-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150219
4599553|4599553-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140232
4599400|4599400-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.10.0|openbsd|4.5|200907140734
4598320|4598320-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140122
4597681|4597681-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140109
4597466|4597466-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140058
4597323|4597323-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140103
4595599|4595599-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140321
4592972|4592972-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140107
4591587|4591587-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140041
4591489|4591489-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907140040
4591180|4591180-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140034
4591132|4591132-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140032
4590478|4590478-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140020
4589586|4589586-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140005
4589061|4589061-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker9@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131955
4586905|4586905-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907131913
4585439|4585439-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131836
4585399|4585399-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131835
4584237|4584237-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131633
4584113|4584113-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131623
4581015|4581015-b19f-3f77-b713-d32bba55d77f|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131242
4580545|4580545-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200907131659
4577843|4577843-b19f-3f77-b713-d32bba55d77f|pass|200907|artur+cpan@niif.spb.su (ARTO)|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200907131508
4576334|4576334-b19f-3f77-b713-d32bba55d77f|pass|200907|rlane10@wi.rr.com|Test-YAML-Meta|0.12|darwin-2level-ld|5.10.0|darwin|8.11.0|200907130247
4575414|4575414-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131903
4573772|4573772-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130357
4573626|4573626-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907130345
4573555|4573555-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907130340
4573192|4573192-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130321
4571869|4571869-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130233
4571653|4571653-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907130225
4571649|4571649-b19f-3f77-b713-d32bba55d77f|unknown|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130225
4570787|4570787-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131156
4570760|4570760-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131155
4569062|4569062-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130804
4568323|4568323-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130556
4568310|4568310-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130554
4568064|4568064-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130513
4568061|4568061-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130513
4564442|4564442-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120147
4564175|4564175-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120141
4563902|4563902-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120133
4563758|4563758-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120129
4563756|4563756-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120129
4563551|4563551-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120123
4563540|4563540-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120123
4563445|4563445-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120120
4563442|4563442-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120120
4563119|4563119-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120110
4562836|4562836-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120102
4562797|4562797-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120101
4562686|4562686-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120058
4562457|4562457-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120051
4562445|4562445-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120051
4562219|4562219-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120045
4561923|4561923-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120036
4561415|4561415-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120024
4561229|4561229-b19f-3f77-b713-d32bba55d77f|pass|200907|bob@randomness.org.uk ("bob walker")|Test-YAML-Meta|0.12|i86pc-solaris|5.10.0|solaris|2.10|200907120117
4561084|4561084-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120014
4560862|4560862-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120008
4560756|4560756-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120005
4560746|4560746-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120005
4560633|4560633-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120002
4560549|4560549-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120000
4560432|4560432-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907111957
4559999|4559999-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111950
4559717|4559717-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111944
4559659|4559659-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111943
4559457|4559457-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111940
4559268|4559268-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111935
4559202|4559202-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907111933
4559183|4559183-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907111933
4558952|4558952-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111929
4558903|4558903-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111928
4558894|4558894-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111928
4558734|4558734-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111925
4558675|4558675-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111924
4558674|4558674-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907111924
4558191|4558191-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111913
4558185|4558185-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111913
4557581|4557581-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.5|200907112330
4557487|4557487-b19f-3f77-b713-d32bba55d77f|pass|200907|alexchorny@gmail.com|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.4.20-8smp|200907111420
4552834|4552834-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200907110425
4552543|4552543-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111822
4552538|4552538-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111821
4550682|4550682-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907110138
4550681|4550681-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907110138
4549731|4549731-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907110118
4548529|4548529-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907110055
4548070|4548070-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907110044
4546828|4546828-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907110006
4546533|4546533-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111249
4546528|4546528-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111247
4546418|4546418-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111227
4546415|4546415-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111226
4546377|4546377-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111221
4546376|4546376-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111221
4546285|4546285-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111202
4545909|4545909-b19f-3f77-b713-d32bba55d77f|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907110959
4544511|4544511-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200907102025
4543322|4543322-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101429
4543257|4543257-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101427
4543212|4543212-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101426
4542992|4542992-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101421
4542817|4542817-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101417
4542614|4542614-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101411
4542505|4542505-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101407
4536496|4536496-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24-24-generic|200907101310
4529474|4529474-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907100027
4528637|4528637-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907100011
4527364|4527364-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091947
4527022|4527022-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091937
4526811|4526811-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091933
4526171|4526171-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907091921
4521156|4521156-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907091105
4520988|4520988-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091059
4519735|4519735-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091019
4519561|4519561-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091015
4519232|4519232-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091007
4518807|4518807-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|Regexp-Log-Common|0.05|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907091658
4518305|4518305-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907090945
4516058|4516058-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907090846
4515129|4515129-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907090824
4510939|4510939-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907090213
4510289|4510289-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907090000
4509825|4509825-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Mail-File|0.08|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082217
4509359|4509359-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|GD-Chart-Radial|0.07|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082106
4509356|4509356-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Games-Trackword|1.06|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082105
4508683|4508683-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081534
4508155|4508155-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200907082018
4507310|4507310-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081324
4505671|4505671-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907081241
4503070|4503070-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081132
4502958|4502958-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081129
4502877|4502877-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081128
4502365|4502365-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081112
4502059|4502059-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081105
4501996|4501996-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907081103
4501948|4501948-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907081102
4501600|4501600-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081056
4501575|4501575-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081055
4501438|4501438-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081554
4501395|4501395-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081553
4501377|4501377-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081553
4501361|4501361-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081552
4501329|4501329-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081551
4501246|4501246-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081548
4501097|4501097-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081526
4501081|4501081-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081523
4501068|4501068-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081521
4501045|4501045-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081518
4501042|4501042-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081518
4500723|4500723-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Calendar-List|0.21|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081430
4496380|4496380-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907080459
4495796|4495796-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907072351
4494665|4494665-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071321
4494659|4494659-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071320
4494612|4494612-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071319
4494556|4494556-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071318
4493643|4493643-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071247
4493618|4493618-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071246
4492509|4492509-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071219
4492471|4492471-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071219
4491482|4491482-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071156
4490876|4490876-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071138
4490384|4490384-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071122
4490164|4490164-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071114
4489982|4489982-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907071108
4489939|4489939-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071107
4489838|4489838-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071102
4489833|4489833-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071102
4489740|4489740-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907071058
4489418|4489418-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200907071541
4489412|4489412-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24-24-generic|200907071541
4488086|4488086-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-64int|5.10.0 patch GitLive-maint-5.10-1501-gba4fcaa|netbsd|5.0|200907071252
4481321|4481321-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061907
4481275|4481275-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061906
4481267|4481267-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061905
4481026|4481026-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061858
4480270|4480270-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.01|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907070133
4480192|4480192-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061829
4479988|4479988-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061822
4479512|4479512-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.41|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070110
4479482|4479482-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.40|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070109
4479458|4479458-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.39|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070109
4479344|4479344-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070106
4479215|4479215-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070103
4479198|4479198-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070102
4479182|4479182-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061802
4479161|4479161-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061801
4478920|4478920-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061756
4476450|4476450-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200907061626
4476356|4476356-b19f-3f77-b713-d32bba55d77f|pass|200907|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907062033
4475734|4475734-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061310
4475032|4475032-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061252
4474842|4474842-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061247
4474533|4474533-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061239
4474504|4474504-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061238
4474472|4474472-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061238
4473985|4473985-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061226
4473963|4473963-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061225
4473832|4473832-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061221
4473655|4473655-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061217
4472851|4472851-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061157
4471558|4471558-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061129
4471179|4471179-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061121
4470325|4470325-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061101
4469889|4469889-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061049
4469600|4469600-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061042
4463152|4463152-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060122
4462467|4462467-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060110
4462429|4462429-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060109
4462145|4462145-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907060103
4462068|4462068-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060101
4461298|4461298-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060047
4461270|4461270-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060046
4461259|4461259-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060046
4460925|4460925-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060037
4460729|4460729-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907060033
4459461|4459461-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060007
4459272|4459272-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060003
4457184|4457184-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.11.0|netbsd|5.0|200907052008
4455642|4455642-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050944
4455402|4455402-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050947
4455327|4455327-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050946
4454885|4454885-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050938
4454201|4454201-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050927
4454077|4454077-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050925
4454032|4454032-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050924
4453727|4453727-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050918
4453505|4453505-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050914
4453458|4453458-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050913
4452927|4452927-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050905
4452552|4452552-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050859
4452525|4452525-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050858
4452471|4452471-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050857
4452369|4452369-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050855
4452133|4452133-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050851
4452089|4452089-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050850
4451892|4451892-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050847
4451818|4451818-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050846
4451671|4451671-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050844
4451659|4451659-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050843
4451504|4451504-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050841
4451209|4451209-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050837
4451045|4451045-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050834
4450945|4450945-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050832
4450804|4450804-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050830
4450788|4450788-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050829
4450761|4450761-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050829
4450535|4450535-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050824
4445851|4445851-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041800
4445053|4445053-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041739
4444771|4444771-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041746
4444734|4444734-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041746
4444040|4444040-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041733
4443918|4443918-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041730
4443341|4443341-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041718
4442641|4442641-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041706
4442500|4442500-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041703
4442232|4442232-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041658
4441745|4441745-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041649
4440034|4440034-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041616
4439845|4439845-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041611
4439592|4439592-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041606
4437862|4437862-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041158
4437626|4437626-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041152
4437558|4437558-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041151
4437548|4437548-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041151
4437214|4437214-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041145
4437200|4437200-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200907041644
4436762|4436762-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041137
4436693|4436693-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041136
4436689|4436689-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041136
4436425|4436425-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041131
4436151|4436151-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041126
4435557|4435557-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041115
4435462|4435462-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041114
4435241|4435241-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041110
4435042|4435042-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041104
4434404|4434404-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041047
4433966|4433966-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041036
4433900|4433900-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041034
4433855|4433855-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041033
4433775|4433775-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041032
4433731|4433731-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041031
4433549|4433549-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041007
4433366|4433366-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041008
4433202|4433202-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907040957
4433127|4433127-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041012
4433101|4433101-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041011
4432604|4432604-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907040958
4432600|4432600-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907040958
4432479|4432479-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907040953
4432468|4432468-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907040953
4431877|4431877-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907040930
4431680|4431680-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907040925
4426667|4426667-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031429
4426025|4426025-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031458
4425979|4425979-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031457
4425721|4425721-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031451
4425694|4425694-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031450
4423672|4423672-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907031410
4423225|4423225-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031400
4421911|4421911-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031333
4421657|4421657-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031327
4421561|4421561-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031325
4421445|4421445-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907031322
4421346|4421346-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031319
4416909|4416909-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0 patch GitLive-maint-5.10-1462-g178839f|midnightbsd|0.1.1-release|200907030600
4413860|4413860-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021949
4413672|4413672-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021946
4413464|4413464-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021942
4413106|4413106-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021933
4412295|4412295-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021912
4412069|4412069-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021904
4412003|4412003-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021903
4410942|4410942-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021835
4410785|4410785-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021831
4410361|4410361-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021821
4410175|4410175-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021815
4409381|4409381-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021755
4409338|4409338-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021753
4409281|4409281-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021752
4408944|4408944-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021744
4407533|4407533-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200907021951
4405338|4405338-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021132
4405050|4405050-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021048
4405049|4405049-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021048
4404883|4404883-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021036
4403276|4403276-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020049
4402952|4402952-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020043
4402931|4402931-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020043
4401841|4401841-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020022
4401462|4401462-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020011
4401296|4401296-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020006
4401048|4401048-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020358
4400995|4400995-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020357
4400931|4400931-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker3@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020355
4400638|4400638-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker7@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020345
4400364|4400364-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020337
4397499|4397499-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011737
4397031|4397031-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907011716
4396578|4396578-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker8@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011653
4396101|4396101-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011628
4395363|4395363-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011547
4395054|4395054-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011533
4394617|4394617-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011512
4393471|4393471-b19f-3f77-b713-d32bba55d77f|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.11.0 patch GitLive-blead-1493-g9015f10|midnightbsd|0.1.1-release|200907011622
4393098|4393098-b19f-3f77-b713-d32bba55d77f|fail|200907|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011145
4392793|4392793-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011129
4392664|4392664-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907011122
4392342|4392342-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907011102
4392312|4392312-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.589@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907011101
4390853|4390853-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010959
4390667|4390667-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907010950
4388838|4388838-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907010845
4384554|4384554-b19f-3f77-b713-d32bba55d77f|pass|200907|martin.evans@easysoft.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.24-19-server|200907010943
4382674|4382674-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907010318
4382175|4382175-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907010044
4381786|4381786-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010028
4381429|4381429-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010019
4380911|4380911-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907010008
4380839|4380839-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010007
4380833|4380833-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker9@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907010007
4380582|4380582-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010004
4380535|4380535-b19f-3f77-b713-d32bba55d77f|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907010004
4380061|4380061-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301958
4380052|4380052-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301958
4379935|4379935-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906301956
4379607|4379607-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906301952
4378558|4378558-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301937
4378151|4378151-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906301931
4377851|4377851-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906301927
4377626|4377626-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301923
4377558|4377558-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301922
4376856|4376856-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301848
4376699|4376699-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301844
4375353|4375353-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301818
4374781|4374781-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906302301
4374530|4374530-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301608
4374446|4374446-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906302141
4368619|4368619-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd|5.8.9|midnightbsd|0.1.1-release|200906300443
4368262|4368262-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200906300427
4367273|4367273-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906300246
4367073|4367073-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300237
4366342|4366342-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300212
4365587|4365587-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300158
4364372|4364372-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906300140
4364119|4364119-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300136
4363834|4363834-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300131
4363611|4363611-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906300128
4363416|4363416-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300125
4362782|4362782-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906300113
4362469|4362469-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300108
4362421|4362421-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300108
4358790|4358790-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291525
4358561|4358561-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291519
4358064|4358064-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291508
4356620|4356620-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291428
4356427|4356427-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291423
4356403|4356403-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291423
4356251|4356251-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291420
4355554|4355554-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906291904
4355148|4355148-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291354
4353771|4353771-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291320
4352141|4352141-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906291001
4348577|4348577-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291006
4348569|4348569-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291003
4348552|4348552-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291000
4348373|4348373-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290940
4348368|4348368-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290939
4348362|4348362-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290938
4347362|4347362-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290058
4347359|4347359-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290056
4347100|4347100-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290008
4347078|4347078-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290602
4347077|4347077-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290002
4346982|4346982-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-NNTP|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290537
4346937|4346937-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906290336
4346591|4346591-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290329
4345121|4345121-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290029
4341042|4341042-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906281008
4340546|4340546-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280921
4340246|4340246-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280927
4339709|4339709-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280946
4339618|4339618-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280948
4339429|4339429-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280957
4339364|4339364-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280956
4339225|4339225-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280953
4338978|4338978-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280949
4338541|4338541-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280940
4338447|4338447-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280938
4337610|4337610-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280921
4337529|4337529-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280919
4336723|4336723-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280904
4335572|4335572-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280842
4335333|4335333-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280824
4335315|4335315-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280837
4335299|4335299-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280837
4334617|4334617-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906280824
4334211|4334211-b19f-3f77-b713-d32bba55d77f|pass|200906|joerg.meltzer@tngtech.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906271510
4331867|4331867-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906280922
4330025|4330025-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906280401
4328677|4328677-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200906280022
4326863|4326863-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd|5.10.0|midnightbsd|0.1.1-release|200906272030
4322583|4322583-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906271053
4322515|4322515-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906271043
4322389|4322389-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906271022
4315389|4315389-b19f-3f77-b713-d32bba55d77f|pass|200906|lists.perl.cpan-testers@csjewell.fastmail.us (Curtis Jewell)|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200906260055
4315228|4315228-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200906261527
4309814|4309814-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906260130
4307066|4307066-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251757
4306816|4306816-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251751
4306793|4306793-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251750
4306388|4306388-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251739
4303835|4303835-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251221
4303196|4303196-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251129
4302780|4302780-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906251205
4302741|4302741-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251202
4301969|4301969-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906251227
4301868|4301868-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251223
4301346|4301346-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251217
4301208|4301208-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251227
4300801|4300801-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251218
4300629|4300629-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251214
4300550|4300550-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251213
4300512|4300512-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251153
4300135|4300135-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251204
4299694|4299694-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251058
4299440|4299440-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251130
4299336|4299336-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251146
4299016|4299016-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251139
4298992|4298992-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251139
4298875|4298875-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251117
4298812|4298812-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251133
4298775|4298775-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251133
4298754|4298754-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251133
4298749|4298749-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251132
4298568|4298568-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251117
4298173|4298173-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251121
4298127|4298127-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251120
4297560|4297560-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251106
4297425|4297425-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251103
4296349|4296349-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251416
4296345|4296345-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251416
4295189|4295189-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251120
4293003|4293003-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906250525
4291803|4291803-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.smoker5@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250035
4290990|4290990-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250016
4290984|4290984-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250016
4290668|4290668-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906250410
4290275|4290275-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250001
4289970|4289970-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250355
4288718|4288718-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906250327
4288696|4288696-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250326
4288694|4288694-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906250326
4288539|4288539-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250323
4288341|4288341-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906250318
4288304|4288304-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250317
4288299|4288299-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250317
4287961|4287961-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906250310
4287749|4287749-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250305
4287507|4287507-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250300
4287225|4287225-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250254
4286871|4286871-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250246
4286867|4286867-b19f-3f77-b713-d32bba55d77f|unknown|200906|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250245
4283773|4283773-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906241648
4283771|4283771-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906241648
4283177|4283177-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240840
4282885|4282885-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240837
4282871|4282871-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240836
4282818|4282818-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240831
4282113|4282113-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240845
4282057|4282057-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240843
4281273|4281273-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240829
4280025|4280025-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240810
4280009|4280009-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240809
4279892|4279892-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240807
4279617|4279617-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240759
4279424|4279424-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240754
4279014|4279014-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240744
4278573|4278573-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906241235
4278406|4278406-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906241206
4278050|4278050-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200906240915
4277793|4277793-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906231037
4277702|4277702-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906240815
4277657|4277657-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906240758
4277603|4277603-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906240735
4277480|4277480-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240511
4277363|4277363-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906240641
4277349|4277349-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240437
4277178|4277178-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906240618
4276519|4276519-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240352
4276486|4276486-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906231050
4276452|4276452-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240350
4276315|4276315-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240345
4276209|4276209-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240341
4275905|4275905-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240332
4275831|4275831-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240330
4275514|4275514-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240321
4274953|4274953-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240308
4274868|4274868-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240306
4274644|4274644-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240300
4274526|4274526-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906240456
4274133|4274133-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240246
4273998|4273998-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240243
4273827|4273827-b19f-3f77-b713-d32bba55d77f|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240239
4273694|4273694-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906231037
4272846|4272846-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906231340
4272110|4272110-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906231359
4271921|4271921-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231349
4271822|4271822-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231339
4271712|4271712-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231041
4271393|4271393-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906231038
4270521|4270521-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906240031
4269944|4269944-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906232317
4268764|4268764-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231355
4267685|4267685-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221724
4267519|4267519-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.24-24-generic|200906231640
4266514|4266514-b19f-3f77-b713-d32bba55d77f|pass|200906|andy@hexten.net|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200906231539
4265809|4265809-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200906231417
4265622|4265622-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221827
4265055|4265055-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221716
4264109|4264109-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221732
4263918|4263918-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221820
4263729|4263729-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221812
4263514|4263514-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221655
4262983|4262983-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221701
4262712|4262712-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906230015
4262393|4262393-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221811
4261051|4261051-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221655
4260919|4260919-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221702
4259671|4259671-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi|5.8.9|netbsd|5.0|200906230406
4258952|4258952-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221356
4258366|4258366-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221509
4257470|4257470-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221531
4257310|4257310-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221505
4257280|4257280-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221357
4257099|4257099-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221531
4256796|4256796-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221524
4256554|4256554-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221517
4255743|4255743-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221524
4255158|4255158-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221520
4254791|4254791-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221517
4254553|4254553-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221507
4254393|4254393-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221502
4253740|4253740-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221347
4253602|4253602-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221355
4253342|4253342-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221345
4251426|4251426-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906220142
4250919|4250919-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.24-24-generic|200906221208
4247755|4247755-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906211927
4247514|4247514-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906211908
4247383|4247383-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906211917
4244498|4244498-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906212028
4244376|4244376-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906212003
4242465|4242465-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0|200906211325
4239925|4239925-b19f-3f77-b713-d32bba55d77f|pass|200906|emer@emer.net|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|9.6.0|200906201237
4239465|4239465-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200906210736
4232094|4232094-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210138
4232023|4232023-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210137
4231033|4231033-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210058
4230902|4230902-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210050
4230661|4230661-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210018
4230337|4230337-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210913
4230335|4230335-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210912
4230017|4230017-b19f-3f77-b713-d32bba55d77f|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200906201822
4228951|4228951-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.8.7|darwin|8.11.0|200906202020
4226827|4226827-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210126
4226813|4226813-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210123
4226615|4226615-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210057
4226497|4226497-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210045
4226226|4226226-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210013
4224124|4224124-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201303
4224034|4224034-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201245
4224023|4224023-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201244
4221766|4221766-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906201124
4220468|4220468-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906192232
4214510|4214510-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906190708
4214505|4214505-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906190707
4212577|4212577-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190117
4212572|4212572-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190116
4212508|4212508-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190103
4212497|4212497-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190100
4212494|4212494-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190059
4212475|4212475-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190055
4212474|4212474-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190054
4212426|4212426-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190041
4212424|4212424-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190040
4212421|4212421-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190040
4211968|4211968-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906182245
4211961|4211961-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.8.9|netbsd|5.0|200906182138
4211911|4211911-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906182234
4211863|4211863-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-NNTP|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906182218
4211372|4211372-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906182043
4210034|4210034-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906181513
4207546|4207546-b19f-3f77-b713-d32bba55d77f|pass|200906|mmlange@cpan.org (Matthew Lange)|Test-YAML-Meta|0.12|x86_64-linux|5.8.8|linux|2.6.25-gentoo-r7a1|200906171153
4205974|4205974-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906180651
4205871|4205871-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906180635
4205435|4205435-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200906180426
4201729|4201729-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200906171820
4198671|4198671-b19f-3f77-b713-d32bba55d77f|pass|200906|brian@minton.name|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.4-dsa-dl380-oldxeon|200906161610
4198654|4198654-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-64int|5.10.0|netbsd|5.0|200906171317
4198391|4198391-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200906171300
4197688|4197688-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906170333
4197388|4197388-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906171144
4194253|4194253-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.9|darwin|8.11.0|200906162339
4192949|4192949-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-64int-2level|5.8.9|darwin|8.11.0|200906162039
4191229|4191229-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200906161608
4188189|4188189-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160829
4188179|4188179-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160827
4188167|4188167-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160823
4188084|4188084-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160807
4188077|4188077-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160806
4188067|4188067-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160805
4187636|4187636-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd|5.8.9|netbsd|5.0|200906160559
4187082|4187082-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160556
4186817|4186817-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200906160407
4185957|4185957-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200906160202
4184573|4184573-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.8.9|netbsd|5.0|200906152345
4183884|4183884-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151441
4183718|4183718-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd|5.8.9|netbsd|5.0|200906152210
4183714|4183714-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd|5.8.9|netbsd|5.0|200906152209
4183697|4183697-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd|5.8.9|netbsd|5.0|200906152207
4183672|4183672-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd|5.8.9|netbsd|5.0|200906152203
4183281|4183281-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151256
4183280|4183280-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4183277|4183277-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4183276|4183276-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4179027|4179027-b19f-3f77-b713-d32bba55d77f|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906150600
4178074|4178074-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|armv5tejl-linux|5.10.0|linux|2.6.17.14|200906151159
4175718|4175718-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|WWW-UsePerl-Journal|0.22|armv5tejl-linux|5.10.0|linux|2.6.17.14|200906150315
4173895|4173895-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd|5.10.0|netbsd|5.0|200906142132
4172381|4172381-b19f-3f77-b713-d32bba55d77f|pass|200906|l.mai@web.de|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.22-gentoo-r9|200906131705
4172057|4172057-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.10.0|netbsd|5.0|200906140057
4171666|4171666-b19f-3f77-b713-d32bba55d77f|pass|200906|bernt.guldbrandtsen@agrsci.dk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5|200906132217
4171325|4171325-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132358
4170942|4170942-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd|5.10.0|netbsd|5.0|200906132301
4170939|4170939-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd|5.10.0|netbsd|5.0|200906132300
4170892|4170892-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd|5.10.0|netbsd|5.0|200906132254
4170889|4170889-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd|5.10.0|netbsd|5.0|200906132254
4170867|4170867-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd|5.10.0|netbsd|5.0|200906132249
4170857|4170857-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd|5.10.0|netbsd|5.0|200906132247
4170837|4170837-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd|5.10.0|netbsd|5.0|200906132242
4170179|4170179-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132035
4170169|4170169-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132034
4170149|4170149-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132030
4170101|4170101-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132022
4169912|4169912-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131148
4169362|4169362-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131009
4169356|4169356-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131009
4169353|4169353-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131008
4169352|4169352-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131008
4169027|4169027-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131711
4168404|4168404-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906121554
4168217|4168217-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131417
4168215|4168215-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131416
4168175|4168175-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131411
4168167|4168167-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131410
4168166|4168166-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131409
4167296|4167296-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906131207
4166146|4166146-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906130611
4165797|4165797-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906130548
4165607|4165607-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130303
4165574|4165574-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130356
4165084|4165084-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906130335
4165036|4165036-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130125
4165033|4165033-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130125
4165032|4165032-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4165031|4165031-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4165030|4165030-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4164564|4164564-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130043
4164561|4164561-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130042
4164557|4164557-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130041
4164519|4164519-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120439
4164510|4164510-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906110249
4164474|4164474-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120440
4164280|4164280-b19f-3f77-b713-d32bba55d77f|pass|200906|davidp@preshweb.co.uk ("David Precious")|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.25-arch|200906122128
4164181|4164181-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120438
4164134|4164134-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120437
4163817|4163817-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Statistics|0.64|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906121343
4163715|4163715-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120500
4163667|4163667-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120439
4163665|4163665-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120438
4163664|4163664-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120437
4161283|4161283-b19f-3f77-b713-d32bba55d77f|pass|200906|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906121618
4161273|4161273-b19f-3f77-b713-d32bba55d77f|pass|200906|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906121617
4161223|4161223-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121505
4160603|4160603-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121310
4160599|4160599-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121309
4160574|4160574-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121304
4160572|4160572-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121303
4160546|4160546-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121259
4160543|4160543-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121258
4160542|4160542-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121258
4156532|4156532-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906120052
4155758|4155758-b19f-3f77-b713-d32bba55d77f|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-64int-ld|5.10.0|linux|2.6.27.4-chii.profvince.com|200906112305
4155523|4155523-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112056
4155521|4155521-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112056
4155492|4155492-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112051
4155487|4155487-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112050
4155486|4155486-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112050
4154538|4154538-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906111650
4153018|4153018-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111036
4153017|4153017-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.7|darwin|8.11.0|200906111036
4153015|4153015-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111035
4153012|4153012-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111034
4152971|4152971-b19f-3f77-b713-d32bba55d77f|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906110657
4152332|4152332-b19f-3f77-b713-d32bba55d77f|fail|200906|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-24-generic|200906110925
4149298|4149298-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110056
4149292|4149292-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110054
4149275|4149275-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110050
4149271|4149271-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110049
4149259|4149259-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110045
4149251|4149251-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110044
4149249|4149249-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110044
4148594|4148594-b19f-3f77-b713-d32bba55d77f|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-20-eeepc|200906102307
4148342|4148342-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906102205
4147875|4147875-b19f-3f77-b713-d32bba55d77f|pass|200906|vpit@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200906102033
4147874|4147874-b19f-3f77-b713-d32bba55d77f|pass|200906|vpit@cpan.org|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200906102032
4147462|4147462-b19f-3f77-b713-d32bba55d77f|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200906101208
4145813|4145813-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101522
4145808|4145808-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101522
4145641|4145641-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.4.27-2-386|200906101550
4145638|4145638-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Test-CPAN-Meta|0.13|i686-linux|5.8.8|linux|2.4.27-2-386|200906101549
4145248|4145248-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200906101411
4145180|4145180-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101406
4145173|4145173-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101406
4145135|4145135-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906101403
4144807|4144807-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906101342
4144704|4144704-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101332
4144584|4144584-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101304
4144571|4144571-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906101302
4144507|4144507-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101251
4144504|4144504-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101251
4144371|4144371-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906101240
4144243|4144243-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200906101230
4144048|4144048-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906101217
4144044|4144044-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101217
4144042|4144042-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101117
4144034|4144034-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101216
4144025|4144025-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4144015|4144015-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4144008|4144008-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4143957|4143957-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906101212
4143490|4143490-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200906101126
4143472|4143472-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101123
4143294|4143294-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906101108
4142986|4142986-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200906101047
4142981|4142981-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101047
4142622|4142622-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906101018
4142409|4142409-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200906100959
4141877|4141877-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100920
4141659|4141659-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906100854
4141599|4141599-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100846
4141551|4141551-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100837
4141496|4141496-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100828
4141387|4141387-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100815
4141316|4141316-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906100804
4141280|4141280-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100757
4141209|4141209-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100747
4141177|4141177-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906100741
4141168|4141168-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100739
4141071|4141071-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100720
4141038|4141038-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906100710
4141037|4141037-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100710
4140816|4140816-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906100621
4140372|4140372-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906100444
4140354|4140354-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100338
4140352|4140352-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100338
4140341|4140341-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906100436
4140323|4140323-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100332
4140316|4140316-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100329
4140314|4140314-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100328
4140281|4140281-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906100422
4140274|4140274-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200906100421
4140263|4140263-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906100420
4140208|4140208-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906100410
4140153|4140153-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100401
4140144|4140144-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906100359
4140100|4140100-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906100350
4140082|4140082-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200906100348
4140064|4140064-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906100345
4139994|4139994-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200906100336
4139846|4139846-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906100321
4139637|4139637-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100308
4139466|4139466-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100258
4139453|4139453-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100256
4139451|4139451-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906100256
4139403|4139403-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100253
4139388|4139388-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200906100252
4139296|4139296-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906100245
4139279|4139279-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906100242
4139066|4139066-b19f-3f77-b713-d32bba55d77f|pass|200906|angryxpeh@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.26-2-686|200906100019
4138990|4138990-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200906100229
4138860|4138860-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906100219
4138440|4138440-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906100120
4138437|4138437-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906100120
4138392|4138392-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906100115
4138300|4138300-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200906100103
4137926|4137926-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200906100016
4137901|4137901-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200906100013
4137793|4137793-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200906100001
4137779|4137779-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906100000
4137773|4137773-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906100000
4137737|4137737-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906092353
4137714|4137714-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906092344
4136377|4136377-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091703
4136374|4136374-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091703
4136372|4136372-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091702
4136364|4136364-b19f-3f77-b713-d32bba55d77f|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906100159
4136360|4136360-b19f-3f77-b713-d32bba55d77f|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906100158
4135489|4135489-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200906091351
4135467|4135467-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906090849
4135338|4135338-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|IP35-irix-64int|5.8.8|irix|6.5|200906091532
4135304|4135304-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906091426
4135248|4135248-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906091416
4135244|4135244-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906091416
4135231|4135231-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200906091414
4135223|4135223-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200906091413
4135098|4135098-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Generator|0.37|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091326
4135097|4135097-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091326
4135062|4135062-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091315
4135060|4135060-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091315
4135056|4135056-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091313
4135053|4135053-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091312
4135048|4135048-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091311
4135047|4135047-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091311
4135045|4135045-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091311
4135044|4135044-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091311
4134992|4134992-b19f-3f77-b713-d32bba55d77f|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200906091356
4134591|4134591-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091101
4134520|4134520-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.6|darwin|8.11.0|200906091042
4134516|4134516-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200906091140
4134319|4134319-b19f-3f77-b713-d32bba55d77f|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906091632
4134215|4134215-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200906090956
4133789|4133789-b19f-3f77-b713-d32bba55d77f|pass|200906|rbo@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris|5.10.0|solaris|2.11|200906090834
4133662|4133662-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906090810
4133603|4133603-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133601|4133601-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133600|4133600-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133596|4133596-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.26-2-686|200906090828
4133371|4133371-b19f-3f77-b713-d32bba55d77f|fail|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4133370|4133370-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4133369|4133369-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4132886|4132886-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091316
4132878|4132878-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091314
4132851|4132851-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200906090301
4132627|4132627-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906090416
4132620|4132620-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091215
4132522|4132522-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091154
4132447|4132447-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090229
4132422|4132422-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090222
4132414|4132414-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090221
4132411|4132411-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090221
4132345|4132345-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906090313
4132310|4132310-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091110
4132068|4132068-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906091030
4131833|4131833-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906090134
4131469|4131469-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.17|i86pc-solaris-64int|5.8.9|solaris|2.11|200906090006
4131442|4131442-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200906082325
4131415|4131415-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.65|i86pc-solaris-64int|5.8.9|solaris|2.11|200906090001
4131251|4131251-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200906082325
4131230|4131230-b19f-3f77-b713-d32bba55d77f|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Release|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906081629
4131150|4131150-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.37|i86pc-solaris-64int|5.8.9|solaris|2.11|200906082320
4131083|4131083-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200906082308
4129686|4129686-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200906081841
4129101|4129101-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.26-2-686|200906082256
4128792|4128792-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux|5.8.9|linux|2.6.26-2-686|200906082235
4128752|4128752-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|i686-linux|5.8.9|linux|2.6.26-2-686|200906082232
4128667|4128667-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.9|linux|2.6.26-2-686|200906082227
4128656|4128656-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.9|linux|2.6.26-2-686|200906082227
4128321|4128321-b19f-3f77-b713-d32bba55d77f|pass|200906|schwern@pobox.com|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.11.1|200906080158
4127676|4127676-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.17|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081738
4127665|4127665-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.65|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081737
4127186|4127186-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.37|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081647
4127138|4127138-b19f-3f77-b713-d32bba55d77f|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081628
4127078|4127078-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-WWW-Reports-Parser|0.01||0|||200906081617
4126695|4126695-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.26-2-686|200906081947
4126461|4126461-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.26-2-686|200906081936
4125616|4125616-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.26-2-686|200906081851
4125319|4125319-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200906081237
4125316|4125316-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906080737
4125306|4125306-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|alpha-netbsd|5.10.0|netbsd|4.0.1|200906081236
4125301|4125301-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906080736
4125185|4125185-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.26-2-686|200906081825
4125184|4125184-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.26-2-686|200906081825
4125101|4125101-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|IP35-irix-64int|5.8.8|irix|6.5|200906081421
4125094|4125094-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|IP35-irix-64int|5.8.8|irix|6.5|200906081421
4125053|4125053-b19f-3f77-b713-d32bba55d77f|pass|200906|rafl@debian.org|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.28.7|200906081417
4124989|4124989-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906081313
4124987|4124987-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906081313
4124984|4124984-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906081313
4124947|4124947-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906081310
4124945|4124945-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906081309
4124781|4124781-b19f-3f77-b713-d32bba55d77f|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.26-2-686|200906081751
4124780|4124780-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.26-2-686|200906081751
4124496|4124496-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.10.0|freebsd|7.0-release|200906081223
4124494|4124494-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.10.0|freebsd|7.0-release|200906081221
4124182|4124182-b19f-3f77-b713-d32bba55d77f|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906081714
4124180|4124180-b19f-3f77-b713-d32bba55d77f|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Generator|0.37|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906081712
4123770|4123770-b19f-3f77-b713-d32bba55d77f|pass|200906|rbo@cpan.org|CPAN-Testers-Data-Release|0.01|i86pc-solaris|5.10.0|solaris|2.11|200906080834
4123766|4123766-b19f-3f77-b713-d32bba55d77f|pass|200906|rbo@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.10.0|solaris|2.11|200906080833
4122290|4122290-b19f-3f77-b713-d32bba55d77f|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906080932
4121213|4121213-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906072357
4121008|4121008-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.10.0|freebsd|7.0-release|200906072304
4120844|4120844-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200906072159
4120659|4120659-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200906072159
4120082|4120082-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906071955
4119998|4119998-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906071925
4119823|4119823-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906071858
4119606|4119606-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.10.0|freebsd|7.0-release|200906071817
4119473|4119473-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-Data-Release|0.01||0|||200906071747
4119082|4119082-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906071637
4119006|4119006-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906071854
4119001|4119001-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.8.8|freebsd|7.0-release|200906071626
4118991|4118991-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.8.9|freebsd|7.0-release|200906071626
4118870|4118870-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906071838
4118843|4118843-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.26-2-686|200906071835
4118713|4118713-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906071559
4117970|4117970-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906071449
4117931|4117931-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.10.0|darwin|8.11.0|200906071344
4117911|4117911-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906071442
4117817|4117817-b19f-3f77-b713-d32bba55d77f|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.26-2-686|200906071702
4117816|4117816-b19f-3f77-b713-d32bba55d77f|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.26-2-686|200906071702
4117652|4117652-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906071425
4117441|4117441-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906071408
4117377|4117377-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200906071402
4116939|4116939-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906071327
4116695|4116695-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906071312
4116474|4116474-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.8|linux|2.4.27-2-386|200906071336
4116404|4116404-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.8|linux|2.4.27-2-386|200906071331
4116369|4116369-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.8|linux|2.4.27-2-386|200906071328
4116342|4116342-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906071248
4116290|4116290-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.26-2-686|200906071511
4116252|4116252-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.26-2-686|200906071508
4116251|4116251-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.26-2-686|200906071508
4115938|4115938-b19f-3f77-b713-d32bba55d77f|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906071218
4115671|4115671-b19f-3f77-b713-d32bba55d77f|pass|200906|angryxpeh@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.26-2-686|200906071425
4115588|4115588-b19f-3f77-b713-d32bba55d77f|pass|200906|wiml@hhhh.org ("Wim Lewis")|Regexp-Log-Common|0.05|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906070136
4115535|4115535-b19f-3f77-b713-d32bba55d77f|pass|200906|angryxpeh@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.26-2-686|200906071408
4115239|4115239-b19f-3f77-b713-d32bba55d77f|pass|200906|angryxpeh@gmail.com|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906071345
4115105|4115105-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|alpha-netbsd|5.10.0|netbsd|4.0.1|200906070858
4115046|4115046-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-Data-Generator|0.37||0|||200906071055
4115040|4115040-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|alpha-netbsd|5.10.0|netbsd|4.0.1|200906070854
4115018|4115018-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906070352
4114991|4114991-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906070350
4114827|4114827-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200906070922
4114821|4114821-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906070920
4114817|4114817-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906070919
4114811|4114811-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906070919
4114786|4114786-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906070916
4114776|4114776-b19f-3f77-b713-d32bba55d77f|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906070915
4114148|4114148-b19f-3f77-b713-d32bba55d77f|pass|200906|rbo@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.10.0|solaris|2.11|200906070827
4113848|4113848-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070724
4113842|4113842-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070722
4113831|4113831-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070719
4113768|4113768-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070705
4113763|4113763-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070704
4113754|4113754-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070703
4113284|4113284-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200906070332
4112502|4112502-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906070519
4111918|4111918-b19f-3f77-b713-d32bba55d77f|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906070035
4111899|4111899-b19f-3f77-b713-d32bba55d77f|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906070031
4111524|4111524-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.8.9|freebsd|7.0-release|200906062229
4111306|4111306-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.8.8|freebsd|7.0-release|200906062229
4111297|4111297-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.8.9|freebsd|7.0-release|200906062229
4111160|4111160-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.26-2-686|200906070242
4111000|4111000-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.8.8|freebsd|7.0-release|200906062229
4110730|4110730-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.26-2-686|200906070131
4107364|4107364-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906062140
4107361|4107361-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@rail.org.ua|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.26-2-686|200906062140
4107202|4107202-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060819
4106458|4106458-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060814
4106453|4106453-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060814
4106451|4106451-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060814
4105413|4105413-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060808
4105410|4105410-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060808
4105408|4105408-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060808
4103101|4103101-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060755
4102696|4102696-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-WWW-Statistics|0.65||0|||200906061312
4102235|4102235-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-WWW-Statistics|0.64||0|||200906061230
4101842|4101842-b19f-3f77-b713-d32bba55d77f|cpan|200906|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.17||0|||200906061159
4100734|4100734-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906060805
4099946|4099946-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906060642
4098933|4098933-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060434
4097763|4097763-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906060232
4097506|4097506-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906060207
4097492|4097492-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060205
4097490|4097490-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060205
4095180|4095180-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906060118
4095175|4095175-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906060118
4095090|4095090-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051433
4092975|4092975-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200906051402
4092922|4092922-b19f-3f77-b713-d32bba55d77f|pass|200906|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200906051400
4092686|4092686-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906051417
4092613|4092613-b19f-3f77-b713-d32bba55d77f|pass|200906|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.16|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906051246
4092607|4092607-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906051417
4092474|4092474-b19f-3f77-b713-d32bba55d77f|pass|200906|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-DBUtils|0.03|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906051239
4092036|4092036-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906051359
4091798|4091798-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906051412
4091795|4091795-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906051412
4091081|4091081-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091078|4091078-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091076|4091076-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091073|4091073-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4090051|4090051-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906051359
4088957|4088957-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-24-generic|200906051618
4088956|4088956-b19f-3f77-b713-d32bba55d77f|pass|200906|martin.evans@easysoft.com|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200906051618
4087366|4087366-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.6.2|freebsd|7.0-release|200906051046
4086545|4086545-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906050751
4085940|4085940-b19f-3f77-b713-d32bba55d77f|pass|200906|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|darwin-2level|5.8.8|darwin|8.11.0|200906050551
4085677|4085677-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906050320
4085212|4085212-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906050419
4085193|4085193-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906050418
4084664|4084664-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906050114
4084542|4084542-b19f-3f77-b713-d32bba55d77f|pass|200906|wiml@hhhh.org ("Wim Lewis")|WWW-UsePerl-Journal|0.22|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906050103
4083995|4083995-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906050013
4083876|4083876-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906050201
4083866|4083866-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906050200
4083628|4083628-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906041406
4083627|4083627-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906041406
4083597|4083597-b19f-3f77-b713-d32bba55d77f|pass|200906|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|8.11.0|200906050138
4083402|4083402-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906041403
4082533|4082533-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906042234
4082324|4082324-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906042221
4082297|4082297-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906042219
4080407|4080407-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906041406
4080054|4080054-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906041403
4079845|4079845-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906041401
4079376|4079376-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040721
4079369|4079369-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040721
4078926|4078926-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040713
4078676|4078676-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.8.8|linux|2.6.28-11-generic|200906041838
4078675|4078675-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040637
4078043|4078043-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040641
4077456|4077456-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040721
4077454|4077454-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040721
4076524|4076524-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040713
4075853|4075853-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040637
4075851|4075851-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906040637
4075531|4075531-b19f-3f77-b713-d32bba55d77f|pass|200906|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.6.2|freebsd|7.0-release|200906041508
4074193|4074193-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040641
4073601|4073601-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040637
4073599|4073599-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040637
4073595|4073595-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040637
4073594|4073594-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040637
4069864|4069864-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040043
4069726|4069726-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040023
4069299|4069299-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906032349
4069068|4069068-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031705
4068379|4068379-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031658
4068275|4068275-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906032237
4068091|4068091-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031705
4068087|4068087-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031705
4067252|4067252-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031658
4066714|4066714-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906032019
4066645|4066645-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906032013
4065222|4065222-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030644
4064964|4064964-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030641
4063027|4063027-b19f-3f77-b713-d32bba55d77f|pass|200906|bminton@integ.com (Brian Minton)|Parse-CPAN-Distributions|0.05|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906031047
4061345|4061345-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030638
4060692|4060692-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030644
4060216|4060216-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030641
4059563|4059563-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030638
4059562|4059562-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030638
4059560|4059560-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030638
4059558|4059558-b19f-3f77-b713-d32bba55d77f|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030638
4059338|4059338-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031023
4059304|4059304-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031018
4059290|4059290-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.8.9|linux|2.6.28-11-generic|200906031116
4059157|4059157-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906031005
4058541|4058541-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030915
4058482|4058482-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030910
4058140|4058140-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030845
4058116|4058116-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030843
4057776|4057776-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.12|i386-openbsd|5.10.0|openbsd|4.5|200906022342
4056591|4056591-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030712
4056584|4056584-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030711
4056463|4056463-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030702
4056441|4056441-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030701
4055960|4055960-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030623
4055389|4055389-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030545
4054073|4054073-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030354
4053435|4053435-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030306
4053434|4053434-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030305
4053431|4053431-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030305
4053427|4053427-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030305
4053163|4053163-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030244
4053162|4053162-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030244
4053160|4053160-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030244
4053159|4053159-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030244
4053157|4053157-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030244
4053156|4053156-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030243
4053004|4053004-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030231
4052633|4052633-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030201
4052164|4052164-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030125
4051298|4051298-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030031
4050393|4050393-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021412
4049160|4049160-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906021418
4048643|4048643-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906021420
4048409|4048409-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906022319
4047583|4047583-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906021412
4047581|4047581-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021412
4047219|4047219-b19f-3f77-b713-d32bba55d77f|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906022145
4046415|4046415-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046413|4046413-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906021401
4046410|4046410-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046409|4046409-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906021401
4046406|4046406-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021401
4046403|4046403-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046399|4046399-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021401
4045828|4045828-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020641
4044757|4044757-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020639
4044742|4044742-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906020639
4043537|4043537-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020621
4043532|4043532-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020621
4043303|4043303-b19f-3f77-b713-d32bba55d77f|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux|5.8.6|linux|2.4.18|200906021600
4042450|4042450-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906020641
4042220|4042220-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020639
4042218|4042218-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906020639
4039610|4039610-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020621
4039607|4039607-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020621
4039602|4039602-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906020621
4036092|4036092-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021312
4035275|4035275-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020200
4034837|4034837-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal-Thread|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021130
4034457|4034457-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-WWW-Testers-Generator|0.30|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021103
4033198|4033198-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906011820
4032133|4032133-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906011509
4030579|4030579-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906011509
4029512|4029512-b19f-3f77-b713-d32bba55d77f|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906011501
4024998|4024998-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|8.11.0|200906011454
4024980|4024980-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-2level|5.10.0|darwin|8.11.0|200906011453
4024656|4024656-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906011418
4024650|4024650-b19f-3f77-b713-d32bba55d77f|pass|200906|bingos@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906011418
4023357|4023357-b19f-3f77-b713-d32bba55d77f|pass|200906|andy@hexten.net|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200906011129
4022717|4022717-b19f-3f77-b713-d32bba55d77f|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.6|freebsd|5.4-release|200906010953
4022223|4022223-b19f-3f77-b713-d32bba55d77f|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906011718
4022215|4022215-b19f-3f77-b713-d32bba55d77f|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906011717
4019842|4019842-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311551
4019841|4019841-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311551
4019761|4019761-b19f-3f77-b713-d32bba55d77f|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.23.1-42.fc8|200906010040
4018489|4018489-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905312158
4018487|4018487-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905312158
4018312|4018312-b19f-3f77-b713-d32bba55d77f|pass|200905|andy@hexten.net|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.2.2|200905312022
4018078|4018078-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311146
4018076|4018076-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311146
4017978|4017978-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010432
4017588|4017588-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010309
4017587|4017587-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010308
4017088|4017088-b19f-3f77-b713-d32bba55d77f|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010126
4016194|4016194-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.9|linux|2.6.26-2-686|200905311848
4016193|4016193-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.9|linux|2.6.26-2-686|200905311848
4016189|4016189-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Mail-File|0.08|i686-linux|5.8.9|linux|2.6.26-2-686|200905311847
4016132|4016132-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016130|4016130-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016129|4016129-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016127|4016127-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905311842
4013044|4013044-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310548
4013043|4013043-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310548
4012808|4012808-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311502
4012739|4012739-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311451
4012681|4012681-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012679|4012679-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012678|4012678-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Data-Phrasebook|0.29|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012676|4012676-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Data-Phrasebook|0.29|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012459|4012459-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311417
4012137|4012137-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.35|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310340
4012132|4012132-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.35|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310340
4009180|4009180-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Uploads|0.06|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301517
4008681|4008681-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905310713
4008486|4008486-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Uploads|0.06|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008479|4008479-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.36|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008476|4008476-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008454|4008454-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.36|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301355
4008452|4008452-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301355
4008122|4008122-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.28-11-generic|200905301625
4008117|4008117-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.10.0|linux|2.6.28-11-generic|200905301625
4008041|4008041-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.11.0|linux|2.6.28-11-generic|200905301617
4008037|4008037-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.11.0|linux|2.6.28-11-generic|200905301616
4007943|4007943-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.8.9 patch 35104|linux|2.6.28-11-generic|200905301604
4007939|4007939-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.8.9 patch 35104|linux|2.6.28-11-generic|200905301604
4007869|4007869-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905301057
4005984|4005984-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|App-Maisha|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301043
4005854|4005854-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905301057
4005841|4005841-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905301057
4004514|4004514-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905301057
4004512|4004512-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905301057
4002201|4002201-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905301856
4001524|4001524-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905302124
4001518|4001518-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905302123
4001174|4001174-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301952
4000495|4000495-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905301005
3999764|3999764-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905301711
3999759|3999759-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905301710
3999748|3999748-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301707
3999742|3999742-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301706
3999195|3999195-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.9|linux|2.6.26-2-686|200905300502
3999090|3999090-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.9|linux|2.6.26-2-686|200905300451
3997732|3997732-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905300131
3997717|3997717-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905300128
3997522|3997522-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd|5.10.0|freebsd|6.4-release|200905300046
3997510|3997510-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd|5.10.0|freebsd|6.4-release|200905300045
3995793|3995793-b19f-3f77-b713-d32bba55d77f|pass|200905|jafelds@gmail.com|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200905281253
3995488|3995488-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905300157
3995451|3995451-b19f-3f77-b713-d32bba55d77f|pass|200905|gardnerm@gsicommerce.com|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-53.el5|200905281324
3995389|3995389-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux|5.8.6|linux|2.4.20|200905291634
3995000|3995000-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Games-Trackword|1.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905291454
3994999|3994999-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Calendar-List|0.21|i686-linux|5.8.9|linux|2.6.26-2-686|200905291454
3994351|3994351-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@rail.org.ua|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.9|linux|2.6.26-2-686|200905291332
3994349|3994349-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.9|linux|2.6.26-2-686|200905291332
3993933|3993933-b19f-3f77-b713-d32bba55d77f|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200905291358
3993930|3993930-b19f-3f77-b713-d32bba55d77f|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.13|i86pc-solaris-64int|5.10.0|solaris|2.11|200905291357
3993096|3993096-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905291126
3992825|3992825-b19f-3f77-b713-d32bba55d77f|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.8|freebsd|6.2-release|200905291033
3992051|3992051-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905290832
3992021|3992021-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.9|linux|2.6.26-2-686|200905290829
3991895|3991895-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905291128
3991886|3991886-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905291125
3990404|3990404-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.9|linux|2.6.26-2-686|200905290223
3990402|3990402-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.9|linux|2.6.26-2-686|200905290223
3990047|3990047-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905290043
3990043|3990043-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905290042
3988787|3988787-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905282130
3988786|3988786-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905282130
3988632|3988632-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905282202
3988600|3988600-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905282158
3987341|3987341-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200905281704
3987337|3987337-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200905281704
3986122|3986122-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280645
3985952|3985952-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280639
3985406|3985406-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.8.9|linux|2.6.26-2-686|200905281822
3985345|3985345-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.9|linux|2.6.26-2-686|200905281819
3985343|3985343-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Data-Phrasebook|0.29|i686-linux|5.8.9|linux|2.6.26-2-686|200905281819
3985193|3985193-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|CPAN-Testers-Data-Generator|0.35|i686-linux|5.8.9|linux|2.6.26-2-686|200905281810
3985044|3985044-b19f-3f77-b713-d32bba55d77f|pass|200905|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905280738
3985031|3985031-b19f-3f77-b713-d32bba55d77f|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905280737
3984744|3984744-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Mail-Outlook|0.15|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280526
3984310|3984310-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905281725
3984283|3984283-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Data-Generator|0.36|i686-linux|5.8.9|linux|2.6.26-2-686|200905281723
3984281|3984281-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.8.9|linux|2.6.26-2-686|200905281723
3983793|3983793-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280644
3983736|3983736-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|Mail-Outlook|0.15|i686-linux|5.8.9|linux|2.6.26-2-686|200905281656
3983434|3983434-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.55|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282116
3982946|3982946-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook-Loader-YAML|0.09|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282056
3982940|3982940-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook|0.29|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282056
3982850|3982850-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280640
3982818|3982818-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280352
3982816|3982816-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280351
3982694|3982694-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280639
3982410|3982410-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.35|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282006
3982038|3982038-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200905280932
3982034|3982034-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200905280931
3981743|3981743-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280039
3980024|3980024-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200905280141
3980022|3980022-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200905280140
3978967|3978967-b19f-3f77-b713-d32bba55d77f|pass|200905|rafl@debian.org|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.28.7|200905272234
3978912|3978912-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|Regexp-Log-Common|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905271626
3978775|3978775-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@rail.org.ua|WWW-UsePerl-Journal|0.22|i686-linux|5.8.9|linux|2.6.26-2-686|200905271505
3978325|3978325-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905271140
3977857|3977857-b19f-3f77-b713-d32bba55d77f|pass|200905|brian@minton.name|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.2-dsa-dl380-oldxeon|200905271224
3977752|3977752-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|App-Maisha|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905271100
3977628|3977628-b19f-3f77-b713-d32bba55d77f|pass|200905|overlordq@gmail.com|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.18-xen-3.1-1-amd64|200905270910
3977431|3977431-b19f-3f77-b713-d32bba55d77f|pass|200905|mjg@phoenixtrap.com|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200905270116
3976913|3976913-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|Test-YAML-Meta|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905271113
3976905|3976905-b19f-3f77-b713-d32bba55d77f|pass|200905|angryxpeh@gmail.com|Test-CPAN-Meta|0.13|i686-linux|5.8.9|linux|2.6.26-2-686|200905271113
3976783|3976783-b19f-3f77-b713-d32bba55d77f|pass|200905|mjg@phoenixtrap.com|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200905270116
3975407|3975407-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.8.9|linux|2.6.26-2-686|200905271024
3975406|3975406-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.9|linux|2.6.26-2-686|200905271024
3975007|3975007-b19f-3f77-b713-d32bba55d77f|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200905271211
3974521|3974521-b19f-3f77-b713-d32bba55d77f|pass|200905|rbo@cpan.org|Test-CPAN-Meta|0.13|i86pc-solaris|5.8.9|solaris|2.11|200905271223
3974048|3974048-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905271008
3974043|3974043-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905271008
3973676|3973676-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200905270929
3973516|3973516-b19f-3f77-b713-d32bba55d77f|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905270153
3973465|3973465-b19f-3f77-b713-d32bba55d77f|pass|200905|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.12|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905270153
3972476|3972476-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905270556
3972145|3972145-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905270403
3971628|3971628-b19f-3f77-b713-d32bba55d77f|pass|200905|cpanuser@oeuftete.com|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.18.8-linode16|200905260241
3971182|3971182-b19f-3f77-b713-d32bba55d77f|pass|200905|hholz@mcs.csueastbay.edu ((Hilary Holz))|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200905261401
3971027|3971027-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905261548
3971008|3971008-b19f-3f77-b713-d32bba55d77f|pass|200905|arto+test@cpan.org|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200905260106
3970891|3970891-b19f-3f77-b713-d32bba55d77f|fail|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905261536
3970478|3970478-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261402
3970464|3970464-b19f-3f77-b713-d32bba55d77f|pass|200905|andy@hexten.net|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200905262237
3970065|3970065-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.8|darwin|8.11.0|200905262208
3970052|3970052-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.8|darwin|8.11.0|200905262208
3969850|3969850-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905261612
3969847|3969847-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905261612
3969381|3969381-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261403
3968981|3968981-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261359
3966564|3966564-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.10.0|freebsd|7.0-release|200905261433
3965405|3965405-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200905261027
3965401|3965401-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200905261026
3965299|3965299-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200905261052
3965298|3965298-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200905261052
3965282|3965282-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905260949
3965279|3965279-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905260947
3965069|3965069-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905260900
3965067|3965067-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905260858
3965041|3965041-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200905260854
3965036|3965036-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200905260852
3964985|3964985-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200905260842
3964972|3964972-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200905260840
3964800|3964800-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200905260812
3964794|3964794-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200905260811
3964736|3964736-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905260802
3964731|3964731-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905260800
3964723|3964723-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905260759
3964713|3964713-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905260757
3964649|3964649-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905260745
3964610|3964610-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905260739
3964589|3964589-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905260733
3964584|3964584-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905260732
3964512|3964512-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905260713
3964500|3964500-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905260709
3964175|3964175-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905260604
3964159|3964159-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905260559
3964088|3964088-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905260546
3964064|3964064-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905260541
3964042|3964042-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905260538
3964028|3964028-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905260536
3963989|3963989-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905260527
3963971|3963971-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905260522
3963909|3963909-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200905260508
3963892|3963892-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200905260506
3963801|3963801-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905260449
3963787|3963787-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905260445
3963703|3963703-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905260430
3963672|3963672-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905260425
3963668|3963668-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905260424
3963651|3963651-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905260419
3963573|3963573-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.6|darwin|8.11.0|200905260304
3963265|3963265-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905260109
3963117|3963117-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905260056
3962897|3962897-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200905260204
3962892|3962892-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200905260202
3962886|3962886-b19f-3f77-b713-d32bba55d77f|pass|200905|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.23.11.20071215-bcm203x|200905260202
3962770|3962770-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200905260133
3962667|3962667-b19f-3f77-b713-d32bba55d77f|pass|200905|perl@galumph.com|Test-YAML-Meta|0.12|darwin-thread-multi-64int-ld-2level|5.10.0|darwin|9.4.0|200905251818
3962583|3962583-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200905260102
3962579|3962579-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200905260101
3962426|3962426-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200905260030
3962327|3962327-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200905260021
3962316|3962316-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200905260020
3962089|3962089-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200905252353
3962030|3962030-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200905252345
3962026|3962026-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200905252344
3960457|3960457-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.8.8|freebsd|7.0-release|200905251136
3960450|3960450-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.10.0|freebsd|7.0-release|200905251146
3960133|3960133-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200905251136
3960049|3960049-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200905251848
3960048|3960048-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.8.9|freebsd|7.0-release|200905251848
3960010|3960010-b19f-3f77-b713-d32bba55d77f|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.10.0|freebsd|7.0-release|200905250859
3960002|3960002-b19f-3f77-b713-d32bba55d77f|pass|200905|wiml@hhhh.org ("Wim Lewis")|Test-YAML-Meta|0.12|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200905251132
3959999|3959999-b19f-3f77-b713-d32bba55d77f|pass|200905|wiml@hhhh.org ("Wim Lewis")|Test-CPAN-Meta|0.13|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200905251131
3959761|3959761-b19f-3f77-b713-d32bba55d77f|pass|200905|jayfrombkk@gmail.com ("Jay from BKK")|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.8|darwin|9.0|200905251222
3959639|3959639-b19f-3f77-b713-d32bba55d77f|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i586-linux-thread-multi|5.8.5|linux|2.6.8.1|200905251927
3959635|3959635-b19f-3f77-b713-d32bba55d77f|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.8.0|linux|2.6.9-22.18.bz155725.elsmp|200905251926
3959632|3959632-b19f-3f77-b713-d32bba55d77f|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.8.3|linux|2.6.4|200905251926
3959625|3959625-b19f-3f77-b713-d32bba55d77f|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|x86_64-linux|5.8.8|linux|2.6.5-7.276-smp|200905251922
3959619|3959619-b19f-3f77-b713-d32bba55d77f|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i586-linux-thread-multi|5.8.8|linux|2.6.16|200905251916
3959501|3959501-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200905251601
3959491|3959491-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|alpha-netbsd|5.10.0|netbsd|4.0.1|200905251555
3959182|3959182-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.9-5.elsmp|200905251446
3958811|3958811-b19f-3f77-b713-d32bba55d77f|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200905251218
3958637|3958637-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200905251251
3958616|3958616-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200905251248
3958596|3958596-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200905251245
3958581|3958581-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200905251241
3958567|3958567-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200905250536
3958559|3958559-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|IP35-irix-64int|5.8.8|irix|6.5|200905251234
3958547|3958547-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|IP35-irix-64int|5.8.8|irix|6.5|200905251233
3958546|3958546-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200905250532
3958542|3958542-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905251832
3958534|3958534-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905251831
3958422|3958422-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200905251105
3958421|3958421-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200905251105
3958420|3958420-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200905251104
3958419|3958419-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200905251104
3958415|3958415-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200905251204
3958414|3958414-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200905251103
3958411|3958411-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200905251103
3958410|3958410-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200905251103
3958408|3958408-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200905251103
3958382|3958382-b19f-3f77-b713-d32bba55d77f|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200905251058
3957811|3957811-b19f-3f77-b713-d32bba55d77f|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.13|i86pc-solaris-64int|5.8.9|solaris|2.11|200905251000
3957795|3957795-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905251002
3957792|3957792-b19f-3f77-b713-d32bba55d77f|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200905251000
3957760|3957760-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905250955
3957656|3957656-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200905250938
3957142|3957142-b19f-3f77-b713-d32bba55d77f|pass|200905|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200905251518
3957138|3957138-b19f-3f77-b713-d32bba55d77f|pass|200905|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-YAML-Meta|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200905251517
3957137|3957137-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.8.6|darwin|8.11.0|200905250712
3956993|3956993-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200905250625
3956308|3956308-b19f-3f77-b713-d32bba55d77f|pass|200905|cpanuser@oeuftete.com|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18.8-linode16|200905241642
3955237|3955237-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905241830
3955222|3955222-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905241830
3955217|3955217-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Regexp-Log-Common|0.05|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241544
3954719|3954719-b19f-3f77-b713-d32bba55d77f|pass|200905|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200905242324
3954718|3954718-b19f-3f77-b713-d32bba55d77f|pass|200905|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200905242323
3954676|3954676-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905242318
3954672|3954672-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905242318
3954592|3954592-b19f-3f77-b713-d32bba55d77f|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-ld|5.10.0|linux|2.6.26.5-fuuka.profvince.com|200905242303
3953783|3953783-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241144
3953519|3953519-b19f-3f77-b713-d32bba55d77f|cpan|200905|BARBIE|Test-CPAN-Meta|0.13||0|||200905242008
3953511|3953511-b19f-3f77-b713-d32bba55d77f|cpan|200905|BARBIE|Test-YAML-Meta|0.12||0|||200905242007
3953282|3953282-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241012
3953276|3953276-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241012
3953231|3953231-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Regexp-Log-Common|0.05|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241003
3951935|3951935-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240452
3951628|3951628-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240306
3951624|3951624-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240306
3951400|3951400-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240156
3950732|3950732-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905240338
3950522|3950522-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905240233
3945854|3945854-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200905231138
3945554|3945554-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231856
3945511|3945511-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231841
3945510|3945510-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231841
3945415|3945415-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231754
3944846|3944846-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231500
3944267|3944267-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905230318
3943636|3943636-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905230219
3943516|3943516-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231158
3942372|3942372-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.11.0|200905222156
3942303|3942303-b19f-3f77-b713-d32bba55d77f|pass|200905|pjacklam@cpan.org|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905221907
3937351|3937351-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905221708
3935861|3935861-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905220043
3935472|3935472-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905211843
3935125|3935125-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905211843
3935124|3935124-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905211843
3934864|3934864-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220831
3934476|3934476-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.16|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220707
3934466|3934466-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220706
3933811|3933811-b19f-3f77-b713-d32bba55d77f|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220440
3933090|3933090-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200905211800
3932370|3932370-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210621
3932243|3932243-b19f-3f77-b713-d32bba55d77f|pass|200905|james@mastros.biz|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200905202155
3932088|3932088-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210632
3931517|3931517-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210621
3931436|3931436-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210619
3931426|3931426-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210619
3931239|3931239-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210632
3929976|3929976-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210621
3929744|3929744-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210619
3929743|3929743-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210619
3929742|3929742-b19f-3f77-b713-d32bba55d77f|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210619
3928037|3928037-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905210257
3926499|3926499-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200905201831
3926066|3926066-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200905201723
3922794|3922794-b19f-3f77-b713-d32bba55d77f|pass|200905|bobtfish@bobtfish.net|Test-CPAN-Meta|0.12|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.24-16-server|200905191844
3921646|3921646-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905200306
3920901|3920901-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200905192258
3920336|3920336-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905192147
3920279|3920279-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905192131
3918651|3918651-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905191417
3915543|3915543-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200905190141
3914889|3914889-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905181504
3911308|3911308-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180741
3910881|3910881-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180741
3910260|3910260-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180740
3908677|3908677-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180653
3908253|3908253-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180548
3908224|3908224-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180543
3907965|3907965-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180433
3907713|3907713-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180327
3907187|3907187-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180226
3907185|3907185-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180225
3907100|3907100-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180217
3907099|3907099-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180217
3906466|3906466-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3906299|3906299-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3906123|3906123-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3905121|3905121-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|armv5tejl-linux|5.8.8|linux|2.6.17.14|200905172240
3903123|3903123-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3902553|3902553-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3902478|3902478-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901638|3901638-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901545|3901545-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901542|3901542-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901541|3901541-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3899730|3899730-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170523
3899424|3899424-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170345
3899408|3899408-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170343
3899186|3899186-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899184|3899184-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899182|3899182-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899004|3899004-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905170153
3898654|3898654-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898468|3898468-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898211|3898211-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898200|3898200-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905161823
3897926|3897926-b19f-3f77-b713-d32bba55d77f|pass|200905|wiml@hhhh.org ("Wim Lewis")|Regexp-Log-Common|0.05|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200905161053
3897731|3897731-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.8|darwin|8.11.0|200905162134
3897063|3897063-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161959
3896760|3896760-b19f-3f77-b713-d32bba55d77f|pass|200905|rafl@debian.org|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.28.7|200905161834
3896169|3896169-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161534
3895916|3895916-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161422
3894690|3894690-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905160935
3894495|3894495-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905160853
3894473|3894473-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905160643
3894200|3894200-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905160513
3893359|3893359-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905160308
3893019|3893019-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905160226
3893018|3893018-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905160226
3892939|3892939-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905160218
3891334|3891334-b19f-3f77-b713-d32bba55d77f|pass|200905|wiml@hhhh.org ("Wim Lewis")|WWW-UsePerl-Journal|0.22|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200905150828
3890295|3890295-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905150823
3887999|3887999-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905150634
3887441|3887441-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905150634
3887415|3887415-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905150634
3885337|3885337-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905150358
3883137|3883137-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905141850
3882908|3882908-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200905142304
3882226|3882226-b19f-3f77-b713-d32bba55d77f|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905141318
3877814|3877814-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905140637
3877582|3877582-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905140522
3877162|3877162-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905140359
3876636|3876636-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905140310
3875759|3875759-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905140119
3875003|3875003-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200905132033
3874674|3874674-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905131946
3871590|3871590-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905131055
3868617|3868617-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121302
3868330|3868330-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121242
3868298|3868298-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121302
3868297|3868297-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905121302
3868210|3868210-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905121301
3867820|3867820-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905121302
3867519|3867519-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121923
3867504|3867504-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121922
3867377|3867377-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121908
3867369|3867369-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121907
3867363|3867363-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121906
3867324|3867324-b19f-3f77-b713-d32bba55d77f|pass|200905|robin@smidsrod.no ("Robin Smidsrd")|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.24-19-server|200905121237
3867180|3867180-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121242
3866843|3866843-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121747
3866683|3866683-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121708
3866676|3866676-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121707
3866630|3866630-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121656
3866629|3866629-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121655
3866627|3866627-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121654
3866255|3866255-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121541
3863734|3863734-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905120157
3863679|3863679-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905120146
3863363|3863363-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905120114
3862960|3862960-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111703
3862520|3862520-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905111712
3862324|3862324-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111713
3861739|3861739-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905111432
3861580|3861580-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111422
3861395|3861395-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905111430
3860772|3860772-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111409
3860080|3860080-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.6|darwin|8.11.0|200905111543
3859662|3859662-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905110653
3859418|3859418-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110653
3859417|3859417-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110654
3858690|3858690-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110652
3856488|3856488-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110137
3856422|3856422-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905110130
3856232|3856232-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905110232
3852690|3852690-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200905100701
3844448|3844448-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905090354
3843007|3843007-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081935
3843003|3843003-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081933
3842807|3842807-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.9|darwin|8.11.0|200905082340
3841868|3841868-b19f-3f77-b713-d32bba55d77f|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081516
3841065|3841065-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd|5.8.9|netbsd|5.0|200905081745
3829058|3829058-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd|5.10.0|netbsd|5.0|200905070317
3827273|3827273-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|8.11.0|200905061834
3822179|3822179-b19f-3f77-b713-d32bba55d77f|pass|200905|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200905051820
3821180|3821180-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200905052034
3818580|3818580-b19f-3f77-b713-d32bba55d77f|pass|200905|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200905050700
3814742|3814742-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200905042338
3813269|3813269-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200905041625
3811049|3811049-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200905041011
3808094|3808094-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040210
3808090|3808090-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040207
3808085|3808085-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040205
3808081|3808081-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040202
3808070|3808070-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040159
3808063|3808063-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040156
3808054|3808054-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040153
3808050|3808050-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040153
3808049|3808049-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040152
3808047|3808047-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040152
3808045|3808045-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040151
3808043|3808043-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040151
3808037|3808037-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040148
3808035|3808035-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040147
3808034|3808034-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040146
3808032|3808032-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040145
3808031|3808031-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040144
3808030|3808030-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040144
3808029|3808029-b19f-3f77-b713-d32bba55d77f|fail|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-WebList|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040143
3808022|3808022-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040137
3808014|3808014-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040136
3807985|3807985-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040123
3807978|3807978-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040121
3807906|3807906-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040054
3807881|3807881-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040048
3807874|3807874-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040043
3807869|3807869-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Generator|0.35|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040037
3807864|3807864-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040033
3807854|3807854-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040031
3807832|3807832-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040027
3806026|3806026-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200905031026
3805356|3805356-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905031413
3805026|3805026-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905031300
3801570|3801570-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905021813
3801498|3801498-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.27-11-server|200905021714
3801344|3801344-b19f-3f77-b713-d32bba55d77f|pass|200905|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905022338
3801334|3801334-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200905021633
3799946|3799946-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905021229
3799732|3799732-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905021150
3799358|3799358-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905021036
3798773|3798773-b19f-3f77-b713-d32bba55d77f|pass|200905|amiri@metalabel.com (Amiri Barksdale)|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200905010052
3798553|3798553-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905020503
3797985|3797985-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905020251
3797000|3797000-b19f-3f77-b713-d32bba55d77f|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905012020
3796795|3796795-b19f-3f77-b713-d32bba55d77f|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905011626
3795868|3795868-b19f-3f77-b713-d32bba55d77f|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.12|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905010636
3792828|3792828-b19f-3f77-b713-d32bba55d77f|pass|200904|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200904301748
3791836|3791836-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904302023
3791497|3791497-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904301910
3788422|3788422-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904300238
3788052|3788052-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200904300059
3787605|3787605-b19f-3f77-b713-d32bba55d77f|pass|200904|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904292350
3786708|3786708-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904291808
3786517|3786517-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904291730
3786218|3786218-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904291626
3786016|3786016-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904291532
3785011|3785011-b19f-3f77-b713-d32bba55d77f|pass|200904|bobtfisg@bobtfish.net|Test-CPAN-Meta|0.12|darwin-thread-multi-2level|5.8.6|darwin|8.0|200904282318
3784766|3784766-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904290710
3783948|3783948-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904290428
3783686|3783686-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904290253
3782315|3782315-b19f-3f77-b713-d32bba55d77f|pass|200904|andy@hexten.net|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200904282227
3778505|3778505-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200904281104
3778324|3778324-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200904281018
3777038|3777038-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904280622
3776828|3776828-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904280344
3776119|3776119-b19f-3f77-b713-d32bba55d77f|pass|200904|vpit@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200904272249
3774510|3774510-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904271535
3774240|3774240-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904271442
3772230|3772230-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904270516
3770154|3770154-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904262127
3769775|3769775-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904261857
3769620|3769620-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904261813
3768426|3768426-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904261352
3768425|3768425-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904261351
3767428|3767428-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904260847
3767415|3767415-b19f-3f77-b713-d32bba55d77f|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200904260344
3766595|3766595-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904260615
3766324|3766324-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904260419
3766320|3766320-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904260418
3765528|3765528-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904260224
3765525|3765525-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904260224
3765474|3765474-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904260215
3764304|3764304-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904252115
3763929|3763929-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904252011
3763459|3763459-b19f-3f77-b713-d32bba55d77f|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.8.9|linux|2.6.24-16-generic|200904251359
3761834|3761834-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200904250808
3760892|3760892-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904251141
3760804|3760804-b19f-3f77-b713-d32bba55d77f|pass|200904|wiml@hhhh.org ("Wim Lewis")|Test-CPAN-Meta|0.12|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904250919
3760714|3760714-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904251104
3760214|3760214-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200904250828
3760088|3760088-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904250856
3758756|3758756-b19f-3f77-b713-d32bba55d77f|pass|200904|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.16|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904250214
3758546|3758546-b19f-3f77-b713-d32bba55d77f|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200904250139
3757921|3757921-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904250050
3757651|3757651-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904250106
3757581|3757581-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200904250055
3757357|3757357-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904250021
3757262|3757262-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904250008
3756976|3756976-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904242318
3756246|3756246-b19f-3f77-b713-d32bba55d77f|pass|200904|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904242140
3756076|3756076-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904242113
3755249|3755249-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-server|200904241747
3755237|3755237-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-server|200904241744
3754222|3754222-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|amd64-freebsd|5.8.9|freebsd|7.0-release|200904241627
3754069|3754069-b19f-3f77-b713-d32bba55d77f|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.16|i86pc-solaris-64int|5.8.9|solaris|2.11|200904241614
3753490|3753490-b19f-3f77-b713-d32bba55d77f|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.16|i86pc-solaris-64int|5.10.0|solaris|2.11|200904241444
3753115|3753115-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904241355
3752649|3752649-b19f-3f77-b713-d32bba55d77f|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.10.0|linux|2.6.24-16-generic|200904240718
3752626|3752626-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904241316
3752207|3752207-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200904241145
3752191|3752191-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904241144
3752161|3752161-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904241140
3752137|3752137-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200904241137
3752069|3752069-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904241124
3752067|3752067-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904241124
3751862|3751862-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904241042
3751550|3751550-b19f-3f77-b713-d32bba55d77f|pass|200904|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200904241647
3751409|3751409-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904240926
3749666|3749666-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|amd64-freebsd|5.8.8|freebsd|7.0-release|200904240023
3748821|3748821-b19f-3f77-b713-d32bba55d77f|cpan|200904|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.16||0|||200904232016
3748463|3748463-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904231752
3747116|3747116-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net (grahamc)|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904221850
3745035|3745035-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904230703
3744877|3744877-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904230705
3744876|3744876-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904230704
3744829|3744829-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904230647
3744826|3744826-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904230647
3743463|3743463-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200904222328
3743049|3743049-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904222328
3741697|3741697-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904221803
3741531|3741531-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904221836
3741440|3741440-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904221811
3740929|3740929-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904221638
3740518|3740518-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904221418
3739964|3739964-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.10.0|freebsd|7.0-release|200904221114
3738633|3738633-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904220736
3738164|3738164-b19f-3f77-b713-d32bba55d77f|pass|200904|rafl@debian.org|Test-CPAN-Meta|0.12|i686-linux|5.10.0 patch 35117|linux|2.6.26|200904220523
3738075|3738075-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904220354
3737526|3737526-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904220222
3737392|3737392-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904220034
3737173|3737173-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904220036
3736707|3736707-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200904212158
3735943|3735943-b19f-3f77-b713-d32bba55d77f|pass|200904|graham@crookham.uklinux.net ("GRAHAMC")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-generic|200904202214
3733597|3733597-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200904211314
3732593|3732593-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200904211005
3731624|3731624-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904210733
3731616|3731616-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904210731
3730001|3730001-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200904202257
3729630|3729630-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904202328
3729623|3729623-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904202327
3728788|3728788-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200904202053
3728748|3728748-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904202147
3728505|3728505-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904202103
3728022|3728022-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904201945
3727633|3727633-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904201841
3727481|3727481-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904201719
3727363|3727363-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200904201704
3727351|3727351-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904201703
3726997|3726997-b19f-3f77-b713-d32bba55d77f|pass|200904|pjacklam@online.no|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200904201707
3726919|3726919-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904201648
3724957|3724957-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904201103
3724533|3724533-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904200838
3724293|3724293-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200904200757
3723292|3723292-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904200434
3723259|3723259-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200904200320
3722970|3722970-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904200222
3722688|3722688-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200904192339
3722053|3722053-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200904192114
3721532|3721532-b19f-3f77-b713-d32bba55d77f|pass|200904|mjg@phoenixtrap.com|Test-CPAN-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200904181058
3721383|3721383-b19f-3f77-b713-d32bba55d77f|pass|200904|doug@peaches.acomp.usf.edu ("Douglas Christopher Wilson")|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release-p7|200904190042
3721021|3721021-b19f-3f77-b713-d32bba55d77f|pass|200904|mjg@phoenixtrap.com|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200904190209
3720934|3720934-b19f-3f77-b713-d32bba55d77f|pass|200904|rbo@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris|5.8.9|solaris|2.11|200904182101
3720456|3720456-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904191049
3719789|3719789-b19f-3f77-b713-d32bba55d77f|pass|200904|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200904191604
3719595|3719595-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200904190646
3716100|3716100-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904181940
3714948|3714948-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904181729
3714681|3714681-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904181642
3714577|3714577-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904181627
3714287|3714287-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200904181543
3714278|3714278-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904181543
3713785|3713785-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904181441
3713371|3713371-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200904181356
3713301|3713301-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904181247
3712635|3712635-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200904181213
3711461|3711461-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904180555
3710701|3710701-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200904180120
3710689|3710689-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904180118
3710633|3710633-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904180103
3710390|3710390-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904180105
3708826|3708826-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200904171814
3705713|3705713-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200904170759
3705405|3705405-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200904170507
3705017|3705017-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904170344
3704966|3704966-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904170425
3703511|3703511-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200904162230
3703062|3703062-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|alpha-netbsd|5.10.0|netbsd|4.0.1|200904161944
3702959|3702959-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904162121
3702934|3702934-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904162114
3702578|3702578-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200904161955
3701645|3701645-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161644
3701303|3701303-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161547
3700565|3700565-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904161343
3700085|3700085-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161226
3699487|3699487-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904161027
3698180|3698180-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904160407
3698046|3698046-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200904160225
3697302|3697302-b19f-3f77-b713-d32bba55d77f|pass|200904|andy@hexten.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.28-11-generic|200904160003
3693468|3693468-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200904151258
3692233|3692233-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904151043
3691663|3691663-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150756
3691498|3691498-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200904150606
3691447|3691447-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150651
3690856|3690856-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150410
3690279|3690279-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904150140
3690277|3690277-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904150140
3690193|3690193-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904150120
3690187|3690187-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904150119
3687026|3687026-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904141341
3686923|3686923-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904141309
3686561|3686561-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200904141051
3685866|3685866-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904140833
3685805|3685805-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904140813
3683373|3683373-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904132039
3683129|3683129-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904132024
3682875|3682875-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904131921
3680868|3680868-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904130630
3680117|3680117-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904130018
3679943|3679943-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.15|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904122238
3679940|3679940-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904122237
3679817|3679817-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904122142
3679356|3679356-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904121903
3678986|3678986-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904121702
3678602|3678602-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904121443
3678146|3678146-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904121425
3678037|3678037-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904121256
3677786|3677786-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904121147
3676954|3676954-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904120853
3676050|3676050-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904120628
3675847|3675847-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904120538
3675339|3675339-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904120313
3675202|3675202-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904120236
3674198|3674198-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904112218
3672225|3672225-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904111503
3672193|3672193-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904111557
3671784|3671784-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904111353
3670714|3670714-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904110935
3670678|3670678-b19f-3f77-b713-d32bba55d77f|pass|200904|stro@cpan.org|Regexp-Log-Common|0.05|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200904110124
3669896|3669896-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904110626
3669827|3669827-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904110610
3669670|3669670-b19f-3f77-b713-d32bba55d77f|pass|200904|justin.hunter@asu.edu|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200904100308
3669158|3669158-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904110354
3667900|3667900-b19f-3f77-b713-d32bba55d77f|pass|200904|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200904101352
3666282|3666282-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904101611
3665914|3665914-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904101442
3665773|3665773-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904101408
3665217|3665217-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904101130
3664710|3664710-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904101000
3663079|3663079-b19f-3f77-b713-d32bba55d77f|pass|200904|rbo@cpan.org|WWW-UsePerl-Journal|0.22|i86pc-solaris|5.8.9|solaris|2.11|200904092000
3662012|3662012-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904092229
3661531|3661531-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-64int-2level|5.11.0|darwin|8.11.0|200904092040
3660794|3660794-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904091730
3660793|3660793-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904091730
3660776|3660776-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.11.0|darwin|8.11.0|200904091727
3660481|3660481-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200904091747
3660462|3660462-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904091645
3659944|3659944-b19f-3f77-b713-d32bba55d77f|pass|200904|rbo@consol.de|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.9|solaris|2.11|200904091326
3659512|3659512-b19f-3f77-b713-d32bba55d77f|pass|200904|rbo@consol.de|Regexp-Log-Common|0.05|i86pc-solaris|5.8.9|solaris|2.11|200904091406
3658482|3658482-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904091119
3658227|3658227-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904091020
3658124|3658124-b19f-3f77-b713-d32bba55d77f|pass|200904|mw487.yahoo.com@gmail.com|Regexp-Log-Common|0.05|cygwin-thread-multi-64int|0|cygwin|1.5.25(0.15642)|200904090302
3658024|3658024-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904090936
3657337|3657337-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904090644
3656237|3656237-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904090253
3655586|3655586-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904090111
3655224|3655224-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904082316
3654557|3654557-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904082319
3654361|3654361-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904082157
3653977|3653977-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200904082009
3653387|3653387-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081915
3652738|3652738-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081734
3652623|3652623-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904081823
3651665|3651665-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904081409
3651379|3651379-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.10.0|freebsd|7.0-release|200904081414
3650952|3650952-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904081226
3650489|3650489-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081102
3649660|3649660-b19f-3f77-b713-d32bba55d77f|pass|200904|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904080925
3647159|3647159-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200904080011
3644953|3644953-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904071924
3644797|3644797-b19f-3f77-b713-d32bba55d77f|pass|200904|vpit@cpan.org|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200904072000
3644710|3644710-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904071844
3644474|3644474-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200904071741
3643225|3643225-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904071333
3642443|3642443-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904071142
3641521|3641521-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904070932
3641139|3641139-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904070826
3639192|3639192-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904070014
3639181|3639181-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904070013
3637178|3637178-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200904062008
3636640|3636640-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.10.0|freebsd|7.0-release|200904061910
3635724|3635724-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904061505
3634252|3634252-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904061021
3634153|3634153-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200904060903
3633771|3633771-b19f-3f77-b713-d32bba55d77f|pass|200904|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.15|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904060623
3633295|3633295-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200904060514
3633282|3633282-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904060510
3633271|3633271-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200904060506
3633256|3633256-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904060503
3631922|3631922-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200904060019
3631741|3631741-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904052342
3631739|3631739-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904052342
3631424|3631424-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904052300
3630851|3630851-b19f-3f77-b713-d32bba55d77f|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200904052124
3630768|3630768-b19f-3f77-b713-d32bba55d77f|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.15|i86pc-solaris-64int|5.10.0|solaris|2.11|200904052102
3628944|3628944-b19f-3f77-b713-d32bba55d77f|pass|200904|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904051358
3628111|3628111-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904051147
3627123|3627123-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200904050646
3627120|3627120-b19f-3f77-b713-d32bba55d77f|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200904050646
3626066|3626066-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.11.0|darwin|8.11.0|200904050239
3623857|3623857-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904041932
3622782|3622782-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904041716
3622111|3622111-b19f-3f77-b713-d32bba55d77f|cpan|200904|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.15||0|||200904041549
3621387|3621387-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904041402
3621371|3621371-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904041359
3618906|3618906-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904040355
3618100|3618100-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904032310
3615755|3615755-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904031419
3614326|3614326-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200904031035
3612627|3612627-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904030308
3612329|3612329-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200904030112
3611639|3611639-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904022324
3611634|3611634-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904022323
3611007|3611007-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904022031
3611004|3611004-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904022031
3610701|3610701-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200904021832
3608837|3608837-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904021305
3608490|3608490-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904021155
3608367|3608367-b19f-3f77-b713-d32bba55d77f|pass|200904|robertl@apnic.net ("Robert Loomans")|Test-YAML-Meta|0.11|darwin-2level|5.8.9|darwin|9.6.0|200904021313
3607255|3607255-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904020910
3605564|3605564-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904020147
3605482|3605482-b19f-3f77-b713-d32bba55d77f|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200904020134
3604730|3604730-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904012307
3604726|3604726-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904012306
3604448|3604448-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904012151
3604442|3604442-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904012150
3604096|3604096-b19f-3f77-b713-d32bba55d77f|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200904012006
3603324|3603324-b19f-3f77-b713-d32bba55d77f|pass|200904|schwern@pobox.com|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.11.1|200904011345
3599222|3599222-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200903312028
3598463|3598463-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200903311753
3596980|3596980-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903311203
3594836|3594836-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.62|i86pc-solaris-64int|5.8.9|solaris|2.11|200903310119
3594733|3594733-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200903310001
3594464|3594464-b19f-3f77-b713-d32bba55d77f|pass|200903|woody@2143.net|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.6.24-gentoo-r4|200903302215
3593561|3593561-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903302141
3593558|3593558-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903302140
3593537|3593537-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903302133
3589751|3589751-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0 patch 35117|darwin|8.11.0|200903300039
3587757|3587757-b19f-3f77-b713-d32bba55d77f|pass|200903|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200903291636
3586929|3586929-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903291315
3586781|3586781-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200903291222
3586772|3586772-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903291218
3586768|3586768-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903291217
3585445|3585445-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200903290857
3584148|3584148-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Statistics|0.62|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903290128
3583995|3583995-b19f-3f77-b713-d32bba55d77f|pass|200903|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903290057
3583904|3583904-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903290132
3582839|3582839-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903282124
3582493|3582493-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.62|i86pc-solaris-64int|5.10.0|solaris|2.11|200903281957
3582191|3582191-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903281839
3582189|3582189-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903281838
3582046|3582046-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.10.0|freebsd|7.0-release|200903281716
3580876|3580876-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200903281401
3580751|3580751-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200903281334
3580401|3580401-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200903281224
3580392|3580392-b19f-3f77-b713-d32bba55d77f|pass|200903|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903280623
3580327|3580327-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903281211
3580325|3580325-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903281210
3580262|3580262-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903281156
3577617|3577617-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903280347
3576650|3576650-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.62|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903272320
3576301|3576301-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903272211
3575772|3575772-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903271907
3575098|3575098-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200903271511
3574745|3574745-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.8.8|freebsd|7.0-release|200903271240
3574375|3574375-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.8.9|freebsd|7.0-release|200903271139
3574097|3574097-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903271013
3574036|3574036-b19f-3f77-b713-d32bba55d77f|cpan|200903|BARBIE|CPAN-Testers-WWW-Statistics|0.62||0|||200903270956
3573276|3573276-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200903270454
3573101|3573101-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903270329
3570724|3570724-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200903261149
3569987|3569987-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903260651
3568455|3568455-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903260105
3568027|3568027-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200903251815
3565712|3565712-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903251038
3565709|3565709-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903251037
3564410|3564410-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.61|i86pc-solaris-64int|5.10.0|solaris|2.11|200903251053
3563932|3563932-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250433
3563861|3563861-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250425
3563657|3563657-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250351
3563579|3563579-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250332
3563573|3563573-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250331
3562015|3562015-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250236
3560642|3560642-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.61|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903242305
3558450|3558450-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.61|amd64-freebsd|5.8.9|freebsd|7.0-release|200903241838
3558445|3558445-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.61|amd64-freebsd|5.8.8|freebsd|7.0-release|200903241838
3556396|3556396-b19f-3f77-b713-d32bba55d77f|cpan|200903|BARBIE|CPAN-Testers-WWW-Statistics|0.61||0|||200903241353
3554299|3554299-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903240901
3553828|3553828-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903240803
3553541|3553541-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903240718
3552315|3552315-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200903240336
3549531|3549531-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231235
3549518|3549518-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231235
3549515|3549515-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231237
3549360|3549360-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200903231932
3549121|3549121-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903231525
3549003|3549003-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903231340
3548764|3548764-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232105
3548762|3548762-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232104
3548755|3548755-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232104
3548690|3548690-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232102
3548312|3548312-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232046
3546284|3546284-b19f-3f77-b713-d32bba55d77f|pass|200903|yary@pinky.yary.ack.org ((Yary Hluchan IV))|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi|5.10.0|openbsd|3.9|200903201500
3544917|3544917-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903232004
3544224|3544224-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903231948
3540697|3540697-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200903221237
3539376|3539376-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903220804
3537472|3537472-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211845
3537078|3537078-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211748
3535225|3535225-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211115
3535224|3535224-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211115
3534524|3534524-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210850
3534522|3534522-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210850
3534519|3534519-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210849
3533501|3533501-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211116
3533441|3533441-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211109
3533159|3533159-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|App-Maisha-Plugin-PingFM|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211034
3532994|3532994-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211012
3532954|3532954-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211003
3532920|3532920-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.35|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210955
3532869|3532869-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.34|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210950
3532852|3532852-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.33|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210945
3532846|3532846-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210944
3531694|3531694-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210044
3531332|3531332-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210002
3531330|3531330-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210002
3531224|3531224-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210349
3530840|3530840-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.55|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903210245
3529237|3529237-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201838
3528805|3528805-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201739
3528799|3528799-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201738
3528602|3528602-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.14|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903201625
3528590|3528590-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.35|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903201623
3527350|3527350-b19f-3f77-b713-d32bba55d77f|pass|200903|stro@cpan.org|App-Maisha-Plugin-PingFM|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903202024
3524790|3524790-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903201423
3524702|3524702-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200911
3524517|3524517-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201348
3524516|3524516-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201347
3524512|3524512-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201347
3524498|3524498-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200845
3524496|3524496-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200845
3524007|3524007-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200743
3523994|3523994-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200742
3521854|3521854-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200129
3521850|3521850-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200129
3521845|3521845-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200128
3521830|3521830-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200125
3521346|3521346-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200349
3520662|3520662-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903200246
3520657|3520657-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903200246
3519778|3519778-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519777|3519777-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519774|3519774-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519763|3519763-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192357
3519393|3519393-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192238
3519392|3519392-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192238
3519387|3519387-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192236
3519384|3519384-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192236
3519298|3519298-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200903192215
3518275|3518275-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191857
3517785|3517785-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191739
3517780|3517780-b19f-3f77-b713-d32bba55d77f|fail|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-WebList|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191739
3517768|3517768-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTP|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191737
3517758|3517758-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191737
3516000|3516000-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903191406
3515999|3515999-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903191406
3515314|3515314-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190753
3513814|3513814-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190425
3513751|3513751-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190418
3513637|3513637-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190400
3513625|3513625-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190358
3513548|3513548-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190350
3510751|3510751-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903181733
3510366|3510366-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903182131
3506643|3506643-b19f-3f77-b713-d32bba55d77f|pass|200903|jafelds@gmail.com|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200903172037
3506276|3506276-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903180919
3506275|3506275-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903180919
3505391|3505391-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903180615
3504877|3504877-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903180423
3503906|3503906-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903180101
3503267|3503267-b19f-3f77-b713-d32bba55d77f|fail|200903|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200903172247
3502813|3502813-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200903172136
3501223|3501223-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171807
3501221|3501221-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171807
3500826|3500826-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux|5.8.9|linux|2.6.24-16-generic|200903171240
3499516|3499516-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171542
3499503|3499503-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171541
3495328|3495328-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903170345
3493547|3493547-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903162140
3492946|3492946-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161940
3492348|3492348-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161836
3492341|3492341-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161835
3491221|3491221-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903161605
3489651|3489651-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903161052
3488907|3488907-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200903160815
3488756|3488756-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903160753
3488667|3488667-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160731
3488567|3488567-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160707
3488566|3488566-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160707
3488549|3488549-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903160700
3488253|3488253-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160534
3488068|3488068-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200903160436
3487655|3487655-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160318
3486362|3486362-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Statistics|0.55|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903151410
3486213|3486213-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152231
3486146|3486146-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152225
3486111|3486111-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.49|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152220
3486105|3486105-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152219
3486069|3486069-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152206
3485314|3485314-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903151939
3484069|3484069-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903151522
3483815|3483815-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|Data-Phrasebook-Loader-YAML|0.09|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150558
3483811|3483811-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|Data-Phrasebook|0.29|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150557
3481955|3481955-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.14|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150026
3481937|3481937-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Data-Generator|0.35|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150021
3477122|3477122-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903150002
3477105|3477105-b19f-3f77-b713-d32bba55d77f|pass|200903|alceu.freitas.jr@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903141200
3477101|3477101-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142359
3477078|3477078-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142357
3477023|3477023-b19f-3f77-b713-d32bba55d77f|fail|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142354
3476994|3476994-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142350
3476946|3476946-b19f-3f77-b713-d32bba55d77f|fail|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142347
3476916|3476916-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476910|3476910-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476903|3476903-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476896|3476896-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142342
3476893|3476893-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142342
3476888|3476888-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142341
3476885|3476885-b19f-3f77-b713-d32bba55d77f|fail|200903|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142341
3476867|3476867-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142338
3476864|3476864-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-XML|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142338
3476855|3476855-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142337
3476851|3476851-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142336
3476825|3476825-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476817|3476817-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476813|3476813-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476806|3476806-b19f-3f77-b713-d32bba55d77f|fail|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-WebList|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142333
3476758|3476758-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142326
3476753|3476753-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142325
3476715|3476715-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142319
3474985|3474985-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141529
3474892|3474892-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141511
3473875|3473875-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141042
3473871|3473871-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141041
3473855|3473855-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141036
3467328|3467328-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903130148
3466915|3466915-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903131845
3466266|3466266-b19f-3f77-b713-d32bba55d77f|pass|200903|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903131637
3465706|3465706-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903130621
3465677|3465677-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903130459
3465296|3465296-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903130506
3461210|3461210-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903121540
3459998|3459998-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903121244
3459994|3459994-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.9|solaris|2.11|200903121244
3459655|3459655-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903121207
3458191|3458191-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120900
3458188|3458188-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120859
3458185|3458185-b19f-3f77-b713-d32bba55d77f|fail|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120859
3453831|3453831-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111723
3453414|3453414-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111637
3453413|3453413-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111637
3452959|3452959-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111538
3449420|3449420-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110650
3449072|3449072-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110559
3449068|3449068-b19f-3f77-b713-d32bba55d77f|fail|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110559
3443769|3443769-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.55|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101818
3443557|3443557-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101712
3443556|3443556-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101712
3442091|3442091-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101249
3442082|3442082-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.35|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101248
3440670|3440670-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903101017
3440661|3440661-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903101016
3440252|3440252-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100933
3440249|3440249-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100933
3440238|3440238-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100932
3440233|3440233-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100931
3439185|3439185-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.10.0|freebsd|7.0-release|200903100750
3439119|3439119-b19f-3f77-b713-d32bba55d77f|pass|200903|peter.kerrigan@gmail.com|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903090852
3438176|3438176-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|Test-YAML-Meta|0.11|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903100448
3436730|3436730-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100307
3435981|3435981-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200903100126
3435409|3435409-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903100009
3435303|3435303-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-Article|0.36|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092357
3435221|3435221-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092349
3434995|3434995-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092313
3434569|3434569-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Data-Uploads|0.06|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091351
3434202|3434202-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-Article|0.36|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091305
3433976|3433976-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433975|3433975-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433972|3433972-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433952|3433952-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091612
3433787|3433787-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091559
3433333|3433333-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-DBUtils|0.03|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091126
3433162|3433162-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903091942
3432859|3432859-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|App-Maisha-Plugin-PingFM|0.02|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091025
3431139|3431139-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200903091508
3427200|3427200-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903090737
3427198|3427198-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903090737
3425833|3425833-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903090001
3424113|3424113-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903090015
3423404|3423404-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081921
3418406|3418406-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081317
3418402|3418402-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081317
3418162|3418162-b19f-3f77-b713-d32bba55d77f|fail|200903|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903081801
3417618|3417618-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903081722
3416602|3416602-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081100
3416596|3416596-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081100
3412647|3412647-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080316
3412457|3412457-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080132
3412455|3412455-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080132
3412396|3412396-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080121
3411870|3411870-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903080546
3411136|3411136-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|App-Maisha|0.12|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903080244
3411116|3411116-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080241
3410158|3410158-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071813
3409782|3409782-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071659
3409781|3409781-b19f-3f77-b713-d32bba55d77f|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071658
3408859|3408859-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903071932
3407196|3407196-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070825
3407091|3407091-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070802
3407090|3407090-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070802
3406770|3406770-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070654
3406767|3406767-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070653
3406159|3406159-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070450
3405964|3405964-b19f-3f77-b713-d32bba55d77f|pass|200903|wiml@hhhh.org ("Wim Lewis")|Mail-Outlook|0.15|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903070045
3405389|3405389-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070222
3404983|3404983-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903070124
3404980|3404980-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903070123
3404957|3404957-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070120
3404887|3404887-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070113
3404857|3404857-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070109
3404853|3404853-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070108
3404775|3404775-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070054
3403886|3403886-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200903070156
3403768|3403768-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070317
3400529|3400529-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|Mail-Outlook|0.15|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903061135
3398457|3398457-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200903060947
3398424|3398424-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd|0|OpenBSD|4.4|200903060537
3397318|3397318-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|CPAN-Testers-Data-Uploads|0.06|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903060336
3397032|3397032-b19f-3f77-b713-d32bba55d77f|pass|200903|jeff@zeroclue.com|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903060253
3394174|3394174-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903052231
3393772|3393772-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200903051908
3393771|3393771-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200903051908
3392602|3392602-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903051337
3391955|3391955-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903051124
3391954|3391954-b19f-3f77-b713-d32bba55d77f|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903051124
3391864|3391864-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903051051
3391607|3391607-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200903050828
3390787|3390787-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903050518
3389683|3389683-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903050242
3387630|3387630-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200903042040
3387619|3387619-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200903042039
3386698|3386698-b19f-3f77-b713-d32bba55d77f|pass|200903|alfreitas@deloitte.com ("Freitas, Alceu Rodrigues de \\(BR - Sao Paulo\\)")|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903041155
3386624|3386624-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200903041759
3386620|3386620-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200903041759
3383286|3383286-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200903040850
3380733|3380733-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200903032339
3379418|3379418-b19f-3f77-b713-d32bba55d77f|pass|200903|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200903032102
3378755|3378755-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200903031706
3376850|3376850-b19f-3f77-b713-d32bba55d77f|pass|200903|vpit@cpan.org|CPAN-WWW-Testers|0.49|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200903031149
3376419|3376419-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200903030929
3376407|3376407-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200903030926
3375934|3375934-b19f-3f77-b713-d32bba55d77f|pass|200903|srezic@cpan.org|App-Maisha|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200903030841
3375282|3375282-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030007
3375280|3375280-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030006
3375277|3375277-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030006
3375265|3375265-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030003
3375131|3375131-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030415
3374193|3374193-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200903022341
3373877|3373877-b19f-3f77-b713-d32bba55d77f|fail|200903|srezic@cpan.org|App-Maisha|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200903022347
3373669|3373669-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903022317
3372521|3372521-b19f-3f77-b713-d32bba55d77f|pass|200903|davidrw@cpan.org|CPAN-WWW-Testers|0.49|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200903021435
3371915|3371915-b19f-3f77-b713-d32bba55d77f|pass|200903|vpit@cpan.org|App-Maisha|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200903021840
3370801|3370801-b19f-3f77-b713-d32bba55d77f|pass|200903|mithaldu@yahoo.de ("Christian Walde")|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903021530
3370677|3370677-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200903021406
3370367|3370367-b19f-3f77-b713-d32bba55d77f|pass|200903|mw487.yahoo.com@gmail.com|App-Maisha|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903020807
3369549|3369549-b19f-3f77-b713-d32bba55d77f|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200903021119
3366141|3366141-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200903012342
3365991|3365991-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903011811
3365925|3365925-b19f-3f77-b713-d32bba55d77f|pass|200903|alexchorny@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200903011758
3365539|3365539-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200903012110
3365402|3365402-b19f-3f77-b713-d32bba55d77f|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200903012053
3365268|3365268-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24-16-generic|200903011519
3363704|3363704-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200903010634
3363702|3363702-b19f-3f77-b713-d32bba55d77f|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24-16-generic|200903010634
3362089|3362089-b19f-3f77-b713-d32bba55d77f|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200903010613
3361087|3361087-b19f-3f77-b713-d32bba55d77f|pass|200902|alexchorny@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902281506
3360385|3360385-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281217
3360000|3360000-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281044
3359999|3359999-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281043
3359895|3359895-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281023
3359207|3359207-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200902281336
3359143|3359143-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902281424
3359038|3359038-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902281404
3359008|3359008-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902282059
3358998|3358998-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902281357
3358955|3358955-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902281346
3358921|3358921-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902281340
3358805|3358805-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902281316
3358799|3358799-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902281315
3358744|3358744-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902281306
3358693|3358693-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902281301
3358292|3358292-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902280500
3358225|3358225-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|IP35-irix-64int|5.8.8|irix|6.5|200902281150
3358166|3358166-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902281041
3358160|3358160-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902281039
3358142|3358142-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902281038
3358136|3358136-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902281038
3357831|3357831-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280433
3357384|3357384-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280248
3356813|3356813-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280454
3354476|3354476-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.12||0|||200902271414
3348752|3348752-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200902252333
3348739|3348739-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200902252330
3347622|3347622-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902251932
3347369|3347369-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902251644
3346286|3346286-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250710
3346285|3346285-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250710
3345892|3345892-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250531
3345883|3345883-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250530
3345358|3345358-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250339
3343517|3343517-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250212
3343508|3343508-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250209
3343504|3343504-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250207
3343502|3343502-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250206
3343495|3343495-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250206
3343493|3343493-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250205
3343395|3343395-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250139
3343383|3343383-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250135
3343378|3343378-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250134
3343369|3343369-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250133
3343363|3343363-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250132
3343359|3343359-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250131
3342018|3342018-b19f-3f77-b713-d32bba55d77f|fail|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902241917
3341976|3341976-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241806
3341961|3341961-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341960|3341960-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341958|3341958-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341956|3341956-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241803
3341953|3341953-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241803
3341873|3341873-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241249
3341198|3341198-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241052
3340992|3340992-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241018
3340924|3340924-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241006
3340915|3340915-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241005
3340720|3340720-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.24-16-generic|200902240934
3340624|3340624-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200902240912
3339950|3339950-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240558
3339948|3339948-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240558
3339851|3339851-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240523
3338679|3338679-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902240427
3337408|3337408-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232257
3337407|3337407-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232256
3337404|3337404-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232255
3337399|3337399-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232255
3337396|3337396-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232254
3337391|3337391-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232253
3337387|3337387-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232252
3337384|3337384-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232252
3337381|3337381-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232251
3337379|3337379-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232251
3337377|3337377-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232250
3337375|3337375-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232250
3337374|3337374-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232250
3337373|3337373-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232249
3337372|3337372-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232249
3337371|3337371-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232248
3337370|3337370-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232248
3337367|3337367-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232248
3337364|3337364-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232247
3337362|3337362-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232246
3336906|3336906-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200902231929
3336819|3336819-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902231919
3336358|3336358-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902231655
3335837|3335837-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902232232
3335769|3335769-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902232227
3335312|3335312-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902231351
3335175|3335175-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902231312
3335053|3335053-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|x86_64-linux-ld|5.10.0|linux|2.6.27-9-generic|200902230643
3335031|3335031-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902231235
3334800|3334800-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902231128
3334517|3334517-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230912
3334513|3334513-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230910
3334511|3334511-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230909
3334503|3334503-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230907
3334501|3334501-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230906
3334498|3334498-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230905
3334495|3334495-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230904
3334490|3334490-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230903
3334482|3334482-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230902
3334477|3334477-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230901
3333766|3333766-b19f-3f77-b713-d32bba55d77f|pass|200902|rafl@debian.org|Test-YAML-Meta|0.11|i686-linux|5.10.0 patch 35117|linux|2.6.26|200902230816
3332943|3332943-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902230311
3332755|3332755-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230203
3332751|3332751-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230202
3332748|3332748-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230201
3332740|3332740-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230159
3332738|3332738-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230158
3332736|3332736-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230157
3332734|3332734-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230156
3332733|3332733-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230156
3332729|3332729-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230155
3332725|3332725-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230154
3332721|3332721-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230153
3332456|3332456-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200902230040
3332454|3332454-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200902230039
3332321|3332321-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200902222352
3332202|3332202-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha-Plugin-PingFM|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221830
3332195|3332195-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha-Plugin-PingFM|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221829
3332178|3332178-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332173|3332173-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.10|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332172|3332172-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.09|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332170|3332170-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.08|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332168|3332168-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.07|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332166|3332166-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.06|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332165|3332165-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.05|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221824
3332163|3332163-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.04|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221824
3331895|3331895-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902222247
3331710|3331710-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902222203
3331555|3331555-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.6.2|freebsd|7.0-release|200902222123
3329175|3329175-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902221047
3329078|3329078-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221019
3329077|3329077-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221019
3329074|3329074-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221017
3329073|3329073-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221017
3329070|3329070-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221016
3329069|3329069-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221016
3329065|3329065-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221014
3329064|3329064-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221013
3329063|3329063-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221012
3329062|3329062-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221012
3329061|3329061-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221011
3329060|3329060-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221011
3329059|3329059-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221010
3329058|3329058-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221010
3329057|3329057-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221009
3329056|3329056-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221009
3329055|3329055-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221008
3329053|3329053-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221008
3329052|3329052-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221007
3329051|3329051-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221007
3329050|3329050-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221007
3329049|3329049-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221006
3327465|3327465-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.6.2|netbsd|4.0|200902212347
3327169|3327169-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902212242
3327074|3327074-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902212207
3326511|3326511-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902211920
3326437|3326437-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902211924
3326089|3326089-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211524
3326083|3326083-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211523
3326077|3326077-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211522
3326064|3326064-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211519
3326063|3326063-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211518
3326058|3326058-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211517
3326053|3326053-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211516
3326049|3326049-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211515
3326044|3326044-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211514
3326041|3326041-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211513
3326037|3326037-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211512
3326034|3326034-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211511
3326033|3326033-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211510
3325666|3325666-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902211459
3325648|3325648-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902211454
3325617|3325617-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.6.2|freebsd|7.0-release|200902211310
3323902|3323902-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210117
3323901|3323901-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210117
3323900|3323900-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210116
3323896|3323896-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210115
3323618|3323618-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202220
3323604|3323604-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202218
3323589|3323589-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202217
3323583|3323583-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202215
3323578|3323578-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202214
3323573|3323573-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202214
3323568|3323568-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202213
3323559|3323559-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202211
3323554|3323554-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202211
3323547|3323547-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202209
3323541|3323541-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202208
3323537|3323537-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202207
3323533|3323533-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202206
3323530|3323530-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202206
3323526|3323526-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202205
3323523|3323523-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202205
3323518|3323518-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202204
3323515|3323515-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202204
3323512|3323512-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202203
3323511|3323511-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202203
3323507|3323507-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202202
3323506|3323506-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202202
3323502|3323502-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202201
3323500|3323500-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202201
3323499|3323499-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202200
3323492|3323492-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202200
3323487|3323487-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202159
3323482|3323482-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202158
3323475|3323475-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202157
3323472|3323472-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202156
3323455|3323455-b19f-3f77-b713-d32bba55d77f|pass|200902|shlomif@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.29-desktop-0.rc5.1mnb|200902210033
3323453|3323453-b19f-3f77-b713-d32bba55d77f|pass|200902|shlomif@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.29-desktop-0.rc5.1mnb|200902210033
3322730|3322730-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902201405
3322421|3322421-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902201835
3321950|3321950-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200902201528
3321947|3321947-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|IP35-irix-64int|5.8.8|irix|6.5|200902201628
3321913|3321913-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902200917
3321872|3321872-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902201503
3321870|3321870-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902201503
3321863|3321863-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902201503
3321862|3321862-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902201502
3321303|3321303-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201211
3321301|3321301-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201210
3321300|3321300-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201209
3321298|3321298-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201208
3321296|3321296-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201207
3321294|3321294-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201206
3321293|3321293-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201206
3321287|3321287-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201204
3321193|3321193-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902201102
3321191|3321191-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902201101
3320605|3320605-b19f-3f77-b713-d32bba55d77f|pass|200902|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200902200031
3320604|3320604-b19f-3f77-b713-d32bba55d77f|pass|200902|jeff@zeroclue.com|Data-Phrasebook|0.29|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200902200030
3320177|3320177-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902200037
3320176|3320176-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902200037
3320086|3320086-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.10.0|linux|2.6.27.4-chii.profvince.com|200902200019
3318966|3318966-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191236
3318960|3318960-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191234
3318957|3318957-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191233
3318954|3318954-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191232
3318950|3318950-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191231
3318948|3318948-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191230
3318944|3318944-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191229
3318942|3318942-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191229
3318941|3318941-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191228
3318940|3318940-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191227
3318938|3318938-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191227
3318936|3318936-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191226
3318933|3318933-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191226
3318931|3318931-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191225
3318930|3318930-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191225
3318529|3318529-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902191503
3318523|3318523-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902191459
3318490|3318490-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902191434
3318486|3318486-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902191431
3318357|3318357-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190621
3318354|3318354-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191220
3318337|3318337-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191217
3318288|3318288-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190554
3318285|3318285-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190553
3318280|3318280-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190552
3318278|3318278-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190551
3318248|3318248-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318246|3318246-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318245|3318245-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318244|3318244-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318229|3318229-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191059
3318226|3318226-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191058
3318223|3318223-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|IP35-irix-64int|5.8.8|irix|6.5|200902191158
3318215|3318215-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191057
3318213|3318213-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|IP35-irix-64int|5.8.8|irix|6.5|200902191157
3318210|3318210-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|IP35-irix-64int|5.8.8|irix|6.5|200902191156
3318207|3318207-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|IP35-irix-64int|5.8.8|irix|6.5|200902191155
3318196|3318196-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902191054
3318194|3318194-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902191054
3318023|3318023-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318022|3318022-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318020|3318020-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318019|3318019-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318018|3318018-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318016|3318016-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318015|3318015-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318014|3318014-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318008|3318008-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190912
3318006|3318006-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3318004|3318004-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3318003|3318003-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3317921|3317921-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200902190929
3317643|3317643-b19f-3f77-b713-d32bba55d77f|fail|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.04|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902190441
3317472|3317472-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902190404
3317435|3317435-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902190336
3317068|3317068-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902190134
3317008|3317008-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902190125
3316960|3316960-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902190110
3316906|3316906-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902190058
3316879|3316879-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902190057
3316776|3316776-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902190041
3316774|3316774-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902190037
3316772|3316772-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902190033
3316730|3316730-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902190020
3316722|3316722-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902190016
3316652|3316652-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902182352
3316641|3316641-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902182346
3316617|3316617-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902182334
3316612|3316612-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902182328
3316321|3316321-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200902182229
3316092|3316092-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200902182121
3315786|3315786-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200902181824
3315776|3315776-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200902181821
3315702|3315702-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181738
3315700|3315700-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181737
3315693|3315693-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181733
3315691|3315691-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181733
3315690|3315690-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181733
3315688|3315688-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181731
3315687|3315687-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181731
3315685|3315685-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181729
3315683|3315683-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181727
3315681|3315681-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181727
3315680|3315680-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181726
3315679|3315679-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181725
3315678|3315678-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181725
3315677|3315677-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181724
3315676|3315676-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181724
3315673|3315673-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181723
3315672|3315672-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181722
3315671|3315671-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181722
3315670|3315670-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181721
3315668|3315668-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181721
3315667|3315667-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181720
3315666|3315666-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181720
3315665|3315665-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181719
3315664|3315664-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181719
3315663|3315663-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181718
3315662|3315662-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181718
3315659|3315659-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181717
3315656|3315656-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181716
3315594|3315594-b19f-3f77-b713-d32bba55d77f|pass|200902|office@darac.org.uk|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.6|MSWin32|4.0|200902171029
3315530|3315530-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.11||0|||200902181649
3315524|3315524-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181647
3315522|3315522-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181646
3314683|3314683-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.08|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181121
3313968|3313968-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180139
3313950|3313950-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180134
3313947|3313947-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180133
3313945|3313945-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180132
3313938|3313938-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180129
3313936|3313936-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180128
3313935|3313935-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180127
3313932|3313932-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180127
3313930|3313930-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180126
3313613|3313613-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171811
3313602|3313602-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313600|3313600-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313597|3313597-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313589|3313589-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313584|3313584-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313579|3313579-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313577|3313577-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.04|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313575|3313575-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313572|3313572-b19f-3f77-b713-d32bba55d77f|fail|200902|DCOLLINS@cpan.org|App-Maisha|0.02|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313570|3313570-b19f-3f77-b713-d32bba55d77f|fail|200902|DCOLLINS@cpan.org|App-Maisha|0.01|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3312806|3312806-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.10.0|freebsd|7.0-release|200902172112
3312768|3312768-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-WWW-Testers|0.49|amd64-freebsd|5.10.0|freebsd|7.0-release|200902172103
3312733|3312733-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200902172038
3312687|3312687-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200902172038
3312673|3312673-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200902172037
3312671|3312671-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200902172037
3312133|3312133-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171724
3312119|3312119-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171719
3312105|3312105-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171716
3312099|3312099-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171714
3312097|3312097-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171713
3312094|3312094-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171713
3312089|3312089-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171712
3312086|3312086-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171711
3312069|3312069-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171709
3312064|3312064-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171707
3311935|3311935-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171646
3311846|3311846-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902171029
3311786|3311786-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha-Plugin-PingFM|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171719
3311781|3311781-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902171017
3311780|3311780-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171719
3311779|3311779-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171616
3311777|3311777-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171718
3311776|3311776-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171616
3311772|3311772-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171717
3311667|3311667-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171550
3311642|3311642-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.10||0|||200902171647
3311637|3311637-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171547
3311615|3311615-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha-Plugin-PingFM|0.02||0|||200902171643
3311567|3311567-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.09||0|||200902171638
3311511|3311511-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171525
3311510|3311510-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171525
3311458|3311458-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171512
3311454|3311454-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171512
3311452|3311452-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902171512
3311444|3311444-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902171510
3311439|3311439-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170910
3311304|3311304-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200902171434
3311303|3311303-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200902171434
3311285|3311285-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200902171428
3311283|3311283-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200902171428
3311015|3311015-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.08||0|||200902171407
3310770|3310770-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171301
3310697|3310697-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.36|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171249
3310695|3310695-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-Article|0.36|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171249
3310658|3310658-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171141
3310650|3310650-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171139
3310644|3310644-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171238
3310643|3310643-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171138
3310642|3310642-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171237
3310640|3310640-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171137
3310637|3310637-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171137
3310634|3310634-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171136
3310632|3310632-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171136
3310629|3310629-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171135
3310527|3310527-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.07||0|||200902171212
3310525|3310525-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|IP35-irix-64int|5.8.8|irix|6.5|200902171212
3310511|3310511-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|IP35-irix-64int|5.8.8|irix|6.5|200902171210
3310423|3310423-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170457
3310422|3310422-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902171057
3310419|3310419-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902171056
3310418|3310418-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170456
3310241|3310241-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171119
3310211|3310211-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|IP35-irix-64int|5.8.8|irix|6.5|200902171114
3310210|3310210-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171013
3310208|3310208-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171014
3310207|3310207-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|IP35-irix-64int|5.8.8|irix|6.5|200902171113
3310204|3310204-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171012
3310203|3310203-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171012
3310171|3310171-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171104
3310170|3310170-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171104
3310164|3310164-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.6.2|freebsd|7.0-release|200902170935
3310113|3310113-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171052
3310106|3310106-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171050
3310081|3310081-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171043
3310067|3310067-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|IP35-irix-64int|5.8.8|irix|6.5|200902171038
3310065|3310065-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902170937
3310063|3310063-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902170938
3310062|3310062-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310059|3310059-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310057|3310057-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310055|3310055-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171036
3310033|3310033-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171029
3309991|3309991-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171016
3309972|3309972-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170913
3309971|3309971-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170912
3309956|3309956-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170910
3309921|3309921-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902171704
3309891|3309891-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902171659
3309833|3309833-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170949
3309810|3309810-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902170938
3309807|3309807-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902170935
3309806|3309806-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170934
3309803|3309803-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902170934
3309802|3309802-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902170933
3309783|3309783-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170930
3309582|3309582-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902170858
3309571|3309571-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902170854
3309548|3309548-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200902170839
3309546|3309546-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200902170839
3308015|3308015-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162336
3308009|3308009-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162336
3308008|3308008-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3308001|3308001-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3307999|3307999-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3307994|3307994-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162334
3307905|3307905-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902162317
3307903|3307903-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902162316
3307900|3307900-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902162316
3307896|3307896-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902162315
3307509|3307509-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902162225
3307240|3307240-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902162109
3306923|3306923-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200902161906
3306921|3306921-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.8.8|freebsd|7.0-release|200902161906
3306845|3306845-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.8.9|freebsd|7.0-release|200902161906
3306842|3306842-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200902161906
3306773|3306773-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902161847
3306447|3306447-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha-Plugin-PingFM|0.01||0|||200902161716
3306379|3306379-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.04|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902162355
3306087|3306087-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.06||0|||200902161530
3305952|3305952-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.05||0|||200902161422
3305780|3305780-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161238
3305775|3305775-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161237
3305773|3305773-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161236
3305768|3305768-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161235
3305764|3305764-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161234
3305760|3305760-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161234
3305751|3305751-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161231
3305745|3305745-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161229
3305743|3305743-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161228
3305735|3305735-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161228
3305732|3305732-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161227
3305730|3305730-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161226
3305692|3305692-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-WWW-Testers|0.49||0|||200902161317
3305663|3305663-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-Data-Generator|0.36||0|||200902161309
3305477|3305477-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|CPAN-WWW-Testers|0.48|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200902161212
3305185|3305185-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161019
3305180|3305180-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161018
3305179|3305179-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161017
3305174|3305174-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161016
3305173|3305173-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161015
3305170|3305170-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161015
3305167|3305167-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161014
3304867|3304867-b19f-3f77-b713-d32bba55d77f|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160419
3304864|3304864-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160418
3304861|3304861-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160418
3304856|3304856-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|Mail-Outlook|0.15|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902160418
3304413|3304413-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160721
3304405|3304405-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160720
3304399|3304399-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160718
3304394|3304394-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160718
3304390|3304390-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160717
3304389|3304389-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160716
3303942|3303942-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160359
3303633|3303633-b19f-3f77-b713-d32bba55d77f|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.10.0|cygwin|1.5.25(0.15642)|200902160142
3303629|3303629-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160141
3303624|3303624-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160141
3303508|3303508-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902160053
3303507|3303507-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902160052
3303506|3303506-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902160052
3303505|3303505-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902160051
3302990|3302990-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200902152236
3302980|3302980-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200902152236
3302808|3302808-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.04|amd64-freebsd|5.8.9|freebsd|7.0-release|200902152236
3302790|3302790-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.04|amd64-freebsd|5.8.8|freebsd|7.0-release|200902152236
3302643|3302643-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.10.0|freebsd|7.0-release|200902152207
3302624|3302624-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.10.0|freebsd|7.0-release|200902152207
3302256|3302256-b19f-3f77-b713-d32bba55d77f|pass|200902|sanko@cpan.org ("Sanko Robinson")|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.11.0 patch blead 2009-02-05.22:06:19 c8f794576f0d940fc66e0fc10236a1b54a7e40a3 GitLive-blead-510-gc8f7945|MSWin32|5.1|200902141340
3302160|3302160-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151807
3302154|3302154-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151805
3302152|3302152-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151805
3302150|3302150-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151804
3302148|3302148-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151804
3302125|3302125-b19f-3f77-b713-d32bba55d77f|pass|200902|mithaldu@yahoo.de ("Christian Walde")|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200902142242
3301739|3301739-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.04||0|||200902151742
3301669|3301669-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.06||0|||200902151731
3301290|3301290-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|alpha-netbsd|5.10.0|netbsd|4.0.1|200902151441
3301096|3301096-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200902151339
3301095|3301095-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902150739
3300979|3300979-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902150709
3300784|3300784-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902151203
3300783|3300783-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902151204
3300782|3300782-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902151204
3300781|3300781-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902151204
3300763|3300763-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902151159
3300762|3300762-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902151159
3300761|3300761-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902151159
3300760|3300760-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902151159
3300758|3300758-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151157
3300745|3300745-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151155
3300743|3300743-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151153
3300741|3300741-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151153
3300736|3300736-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151152
3300667|3300667-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151140
3300662|3300662-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151138
3300660|3300660-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151138
3300659|3300659-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151137
3300657|3300657-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151136
3300567|3300567-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.21.5-smp|200902151058
3300457|3300457-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902151117
3300291|3300291-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902151026
3300290|3300290-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902151026
3300269|3300269-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.05||0|||200902150959
3299845|3299845-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902150258
3299843|3299843-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902150257
3299842|3299842-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902150257
3299840|3299840-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902150256
3299614|3299614-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902150125
3298972|3298972-b19f-3f77-b713-d32bba55d77f|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141742
3298962|3298962-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141740
3298952|3298952-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142236
3298948|3298948-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142235
3298947|3298947-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142234
3298556|3298556-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|Mail-Outlook|0.15|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141633
3298554|3298554-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141633
3298529|3298529-b19f-3f77-b713-d32bba55d77f|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141630
3298419|3298419-b19f-3f77-b713-d32bba55d77f|fail|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141600
3298346|3298346-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902142025
3298343|3298343-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902142024
3298342|3298342-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902142024
3298337|3298337-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902142023
3298178|3298178-b19f-3f77-b713-d32bba55d77f|fail|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.02|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902142040
3297991|3297991-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.03||0|||200902141945
3297758|3297758-b19f-3f77-b713-d32bba55d77f|fail|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902150145
3297744|3297744-b19f-3f77-b713-d32bba55d77f|fail|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902150142
3297386|3297386-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200902141733
3297385|3297385-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200902141733
3296725|3296725-b19f-3f77-b713-d32bba55d77f|fail|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.04|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902140914
3296710|3296710-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|alpha-netbsd|5.10.0|netbsd|4.0.1|200902141413
3296703|3296703-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902140912
3296658|3296658-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141402
3296652|3296652-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141401
3296529|3296529-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141346
3296517|3296517-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141345
3296510|3296510-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902140744
3296425|3296425-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|IP35-irix-64int|5.8.8|irix|6.5|200902141429
3296415|3296415-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200902141327
3296362|3296362-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902141321
3296359|3296359-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902140721
3296357|3296357-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902141321
3296356|3296356-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902141321
3296355|3296355-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902141321
3296284|3296284-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200902141310
3296273|3296273-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200902141308
3296260|3296260-b19f-3f77-b713-d32bba55d77f|fail|200902|vpit@cpan.org|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296257|3296257-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296255|3296255-b19f-3f77-b713-d32bba55d77f|pass|200902|vpit@cpan.org|App-Maisha|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296123|3296123-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.02||0|||200902141315
3296122|3296122-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902141215
3296121|3296121-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902141215
3296118|3296118-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902141214
3296112|3296112-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902141213
3295977|3295977-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141144
3295963|3295963-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141142
3295959|3295959-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141141
3295906|3295906-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141130
3295902|3295902-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141127
3295900|3295900-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141126
3295756|3295756-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902141148
3295750|3295750-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141145
3295664|3295664-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902141120
3295631|3295631-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902141113
3295570|3295570-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141102
3295485|3295485-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902141044
3295406|3295406-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141018
3293390|3293390-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902140345
3292493|3292493-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902140136
3292479|3292479-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902140135
3292467|3292467-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902140134
3292459|3292459-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902140133
3290605|3290605-b19f-3f77-b713-d32bba55d77f|fail|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.04|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902132305
3290439|3290439-b19f-3f77-b713-d32bba55d77f|fail|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.01|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902132250
3290158|3290158-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902131621
3289641|3289641-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902132039
3289635|3289635-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902132039
3289624|3289624-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902132038
3289614|3289614-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902132037
3289453|3289453-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902131328
3289324|3289324-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200902132116
3289262|3289262-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|App-Maisha|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200902132109
3289039|3289039-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902131446
3287570|3287570-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902131228
3286379|3286379-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.04|amd64-freebsd|5.8.9|freebsd|7.0-release|200902131633
3286284|3286284-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|App-Maisha|0.01||0|||200902131648
3286173|3286173-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.04|amd64-freebsd|5.8.8|freebsd|7.0-release|200902131633
3285769|3285769-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.8.9|freebsd|7.0-release|200902131540
3285589|3285589-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.8.8|freebsd|7.0-release|200902131540
3283955|3283955-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.11.0 patch GitLive-blead-599-gd9acc78|linux|2.6.16.38|200902131250
3283539|3283539-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.04||0|||200902131317
3283159|3283159-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902131253
3283100|3283100-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902131950
3282781|3282781-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|alpha-netbsd|5.10.0|netbsd|4.0.1|200902131131
3282755|3282755-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200902131129
3282748|3282748-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902131129
3282527|3282527-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200902131110
3282505|3282505-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902131208
3282482|3282482-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902131206
3282469|3282469-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902131106
3282266|3282266-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902131150
3282178|3282178-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902131142
3282046|3282046-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|IP35-irix-64int|5.8.8|irix|6.5|200902131134
3281925|3281925-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902130428
3281901|3281901-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902131026
3281895|3281895-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902131026
3281852|3281852-b19f-3f77-b713-d32bba55d77f|pass|200902|stro@cpan.org|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200902131223
3281582|3281582-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130310
3281543|3281543-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902131100
3281321|3281321-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200902131044
3281294|3281294-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902131042
3281188|3281188-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902131036
3281118|3281118-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902131031
3281035|3281035-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200902131024
3281012|3281012-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902130921
3281002|3281002-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902130918
3280985|3280985-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200902131013
3280838|3280838-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200902130956
3280521|3280521-b19f-3f77-b713-d32bba55d77f|pass|200902|stro@cpan.org|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200902131025
3280382|3280382-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902130813
3280280|3280280-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902130252
3280097|3280097-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130240
3280069|3280069-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130237
3280043|3280043-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902130232
3277837|3277837-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902122357
3277832|3277832-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902122357
3277831|3277831-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902122357
3277829|3277829-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int|5.6.2|darwin|8.11.0|200902122356
3277824|3277824-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902122356
3277296|3277296-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Mail-Outlook|0.15|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902122206
3277141|3277141-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902122229
3276437|3276437-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121953
3276312|3276312-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121052
3276084|3276084-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120918
3276046|3276046-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121915
3276045|3276045-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121915
3275224|3275224-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120920
3275100|3275100-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121243
3275099|3275099-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121243
3274975|3274975-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121235
3274972|3274972-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121235
3274952|3274952-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902121233
3274951|3274951-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902121233
3274779|3274779-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121722
3274039|3274039-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121052
3272314|3272314-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-Common-Article|0.36||0|||200902121435
3270654|3270654-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902120240
3269731|3269731-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121054
3269721|3269721-b19f-3f77-b713-d32bba55d77f|fail|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121053
3269612|3269612-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120359
3269140|3269140-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120234
3269115|3269115-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200902121115
3268811|3268811-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200902121054
3268618|3268618-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902120359
3268585|3268585-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200902121037
3268362|3268362-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200902121023
3260158|3260158-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200902112134
3259888|3259888-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200902112134
3259349|3259349-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902112003
3258136|3258136-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902111127
3258055|3258055-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902111702
3258054|3258054-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902111702
3258047|3258047-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|alpha-netbsd|5.10.0|netbsd|4.0.1|200902111700
3258042|3258042-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|IP35-irix-64int|5.8.8|irix|6.5|200902111759
3258041|3258041-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902111657
3258040|3258040-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902111657
3258039|3258039-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200902111657
3257088|3257088-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111411
3256717|3256717-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111318
3256716|3256716-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111318
3255754|3255754-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902110640
3255422|3255422-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111052
3254871|3254871-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902110929
3254605|3254605-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.15|i86pc-solaris-64int|5.10.0|solaris|2.11|200902110956
3254512|3254512-b19f-3f77-b713-d32bba55d77f|pass|200902|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902111637
3254339|3254339-b19f-3f77-b713-d32bba55d77f|pass|200902|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200902111527
3253720|3253720-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902110157
3252997|3252997-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|Mail-Outlook|0.15||0|||200902110057
3250655|3250655-b19f-3f77-b713-d32bba55d77f|pass|200902|davidp@preshweb.co.uk ("David Precious")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24.2|200902092159
3250492|3250492-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902101533
3250108|3250108-b19f-3f77-b713-d32bba55d77f|pass|200902|artur+cpan@niif.spb.su (ARTO)|Test-YAML-Meta|0.11|i386-linux-thread-multi|5.10.0|linux|2.6.18-92.1.18.el5|200902091110
3248609|3248609-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200902100647
3247946|3247946-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902100314
3247899|3247899-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902100308
3247452|3247452-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902100148
3247433|3247433-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902100146
3247243|3247243-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.11.0 patch GitLive-blead-571-gabd7186|freebsd|7.0-release|200902100124
3246971|3246971-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902100021
3246651|3246651-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091855
3246614|3246614-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091852
3246495|3246495-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091845
3245565|3245565-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902091650
3245558|3245558-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902091648
3245514|3245514-b19f-3f77-b713-d32bba55d77f|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091644
3241468|3241468-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902091457
3236614|3236614-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902090259
3236575|3236575-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902090253
3235170|3235170-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902082255
3234983|3234983-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080333
3234952|3234952-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080332
3234879|3234879-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080334
3234534|3234534-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080335
3234531|3234531-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080333
3234474|3234474-b19f-3f77-b713-d32bba55d77f|pass|200902|myxomatosis@snoogans.org|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.24-16-server|200902080810
3234401|3234401-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080233
3229957|3229957-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200902081016
3229283|3229283-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080327
3229279|3229279-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080327
3229262|3229262-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080326
3229259|3229259-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080325
3229249|3229249-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080324
3229197|3229197-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080319
3229194|3229194-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080319
3229179|3229179-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080317
3229177|3229177-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080317
3229160|3229160-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080316
3228897|3228897-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080248
3228892|3228892-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080247
3228886|3228886-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080246
3228883|3228883-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080246
3228875|3228875-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080245
3228806|3228806-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080238
3228805|3228805-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080238
3228798|3228798-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080237
3228797|3228797-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080236
3228791|3228791-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080236
3228555|3228555-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080211
3228552|3228552-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080209
3228475|3228475-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080155
3228437|3228437-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080148
3226748|3226748-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.589@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080003
3226626|3226626-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902071843
3221883|3221883-b19f-3f77-b713-d32bba55d77f|fail|200902|cpan.dcollins.5100@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902070835
3221535|3221535-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200902071207
3218664|3218664-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902070103
3214600|3214600-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902051829
3214289|3214289-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902061230
3214277|3214277-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902061228
3213971|3213971-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902051832
3213917|3213917-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902061139
3213772|3213772-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902061123
3213324|3213324-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902061016
3213323|3213323-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200902061016
3212378|3212378-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902060200
3212374|3212374-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902060159
3209733|3209733-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051412
3209687|3209687-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051400
3209536|3209536-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051335
3209528|3209528-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051333
3209120|3209120-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051228
3209024|3209024-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051217
3209017|3209017-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051216
3206570|3206570-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051140
3206562|3206562-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051134
3206557|3206557-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051131
3206117|3206117-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902050957
3204537|3204537-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902050319
3204460|3204460-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.s2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902050312
3203518|3203518-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902050127
3202654|3202654-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|alpha-netbsd|5.10.0|netbsd|4.0.1|200902050003
3201718|3201718-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902042225
3201320|3201320-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.10.0|freebsd|7.0-release|200902042257
3198952|3198952-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902041308
3197911|3197911-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-WWW-Testers|0.48|amd64-freebsd|5.10.0|freebsd|7.0-release|200902041311
3197681|3197681-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200902041134
3197016|3197016-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902040936
3196662|3196662-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902040838
3195484|3195484-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040230
3195305|3195305-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040208
3195088|3195088-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902040148
3194762|3194762-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040101
3194577|3194577-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.589@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902040041
3193732|3193732-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902032251
3193729|3193729-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902032250
3193723|3193723-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902032250
3193684|3193684-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902032108
3192969|3192969-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902032141
3192563|3192563-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902031510
3192540|3192540-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902031507
3191873|3191873-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031929
3191855|3191855-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031921
3191844|3191844-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031916
3191837|3191837-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031914
3191829|3191829-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031906
3191819|3191819-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031858
3191557|3191557-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031641
3191550|3191550-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031639
3191539|3191539-b19f-3f77-b713-d32bba55d77f|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902031130
3188034|3188034-b19f-3f77-b713-d32bba55d77f|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.48|i686-linux|5.10.0|linux|2.6.18-4-686|200902030217
3187365|3187365-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022354
3187359|3187359-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022353
3187156|3187156-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022319
3186366|3186366-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-WWW-Testers|0.48||0|||200902022230
3186072|3186072-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902021537
3186053|3186053-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902021534
3185949|3185949-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902022108
3185921|3185921-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902022106
3185393|3185393-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.8.9|freebsd|7.0-release|200902021857
3185385|3185385-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.8.8|freebsd|7.0-release|200902021857
3185326|3185326-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902021752
3184811|3184811-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-WWW-Testers|0.47||0|||200902021735
3184401|3184401-b19f-3f77-b713-d32bba55d77f|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.60|i86pc-solaris-64int|5.10.0|solaris|2.11|200902021625
3184097|3184097-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200902021416
3183948|3183948-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902021342
3183820|3183820-b19f-3f77-b713-d32bba55d77f|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902021316
3183660|3183660-b19f-3f77-b713-d32bba55d77f|cpan|200902|BARBIE|CPAN-Testers-WWW-Statistics|0.60||0|||200902021333
3183425|3183425-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902021221
3181885|3181885-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902020701
3181883|3181883-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902020700
3181170|3181170-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902020116
3180309|3180309-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.10.0|freebsd|7.0-release|200902012250
3180305|3180305-b19f-3f77-b713-d32bba55d77f|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.10.0|freebsd|7.0-release|200902012249
3178689|3178689-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011325
3178688|3178688-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011325
3178668|3178668-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902011323
3178665|3178665-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902011323
3178652|3178652-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011321
3178647|3178647-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011321
3178614|3178614-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011319
3178611|3178611-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011319
3178580|3178580-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902011315
3178579|3178579-b19f-3f77-b713-d32bba55d77f|pass|200902|cpan.dcollins.blead@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902011315
3178567|3178567-b19f-3f77-b713-d32bba55d77f|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.10.0|freebsd|7.0-release|200902011912
3177029|3177029-b19f-3f77-b713-d32bba55d77f|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.8.9|freebsd|7.0-release|200902011531
3176873|3176873-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902011408
3176870|3176870-b19f-3f77-b713-d32bba55d77f|fail|200902|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.59|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902011408
3176835|3176835-b19f-3f77-b713-d32bba55d77f|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.8.8|freebsd|7.0-release|200902011456
3176225|3176225-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011218
3176219|3176219-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011217
3176217|3176217-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011217
3176178|3176178-b19f-3f77-b713-d32bba55d77f|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011208
3175629|3175629-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010622
3175622|3175622-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010620
3175618|3175618-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010619
3175614|3175614-b19f-3f77-b713-d32bba55d77f|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010618
3173864|3173864-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312308
3173863|3173863-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312307
3173862|3173862-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312306
3173817|3173817-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312257
3172580|3172580-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311535
3172569|3172569-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311533
3172544|3172544-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311530
3172538|3172538-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311528
3172463|3172463-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.s1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311523
3172456|3172456-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311523
3172287|3172287-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311455
3172286|3172286-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311458
3172279|3172279-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311457
3172270|3172270-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311456
3172234|3172234-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311452
3172220|3172220-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311449
3172210|3172210-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311446
3172208|3172208-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311444
3172182|3172182-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311442
3172105|3172105-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311434
3172100|3172100-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311436
3172093|3172093-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311433
3172086|3172086-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311432
3172083|3172083-b19f-3f77-b713-d32bba55d77f|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311431
3171414|3171414-b19f-3f77-b713-d32bba55d77f|fail|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.59|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902010129
3170952|3170952-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901311558
3170921|3170921-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311554
3170915|3170915-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311553
3170914|3170914-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311552
3170903|3170903-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311552
3170737|3170737-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311539
3170719|3170719-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311537
3170703|3170703-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311536
3170686|3170686-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311535
3169457|3169457-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.46|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901310914
3168973|3168973-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311214
3168971|3168971-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311213
3168969|3168969-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311211
3168968|3168968-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311210
3168947|3168947-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311153
3168945|3168945-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311155
3168944|3168944-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311151
3168941|3168941-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311150
3168571|3168571-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901310514
3168570|3168570-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901310514
3168073|3168073-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310426
3167893|3167893-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901310412
3167885|3167885-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310411
3167849|3167849-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310409
3167818|3167818-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901310405
3166461|3166461-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901302221
3166460|3166460-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901302220
3165707|3165707-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901301215
3165675|3165675-b19f-3f77-b713-d32bba55d77f|pass|200901|alexchorny@gmail.com|Mail-Outlook|0.14|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200901301504
3164595|3164595-b19f-3f77-b713-d32bba55d77f|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901301158
3164585|3164585-b19f-3f77-b713-d32bba55d77f|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901301156
3163156|3163156-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.59||0|||200901301421
3162917|3162917-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162711|3162711-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901301110
3162708|3162708-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162702|3162702-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901301109
3162650|3162650-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162538|3162538-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901300530
3162518|3162518-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162411|3162411-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162377|3162377-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162373|3162373-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901301013
3162371|3162371-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901301013
3162297|3162297-b19f-3f77-b713-d32bba55d77f|fail|200901|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.18-4-686|200901301142
3162287|3162287-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162227|3162227-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901301024
3162222|3162222-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901301028
3162220|3162220-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901301028
3162209|3162209-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301007
3162205|3162205-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162187|3162187-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162163|3162163-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162103|3162103-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162090|3162090-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3161945|3161945-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|alpha-netbsd|5.10.0|netbsd|4.0.1|200901300939
3161867|3161867-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901300927
3161310|3161310-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300018
3160706|3160706-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-Data-Generator|0.35|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901300516
3160516|3160516-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300430
3160513|3160513-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300430
3160459|3160459-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901300417
3159773|3159773-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901300130
3159771|3159771-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901300129
3159518|3159518-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901300040
3159420|3159420-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200901300121
3159382|3159382-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.18-4-686|200901300112
3159323|3159323-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901292354
3158015|3158015-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.14|i86pc-solaris-64int|5.10.0|solaris|2.11|200901292237
3158013|3158013-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.35|i86pc-solaris-64int|5.10.0|solaris|2.11|200901292236
3157332|3157332-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.14||0|||200901291331
3157225|3157225-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-Data-Generator|0.35||0|||200901291422
3157165|3157165-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200901291813
3157068|3157068-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.8.9|freebsd|7.0-release|200901291813
3157067|3157067-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200901291813
3157065|3157065-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.8.8|freebsd|7.0-release|200901291813
3156634|3156634-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901290813
3156457|3156457-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291517
3156456|3156456-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291517
3155886|3155886-b19f-3f77-b713-d32bba55d77f|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901291500
3155641|3155641-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901291248
3155640|3155640-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901291247
3155292|3155292-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291035
3155287|3155287-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291035
3155284|3155284-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291034
3155123|3155123-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901290920
3155121|3155121-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901290919
3155103|3155103-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901290903
3155102|3155102-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901290902
3154588|3154588-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290615
3154585|3154585-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290615
3154564|3154564-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290613
3154560|3154560-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290612
3154337|3154337-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290917
3154231|3154231-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290853
3154223|3154223-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290850
3154143|3154143-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290835
3154061|3154061-b19f-3f77-b713-d32bba55d77f|pass|200901|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200901290920
3153432|3153432-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290536
3153302|3153302-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290503
3153291|3153291-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290500
3153290|3153290-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290500
3153252|3153252-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290444
3153246|3153246-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290440
3153245|3153245-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290440
3152009|3152009-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901290205
3151796|3151796-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290106
3150849|3150849-b19f-3f77-b713-d32bba55d77f|pass|200901|pjacklam@online.no|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200901282306
3150420|3150420-b19f-3f77-b713-d32bba55d77f|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-ld|5.10.0|linux|2.6.27-9-generic|200901281527
3149927|3149927-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281321
3149905|3149905-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281320
3149903|3149903-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281319
3149853|3149853-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281307
3149621|3149621-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200901281225
3147820|3147820-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901280657
3147801|3147801-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200901280649
3147799|3147799-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200901280649
3147767|3147767-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901280645
3145983|3145983-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901280218
3145637|3145637-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272244
3145632|3145632-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272243
3145627|3145627-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272242
3145359|3145359-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.10.0|freebsd|7.0-release|200901272326
3144281|3144281-b19f-3f77-b713-d32bba55d77f|pass|200901|alexchorny@gmail.com|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200901271302
3143884|3143884-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200901271511
3143881|3143881-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200901271511
3143633|3143633-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271510
3143632|3143632-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271509
3142220|3142220-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901271052
3142207|3142207-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901271051
3142205|3142205-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901271052
3142195|3142195-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271050
3141467|3141467-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200901270609
3141437|3141437-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200901270600
3141436|3141436-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200901270559
3140613|3140613-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901270307
3140527|3140527-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901270300
3139959|3139959-b19f-3f77-b713-d32bba55d77f|fail|200901|rhaen@cpan.org (Ulrich Habel)|Finance-Currency-Convert-XE|0.15|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901270218
3139897|3139897-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901270129
3139891|3139891-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901270129
3139856|3139856-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901270128
3139855|3139855-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901270128
3139252|3139252-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901270054
3139209|3139209-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901270048
3138283|3138283-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|Data-FormValidator-Constraints-Words|0.03|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901262210
3137683|3137683-b19f-3f77-b713-d32bba55d77f|fail|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901270421
3137224|3137224-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901261752
3137157|3137157-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901261741
3137128|3137128-b19f-3f77-b713-d32bba55d77f|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901261837
3137127|3137127-b19f-3f77-b713-d32bba55d77f|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.56|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901261837
3136547|3136547-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.58|i86pc-solaris-64int|5.10.0|solaris|2.11|200901261625
3136426|3136426-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.8.9|freebsd|7.0-release|200901261532
3136421|3136421-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.8.8|freebsd|7.0-release|200901261532
3135923|3135923-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901261232
3135462|3135462-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.46|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901261139
3135423|3135423-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.58||0|||200901261122
3135399|3135399-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901261015
3135398|3135398-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901261016
3135385|3135385-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261007
3135384|3135384-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261006
3135381|3135381-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261004
3135327|3135327-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901260927
3135325|3135325-b19f-3f77-b713-d32bba55d77f|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.56|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901260927
3134950|3134950-b19f-3f77-b713-d32bba55d77f|fail|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.10.0|freebsd|7.0-release|200901260840
3134694|3134694-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200901260703
3134690|3134690-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200901260702
3133334|3133334-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901260030
3133297|3133297-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901260014
3133209|3133209-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.8.9|freebsd|7.0-release|200901260008
3133111|3133111-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.8.8|freebsd|7.0-release|200901260008
3132914|3132914-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.56|amd64-freebsd|5.8.8|freebsd|7.0-release|200901252205
3132897|3132897-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.56|amd64-freebsd|5.8.9|freebsd|7.0-release|200901252205
3132861|3132861-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.57||0|||200901252159
3132344|3132344-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.56||0|||200901251837
3131987|3131987-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|alpha-netbsd|5.10.0|netbsd|4.0.1|200901251602
3131984|3131984-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|alpha-netbsd|5.10.0|netbsd|4.0.1|200901251601
3131323|3131323-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901251228
3131322|3131322-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901251228
3131070|3131070-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901251159
3131068|3131068-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901251159
3129244|3129244-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901250057
3129243|3129243-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901250057
3128280|3128280-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901242122
3128252|3128252-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901242116
3128236|3128236-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.46|amd64-freebsd|5.10.0|freebsd|7.0-release|200901242107
3127536|3127536-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241827
3127534|3127534-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241827
3126616|3126616-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901241528
3126615|3126615-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901241528
3126187|3126187-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241337
3126154|3126154-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241331
3125449|3125449-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|Games-Trackword|1.06|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240914
3125448|3125448-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|Calendar-List|0.21|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240914
3123991|3123991-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240111
3121008|3121008-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.46|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901231508
3121007|3121007-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.46|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901231508
3120829|3120829-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.44|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901231522
3120712|3120712-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901231353
3118892|3118892-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901230916
3118159|3118159-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230657
3117234|3117234-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230104
3117233|3117233-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230104
3117002|3117002-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901222200
3116913|3116913-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901222148
3116496|3116496-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901222131
3114867|3114867-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.46||0|||200901221456
3114825|3114825-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.45||0|||200901221439
3114541|3114541-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901221402
3114481|3114481-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901221145
3114300|3114300-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.34|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901221035
3114294|3114294-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.54|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901221034
3112230|3112230-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.10.0|freebsd|7.0-release|200901220037
3112126|3112126-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901212313
3112103|3112103-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901212307
3111416|3111416-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.44|amd64-freebsd|5.10.0|freebsd|7.0-release|200901212135
3111325|3111325-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.8.9|freebsd|7.0-release|200901212102
3110750|3110750-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.55|darwin-2level|5.10.0|darwin|9.2.0|200901211022
3110729|3110729-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.8.8|freebsd|7.0-release|200901211919
3110014|3110014-b19f-3f77-b713-d32bba55d77f|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901220011
3109560|3109560-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.18-4-686|200901211516
3109435|3109435-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.55|i86pc-solaris-64int|5.10.0|solaris|2.11|200901211512
3109191|3109191-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901210747
3108606|3108606-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|alpha-netbsd|5.10.0|netbsd|4.0.1|200901211035
3108310|3108310-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901210907
3108297|3108297-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901210905
3108292|3108292-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901210904
3108005|3108005-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901210805
3107989|3107989-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901210801
3107740|3107740-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901210647
3107649|3107649-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.13|darwin-2level|5.10.0|darwin|9.2.0|200901210624
3106271|3106271-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901210030
3106268|3106268-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901210030
3105793|3105793-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.55||0|||200901202218
3105536|3105536-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.10.0|freebsd|7.0-release|200901202122
3105101|3105101-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901201328
3104430|3104430-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.13|i86pc-solaris-64int|5.10.0|solaris|2.11|200901201737
3103215|3103215-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.44|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200628
3103212|3103212-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.44|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201227
3103206|3103206-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201227
3103179|3103179-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201219
3103174|3103174-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201219
3103090|3103090-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.44|i686-linux|5.10.0|linux|2.6.18-4-686|200901201308
3103032|3103032-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200901201202
3102994|3102994-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201155
3102818|3102818-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200520
3102817|3102817-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201119
3102815|3102815-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901201119
3102812|3102812-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201119
3102808|3102808-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201119
3102763|3102763-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200506
3102762|3102762-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201105
3102758|3102758-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901201105
3102664|3102664-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.13|i686-linux|5.10.0|linux|2.6.18-4-686|200901201141
3102555|3102555-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201009
3102550|3102550-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201008
3102529|3102529-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201004
3102442|3102442-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901200944
3100337|3100337-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|Test-YAML-Meta|0.11|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901200022
3099844|3099844-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901191822
3099356|3099356-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.8.9|freebsd|7.0-release|200901192252
3099354|3099354-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.8.8|freebsd|7.0-release|200901192252
3098688|3098688-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.13||0|||200901192108
3097789|3097789-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191838
3097710|3097710-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191833
3097621|3097621-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191827
3097561|3097561-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191820
3097549|3097549-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901191922
3097545|3097545-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901191921
3097468|3097468-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191814
3097406|3097406-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191807
3097326|3097326-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901191751
3097272|3097272-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200901191810
3097194|3097194-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901191839
3096998|3096998-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901191817
3096967|3096967-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200901191810
3096412|3096412-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200901191637
3095709|3095709-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200901191507
3095461|3095461-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901190809
3095281|3095281-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.44||0|||200901191324
3095212|3095212-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.12||0|||200901191313
3094905|3094905-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.43|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901191224
3094834|3094834-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200901191107
3094832|3094832-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901191107
3094825|3094825-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|alpha-netbsd|5.10.0|netbsd|4.0.1|200901191106
3094791|3094791-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901190459
3094529|3094529-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|Mail-Outlook|0.14|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901191001
3094287|3094287-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901190859
3094282|3094282-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901190859
3094279|3094279-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901190859
3094277|3094277-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901190859
3094276|3094276-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901190859
3094055|3094055-b19f-3f77-b713-d32bba55d77f|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901191618
3093856|3093856-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200901190829
3093854|3093854-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200901190829
3093794|3093794-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901190719
3093793|3093793-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901190719
3092512|3092512-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.8.9|mirbsd|10|200901182356
3091968|3091968-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.11||0|||200901182252
3091952|3091952-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-Data-Generator|0.34|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901181647
3091946|3091946-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901181646
3090779|3090779-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200901181857
3090767|3090767-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200901181855
3090754|3090754-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200901181852
3090542|3090542-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200901181824
3089291|3089291-b19f-3f77-b713-d32bba55d77f|fail|200901|vrurg@otoib.dp.ua|Finance-Currency-Convert-XE|0.15|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200901161558
3089176|3089176-b19f-3f77-b713-d32bba55d77f|pass|200901|nothingmuch@woobling.org|CPAN-WWW-Testers|0.43|darwin-2level|5.10.0|darwin|9.5.0|200901172112
3088656|3088656-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.18-4-686|200901181423
3088644|3088644-b19f-3f77-b713-d32bba55d77f|fail|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200901181420
3088610|3088610-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200901181416
3088598|3088598-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.18-4-686|200901181413
3087765|3087765-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901180958
3083718|3083718-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200901171827
3080417|3080417-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.8.8|mirbsd|10|200901170117
3079417|3079417-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200901162015
3076616|3076616-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901160836
3074438|3074438-b19f-3f77-b713-d32bba55d77f|fail|200901|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901160600
3072714|3072714-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.43|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901150921
3072052|3072052-b19f-3f77-b713-d32bba55d77f|pass|200901|sartak@gmail.com|Test-YAML-Meta|0.11|darwin-2level|5.8.8|darwin|9.5.0|200901141112
3071547|3071547-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901150807
3071483|3071483-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901150741
3069852|3069852-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.43|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901150043
3069155|3069155-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901142144
3069112|3069112-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901141303
3068593|3068593-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.43|amd64-freebsd|5.10.0|freebsd|7.0-release|200901142008
3068541|3068541-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901141955
3067194|3067194-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901140813
3067063|3067063-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901141311
3067002|3067002-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|i686-linux|5.8.8|linux|2.4.27-3-686|200901141253
3066688|3066688-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901141136
3066502|3066502-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.54|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200901141222
3066501|3066501-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200901141222
3064369|3064369-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901140020
3064315|3064315-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901140007
3063820|3063820-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.43||0|||200901132314
3061634|3061634-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901131428
3061485|3061485-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200901131117
3061455|3061455-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901131404
3061296|3061296-b19f-3f77-b713-d32bba55d77f|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901132141
3060302|3060302-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901131057
3060061|3060061-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|i686-linux|5.8.8|linux|2.4.27-3-686|200901130959
3060051|3060051-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901130957
3057036|3057036-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901130041
3056785|3056785-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901122356
3056591|3056591-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.54|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901130118
3056556|3056556-b19f-3f77-b713-d32bba55d77f|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901130110
3056486|3056486-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.34|i86pc-solaris-64int|5.10.0|solaris|2.11|200901130019
3056482|3056482-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.54|i86pc-solaris-64int|5.10.0|solaris|2.11|200901130019
3055683|3055683-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122053
3055678|3055678-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122053
3055603|3055603-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122044
3055593|3055593-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122044
3055586|3055586-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122043
3055572|3055572-b19f-3f77-b713-d32bba55d77f|fail|200901|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122041
3055184|3055184-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901122057
3055157|3055157-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901122056
3054740|3054740-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901122013
3054109|3054109-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901121754
3053826|3053826-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901121717
3053530|3053530-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.10.0|freebsd|7.0-release|200901121724
3053529|3053529-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.10.0|freebsd|7.0-release|200901121724
3053474|3053474-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121613
3052765|3052765-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.8.9|freebsd|7.0-release|200901121515
3052764|3052764-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.8.9|freebsd|7.0-release|200901121515
3052676|3052676-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.8.8|freebsd|7.0-release|200901121458
3052675|3052675-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.8.8|freebsd|7.0-release|200901121458
3052585|3052585-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121336
3052403|3052403-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.42|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901121355
3052324|3052324-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.54||0|||200901121338
3052213|3052213-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-Testers-Data-Generator|0.34||0|||200901121310
3051861|3051861-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121024
3050831|3050831-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120708
3049557|3049557-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120241
3049536|3049536-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120227
3048751|3048751-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200901120112
3048746|3048746-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901120111
3048558|3048558-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901112336
3048441|3048441-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112312
3048439|3048439-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048438|3048438-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048436|3048436-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048434|3048434-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112310
3048419|3048419-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112306
3048141|3048141-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112155
3048132|3048132-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112154
3047350|3047350-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901111947
3046764|3046764-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111246
3046760|3046760-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111246
3046740|3046740-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Mail-File|0.08|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111242
3046582|3046582-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111210
3046581|3046581-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111209
3046184|3046184-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901111641
3046183|3046183-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901111640
3044186|3044186-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901110105
3043869|3043869-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901110329
3043867|3043867-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901110329
3043456|3043456-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200901110009
3043328|3043328-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200901102344
3043223|3043223-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i686-linux|5.8.8|linux|2.4.27-3-686|200901102326
3043218|3043218-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901101727
3043216|3043216-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901102327
3043214|3043214-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|IP35-irix|5.8.8|irix|6.5|200901110027
3041170|3041170-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901101516
3039409|3039409-b19f-3f77-b713-d32bba55d77f|pass|200901|nothingmuch@woobling.org|CPAN-Testers-Common-DBUtils|0.03|darwin-2level|5.10.0|darwin|9.5.0|200901100653
3039279|3039279-b19f-3f77-b713-d32bba55d77f|pass|200901|nothingmuch@woobling.org|CPAN-WWW-Testers|0.42|darwin-2level|5.10.0|darwin|9.5.0|200901100655
3036271|3036271-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.42|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901100032
3036265|3036265-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.41|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901100031
3036037|3036037-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.42|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901100047
3035215|3035215-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901092059
3034843|3034843-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.42|amd64-freebsd|5.10.0|freebsd|7.0-release|200901092147
3034228|3034228-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901091939
3034224|3034224-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901091938
3032625|3032625-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901091552
3032431|3032431-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.42||0|||200901091513
3031482|3031482-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901090847
3031481|3031481-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901090847
3031239|3031239-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901090309
3030035|3030035-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Data-FormValidator-Constraints-Words|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901090039
3029345|3029345-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901090424
3028567|3028567-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901090056
3028344|3028344-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901090028
3027881|3027881-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901082327
3027375|3027375-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901082257
3026466|3026466-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|i686-linux|5.8.8|linux|2.4.27-3-686|200901081928
3025994|3025994-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Games-Trackword|1.06|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901081229
3025992|3025992-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Calendar-List|0.21|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901081229
3025648|3025648-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers|0.41|i86pc-solaris-64int|5.10.0|solaris|2.11|200901081745
3025030|3025030-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901080847
3024969|3024969-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.41|i686-linux|5.10.0|linux|2.6.18-4-686|200901081408
3024800|3024800-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.41|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901081308
3024678|3024678-b19f-3f77-b713-d32bba55d77f|pass|200901|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers|0.41|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901081929
3024207|3024207-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901080419
3023770|3023770-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901080733
3023768|3023768-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901080733
3023762|3023762-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901080731
3023761|3023761-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901080730
3022226|3022226-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901080133
3021967|3021967-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.8.9|freebsd|7.0-release|200901080049
3021963|3021963-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.8.8|freebsd|7.0-release|200901080049
3021922|3021922-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.10.0|freebsd|7.0-release|200901080044
3021277|3021277-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.26.3-29.fc9.i686|200901072221
3021245|3021245-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.26.3-29.fc9.i686|200901072214
3021074|3021074-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.41||0|||200901072251
3020365|3020365-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901072005
3017356|3017356-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070607
3017208|3017208-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070531
3017206|3017206-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070531
3016304|3016304-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901070852
3015833|3015833-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901070742
3015335|3015335-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901070452
3015333|3015333-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901070451
3013964|3013964-b19f-3f77-b713-d32bba55d77f|pass|200901|amoore@cpan.org|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.26-1-vserver-amd64|200901061008
3013566|3013566-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Mail-Outlook|0.14|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061752
3013549|3013549-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061748
3013520|3013520-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901062244
3013518|3013518-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901062243
3013455|3013455-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901062234
3012503|3012503-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061533
3012502|3012502-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061533
3011998|3011998-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers-Generator|0.30|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061441
3010831|3010831-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061258
3010830|3010830-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.s1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061257
3010752|3010752-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061247
3010751|3010751-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061247
3010213|3010213-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901061652
3009249|3009249-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901061508
3008773|3008773-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901061419
3007965|3007965-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.s2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901060731
3007927|3007927-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.s1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901060724
3007333|3007333-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.40|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901061159
3007306|3007306-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901061152
3006476|3006476-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901060830
3006475|3006475-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901060829
3006161|3006161-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901060729
3006158|3006158-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901060729
3006030|3006030-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060709
3006028|3006028-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060709
3005832|3005832-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060635
3005830|3005830-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060634
3003872|3003872-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901060213
3003818|3003818-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901060302
3003229|3003229-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060103
3002998|3002998-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060036
3002477|3002477-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901052348
3002307|3002307-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901052342
3001676|3001676-b19f-3f77-b713-d32bba55d77f|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901052349
3000184|3000184-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051929
3000181|3000181-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051929
2998257|2998257-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901050944
2998256|2998256-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901050944
2997269|2997269-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051203
2995860|2995860-b19f-3f77-b713-d32bba55d77f|pass|200901|vutral@gmail.com|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.26-1-vserver-amd64|200901042304
2995350|2995350-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050311
2995349|2995349-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050311
2995223|2995223-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901050233
2995222|2995222-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Data-Phrasebook|0.29|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901050233
2994663|2994663-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.40|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901050039
2994651|2994651-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.39|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901050037
2994621|2994621-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050031
2994413|2994413-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901042351
2994379|2994379-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901042347
2994362|2994362-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901041741
2994357|2994357-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901041740
2994221|2994221-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901042316
2993878|2993878-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.33|i86pc-solaris-64int|5.10.0|solaris|2.11|200901042341
2993691|2993691-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|IP35-irix-64int|5.8.8|irix|6.5|200901042254
2993680|2993680-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|IP35-irix-64int|5.8.8|irix|6.5|200901042252
2993675|2993675-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.40|i686-linux|5.8.8|linux|2.4.27-3-686|200901042150
2993481|2993481-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.39|i686-linux|5.8.8|linux|2.4.27-3-686|200901042131
2993437|2993437-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901041626
2993323|2993323-b19f-3f77-b713-d32bba55d77f|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers|0.40|i86pc-solaris-64int|5.10.0|solaris|2.11|200901042234
2993162|2993162-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901041603
2993111|2993111-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|i686-linux|5.8.8|linux|2.4.27-3-686|200901042100
2993077|2993077-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901041558
2993062|2993062-b19f-3f77-b713-d32bba55d77f|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.8|linux|2.4.27-3-686|200901042057
2991475|2991475-b19f-3f77-b713-d32bba55d77f|fail|200901|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-ld|5.11.0 patch 34814|linux|2.6.18-8.1.14.el5|200901041832
2991460|2991460-b19f-3f77-b713-d32bba55d77f|pass|200901|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-ld|5.11.0 patch 34814|linux|2.6.18-8.1.14.el5|200901041830
2989637|2989637-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901041530
2989635|2989635-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901041530
2988314|2988314-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901040912
2986882|2986882-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-WWW-Testers|0.40|darwin-2level|5.10.0|darwin|9.2.0|200901040031
2986704|2986704-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901032335
2986701|2986701-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901032335
2986563|2986563-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901032310
2986559|2986559-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901032309
2984710|2984710-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901031329
2984650|2984650-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901031319
2984643|2984643-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901031318
2984608|2984608-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901031313
2984080|2984080-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031524
2984078|2984078-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031524
2983710|2983710-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901030843
2982966|2982966-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901031149
2982873|2982873-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031122
2981194|2981194-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020117
2981114|2981114-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901030148
2981086|2981086-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901030143
2980827|2980827-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC1|linux|2.6.24-19-generic|200901030116
2980722|2980722-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901021030
2980617|2980617-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|darwin-2level|5.10.0|darwin|9.2.0|200901030050
2980608|2980608-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901030032
2980412|2980412-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901021030
2980369|2980369-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020117
2980094|2980094-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901030006
2979957|2979957-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021832
2979956|2979956-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021831
2979486|2979486-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200901022053
2979455|2979455-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901022046
2979453|2979453-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901022045
2979177|2979177-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18.8|200901021459
2979175|2979175-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18.8|200901021459
2978757|2978757-b19f-3f77-b713-d32bba55d77f|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18.8|200901021413
2978618|2978618-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021900
2978615|2978615-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021900
2977436|2977436-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901021133
2977433|2977433-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901021132
2977401|2977401-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021128
2977381|2977381-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021126
2976844|2976844-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021029
2976839|2976839-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021029
2976598|2976598-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901021440
2976559|2976559-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200901021432
2976393|2976393-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021351
2976207|2976207-b19f-3f77-b713-d32bba55d77f|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.40|i686-linux|5.10.0|linux|2.6.18-4-686|200901021403
2975964|2975964-b19f-3f77-b713-d32bba55d77f|pass|200901|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers|0.40|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901021918
2975765|2975765-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020240
2975759|2975759-b19f-3f77-b713-d32bba55d77f|pass|200901|rhaen@cpan.org (Ulrich Habel)|CPAN-WWW-Testers|0.40|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901021006
2975632|2975632-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.8.9|freebsd|7.0-release|200901020836
2975507|2975507-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.8.8|freebsd|7.0-release|200901020836
2974898|2974898-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020212
2974754|2974754-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.40|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020036
2974607|2974607-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901011730
2974516|2974516-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020241
2974399|2974399-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020045
2974286|2974286-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.39|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020025
2974135|2974135-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901011730
2974090|2974090-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901011500
2974057|2974057-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011733
2973903|2973903-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020212
2973859|2973859-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020142
2973768|2973768-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901020056
2973626|2973626-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020022
2973610|2973610-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.37|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020017
2973579|2973579-b19f-3f77-b713-d32bba55d77f|pass|200901|davidrw@cpan.org|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020012
2973465|2973465-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC1|linux|2.6.24-19-generic|200901011842
2973332|2973332-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011745
2973303|2973303-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011733
2973046|2973046-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011411
2972624|2972624-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200901020050
2972299|2972299-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200901012342
2972154|2972154-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010228
2972024|2972024-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901012345
2971872|2971872-b19f-3f77-b713-d32bba55d77f|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.10.0|freebsd|7.0-release|200901012301
2971793|2971793-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010421
2971676|2971676-b19f-3f77-b713-d32bba55d77f|cpan|200901|BARBIE|CPAN-WWW-Testers|0.40||0|||200901012155
2971370|2971370-b19f-3f77-b713-d32bba55d77f|pass|200812|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311752
2971253|2971253-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901012012
2970603|2970603-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010010
2970572|2970572-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010350
2970387|2970387-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010138
2970266|2970266-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@herlpacker.co.uk|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200901011620
2970244|2970244-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010228
2970229|2970229-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010220
2970228|2970228-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010220
2970006|2970006-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010010
2969991|2969991-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010006
2969977|2969977-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010001
2969883|2969883-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010421
2969791|2969791-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010348
2969610|2969610-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010237
2969405|2969405-b19f-3f77-b713-d32bba55d77f|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010105
2969353|2969353-b19f-3f77-b713-d32bba55d77f|pass|200812|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311752
2969173|2969173-b19f-3f77-b713-d32bba55d77f|pass|200812|cpanblead@example.com ((cpanblead))|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311538
2968744|2968744-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.33|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901011542
2966905|2966905-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010735
2966904|2966904-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010735
2966873|2966873-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010727
2966872|2966872-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010726
2965720|2965720-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010222
2965711|2965711-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010220
2965403|2965403-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901010227
2965397|2965397-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901010226
2965152|2965152-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010037
2965151|2965151-b19f-3f77-b713-d32bba55d77f|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010037
2964991|2964991-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200901010106
2964988|2964988-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200901010106
2964901|2964901-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901010044
2964894|2964894-b19f-3f77-b713-d32bba55d77f|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901010043
2964830|2964830-b19f-3f77-b713-d32bba55d77f|pass|200812|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311140
2962836|2962836-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812311618
2962835|2962835-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812311618
2962485|2962485-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.10.0|freebsd|7.0-release|200812311342
2962484|2962484-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.10.0|freebsd|7.0-release|200812311342
2962257|2962257-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812311141
2962226|2962226-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812311127
2962225|2962225-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812311127
2962224|2962224-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812311125
2961998|2961998-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812310725
2961996|2961996-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812310725
2961992|2961992-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812310722
2961991|2961991-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812310722
2961960|2961960-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812310654
2961959|2961959-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812310653
2961937|2961937-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812310651
2961936|2961936-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812310650
2961375|2961375-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812310336
2961288|2961288-b19f-3f77-b713-d32bba55d77f|pass|200812|davidrw@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200812301413
2961120|2961120-b19f-3f77-b713-d32bba55d77f|pass|200812|davidrw@cpan.org|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200812301537
2959270|2959270-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812301425
2958555|2958555-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Data-Generator|0.33|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812301113
2957248|2957248-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300632
2957162|2957162-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812300558
2956435|2956435-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300221
2956434|2956434-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300220
2956320|2956320-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812300147
2956318|2956318-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812300146
2955596|2955596-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812292255
2955545|2955545-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.10.0|freebsd|7.0-release|200812292156
2955276|2955276-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.8.9|freebsd|7.0-release|200812292137
2955070|2955070-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.8.8|freebsd|7.0-release|200812292041
2954945|2954945-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.33||0|||200812292011
2954898|2954898-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812291948
2954895|2954895-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812291947
2953095|2953095-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-WWW-Testers|0.39|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812291159
2953071|2953071-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812291153
2952894|2952894-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.39|i686-linux|5.10.0|linux|2.6.18-4-686|200812291111
2952691|2952691-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.8.9|freebsd|7.0-release|200812291001
2952690|2952690-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.8.8|freebsd|7.0-release|200812291000
2952186|2952186-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290717
2951803|2951803-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812290447
2951567|2951567-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290233
2951565|2951565-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290232
2951543|2951543-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290219
2951542|2951542-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290219
2951541|2951541-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290217
2951539|2951539-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951538|2951538-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951537|2951537-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951536|2951536-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951535|2951535-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951534|2951534-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951533|2951533-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951532|2951532-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951531|2951531-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951530|2951530-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951529|2951529-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951527|2951527-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951524|2951524-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290213
2951522|2951522-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290211
2951098|2951098-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.10.0|freebsd|7.0-release|200812290003
2950893|2950893-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-WWW-Testers|0.39||0|||200812282251
2950588|2950588-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812282131
2948887|2948887-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812281359
2946292|2946292-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812281359
2946253|2946253-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812281353
2945386|2945386-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812280434
2945298|2945298-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200812280325
2943675|2943675-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812280009
2942633|2942633-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812271951
2941799|2941799-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200812271557
2941747|2941747-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200812271547
2941430|2941430-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200812271545
2941402|2941402-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200812271541
2941195|2941195-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812271506
2941194|2941194-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812271506
2938630|2938630-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812262244
2938606|2938606-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812262237
2938358|2938358-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200812262045
2936769|2936769-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.18-4-686|200812261634
2936032|2936032-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200812261147
2935787|2935787-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812261050
2935751|2935751-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812261043
2935671|2935671-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812261034
2935235|2935235-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812261011
2935195|2935195-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812261004
2935170|2935170-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812261001
2935156|2935156-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812260958
2934745|2934745-b19f-3f77-b713-d32bba55d77f|pass|200812|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200812260018
2934099|2934099-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200812252335
2933310|2933310-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200812251642
2932930|2932930-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200812251252
2932449|2932449-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200812251116
2932298|2932298-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200812251051
2927850|2927850-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200812241513
2927823|2927823-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200812241509
2927781|2927781-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200812241459
2927342|2927342-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200812241303
2926513|2926513-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812240457
2926459|2926459-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200812240912
2919650|2919650-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200812231550
2919643|2919643-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812231551
2918307|2918307-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812231252
2913677|2913677-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913676|2913676-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913675|2913675-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913674|2913674-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913618|2913618-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230011
2911545|2911545-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200812221827
2911541|2911541-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200812221826
2911506|2911506-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200812221818
2911502|2911502-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200812221818
2909190|2909190-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.32|i86pc-solaris-64int|5.10.0|solaris|2.11|200812221147
2909183|2909183-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812221028
2908483|2908483-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200812220831
2908479|2908479-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200812220831
2908354|2908354-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200812220814
2908347|2908347-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200812220813
2905973|2905973-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812220153
2905470|2905470-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812220030
2905000|2905000-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812212321
2904998|2904998-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812212321
2904269|2904269-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211649
2903811|2903811-b19f-3f77-b713-d32bba55d77f|pass|200812|rafl@debian.org|Test-CPAN-Meta|0.12|i686-linux-multi|5.10.0|linux|2.6.24-rc5|200812212108
2902906|2902906-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211152
2902904|2902904-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211152
2901880|2901880-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210932
2901088|2901088-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812211227
2900304|2900304-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812211059
2900299|2900299-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812211059
2899912|2899912-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812211031
2899909|2899909-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812211030
2899463|2899463-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210448
2898276|2898276-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210148
2897855|2897855-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210055
2897854|2897854-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210054
2897806|2897806-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210042
2896094|2896094-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210017
2896092|2896092-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210017
2895952|2895952-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210003
2895467|2895467-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812202254
2895465|2895465-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook|0.29|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812202254
2895353|2895353-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812201741
2892496|2892496-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892494|2892494-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892492|2892492-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892447|2892447-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Regexp-Log-Common|0.05|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812201703
2891823|2891823-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812201045
2891436|2891436-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201502
2891435|2891435-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201501
2891434|2891434-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201501
2891368|2891368-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2891359|2891359-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2891355|2891355-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2890852|2890852-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.32|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200916
2890849|2890849-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200916
2890325|2890325-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202129
2890313|2890313-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202127
2890278|2890278-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812201318
2890259|2890259-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202114
2890257|2890257-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202114
2890254|2890254-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Mail-Outlook|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890253|2890253-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890251|2890251-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890248|2890248-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202112
2890242|2890242-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202110
2890236|2890236-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-XML|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202109
2890233|2890233-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202109
2890232|2890232-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202108
2890218|2890218-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890215|2890215-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890213|2890213-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890196|2890196-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202102
2890181|2890181-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202058
2890160|2890160-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202054
2890104|2890104-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202042
2890100|2890100-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202038
2889794|2889794-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.32|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200608
2889579|2889579-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812201018
2889022|2889022-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812200937
2887993|2887993-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812201256
2886056|2886056-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.10.0|freebsd|7.0-release|200812200201
2885838|2885838-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200812200149
2885670|2885670-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812200131
2885454|2885454-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812200114
2885379|2885379-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200007
2885376|2885376-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200007
2885369|2885369-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200006
2884956|2884956-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812192332
2884481|2884481-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812191646
2884183|2884183-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|IP35-irix-64int|5.8.8|irix|6.5|200812192308
2884165|2884165-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812192205
2884162|2884162-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|i686-linux|5.8.8|linux|2.4.27-3-686|200812192204
2881586|2881586-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.8.8|freebsd|7.0-release|200812191729
2881337|2881337-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191652
2881335|2881335-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191651
2881330|2881330-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191651
2881328|2881328-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812191552
2881205|2881205-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.8.9|freebsd|7.0-release|200812191729
2879925|2879925-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.31|i86pc-solaris-64int|5.10.0|solaris|2.11|200812191511
2879730|2879730-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191330
2879719|2879719-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191328
2879706|2879706-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191327
2879469|2879469-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Data-Generator|0.31|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191245
2879464|2879464-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.32||0|||200812191344
2878914|2878914-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812191249
2878705|2878705-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.10.0|freebsd|7.0-release|200812191223
2878457|2878457-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878454|2878454-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878450|2878450-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878212|2878212-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.31|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812190538
2878112|2878112-b19f-3f77-b713-d32bba55d77f|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812191023
2877243|2877243-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.10.0|freebsd|7.0-release|200812190924
2874863|2874863-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812190344
2874278|2874278-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200812190234
2874234|2874234-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812190228
2873909|2873909-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190057
2873904|2873904-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190057
2873894|2873894-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190056
2873851|2873851-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200812190152
2873698|2873698-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812190138
2873668|2873668-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812190136
2873441|2873441-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200812190120
2872995|2872995-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.8.9|freebsd|7.0-release|200812190041
2872986|2872986-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.8.8|freebsd|7.0-release|200812190041
2872306|2872306-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812182346
2872109|2872109-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872107|2872107-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872105|2872105-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872089|2872089-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181726
2872083|2872083-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812182323
2871972|2871972-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181715
2871850|2871850-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812182302
2871834|2871834-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812182300
2871393|2871393-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812182223
2870200|2870200-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.31||0|||200812182043
2867312|2867312-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181350
2867300|2867300-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181348
2867242|2867242-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181342
2867238|2867238-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181341
2867232|2867232-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181341
2866979|2866979-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181306
2866968|2866968-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181305
2866930|2866930-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181301
2866925|2866925-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181300
2866922|2866922-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181300
2866799|2866799-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200812181400
2866797|2866797-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-64int|5.10.0|solaris|2.11|200812181400
2865954|2865954-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180553
2865937|2865937-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180550
2865792|2865792-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180951
2865788|2865788-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180950
2865785|2865785-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180950
2864818|2864818-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.10.0|freebsd|7.0-release|200812180958
2864684|2864684-b19f-3f77-b713-d32bba55d77f|fail|200812|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180339
2864383|2864383-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180300
2862884|2862884-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180355
2862879|2862879-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180354
2862208|2862208-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180221
2862187|2862187-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180217
2862184|2862184-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180217
2861137|2861137-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180001
2861132|2861132-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180001
2861131|2861131-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180000
2860312|2860312-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200812172300
2860309|2860309-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18-4-686|200812172300
2860244|2860244-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171651
2859850|2859850-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812172101
2859845|2859845-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812172100
2859842|2859842-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812172059
2859233|2859233-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812172030
2859210|2859210-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171429
2858943|2858943-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171350
2858942|2858942-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171350
2858873|2858873-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171342
2858473|2858473-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.52|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171250
2858223|2858223-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812171715
2857017|2857017-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200812171540
2856967|2856967-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812171613
2856669|2856669-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812171540
2856665|2856665-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812171540
2856660|2856660-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.8.8|freebsd|7.0-release|200812171540
2856403|2856403-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812171510
2856157|2856157-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812171351
2856101|2856101-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812171342
2855779|2855779-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|IP35-irix-64int|5.8.8|irix|6.5|200812171428
2855440|2855440-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.10||0|||200812171408
2855403|2855403-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.09||0|||200812171406
2855159|2855159-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812171214
2855156|2855156-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.10.0|freebsd|7.0-release|200812171332
2855154|2855154-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812171213
2855026|2855026-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200812171423
2854900|2854900-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.03||0|||200812171309
2854304|2854304-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.02|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812171223
2854053|2854053-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812170324
2854051|2854051-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux|5.8.8|linux|2.4.27-3-686|200812170924
2854050|2854050-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812170924
2853818|2853818-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812170249
2853645|2853645-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812170835
2853613|2853613-b19f-3f77-b713-d32bba55d77f|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|i686-linux|5.8.8|linux|2.4.27-3-686|200812170831
2853582|2853582-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170330
2853581|2853581-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170330
2853394|2853394-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170312
2853363|2853363-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200812170907
2852671|2852671-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170153
2852658|2852658-b19f-3f77-b713-d32bba55d77f|fail|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170151
2852655|2852655-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170152
2851083|2851083-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200812170512
2850688|2850688-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200812170432
2850308|2850308-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200812170358
2849016|2849016-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812170211
2848854|2848854-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170101
2848424|2848424-b19f-3f77-b713-d32bba55d77f|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.02|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170030
2846571|2846571-b19f-3f77-b713-d32bba55d77f|pass|200812|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200812161640
2846108|2846108-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.18-4-686|200812162144
2846084|2846084-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.18-4-686|200812162141
2843738|2843738-b19f-3f77-b713-d32bba55d77f|pass|200812|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200812161724
2843736|2843736-b19f-3f77-b713-d32bba55d77f|pass|200812|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200812161724
2843566|2843566-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812161610
2843563|2843563-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812161610
2843258|2843258-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812161544
2843256|2843256-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812161544
2842371|2842371-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200812161449
2842037|2842037-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812161305
2841901|2841901-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812161118
2841896|2841896-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812161118
2841693|2841693-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812161155
2841673|2841673-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-Common-DBUtils|0.01|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161146
2841595|2841595-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-WWW-Reports-Mailer|0.08|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161131
2841590|2841590-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-Common-DBUtils|0.02|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161131
2841553|2841553-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812161122
2841513|2841513-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812161113
2841207|2841207-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812161027
2841172|2841172-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812161019
2841097|2841097-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812161010
2841087|2841087-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812161007
2840319|2840319-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200812161452
2840308|2840308-b19f-3f77-b713-d32bba55d77f|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200812161448
2839655|2839655-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812160217
2839654|2839654-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812160215
2839443|2839443-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812160051
2839442|2839442-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812160049
2839437|2839437-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812160048
2838554|2838554-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.10.0|freebsd|7.0-release|200812152146
2838155|2838155-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812152157
2837967|2837967-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.02|i686-linux|5.10.0|linux|2.6.18-4-686|200812152145
2837217|2837217-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200812151821
2837216|2837216-b19f-3f77-b713-d32bba55d77f|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.08|i86pc-solaris-64int|5.10.0|solaris|2.11|200812151821
2837147|2837147-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200812151748
2837140|2837140-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200812151748
2836863|2836863-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.02||0|||200812151614
2836606|2836606-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812151319
2836496|2836496-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200812151329
2836495|2836495-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812151229
2836494|2836494-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.01|i686-linux|5.10.0|linux|2.6.18-4-686|200812151329
2836377|2836377-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812151240
2836146|2836146-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812151108
2836032|2836032-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812151042
2836013|2836013-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812151036
2835938|2835938-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812151011
2835916|2835916-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812151004
2835857|2835857-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812150952
2835826|2835826-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.08|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812150943
2835825|2835825-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812150943
2832589|2832589-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812141851
2832580|2832580-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812141849
2832572|2832572-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812141848
2832388|2832388-b19f-3f77-b713-d32bba55d77f|pass|200812|vovkasm@gmail.com|Regexp-Log-Common|0.05|amd64-freebsd|5.10.0|freebsd|6.2-release-p1|200812141326
2831988|2831988-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812141806
2831987|2831987-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812141806
2831366|2831366-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812141648
2831363|2831363-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812141648
2831177|2831177-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.10.0|freebsd|7.0-release|200812141618
2831176|2831176-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.10.0|freebsd|7.0-release|200812141618
2829541|2829541-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200812141258
2829540|2829540-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200812141258
2829497|2829497-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.08||0|||200812141249
2829106|2829106-b19f-3f77-b713-d32bba55d77f|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.01||0|||200812141127
2828164|2828164-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812140650
2828162|2828162-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812140650
2828010|2828010-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.18-4-686|200812140557
2827999|2827999-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200812140554
2825793|2825793-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200812131729
2824171|2824171-b19f-3f77-b713-d32bba55d77f|fail|200812|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200812131225
2822681|2822681-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812131010
2822680|2822680-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812131010
2805145|2805145-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812102100
2804552|2804552-b19f-3f77-b713-d32bba55d77f|fail|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812102258
2804544|2804544-b19f-3f77-b713-d32bba55d77f|fail|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812102258
2799747|2799747-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200812101330
2796635|2796635-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|GD-Chart-Radial|0.07|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100417
2796244|2796244-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812100337
2796242|2796242-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812100337
2795808|2795808-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Mail-File|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100100
2795752|2795752-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100052
2795721|2795721-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200812100047
2795499|2795499-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100023
2795095|2795095-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2795033|2795033-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2794880|2794880-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Mail-File|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2794877|2794877-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812100037
2794785|2794785-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812092332
2794430|2794430-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812092332
2794150|2794150-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2794025|2794025-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793798|2793798-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793649|2793649-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2793637|2793637-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793595|2793595-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812092202
2793586|2793586-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812092201
2789880|2789880-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|GD-Chart-Radial|0.07|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091151
2789708|2789708-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091129
2789321|2789321-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091306
2789234|2789234-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091108
2788759|2788759-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091330
2787823|2787823-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2787793|2787793-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Mail-Outlook|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091214
2787141|2787141-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091123
2786702|2786702-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2786701|2786701-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2786546|2786546-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091330
2786259|2786259-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091311
2785237|2785237-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091250
2785191|2785191-b19f-3f77-b713-d32bba55d77f|pass|200812|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200812091151
2784959|2784959-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Parse-CPAN-Distributions|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091236
2784291|2784291-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091127
2783609|2783609-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091151
2783565|2783565-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091148
2783234|2783234-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091129
2782987|2782987-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091123
2779535|2779535-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200812082233
2779426|2779426-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200812082250
2778891|2778891-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812082312
2778482|2778482-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Test-CPAN-Meta|0.12|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812082043
2777263|2777263-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081700
2777032|2777032-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081700
2777004|2777004-b19f-3f77-b713-d32bba55d77f|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812081322
2776696|2776696-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812081729
2776276|2776276-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081527
2776266|2776266-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081527
2774551|2774551-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812081020
2774550|2774550-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812081020
2774138|2774138-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200812080846
2771648|2771648-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Mail-Outlook|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072336
2770687|2770687-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072153
2770542|2770542-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072153
2770494|2770494-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072152
2770439|2770439-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072046
2770408|2770408-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812072142
2768217|2768217-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200812071740
2767804|2767804-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Data-Phrasebook-Loader-YAML|0.09|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812071541
2767802|2767802-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Data-Phrasebook|0.29|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812071540
2767220|2767220-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812071210
2767044|2767044-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071009
2766732|2766732-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071008
2766165|2766165-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071006
2766020|2766020-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071006
2765771|2765771-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071009
2765548|2765548-b19f-3f77-b713-d32bba55d77f|pass|200812|srezic@cpan.org|Parse-CPAN-Distributions|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071008
2764264|2764264-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Regexp-Log-Common|0.05|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812070838
2758574|2758574-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812061323
2756980|2756980-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200812060801
2756883|2756883-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Parse-CPAN-Distributions|0.05|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060629
2756854|2756854-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060616
2756845|2756845-b19f-3f77-b713-d32bba55d77f|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|WWW-Scraper-ISBN-Amazon_Driver|0.14|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060613
2755452|2755452-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812052256
2755450|2755450-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812052256
2754807|2754807-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812052004
2747847|2747847-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812042250
2747844|2747844-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812042249
2747707|2747707-b19f-3f77-b713-d32bba55d77f|pass|200812|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812042333
2746594|2746594-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812041910
2746593|2746593-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812041910
2743353|2743353-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812040922
2741657|2741657-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200812032216
2736326|2736326-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200812030632
2736325|2736325-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.18-4-686|200812030632
2727784|2727784-b19f-3f77-b713-d32bba55d77f|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.10.0|linux|2.6.18-4-686|200812011925
2723646|2723646-b19f-3f77-b713-d32bba55d77f|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812010017
2719703|2719703-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811301527
2717789|2717789-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200811300911
2713941|2713941-b19f-3f77-b713-d32bba55d77f|pass|200811|sjn@pvv.org ("Salve J. Nilsen")|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.25|200811281705
2708214|2708214-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200811290019
2708013|2708013-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200811290018
2706461|2706461-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.9|freebsd|7.0-release|200811282003
2706347|2706347-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200811282003
2705964|2705964-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705798|2705798-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705691|2705691-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705047|2705047-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200811281639
2704447|2704447-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281437
2703779|2703779-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811281327
2699696|2699696-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.9|freebsd|7.0-release|200811280030
2699688|2699688-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200811280030
2699392|2699392-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200811272323
2699375|2699375-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200811272323
2698458|2698458-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18-4-686|200811272109
2698453|2698453-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18-4-686|200811272108
2696139|2696139-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200811271357
2691706|2691706-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200811261441
2691680|2691680-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200811261432
2691670|2691670-b19f-3f77-b713-d32bba55d77f|pass|200811|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200811261429
2687479|2687479-b19f-3f77-b713-d32bba55d77f|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.8|linux|2.4.27-2-386|200811260015
2679016|2679016-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200811240653
2679012|2679012-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200811240648
2678739|2678739-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678738|2678738-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678736|2678736-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678730|2678730-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241147
2678614|2678614-b19f-3f77-b713-d32bba55d77f|pass|200811|vpit@cpan.org|CPAN-WWW-Testers|0.37|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200811241055
2677615|2677615-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|Mail-Outlook|0.14|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240351
2677603|2677603-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|Parse-CPAN-Distributions|0.05|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240348
2677391|2677391-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240250
2677390|2677390-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|WWW-UsePerl-Journal|0.22|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240250
2677358|2677358-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240237
2677141|2677141-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240142
2674933|2674933-b19f-3f77-b713-d32bba55d77f|pass|200811|dmdk1@comcast.net|Test-YAML-Meta|0.11|i486-linux-gnu|5.10.0|linux|2.6.24-15-server|200811230918
2674682|2674682-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811231020
2674678|2674678-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811231016
2674533|2674533-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200811231048
2674527|2674527-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200811231045
2674502|2674502-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200811231037
2674493|2674493-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200811231033
2674384|2674384-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231040
2674383|2674383-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|Data-Phrasebook|0.29|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231040
2674251|2674251-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|Regexp-Log-Common|0.05|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231002
2673435|2673435-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811230706
2673430|2673430-b19f-3f77-b713-d32bba55d77f|pass|200811|rafl@debian.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811230705
2671493|2671493-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200811222145
2671486|2671486-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200811222143
2671400|2671400-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200811222111
2671393|2671393-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200811222110
2671149|2671149-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200811221330
2671148|2671148-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200811221329
2670865|2670865-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200811221803
2670855|2670855-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200811221802
2670805|2670805-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.8|linux|2.4.27-3-686|200811221757
2670802|2670802-b19f-3f77-b713-d32bba55d77f|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.8|linux|2.4.27-3-686|200811221756
2670654|2670654-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200811221728
2670633|2670633-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200811221724
2670570|2670570-b19f-3f77-b713-d32bba55d77f|pass|200811|vpit@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200811221817
2670565|2670565-b19f-3f77-b713-d32bba55d77f|pass|200811|vpit@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200811221816
2669900|2669900-b19f-3f77-b713-d32bba55d77f|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200811221632
2669863|2669863-b19f-3f77-b713-d32bba55d77f|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200811221628
2669316|2669316-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200811221219
2669307|2669307-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200811221215
2669229|2669229-b19f-3f77-b713-d32bba55d77f|pass|200811|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200811221959
2669222|2669222-b19f-3f77-b713-d32bba55d77f|pass|200811|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200811221957
2666669|2666669-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200811212332
2666668|2666668-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200811212329
2665787|2665787-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811211719
2665786|2665786-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811211719
2665723|2665723-b19f-3f77-b713-d32bba55d77f|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200811211850
2664772|2664772-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200811211141
2660368|2660368-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201957
2660365|2660365-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201957
2660169|2660169-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201923
2660167|2660167-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201923
2659813|2659813-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201834
2659608|2659608-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201809
2658718|2658718-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200811201430
2658694|2658694-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200811201429
2658643|2658643-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811201319
2658635|2658635-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811201315
2657769|2657769-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811200919
2657737|2657737-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811200911
2656857|2656857-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200811200749
2656378|2656378-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200811200628
2653887|2653887-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192318
2653886|2653886-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192318
2652883|2652883-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652882|2652882-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652880|2652880-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192025
2652879|2652879-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652577|2652577-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200811191845
2652570|2652570-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200811191844
2652125|2652125-b19f-3f77-b713-d32bba55d77f|fail|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811191511
2652104|2652104-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811191507
2649926|2649926-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190615
2649479|2649479-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190454
2649478|2649478-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190454
2649419|2649419-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190442
2649162|2649162-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190322
2648876|2648876-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811190018
2648183|2648183-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811182139
2648153|2648153-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811182134
2647773|2647773-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811182130
2647728|2647728-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811182111
2647499|2647499-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811182023
2647114|2647114-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181857
2647113|2647113-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181857
2647109|2647109-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200811181845
2647108|2647108-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200811181844
2646921|2646921-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181806
2646109|2646109-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181501
2646105|2646105-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181500
2646104|2646104-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181459
2645758|2645758-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200811181209
2645754|2645754-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200811181204
2645417|2645417-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811181148
2645305|2645305-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811181127
2643089|2643089-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811180352
2642306|2642306-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200811180041
2642206|2642206-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200811180029
2642166|2642166-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200811180025
2642012|2642012-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200811180006
2641944|2641944-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi|5.8.9|freebsd|6.1-release-p23|200811180056
2641611|2641611-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200811172309
2641594|2641594-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200811172306
2641588|2641588-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd|5.10.0|freebsd|6.1-release|200811180001
2641587|2641587-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd|5.10.0|freebsd|6.1-release|200811180000
2641584|2641584-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200811172303
2641570|2641570-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200811172301
2641380|2641380-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811172206
2640361|2640361-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811171941
2640359|2640359-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811171941
2639933|2639933-b19f-3f77-b713-d32bba55d77f|cpan|200811|BARBIE|WWW-Scraper-ISBN-Amazon_Driver|0.14||0|||200811171550
2639894|2639894-b19f-3f77-b713-d32bba55d77f|cpan|200811|BARBIE|WWW-Scraper-ISBN-Yahoo_Driver|0.08||0|||200811171541
2639885|2639885-b19f-3f77-b713-d32bba55d77f|cpan|200811|BARBIE|CPAN-WWW-Testers|0.37||0|||200811171539
2636733|2636733-b19f-3f77-b713-d32bba55d77f|pass|200811|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|darwin-2level|5.10.0|darwin|9.2.0|200811161253
2636729|2636729-b19f-3f77-b713-d32bba55d77f|pass|200811|jeff@zeroclue.com|Data-Phrasebook|0.29|darwin-2level|5.10.0|darwin|9.2.0|200811161253
2630342|2630342-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811151216
2630340|2630340-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811151216
2622891|2622891-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811141528
2621178|2621178-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811141110
2620615|2620615-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811140927
2620597|2620597-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811140926
2619299|2619299-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811140757
2619277|2619277-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811140756
2616431|2616431-b19f-3f77-b713-d32bba55d77f|unknown|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Statistics|0.52|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140051
2616430|2616430-b19f-3f77-b713-d32bba55d77f|fail|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Statistics|0.52|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140051
2615760|2615760-b19f-3f77-b713-d32bba55d77f|unknown|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140018
2615759|2615759-b19f-3f77-b713-d32bba55d77f|fail|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140018
2612723|2612723-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811132053
2611723|2611723-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131728
2611660|2611660-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2611481|2611481-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610819|2610819-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610806|2610806-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610680|2610680-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610439|2610439-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2609478|2609478-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131443
2607386|2607386-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131049
2607342|2607342-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131049
2605206|2605206-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200811130215
2605205|2605205-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200811130215
2605115|2605115-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200811130152
2605114|2605114-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200811130151
2604776|2604776-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130002
2604707|2604707-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130012
2604474|2604474-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130012
2604396|2604396-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130003
2603015|2603015-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2602723|2602723-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2602699|2602699-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2601885|2601885-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121403
2600929|2600929-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2600756|2600756-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2600711|2600711-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121131
2600710|2600710-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121131
2600616|2600616-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2598855|2598855-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811120755
2597985|2597985-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811120755
2597448|2597448-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811120623
2597413|2597413-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200811120515
2597410|2597410-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200811120514
2597116|2597116-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200811120352
2597111|2597111-b19f-3f77-b713-d32bba55d77f|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200811120351
2596676|2596676-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811120319
2596645|2596645-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811120314
2596641|2596641-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811120314
2596408|2596408-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811120222
2596406|2596406-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811120222
2596193|2596193-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811120140
2583410|2583410-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811101102
2582489|2582489-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811100834
2582443|2582443-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811100825
2581869|2581869-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811100640
2581861|2581861-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811100639
2580640|2580640-b19f-3f77-b713-d32bba55d77f|pass|200811|perl@galumph.com|Test-YAML-Meta|0.11|darwin-thread-multi-64int-ld-2level|5.10.0|darwin|9.4.0|200811091457
2578676|2578676-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811090840
2578092|2578092-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811091007
2577925|2577925-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811090841
2577915|2577915-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811090939
2577844|2577844-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811090916
2576856|2576856-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811091007
2576848|2576848-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811090945
2576838|2576838-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811091000
2576837|2576837-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811091000
2576783|2576783-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811090945
2576771|2576771-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811090939
2576722|2576722-b19f-3f77-b713-d32bba55d77f|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811090916
2553967|2553967-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2553966|2553966-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2553965|2553965-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2549127|2549127-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042147
2548874|2548874-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042056
2548873|2548873-b19f-3f77-b713-d32bba55d77f|fail|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-WebList|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042056
2548872|2548872-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTP|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042055
2548870|2548870-b19f-3f77-b713-d32bba55d77f|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042054
2547333|2547333-b19f-3f77-b713-d32bba55d77f|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux|5.11.0 patch 34595|linux|2.6.18-8.1.14.el5|200811040101
2547040|2547040-b19f-3f77-b713-d32bba55d77f|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux|5.11.0 patch 34712|linux|2.6.18-8.1.14.el5|200811040805
2547022|2547022-b19f-3f77-b713-d32bba55d77f|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Amazon_Driver|0.13|x86_64-linux|5.11.0 patch 34595|linux|2.6.18-8.1.14.el5|200811040246
2538544|2538544-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811022057
2538479|2538479-b19f-3f77-b713-d32bba55d77f|pass|200811|perl@galumph.com|Test-CPAN-Meta|0.12|darwin-2level|5.10.0|darwin|9.1.0|200811021338
2536552|2536552-b19f-3f77-b713-d32bba55d77f|pass|200811|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811021220
2534982|2534982-b19f-3f77-b713-d32bba55d77f|fail|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811012219
2533864|2533864-b19f-3f77-b713-d32bba55d77f|pass|200811|mw487.yahoo.com@gmail.com|Parse-CPAN-Distributions|0.05|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200811011109
2530540|2530540-b19f-3f77-b713-d32bba55d77f|pass|200810|mw487.yahoo.com@gmail.com|Data-Phrasebook-Loader-YAML|0.09|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810311209
2530539|2530539-b19f-3f77-b713-d32bba55d77f|pass|200810|mw487.yahoo.com@gmail.com|Data-Phrasebook|0.29|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810311208
2524873|2524873-b19f-3f77-b713-d32bba55d77f|pass|200810|frank.wiegand@gmail.com ("Frank Wiegand")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34669|linux|2.6.24-21-generic|200810302226
2524825|2524825-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810302227
2523954|2523954-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810302028
2516202|2516202-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810291541
2516199|2516199-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810291541
2515674|2515674-b19f-3f77-b713-d32bba55d77f|pass|200810|autarch@urth.org|Test-YAML-Meta|0.11|x86_64-linux-gnu|5.10.0|linux|2.6.24-15-server|200810290221
2513981|2513981-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290700
2513978|2513978-b19f-3f77-b713-d32bba55d77f|fail|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2513974|2513974-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2513968|2513968-b19f-3f77-b713-d32bba55d77f|fail|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2510577|2510577-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810281918
2507524|2507524-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280630
2507069|2507069-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280343
2507067|2507067-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280343
2506908|2506908-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280244
2506353|2506353-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810272329
2505665|2505665-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810272014
2505599|2505599-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271958
2505598|2505598-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271958
2504683|2504683-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271639
2502592|2502592-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810270337
2502590|2502590-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810270336
2498417|2498417-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200810260934
2498415|2498415-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200810260933
2497665|2497665-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.4.27-2-386|200810260811
2497407|2497407-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810260208
2497405|2497405-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810260207
2497361|2497361-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810260138
2497360|2497360-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810260138
2496291|2496291-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252224
2495715|2495715-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2495463|2495463-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494539|2494539-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494538|2494538-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494508|2494508-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494507|2494507-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2493787|2493787-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.4.27-2-386|200810252140
2493782|2493782-b19f-3f77-b713-d32bba55d77f|pass|200810|alexchorny@gmail.com|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200810251440
2492762|2492762-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.4.27-2-386|200810251904
2492549|2492549-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.4.27-2-386|200810251821
2492275|2492275-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251455
2491698|2491698-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251456
2491491|2491491-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251455
2489651|2489651-b19f-3f77-b713-d32bba55d77f|pass|200810|autarch@urth.org|WWW-UsePerl-Journal|0.22|x86_64-linux-gnu|5.8.8|linux|2.6.15.7|200810250112
2488394|2488394-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810250318
2488393|2488393-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810250317
2488369|2488369-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810250249
2488367|2488367-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810250248
2487577|2487577-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.21.5-smp|200810242146
2485083|2485083-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2484856|2484856-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2484663|2484663-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2483972|2483972-b19f-3f77-b713-d32bba55d77f|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483965|2483965-b19f-3f77-b713-d32bba55d77f|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483937|2483937-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240825
2483851|2483851-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483850|2483850-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2482679|2482679-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200810240052
2482678|2482678-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200810240052
2482066|2482066-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200810240020
2482063|2482063-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200810240019
2481867|2481867-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240003
2481483|2481483-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200810232006
2481480|2481480-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200810232006
2481330|2481330-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2480867|2480867-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810232148
2480866|2480866-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810232147
2480531|2480531-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232100
2480529|2480529-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232100
2480440|2480440-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232058
2480271|2480271-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232058
2480057|2480057-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2479887|2479887-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2475823|2475823-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200810230034
2475817|2475817-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200810230034
2475765|2475765-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200810230029
2475758|2475758-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200810230029
2471123|2471123-b19f-3f77-b713-d32bba55d77f|pass|200810|mw487.yahoo.com@gmail.com|Regexp-Log-Common|0.05|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810220821
2470570|2470570-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810221128
2470566|2470566-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810221127
2470179|2470179-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810221021
2470172|2470172-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810221021
2468604|2468604-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200810220329
2468602|2468602-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200810220329
2468096|2468096-b19f-3f77-b713-d32bba55d77f|pass|200810|davidp@preshweb.co.uk ("David Precious")|Finance-Currency-Convert-XE|0.15|i486-linux-gnu|5.10.0|linux|2.6.26.1|200810211927
2466508|2466508-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200810211219
2466502|2466502-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200810211217
2466225|2466225-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.10.0|linux|2.4.27-2-386|200810211227
2465472|2465472-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200810210222
2462643|2462643-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810201938
2462642|2462642-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810201938
2462231|2462231-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.4.27-2-386|200810201815
2461954|2461954-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200810201443
2461951|2461951-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200810201443
2461757|2461757-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.4.27-2-386|200810201541
2461685|2461685-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810201314
2461682|2461682-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810201314
2461677|2461677-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810201311
2461676|2461676-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810201310
2461607|2461607-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810201257
2461603|2461603-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810201256
2461601|2461601-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810201256
2461146|2461146-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|CPAN-WWW-Testers|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810201125
2460909|2460909-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810200701
2460904|2460904-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810200654
2460895|2460895-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810200640
2460641|2460641-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.4.27-2-386|200810200058
2459261|2459261-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200810191616
2458601|2458601-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.4.27-2-386|200810191525
2457437|2457437-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191354
2457431|2457431-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191349
2457411|2457411-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-WWW-Testers|0.34|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191343
2457386|2457386-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191338
2457371|2457371-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191333
2456880|2456880-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810190757
2456878|2456878-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810190757
2456873|2456873-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810190755
2456870|2456870-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810190754
2456865|2456865-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810190753
2456859|2456859-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810190752
2456854|2456854-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810190751
2454535|2454535-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810181609
2454509|2454509-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810181557
2454477|2454477-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810181544
2450710|2450710-b19f-3f77-b713-d32bba55d77f|cpan|200810|BARBIE|CPAN-WWW-Testers|0.36||0|||200810171419
2448609|2448609-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2448587|2448587-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448569|2448569-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448559|2448559-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448557|2448557-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162114
2448405|2448405-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2448298|2448298-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448286|2448286-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448283|2448283-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448065|2448065-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162148
2448037|2448037-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447973|2447973-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162148
2447792|2447792-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447735|2447735-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447734|2447734-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447732|2447732-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162112
2439818|2439818-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810151106
2439497|2439497-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810151051
2436197|2436197-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810141125
2435630|2435630-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810141009
2435084|2435084-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140831
2434754|2434754-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140749
2434730|2434730-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140747
2434558|2434558-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140728
2434418|2434418-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140709
2434155|2434155-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140634
2434039|2434039-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140621
2434022|2434022-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140620
2433982|2433982-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140616
2433823|2433823-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140558
2433778|2433778-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140552
2433486|2433486-b19f-3f77-b713-d32bba55d77f|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140003
2433423|2433423-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140517
2433112|2433112-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140437
2432748|2432748-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140401
2432631|2432631-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140352
2431228|2431228-b19f-3f77-b713-d32bba55d77f|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140147
2430379|2430379-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140054
2430316|2430316-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140050
2429821|2429821-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140017
2429750|2429750-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140010
2429458|2429458-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140141
2428537|2428537-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140026
2427681|2427681-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810132322
2427674|2427674-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810132322
2427587|2427587-b19f-3f77-b713-d32bba55d77f|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810132319
2427477|2427477-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810132233
2424396|2424396-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810130104
2424009|2424009-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810122159
2423549|2423549-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810121702
2422614|2422614-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810120417
2422607|2422607-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810121006
2422604|2422604-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810121004
2422603|2422603-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.8.8|linux|2.4.27-3-686|200810121003
2421572|2421572-b19f-3f77-b713-d32bba55d77f|pass|200810|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810120238
2417194|2417194-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.10.0|solaris|2.11|200810101615
2417025|2417025-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810101419
2416945|2416945-b19f-3f77-b713-d32bba55d77f|pass|200810|martin.evans@easysoft.com|Test-YAML-Meta|0.11|i486-linux-gnu|5.8.8|linux|2.6.15.7|200810101151
2416872|2416872-b19f-3f77-b713-d32bba55d77f|cpan|200810|BARBIE|CPAN-Testers-WWW-Statistics|0.52||0|||200810101156
2416812|2416812-b19f-3f77-b713-d32bba55d77f|pass|200810|bobtfish@bobtfish.net|Test-YAML-Meta|0.11|x86_64-linux-gnu|5.8.8|linux|2.6.15.7|200810100014
2416426|2416426-b19f-3f77-b713-d32bba55d77f|pass|200810|carlos.arenas@gmail.com ("Carlos Arenas")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.25-arch|200810091809
2416149|2416149-b19f-3f77-b713-d32bba55d77f|fail|200810|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100730
2416125|2416125-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100723
2416121|2416121-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100721
2416047|2416047-b19f-3f77-b713-d32bba55d77f|fail|200810|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100648
2415921|2415921-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100557
2415636|2415636-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810100354
2412252|2412252-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810091941
2408910|2408910-b19f-3f77-b713-d32bba55d77f|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.7|linux|2.6.26.5|200810090340
2406226|2406226-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810081533
2405360|2405360-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int|5.8.8|linux|2.4.26|200810081857
2405253|2405253-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810081245
2405246|2405246-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810081744
2405027|2405027-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810081815
2404331|2404331-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|i686-linux|5.8.8|linux|2.4.27-3-686|200810081702
2403907|2403907-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|IP35-irix-64int|5.8.8|irix|6.5|200810081719
2403862|2403862-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810081609
2403731|2403731-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.8.7|linux|2.6.26.5|200810081056
2402905|2402905-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.7|linux|2.6.26.5|200810080837
2402904|2402904-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.8.7|linux|2.6.26.5|200810080837
2400112|2400112-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.7|linux|2.6.26.5|200810080340
2397651|2397651-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.8.6|linux|2.6.26.5|200810071811
2395731|2395731-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0 patch 34465|netbsd|4.0|200810071903
2395730|2395730-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0 patch 34465|netbsd|4.0|200810071903
2395373|2395373-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.11.0 patch 34470|netbsd|4.0|200810071818
2395371|2395371-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.11.0 patch 34470|netbsd|4.0|200810071818
2395217|2395217-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810071259
2394084|2394084-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.6|linux|2.6.26.5|200810071031
2393177|2393177-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810070813
2392395|2392395-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810071134
2392393|2392393-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810071133
2391457|2391457-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810071000
2391450|2391450-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810070959
2391439|2391439-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810070958
2391432|2391432-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810070956
2391421|2391421-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810070955
2391410|2391410-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810070953
2391404|2391404-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810070952
2391400|2391400-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810070951
2391393|2391393-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810070950
2391389|2391389-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810070949
2391280|2391280-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200810071037
2391088|2391088-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200810071002
2389068|2389068-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070339
2389054|2389054-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070337
2389039|2389039-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070335
2386689|2386689-b19f-3f77-b713-d32bba55d77f|pass|200810|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.51|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810070330
2385724|2385724-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061738
2385708|2385708-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061736
2385697|2385697-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061735
2385523|2385523-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061713
2385509|2385509-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061711
2385490|2385490-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061709
2380651|2380651-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.6|linux|2.6.26.5|200810041705
2380650|2380650-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.6|linux|2.6.26.5|200810041704
2377550|2377550-b19f-3f77-b713-d32bba55d77f|pass|200810|jeff@zeroclue.com|CPAN-WWW-Testers-Generator|0.30|darwin-2level|5.10.0|darwin|9.2.0|200810031110
2377123|2377123-b19f-3f77-b713-d32bba55d77f|pass|200810|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.51|darwin-2level|5.10.0|darwin|9.2.0|200810031112
2377018|2377018-b19f-3f77-b713-d32bba55d77f|pass|200810|jeff@zeroclue.com|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|9.2.0|200810030909
2373644|2373644-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.7|linux|2.6.26.5|200810040006
2373643|2373643-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.7|linux|2.6.26.5|200810040006
2373476|2373476-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032227
2373460|2373460-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032225
2373443|2373443-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032222
2365509|2365509-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022330
2365493|2365493-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022327
2365477|2365477-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022325
2364857|2364857-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022201
2364839|2364839-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022159
2364831|2364831-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022157
2363284|2363284-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021923
2363281|2363281-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021921
2363273|2363273-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021920
2363262|2363262-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021918
2363260|2363260-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021916
2363259|2363259-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021915
2363252|2363252-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021913
2363247|2363247-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021911
2363244|2363244-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021910
2363226|2363226-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021906
2363193|2363193-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021903
2363179|2363179-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021859
2362870|2362870-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021339
2362850|2362850-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021335
2362798|2362798-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021326
2362795|2362795-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810021225
2362783|2362783-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021324
2362777|2362777-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021323
2362771|2362771-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021323
2362755|2362755-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810021221
2362754|2362754-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021321
2362646|2362646-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810021707
2362642|2362642-b19f-3f77-b713-d32bba55d77f|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021307
2362625|2362625-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810021703
2362549|2362549-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|IP35-irix-64int|5.8.8|irix|6.5|200810021850
2362547|2362547-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810021749
2362542|2362542-b19f-3f77-b713-d32bba55d77f|pass|200810|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200810030148
2362539|2362539-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810021742
2362537|2362537-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.6.2|freebsd|6.1-release|200810021809
2362528|2362528-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810021746
2362526|2362526-b19f-3f77-b713-d32bba55d77f|pass|200810|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200810030146
2362523|2362523-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810021745
2362517|2362517-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.8|linux|2.4.27-3-686|200810021743
2362508|2362508-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|i686-linux|5.8.8|linux|2.4.27-3-686|200810021742
2362128|2362128-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021413
2362123|2362123-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021411
2362109|2362109-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021408
2362093|2362093-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021405
2362085|2362085-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021402
2362080|2362080-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021359
2361919|2361919-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810021638
2361915|2361915-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.51|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810021637
2361765|2361765-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.6.2|freebsd|6.1-release|200810021558
2360537|2360537-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021256
2360267|2360267-b19f-3f77-b713-d32bba55d77f|pass|200810|martin.evans@easysoft.com|CPAN-Testers-WWW-Statistics|0.51|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810021128
2360261|2360261-b19f-3f77-b713-d32bba55d77f|pass|200810|martin.evans@easysoft.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810021127
2359737|2359737-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021102
2359736|2359736-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021102
2359088|2359088-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810020955
2358997|2358997-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.51|i86pc-solaris-64int|5.10.0|solaris|2.11|200810020945
2358994|2358994-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.10.0|solaris|2.11|200810020945
2357109|2357109-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020300
2356926|2356926-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020231
2356861|2356861-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020222
2356805|2356805-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020215
2356696|2356696-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020158
2356615|2356615-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020135
2356603|2356603-b19f-3f77-b713-d32bba55d77f|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020134
2356509|2356509-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020117
2356440|2356440-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020056
2356052|2356052-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810020222
2356040|2356040-b19f-3f77-b713-d32bba55d77f|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810020217
2355940|2355940-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.10.0|freebsd|6.1-release|200810020044
2355603|2355603-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810012348
2355602|2355602-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810012348
2354883|2354883-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.10.0|freebsd|6.1-release|200810012133
2354882|2354882-b19f-3f77-b713-d32bba55d77f|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.10.0|freebsd|6.1-release|200810012133
2354375|2354375-b19f-3f77-b713-d32bba55d77f|cpan|200810|BARBIE|CPAN-WWW-Testers-Generator|0.30||0|||200810012017
2354368|2354368-b19f-3f77-b713-d32bba55d77f|cpan|200810|BARBIE|CPAN-Testers-WWW-Statistics|0.51||0|||200810012015
2353976|2353976-b19f-3f77-b713-d32bba55d77f|fail|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.11.0 patch 34451|freebsd|7.0-release|200810011630
2353936|2353936-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011735
2353914|2353914-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011733
2353892|2353892-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011730
2353882|2353882-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011728
2353873|2353873-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011726
2353851|2353851-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011723
2353029|2353029-b19f-3f77-b713-d32bba55d77f|pass|200810|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810011518
2352864|2352864-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011337
2352850|2352850-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011335
2352834|2352834-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011332
2352159|2352159-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810011053
2352146|2352146-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810011151
2352145|2352145-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810010552
2352144|2352144-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.8|linux|2.4.27-3-686|200810011152
2352143|2352143-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810011151
2351776|2351776-b19f-3f77-b713-d32bba55d77f|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.6.2|linux|2.4.27-3-686|200810011039
2351627|2351627-b19f-3f77-b713-d32bba55d77f|pass|200810|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810011707
2351467|2351467-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810010921
2351461|2351461-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810010919
2351452|2351452-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810010918
2351450|2351450-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810010917
2351448|2351448-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810010916
2351434|2351434-b19f-3f77-b713-d32bba55d77f|pass|200810|vpit@cpan.org|CPAN-WWW-Testers|0.35|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810011015
2351432|2351432-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810010914
2351426|2351426-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810010913
2351422|2351422-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810010912
2351417|2351417-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810010911
2351413|2351413-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810010910
2351409|2351409-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810010909
2351402|2351402-b19f-3f77-b713-d32bba55d77f|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200810011007
2351401|2351401-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810010906
2351387|2351387-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810010904
2351373|2351373-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810010859
2351353|2351353-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810010857
2351331|2351331-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810010854
2351318|2351318-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810010851
2351292|2351292-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810010849
2351286|2351286-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810010846
2351281|2351281-b19f-3f77-b713-d32bba55d77f|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810010843
2350924|2350924-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.8|linux|2.6.26.5|200810010238
2350899|2350899-b19f-3f77-b713-d32bba55d77f|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.6.26.5|200810010234
2347172|2347172-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809302309
2346747|2346747-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809301527
2346466|2346466-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0 patch 34437|netbsd|4.0|200809301946
2346463|2346463-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0 patch 34437|netbsd|4.0|200809301946
2346350|2346350-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.11.0 patch 34448|freebsd|6.2-release|200809301408
2346340|2346340-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.11.0 patch 34448|freebsd|6.2-release|200809301407
2346258|2346258-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.26.5|200809301418
2346081|2346081-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809301851
2346078|2346078-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809301849
2346073|2346073-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809301847
2346071|2346071-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809301846
2345812|2345812-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|WWW-UsePerl-Journal-Thread|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809301902
2345806|2345806-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809301902
2345797|2345797-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8 patch 34439|netbsd|4.0|200809301755
2345792|2345792-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8 patch 34439|netbsd|4.0|200809301755
2345656|2345656-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.26.5|200809301223
2345541|2345541-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809301156
2345432|2345432-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.6.2|freebsd|6.1-release|200809301740
2345425|2345425-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809301741
2344729|2344729-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809301549
2344624|2344624-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.11|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809301436
2344622|2344622-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809301436
2344331|2344331-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.11.0 patch 34444|netbsd|4.0|200809301356
2344318|2344318-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.11.0 patch 34444|netbsd|4.0|200809301351
2343991|2343991-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809301212
2343989|2343989-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809301211
2343964|2343964-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.6.2|linux|2.4.27-3-686|200809301306
2343962|2343962-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i686-linux|5.6.2|linux|2.4.27-3-686|200809301306
2343758|2343758-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809300627
2343753|2343753-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809300627
2343649|2343649-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809301303
2343578|2343578-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809301157
2343577|2343577-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809301157
2343499|2343499-b19f-3f77-b713-d32bba55d77f|cpan|200809|BARBIE|WWW-UsePerl-Journal-Thread|0.12||0|||200809301242
2343456|2343456-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.8.8|linux|2.4.27-3-686|200809301136
2343452|2343452-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.4.27-3-686|200809301136
2343451|2343451-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809301135
2343448|2343448-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809301135
2343415|2343415-b19f-3f77-b713-d32bba55d77f|pass|200809|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809301823
2343409|2343409-b19f-3f77-b713-d32bba55d77f|pass|200809|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809301821
2342949|2342949-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.10.0|freebsd|6.1-release|200809301057
2342907|2342907-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301055
2342864|2342864-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301044
2342681|2342681-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301008
2342667|2342667-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809300401
2342666|2342666-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809300400
2342584|2342584-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809300846
2342561|2342561-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809300843
2342521|2342521-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809300839
2342500|2342500-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809300837
2342223|2342223-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809301001
2339845|2339845-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809291953
2339842|2339842-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809291953
2338665|2338665-b19f-3f77-b713-d32bba55d77f|cpan|200809|BARBIE|WWW-UsePerl-Journal-Thread|0.11||0|||200809292345
2338362|2338362-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809292207
2338326|2338326-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809292202
2338249|2338249-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809292157
2338231|2338231-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809292153
2336646|2336646-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336644|2336644-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336642|2336642-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336173|2336173-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809291847
2335954|2335954-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.29|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291829
2334984|2334984-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.50|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291642
2334761|2334761-b19f-3f77-b713-d32bba55d77f|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291610
2334461|2334461-b19f-3f77-b713-d32bba55d77f|cpan|200809|BARBIE|WWW-UsePerl-Journal|0.22||0|||200809291524
2333219|2333219-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809290631
2331775|2331775-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|CPAN-WWW-Testers|0.35|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809290840
2328912|2328912-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.26.5|200809281619
2328786|2328786-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.8.8|linux|2.6.26.5|200809281552
2328728|2328728-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.26.5|200809281543
2328573|2328573-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.8.8|linux|2.6.26.5|200809281526
2328494|2328494-b19f-3f77-b713-d32bba55d77f|pass|200809|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200809290417
2328135|2328135-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.26.5|200809281443
2328101|2328101-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.26.5|200809281440
2328066|2328066-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.26.5|200809281437
2328009|2328009-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.26.5|200809281430
2327982|2327982-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.8.8|linux|2.6.26.5|200809281426
2327950|2327950-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.8.8|linux|2.6.26.5|200809281423
2327773|2327773-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.8|linux|2.6.26.5|200809281405
2327726|2327726-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.8|linux|2.6.26.5|200809281400
2327359|2327359-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.10.0|linux|2.6.26.5|200809281316
2327202|2327202-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.6.26.5|200809281254
2327197|2327197-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.8|linux|2.6.26.5|200809281253
2326887|2326887-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.8.8|linux|2.6.26.5|200809281222
2326635|2326635-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.26.5|200809281157
2326370|2326370-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.10.0|linux|2.6.26.5|200809281131
2326201|2326201-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.8|linux|2.6.26.5|200809281109
2326134|2326134-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.26.5|200809281102
2325916|2325916-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.8.8|linux|2.6.26.5|200809281042
2325877|2325877-b19f-3f77-b713-d32bba55d77f|cpan|200809|BARBIE|CPAN-WWW-Testers|0.35||0|||200809281637
2325646|2325646-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.26.5|200809281019
2325554|2325554-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.8|linux|2.6.26.5|200809281009
2325216|2325216-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.6.26.5|200809280933
2325185|2325185-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.10.0|linux|2.6.26.5|200809280930
2325061|2325061-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.8|linux|2.6.26.5|200809280919
2324825|2324825-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.26.5|200809280854
2324668|2324668-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.8.8|linux|2.6.26.5|200809280835
2324635|2324635-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.8.8|linux|2.6.26.5|200809280832
2324573|2324573-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.26.5|200809280827
2324378|2324378-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.8.8|linux|2.6.26.5|200809280804
2324083|2324083-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.8.8|linux|2.6.26.5|200809280739
2323122|2323122-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280539
2323066|2323066-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280525
2322843|2322843-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280434
2322837|2322837-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280432
2322830|2322830-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280431
2322801|2322801-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280427
2322514|2322514-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280321
2322285|2322285-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280254
2321723|2321723-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280139
2321554|2321554-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280117
2321455|2321455-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280100
2321215|2321215-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280029
2321104|2321104-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280004
2321088|2321088-b19f-3f77-b713-d32bba55d77f|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280001
2320930|2320930-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280325
2320827|2320827-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280250
2318193|2318193-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.50|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809272013
2318020|2318020-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809272055
2317920|2317920-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809271346
2316164|2316164-b19f-3f77-b713-d32bba55d77f|pass|200809|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.50|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809271919
2315731|2315731-b19f-3f77-b713-d32bba55d77f|pass|200809|jeff@zeroclue.com|CPAN-WWW-Testers-Generator|0.25|darwin-2level|5.10.0|darwin|9.2.0|200809261631
2315279|2315279-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809270420
2315229|2315229-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809270910
2315157|2315157-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809270948
2315129|2315129-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809270949
2315116|2315116-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|i686-linux|5.8.8|linux|2.4.27-3-686|200809270947
2312452|2312452-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.50|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809270100
2312163|2312163-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809270304
2311698|2311698-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809262331
2311665|2311665-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809262327
2311647|2311647-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809262322
2311624|2311624-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809262316
2311596|2311596-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809262312
2311583|2311583-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809261807
2311573|2311573-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809262304
2311546|2311546-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809262258
2311524|2311524-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809262254
2311477|2311477-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809262248
2310946|2310946-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200809262113
2310514|2310514-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809262115
2310408|2310408-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200809262002
2310126|2310126-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.8.8|linux|2.6.26.3-29.fc9.i686|200809261914
2309683|2309683-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Mail-Outlook|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809261852
2309528|2309528-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|CPAN-Testers-WWW-Statistics|0.49|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261730
2309134|2309134-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|Mail-Outlook|0.14|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261643
2308805|2308805-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.26.3-29.fc9.i686|200809261603
2308749|2308749-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|Parse-CPAN-Distributions|0.05|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261557
2308060|2308060-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809261452
2308057|2308057-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd|5.10.0|freebsd|6.1-release|200809261450
2307990|2307990-b19f-3f77-b713-d32bba55d77f|cpan|200809|BARBIE|CPAN-Testers-WWW-Statistics|0.50||0|||200809261437
2306641|2306641-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.26.5|200809260422
2305306|2305306-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.8|linux|2.6.26.5|200809260327
2304285|2304285-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.11.0 patch 34419|solaris|2.10|200809260113
2299794|2299794-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809250846
2296934|2296934-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296930|2296930-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296929|2296929-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296926|2296926-b19f-3f77-b713-d32bba55d77f|fail|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250156
2296923|2296923-b19f-3f77-b713-d32bba55d77f|fail|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250155
2294573|2294573-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8 patch 34415|solaris|2.10|200809250121
2294556|2294556-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8 patch 34415|solaris|2.10|200809250119
2294231|2294231-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0 patch 34413|solaris|2.10|200809250038
2294228|2294228-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0 patch 34413|solaris|2.10|200809250036
2293382|2293382-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809241754
2291953|2291953-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242129
2291859|2291859-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242127
2291848|2291848-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242126
2291402|2291402-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.26.5|200809241329
2291400|2291400-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.26.5|200809241329
2291279|2291279-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|i686-linux-64int-ld|5.10.0|linux|2.6.22-14-386|200809241309
2290685|2290685-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.8|linux|2.6.26.5|200809241144
2290683|2290683-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.8|linux|2.6.26.5|200809241144
2286032|2286032-b19f-3f77-b713-d32bba55d77f|pass|200809|dmdk1@comcast.net|Parse-CPAN-Distributions|0.05|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809240215
2283686|2283686-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809231619
2283682|2283682-b19f-3f77-b713-d32bba55d77f|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809231619
2282819|2282819-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231413
2282818|2282818-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231413
2282790|2282790-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809231909
2282756|2282756-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809231906
2282732|2282732-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809231904
2282696|2282696-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809231901
2282597|2282597-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809231851
2282568|2282568-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809231849
2282119|2282119-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.49|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231316
2282072|2282072-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231312
2282002|2282002-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231308
2281994|2281994-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231307
2281935|2281935-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231303
2281929|2281929-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231303
2281611|2281611-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.04|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231242
2281389|2281389-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.28|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231227
2281383|2281383-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.49|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231227
2281221|2281221-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231215
2280449|2280449-b19f-3f77-b713-d32bba55d77f|pass|200809|martin.evans@easysoft.com|Test-YAML-Meta|0.11|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809231509
2280257|2280257-b19f-3f77-b713-d32bba55d77f|pass|200809|andy@hexten.net|Test-YAML-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809231543
2278975|2278975-b19f-3f77-b713-d32bba55d77f|pass|200809|andy@hexten.net|Finance-Currency-Convert-XE|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809231258
2278876|2278876-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230655
2278843|2278843-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230653
2273048|2273048-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230153
2271937|2271937-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230054
2271289|2271289-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230011
2271060|2271060-b19f-3f77-b713-d32bba55d77f|pass|200809|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230356
2270074|2270074-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222342
2270058|2270058-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222334
2270030|2270030-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222327
2269998|2269998-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222319
2269934|2269934-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222304
2269899|2269899-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222258
2269873|2269873-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222251
2269859|2269859-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222245
2269843|2269843-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222241
2269837|2269837-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222239
2269833|2269833-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222237
2269829|2269829-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222235
2268222|2268222-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221432
2268201|2268201-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221429
2268180|2268180-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221426
2268160|2268160-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221423
2267948|2267948-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221355
2267934|2267934-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221352
2267925|2267925-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221349
2267918|2267918-b19f-3f77-b713-d32bba55d77f|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221348
2267507|2267507-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221043
2267444|2267444-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221509
2267442|2267442-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267441|2267441-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267439|2267439-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267435|2267435-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.49|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221506
2267302|2267302-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221220
2267295|2267295-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221219
2267289|2267289-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221218
2267284|2267284-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221217
2267140|2267140-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221157
2267134|2267134-b19f-3f77-b713-d32bba55d77f|pass|200809|frank.wiegand@gmail.com ("Frank Wiegand")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34384|linux|2.6.24-21-generic|200809221419
2266757|2266757-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.03|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221028
2266596|2266596-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.04|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221035
2266595|2266595-b19f-3f77-b713-d32bba55d77f|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221020
2266272|2266272-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809221151
2266266|2266266-b19f-3f77-b713-d32bba55d77f|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809221150
2262879|2262879-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809212116
2262844|2262844-b19f-3f77-b713-d32bba55d77f|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809212114
2260545|2260545-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809211506
2260513|2260513-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809211502
2260338|2260338-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809210833
2260293|2260293-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809210826
2260202|2260202-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809211311
2260151|2260151-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809211302
2259964|2259964-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809211340
2259922|2259922-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809211336
2259820|2259820-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|IP35-irix-64int|5.8.8|irix|6.5|200809211421
2259722|2259722-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|IP35-irix-64int|5.8.8|irix|6.5|200809211418
2259674|2259674-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|i686-linux|5.8.8|linux|2.4.27-3-686|200809211316
2259649|2259649-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.4.27-3-686|200809211312
2259630|2259630-b19f-3f77-b713-d32bba55d77f|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i686-linux|5.6.2|linux|2.4.27-3-686|200809211310
2259534|2259534-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211258
2259518|2259518-b19f-3f77-b713-d32bba55d77f|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211256
2259512|2259512-b19f-3f77-b713-d32bba55d77f|pass|