#!/usr/bin/perl -w
# $File: //member/autrijus/PAR/myldr/Makefile.PL $ $Author: autrijus $
# $Revision: #2 $ $Change: 2027 $ $DateTime: 2002/11/06 23:01:46 $
#
# Copyright (c) 2002 Mattia Barbon.
# Copyright (c) 2002 Autrijus Tang.
# This package is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

use strict;
use Config;
use ExtUtils::Embed;

xsinit();

my $debug = 0;

my $exe = $Config{_exe};
my $o = $Config{_o};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};
my $f2c = "./file2c.pl";
system($^X, $f2c, qw(../script/par.pl my_par_pl.c load_me_2));

print "Writing Makefile for the par$exe program\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

my $is_MSVC = $cc =~ m/^cl/;
if( $is_MSVC ) {
  $out = '-out:';
  $ccdebug = $debug ? '-Zi ' : '';
  $lddebug = $debug ? '-debug ' : '-release ';
  $warn = '-W3';
} else {
  $out = '-o ';
  $ccdebug = $debug ? '-g ' : '';
  $lddebug = $debug ? '' : '-s ';
  $warn = '-Wall -Wno-comments ';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags

OBJECTS=main$o

.c$o:
	\$(CC) -c \$(CFLAGS) \$<

all: ../script/par$exe

clean:
	-\$(RM) my_par_pl.c
	-\$(RM) *$o
	-\$(RM) *.opt *.pdb perlxsi.c
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) ../script/par$exe
	-\$(RM) Makefile Makefile.old

distclean: clean
	-\$(RM) ../script/par$exe
	-\$(RM) Makefile Makefile.old

../script/par$exe: \$(OBJECTS) my_par_pl.c
	\$(LD) \$(OBJECTS) \$(LDFLAGS) $out\$@

main$o: main.c

disttest:
	-\$(RM) Makefile.old

test:
	-\$(RM) Makefile.old

.DEFAULT:
	-\$(RM) Makefile.old

.SUFFIXES: $o

EOT

# local variables:
# mode: cperl
# end:
