=head1 NAME

ORM - Object relational mapper  Perl,      
  .

=head1 SYNOPSIS

  use Music::Song;
  use Music::Performer;

  # Show number of songs performed by 'Gorillaz'
  print Music::Song->count( filter=>( Music::Song->M->performer->name eq 'Gorillaz' ) );

  # Find object corresponding to performer 'Gorillaz'
  $performer = Music::Performer->find
  (
      filter=>( Music::Performer->M->name eq 'Gorillaz' ),
  );

  # Add new song to our database
  $error = ORM::Error->new;
  $song  = Music::Song->new
  (
      error => $error,
      prop  =>
      {
          performer => $performer,
          year      => 2005,
          title     => "September's Gone",
          content   => "/home/user/music/Gorillaz/September's Gone.mp3",
      },
  );
  if( $error->fatal )
  {
      die $error->text;
  }
  else
  {
      print $song->title,"\n";
  }

=head1 DESCRIPTION

ORM is Perl library that implements object-relational mapping.
Its features are much similar to those of Java's Hibernate library,
but interface is much different and easier to use.

=head2   ORM

=over

=item *
  ORM      
SQL-   SQL-. SQL- 
    .    
   ,    ORM
      .

=item *
 ,      SQL-, 
     
    SQL-injection.

=item *
        
      ORM::Db::Replicated 
ORM::Db::Backup   (, PostgreSQL)   (,
MySQL Cluster) .

=back

=head2  

=over

=item *    

=item *  

=item *    SQL-

=item *         Perl-

=item *    "  "  "  "

=item *   

=item *   

=item *   (lazy-loaded) 

=item *     (  GROUP BY)

=item *       

=item *    

=item *  

=item *       

=back

       TODO.txt

=head2  

=over 

=item  (Intermediate) 

      .

=item  (Initial) 

 intermediate ,  
 ORM        .

=item  (Primary) 

     Initial .

=back

=head2  

    ORM     
 .        _init
     ORM     
 .

,    ,   
ORM-          
  .

      



 Music::ORM   ORM    
    .

  Music::Song -       ,
      Music::ORM.
            
 ORM    ,        
 named 'Music_Song' you can change its suggested name by overriding method
 ORM->_guess_table_name() or by specifying 'table' argument in use clause.

=head2   (lazy_load)

=head1 

=head2 _init

=over

=item history_class

 ,        B<>
   .    C<Todo::History> .

    -      .

  ,     ,
     ,    
     ,    .

=item prefer_lazy_load

      .
       L<ORM(5)>.

=item emulate_foreign_keys

,        ORM
  ,    .

=item default_cache_size

   .

ORM       ,
     B<> 
(,     )
          .

      0,      
     .  :

  $a = Todo::Task->find_id( id=1 );
  $b = Todo::Task->find_id( id=1 );

        .
  $a  $b       .

=item db

  .    L<ORM::Db(5)>.

=back

=head1 SEE ALSO

http://sourceforge.net/projects/perlorm

=head1 AUTHOR

Alexey V. Akimov

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2005 by Alexey V. Akimov

This library is free software; you can redistribute it and/or modify
it under the terms of LGPL licence.

=cut
