#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = '0.08';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'DEFAULT' => 38,
			"\$" => 6,
			'LITERAL' => 41,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			'RAW' => 46,
			'FOR' => 52,
			'PROCESS' => 11,
			'WRAPPER' => 30,
			"[" => 31,
			'IF' => 33,
			"(" => 32,
			";" => -19,
			'LAST' => 28,
			'TRY' => 1,
			'RETURN' => 29,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			'TEXT' => 37,
			'VIEW' => 67,
			'NEXT' => 68,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'rawperl' => 24,
			'GET' => 26,
			'USE' => 71,
			'IDENT' => 25,
			'FILTER' => 70,
			"\"" => 27,
			'META' => 73,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			"{" => 64,
			'INCLUDE' => 63
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 69,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21,
			'statement' => 75,
			'block' => 74,
			'use' => 72,
			'condition' => 57,
			'wrapper' => 16,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'sterm' => 19,
			'lterm' => 18,
			'expr' => 17,
			'view' => 62,
			'term' => 60,
			'defblockname' => 42,
			'atomdir' => 40,
			'switch' => 39,
			'chunk' => 5,
			'template' => 12,
			'try' => 13,
			'filter' => 50,
			'defblock' => 51,
			'anonblock' => 49,
			'javascript' => 10,
			'capture' => 48,
			'directive' => 45,
			'setlist' => 2,
			'raw' => 35,
			'node' => 3
		}
	},
	{#State 1
		ACTIONS => {
			";" => 76
		}
	},
	{#State 2
		ACTIONS => {
			"\${" => 36,
			'COMMA' => 78,
			'IDENT' => 25,
			"\$" => 6,
			'LITERAL' => 80
		},
		DEFAULT => -20,
		GOTOS => {
			'node' => 3,
			'ident' => 77,
			'item' => 56,
			'assign' => 79
		}
	},
	{#State 3
		DEFAULT => -128
	},
	{#State 4
		DEFAULT => -39
	},
	{#State 5
		DEFAULT => -5
	},
	{#State 6
		ACTIONS => {
			'IDENT' => 81
		}
	},
	{#State 7
		DEFAULT => -114
	},
	{#State 8
		ACTIONS => {
			'FILENAME' => 89,
			'IDENT' => 83,
			'LITERAL' => 91,
			"\"" => 84,
			"\$" => 87,
			'NUMBER' => 88
		},
		GOTOS => {
			'names' => 92,
			'nameargs' => 86,
			'filename' => 82,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 9
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			'LITERAL' => 80,
			"\$" => 6
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 93,
			'item' => 56,
			'node' => 3,
			'ident' => 77
		}
	},
	{#State 10
		DEFAULT => -26
	},
	{#State 11
		ACTIONS => {
			'IDENT' => 83,
			'FILENAME' => 89,
			"\$" => 87,
			'LITERAL' => 91,
			"\"" => 84,
			'NUMBER' => 88
		},
		GOTOS => {
			'filepart' => 85,
			'name' => 90,
			'names' => 92,
			'nameargs' => 94,
			'filename' => 82
		}
	},
	{#State 12
		ACTIONS => {
			'' => 95
		}
	},
	{#State 13
		DEFAULT => -25
	},
	{#State 14
		DEFAULT => -27
	},
	{#State 15
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"\"" => 27,
			"{" => 64,
			'REF' => 54,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 98,
			'NUMBER' => 7,
			"(" => 32,
			'NOT' => 43
		},
		GOTOS => {
			'node' => 3,
			'expr' => 97,
			'ident' => 96,
			'term' => 60,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 16
		DEFAULT => -44
	},
	{#State 17
		ACTIONS => {
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100,
			'AND' => 106,
			'DIV' => 108,
			";" => -17,
			'MOD' => 104,
			'BINOP' => 99,
			'OR' => 102,
			'CAT' => 103,
			"/" => 105
		},
		DEFAULT => -28
	},
	{#State 18
		DEFAULT => -104
	},
	{#State 19
		DEFAULT => -105
	},
	{#State 20
		ACTIONS => {
			";" => 109
		}
	},
	{#State 21
		ACTIONS => {
			'ASSIGN' => 111,
			'DOT' => 110
		},
		DEFAULT => -110
	},
	{#State 22
		ACTIONS => {
			'REF' => 54,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 98,
			'NUMBER' => 7,
			"(" => 32,
			'NOT' => 43,
			'IDENT' => 25,
			"\${" => 36,
			"\"" => 27,
			"{" => 64
		},
		GOTOS => {
			'term' => 60,
			'ident' => 96,
			'expr' => 112,
			'node' => 3,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 23
		DEFAULT => -24
	},
	{#State 24
		DEFAULT => -16
	},
	{#State 25
		DEFAULT => -131
	},
	{#State 26
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			'IDENT' => 25,
			"\${" => 36,
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			'REF' => 54
		},
		GOTOS => {
			'expr' => 113,
			'node' => 3,
			'term' => 60,
			'ident' => 96,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 27
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 114
		}
	},
	{#State 28
		DEFAULT => -41
	},
	{#State 29
		DEFAULT => -38
	},
	{#State 30
		ACTIONS => {
			'IDENT' => 83,
			'FILENAME' => 89,
			'NUMBER' => 88,
			'LITERAL' => 91,
			"\$" => 87,
			"\"" => 84
		},
		GOTOS => {
			'nameargs' => 115,
			'filename' => 82,
			'names' => 92,
			'name' => 90,
			'filepart' => 85
		}
	},
	{#State 31
		ACTIONS => {
			'REF' => 54,
			'NUMBER' => 7,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			'IDENT' => 25,
			"\${" => 36,
			"]" => 117,
			"{" => 64,
			"\"" => 27
		},
		GOTOS => {
			'lterm' => 18,
			'sterm' => 118,
			'term' => 116,
			'node' => 3,
			'item' => 56,
			'range' => 119,
			'list' => 120,
			'ident' => 96
		}
	},
	{#State 32
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 41,
			"\$" => 6,
			"[" => 31
		},
		GOTOS => {
			'assign' => 123,
			'item' => 56,
			'ident' => 122,
			'sterm' => 19,
			'lterm' => 18,
			'term' => 60,
			'expr' => 121,
			'node' => 3
		}
	},
	{#State 33
		ACTIONS => {
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			'REF' => 54,
			"{" => 64,
			"\"" => 27,
			'IDENT' => 25,
			"\${" => 36
		},
		GOTOS => {
			'node' => 3,
			'expr' => 124,
			'ident' => 96,
			'term' => 60,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 34
		DEFAULT => -40
	},
	{#State 35
		DEFAULT => -14
	},
	{#State 36
		ACTIONS => {
			'REF' => 54,
			"\${" => 36,
			'IDENT' => 25,
			'LITERAL' => 98,
			"\"" => 27,
			"\$" => 6,
			'NUMBER' => 7
		},
		GOTOS => {
			'ident' => 96,
			'node' => 3,
			'item' => 56,
			'sterm' => 125
		}
	},
	{#State 37
		DEFAULT => -6
	},
	{#State 38
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			'LITERAL' => 80,
			"\$" => 6
		},
		GOTOS => {
			'ident' => 77,
			'node' => 3,
			'item' => 56,
			'setlist' => 126,
			'assign' => 69
		}
	},
	{#State 39
		DEFAULT => -23
	},
	{#State 40
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 41
		ACTIONS => {
			'ASSIGN' => 127
		},
		DEFAULT => -113
	},
	{#State 42
		ACTIONS => {
			'IDENT' => 131
		},
		DEFAULT => -88,
		GOTOS => {
			'meta' => 130,
			'blockargs' => 128,
			'metadata' => 129
		}
	},
	{#State 43
		ACTIONS => {
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			"\${" => 36,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 98,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'REF' => 54
		},
		GOTOS => {
			'term' => 60,
			'ident' => 96,
			'expr' => 132,
			'node' => 3,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 44
		ACTIONS => {
			'IDENT' => 83,
			'FILENAME' => 89,
			'NUMBER' => 88,
			'LITERAL' => 91,
			"\"" => 84,
			"\$" => 87
		},
		GOTOS => {
			'names' => 92,
			'filename' => 82,
			'nameargs' => 133,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 45
		DEFAULT => -8
	},
	{#State 46
		ACTIONS => {
			"\${" => 36,
			'FILENAME' => 89,
			'IDENT' => 135,
			'NUMBER' => 88,
			"\"" => 136,
			'LITERAL' => 141,
			"\$" => 138
		},
		GOTOS => {
			'filepart' => 85,
			'names' => 92,
			'lnameargs' => 140,
			'filename' => 82,
			'item' => 139,
			'name' => 90,
			'lvalue' => 134,
			'nameargs' => 137
		}
	},
	{#State 47
		ACTIONS => {
			'LITERAL' => 91,
			"\"" => 84,
			"\$" => 87,
			'NUMBER' => 88,
			'IDENT' => 83,
			'FILENAME' => 89
		},
		GOTOS => {
			'names' => 92,
			'nameargs' => 142,
			'filename' => 82,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 48
		DEFAULT => -11
	},
	{#State 49
		DEFAULT => -10
	},
	{#State 50
		DEFAULT => -45
	},
	{#State 51
		DEFAULT => -9
	},
	{#State 52
		ACTIONS => {
			"\"" => 27,
			"{" => 64,
			"\${" => 36,
			'IDENT' => 145,
			'LITERAL' => 98,
			"[" => 31,
			"\$" => 6,
			'NUMBER' => 7,
			'REF' => 54
		},
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56,
			'node' => 3,
			'ident' => 96,
			'term' => 143,
			'loopvar' => 144
		}
	},
	{#State 53
		ACTIONS => {
			'CALL' => 58,
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'INCLUDE' => 63,
			"{" => 64,
			'MACRO' => 59,
			'BLOCK' => 61,
			'rawperl' => 24,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'UNLESS' => 65,
			'VIEW' => 67,
			'NEXT' => 68,
			'META' => 73,
			"\"" => 27,
			'IDENT' => 25,
			'FILTER' => 70,
			'GET' => 26,
			'USE' => 71,
			";" => -19,
			'TRY' => 1,
			'LAST' => 28,
			'RETURN' => 29,
			"[" => 31,
			'WRAPPER' => 30,
			"(" => 32,
			'IF' => 33,
			'TEXT' => 37,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'LITERAL' => 41,
			"\$" => 6,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'DEFAULT' => 38,
			'PROCESS' => 11,
			'FOR' => 52,
			'RAW' => 46,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8
		},
		DEFAULT => -2,
		GOTOS => {
			'atomexpr' => 55,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'term' => 60,
			'expr' => 17,
			'raw' => 35,
			'node' => 3,
			'view' => 62,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'atomdir' => 40,
			'assign' => 69,
			'switch' => 39,
			'chunk' => 146,
			'defblockname' => 42,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'filter' => 50,
			'defblock' => 51,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13
		}
	},
	{#State 54
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"\$" => 6
		},
		GOTOS => {
			'item' => 56,
			'node' => 3,
			'ident' => 147
		}
	},
	{#State 55
		ACTIONS => {
			'WRAPPER' => 148,
			'FOR' => 150,
			'IF' => 149,
			'WHILE' => 153,
			'FILTER' => 152,
			'UNLESS' => 151
		}
	},
	{#State 56
		ACTIONS => {
			"(" => 154
		},
		DEFAULT => -129
	},
	{#State 57
		DEFAULT => -22
	},
	{#State 58
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NOT' => 43,
			'NUMBER' => 7,
			"(" => 32,
			"\$" => 6,
			'LITERAL' => 98,
			"[" => 31
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 155,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 59
		ACTIONS => {
			'IDENT' => 156
		}
	},
	{#State 60
		DEFAULT => -147
	},
	{#State 61
		ACTIONS => {
			'LITERAL' => 157,
			'NUMBER' => 88,
			'IDENT' => 161,
			'FILENAME' => 89
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 158,
			'blockname' => 159,
			'filepart' => 85,
			'meta' => 130,
			'metadata' => 129,
			'filename' => 160
		}
	},
	{#State 62
		DEFAULT => -15
	},
	{#State 63
		ACTIONS => {
			'NUMBER' => 88,
			"\$" => 87,
			"\"" => 84,
			'LITERAL' => 91,
			'FILENAME' => 89,
			'IDENT' => 83
		},
		GOTOS => {
			'filepart' => 85,
			'name' => 90,
			'names' => 92,
			'nameargs' => 162,
			'filename' => 82
		}
	},
	{#State 64
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"\$" => 6,
			'LITERAL' => 165
		},
		DEFAULT => -120,
		GOTOS => {
			'item' => 166,
			'param' => 167,
			'hash' => 164,
			'params' => 163
		}
	},
	{#State 65
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NUMBER' => 7,
			"(" => 32,
			'NOT' => 43,
			"\$" => 6,
			'LITERAL' => 98,
			"[" => 31
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 168,
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18
		}
	},
	{#State 66
		DEFAULT => -12
	},
	{#State 67
		ACTIONS => {
			'IDENT' => 83,
			'FILENAME' => 89,
			'NUMBER' => 88,
			'LITERAL' => 91,
			"\$" => 87,
			"\"" => 84
		},
		GOTOS => {
			'names' => 92,
			'nameargs' => 169,
			'filename' => 82,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 68
		DEFAULT => -42
	},
	{#State 69
		DEFAULT => -150
	},
	{#State 70
		ACTIONS => {
			'FILENAME' => 89,
			"\${" => 36,
			'IDENT' => 135,
			"\"" => 136,
			"\$" => 138,
			'LITERAL' => 141,
			'NUMBER' => 88
		},
		GOTOS => {
			'name' => 90,
			'item' => 139,
			'nameargs' => 137,
			'lvalue' => 134,
			'filepart' => 85,
			'lnameargs' => 170,
			'filename' => 82,
			'names' => 92
		}
	},
	{#State 71
		ACTIONS => {
			'LITERAL' => 141,
			"\"" => 136,
			"\$" => 138,
			'NUMBER' => 88,
			'FILENAME' => 89,
			"\${" => 36,
			'IDENT' => 135
		},
		GOTOS => {
			'nameargs' => 137,
			'lvalue' => 134,
			'name' => 90,
			'item' => 139,
			'filename' => 82,
			'lnameargs' => 171,
			'names' => 92,
			'filepart' => 85
		}
	},
	{#State 72
		DEFAULT => -13
	},
	{#State 73
		ACTIONS => {
			'IDENT' => 131
		},
		GOTOS => {
			'metadata' => 172,
			'meta' => 130
		}
	},
	{#State 74
		DEFAULT => -1
	},
	{#State 75
		ACTIONS => {
			";" => 173
		}
	},
	{#State 76
		ACTIONS => {
			'NUMBER' => 7,
			'INSERT' => 44,
			'NOT' => 43,
			"\$" => 6,
			'LITERAL' => 41,
			'DEFAULT' => 38,
			'PROCESS' => 11,
			'FOR' => 52,
			'RAW' => 46,
			'SET' => 9,
			'THROW' => 47,
			'DEBUG' => 8,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			'WRAPPER' => 30,
			"[" => 31,
			'TEXT' => 37,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'rawperl' => 24,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'NEXT' => 68,
			'VIEW' => 67,
			'META' => 73,
			"\"" => 27,
			'FILTER' => 70,
			'IDENT' => 25,
			'USE' => 71,
			'GET' => 26,
			'CALL' => 58,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'INCLUDE' => 63,
			"{" => 64,
			'BLOCK' => 61,
			'MACRO' => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'expr' => 17,
			'raw' => 35,
			'node' => 3,
			'view' => 62,
			'term' => 60,
			'condition' => 57,
			'wrapper' => 16,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'statement' => 75,
			'try' => 13,
			'defblock' => 51,
			'block' => 174,
			'filter' => 50,
			'anonblock' => 49,
			'javascript' => 10,
			'use' => 72,
			'capture' => 48,
			'directive' => 45,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'switch' => 39,
			'chunk' => 5,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21
		}
	},
	{#State 77
		ACTIONS => {
			'ASSIGN' => 175,
			'DOT' => 110
		}
	},
	{#State 78
		DEFAULT => -149
	},
	{#State 79
		DEFAULT => -148
	},
	{#State 80
		ACTIONS => {
			'ASSIGN' => 127
		}
	},
	{#State 81
		DEFAULT => -133
	},
	{#State 82
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -169
	},
	{#State 83
		DEFAULT => -174
	},
	{#State 84
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 177
		}
	},
	{#State 85
		DEFAULT => -172
	},
	{#State 86
		DEFAULT => -43
	},
	{#State 87
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"\$" => 6
		},
		GOTOS => {
			'item' => 56,
			'ident' => 178,
			'node' => 3
		}
	},
	{#State 88
		DEFAULT => -175
	},
	{#State 89
		DEFAULT => -173
	},
	{#State 90
		DEFAULT => -167
	},
	{#State 91
		DEFAULT => -170
	},
	{#State 92
		ACTIONS => {
			"(" => 179,
			"+" => 181
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 180
		}
	},
	{#State 93
		ACTIONS => {
			"\$" => 6,
			'LITERAL' => 80,
			'COMMA' => 78,
			"\${" => 36,
			'IDENT' => 25
		},
		DEFAULT => -32,
		GOTOS => {
			'node' => 3,
			'ident' => 77,
			'assign' => 79,
			'item' => 56
		}
	},
	{#State 94
		DEFAULT => -36
	},
	{#State 95
		DEFAULT => 0
	},
	{#State 96
		ACTIONS => {
			'DOT' => 110
		},
		DEFAULT => -110
	},
	{#State 97
		ACTIONS => {
			";" => 182,
			'DIV' => 108,
			"/" => 105,
			'OR' => 102,
			'BINOP' => 99,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'MOD' => 104,
			'AND' => 106,
			'CAT' => 103
		}
	},
	{#State 98
		DEFAULT => -113
	},
	{#State 99
		ACTIONS => {
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			"\${" => 36
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 183,
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18
		}
	},
	{#State 100
		ACTIONS => {
			'REF' => 54,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'IDENT' => 25,
			"\${" => 36,
			"\"" => 27,
			"{" => 64
		},
		GOTOS => {
			'expr' => 184,
			'node' => 3,
			'term' => 60,
			'ident' => 96,
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56
		}
	},
	{#State 101
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			"\${" => 36,
			'IDENT' => 25,
			'NOT' => 43,
			"(" => 32,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 98,
			"\$" => 6,
			'REF' => 54
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 185,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 102
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			'IDENT' => 25,
			"\${" => 36,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 98,
			"[" => 31,
			"\$" => 6,
			'REF' => 54
		},
		GOTOS => {
			'term' => 60,
			'ident' => 96,
			'expr' => 186,
			'node' => 3,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 103
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			'IDENT' => 25,
			"\${" => 36,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 98,
			"\$" => 6,
			'REF' => 54
		},
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56,
			'expr' => 187,
			'node' => 3,
			'term' => 60,
			'ident' => 96
		}
	},
	{#State 104
		ACTIONS => {
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'REF' => 54,
			"{" => 64,
			"\"" => 27,
			"\${" => 36,
			'IDENT' => 25
		},
		GOTOS => {
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'ident' => 96,
			'expr' => 188,
			'node' => 3
		}
	},
	{#State 105
		ACTIONS => {
			'REF' => 54,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 98,
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 189,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 106
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"\"" => 27,
			"{" => 64,
			'REF' => 54,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43
		},
		GOTOS => {
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18,
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 190
		}
	},
	{#State 107
		ACTIONS => {
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			"\${" => 36
		},
		GOTOS => {
			'expr' => 191,
			'node' => 3,
			'term' => 60,
			'ident' => 96,
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56
		}
	},
	{#State 108
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			"\${" => 36,
			'IDENT' => 25,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98,
			'REF' => 54
		},
		GOTOS => {
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18,
			'term' => 60,
			'ident' => 96,
			'expr' => 192,
			'node' => 3
		}
	},
	{#State 109
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 193
		}
	},
	{#State 110
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"\$" => 6,
			'NUMBER' => 195
		},
		GOTOS => {
			'item' => 56,
			'node' => 194
		}
	},
	{#State 111
		ACTIONS => {
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'BLOCK' => 197,
			'INCLUDE' => 63,
			"{" => 64,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'NEXT' => 68,
			'FILTER' => 70,
			'IDENT' => 25,
			'GET' => 26,
			"\"" => 27,
			'LAST' => 28,
			'RETURN' => 29,
			'TRY' => 1,
			"[" => 31,
			'WRAPPER' => 30,
			'IF' => 33,
			"(" => 32,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'DEFAULT' => 38,
			'LITERAL' => 41,
			"\$" => 6,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			'PROCESS' => 11,
			'FOR' => 52
		},
		GOTOS => {
			'atomexpr' => 55,
			'item' => 56,
			'setlist' => 2,
			'wrapper' => 16,
			'condition' => 57,
			'term' => 60,
			'node' => 3,
			'expr' => 199,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 122,
			'loop' => 23,
			'switch' => 39,
			'mdir' => 198,
			'atomdir' => 40,
			'assign' => 69,
			'directive' => 196,
			'javascript' => 10,
			'filter' => 50,
			'try' => 13
		}
	},
	{#State 112
		ACTIONS => {
			'CAT' => 103,
			'AND' => 106,
			'MOD' => 104,
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100,
			'BINOP' => 99,
			'OR' => 102,
			"/" => 105,
			'DIV' => 108,
			";" => 200
		}
	},
	{#State 113
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 99,
			'OR' => 102,
			'CAT' => 103,
			"/" => 105,
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100,
			'AND' => 106,
			'DIV' => 108
		},
		DEFAULT => -30
	},
	{#State 114
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"\"" => 205,
			"\$" => 6,
			";" => 203,
			'TEXT' => 201
		},
		GOTOS => {
			'node' => 3,
			'quotable' => 202,
			'ident' => 204,
			'item' => 56
		}
	},
	{#State 115
		ACTIONS => {
			";" => 206
		}
	},
	{#State 116
		DEFAULT => -117
	},
	{#State 117
		DEFAULT => -108
	},
	{#State 118
		ACTIONS => {
			'TO' => 207
		},
		DEFAULT => -105
	},
	{#State 119
		ACTIONS => {
			"]" => 208
		}
	},
	{#State 120
		ACTIONS => {
			"\${" => 36,
			'COMMA' => 211,
			"]" => 209,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 98,
			"\$" => 6
		},
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56,
			'node' => 3,
			'ident' => 96,
			'term' => 210
		}
	},
	{#State 121
		ACTIONS => {
			'DIV' => 108,
			"/" => 105,
			"+" => 101,
			'MOD' => 104,
			'CMPOP' => 107,
			"?" => 100,
			'BINOP' => 99,
			'OR' => 102,
			'CAT' => 103,
			")" => 212,
			'AND' => 106
		}
	},
	{#State 122
		ACTIONS => {
			'DOT' => 110,
			'ASSIGN' => 175
		},
		DEFAULT => -110
	},
	{#State 123
		ACTIONS => {
			")" => 213
		}
	},
	{#State 124
		ACTIONS => {
			'OR' => 102,
			'BINOP' => 99,
			"?" => 100,
			'CMPOP' => 107,
			'MOD' => 104,
			"+" => 101,
			'AND' => 106,
			'CAT' => 103,
			";" => 214,
			'DIV' => 108,
			"/" => 105
		}
	},
	{#State 125
		ACTIONS => {
			"}" => 215
		}
	},
	{#State 126
		ACTIONS => {
			"\$" => 6,
			'LITERAL' => 80,
			"\${" => 36,
			'COMMA' => 78,
			'IDENT' => 25
		},
		DEFAULT => -33,
		GOTOS => {
			'ident' => 77,
			'node' => 3,
			'assign' => 79,
			'item' => 56
		}
	},
	{#State 127
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			'IDENT' => 25,
			"\${" => 36,
			'NOT' => 43,
			'NUMBER' => 7,
			"(" => 32,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'REF' => 54
		},
		GOTOS => {
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 216,
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18
		}
	},
	{#State 128
		ACTIONS => {
			";" => 217
		}
	},
	{#State 129
		ACTIONS => {
			'COMMA' => 218,
			'IDENT' => 131
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 219
		}
	},
	{#State 130
		DEFAULT => -100
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => 220
		}
	},
	{#State 132
		ACTIONS => {
			"+" => 101,
			'CMPOP' => 107,
			"/" => 105,
			'BINOP' => 99,
			'MOD' => 104,
			'CAT' => 103,
			'DIV' => 108
		},
		DEFAULT => -143
	},
	{#State 133
		DEFAULT => -34
	},
	{#State 134
		ACTIONS => {
			'ASSIGN' => 221
		}
	},
	{#State 135
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 136
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 222
		}
	},
	{#State 137
		DEFAULT => -159
	},
	{#State 138
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 223,
			"\$" => 6
		},
		GOTOS => {
			'ident' => 178,
			'node' => 3,
			'item' => 56
		}
	},
	{#State 139
		DEFAULT => -160
	},
	{#State 140
		DEFAULT => -76
	},
	{#State 141
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 142
		DEFAULT => -37
	},
	{#State 143
		DEFAULT => -157,
		GOTOS => {
			'args' => 224
		}
	},
	{#State 144
		ACTIONS => {
			";" => 225
		}
	},
	{#State 145
		ACTIONS => {
			'IN' => 226,
			'ASSIGN' => 227
		},
		DEFAULT => -131
	},
	{#State 146
		DEFAULT => -4
	},
	{#State 147
		ACTIONS => {
			'DOT' => 110
		},
		DEFAULT => -111
	},
	{#State 148
		ACTIONS => {
			'FILENAME' => 89,
			'IDENT' => 83,
			"\"" => 84,
			"\$" => 87,
			'LITERAL' => 91,
			'NUMBER' => 88
		},
		GOTOS => {
			'names' => 92,
			'nameargs' => 228,
			'filename' => 82,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 149
		ACTIONS => {
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'NOT' => 43,
			"(" => 32,
			'NUMBER' => 7,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			"\${" => 36,
			'IDENT' => 25
		},
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56,
			'expr' => 229,
			'node' => 3,
			'term' => 60,
			'ident' => 96
		}
	},
	{#State 150
		ACTIONS => {
			'REF' => 54,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 98,
			"\$" => 6,
			'IDENT' => 145,
			"\${" => 36,
			"{" => 64,
			"\"" => 27
		},
		GOTOS => {
			'loopvar' => 230,
			'term' => 143,
			'ident' => 96,
			'node' => 3,
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18
		}
	},
	{#State 151
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NOT' => 43,
			"(" => 32,
			'NUMBER' => 7,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 98
		},
		GOTOS => {
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 231
		}
	},
	{#State 152
		ACTIONS => {
			'FILENAME' => 89,
			"\${" => 36,
			'IDENT' => 135,
			"\"" => 136,
			'LITERAL' => 141,
			"\$" => 138,
			'NUMBER' => 88
		},
		GOTOS => {
			'lvalue' => 134,
			'nameargs' => 137,
			'item' => 139,
			'name' => 90,
			'names' => 92,
			'lnameargs' => 232,
			'filename' => 82,
			'filepart' => 85
		}
	},
	{#State 153
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"\"" => 27,
			"{" => 64,
			'REF' => 54,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32
		},
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'item' => 56,
			'node' => 3,
			'expr' => 233,
			'ident' => 96,
			'term' => 60
		}
	},
	{#State 154
		DEFAULT => -157,
		GOTOS => {
			'args' => 234
		}
	},
	{#State 155
		ACTIONS => {
			"/" => 105,
			'OR' => 102,
			'BINOP' => 99,
			'MOD' => 104,
			'CAT' => 103,
			'DIV' => 108,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'AND' => 106
		},
		DEFAULT => -31
	},
	{#State 156
		ACTIONS => {
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			'IF' => 33,
			"(" => 235,
			'WRAPPER' => 30,
			"[" => 31,
			'PROCESS' => 11,
			'FOR' => 52,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 41,
			"\$" => 6,
			'DEFAULT' => 38,
			'INCLUDE' => 63,
			"{" => 64,
			'BLOCK' => 197,
			'CALL' => 58,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			"\"" => 27,
			'FILTER' => 70,
			'IDENT' => 25,
			'GET' => 26,
			'UNLESS' => 65,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'NEXT' => 68
		},
		GOTOS => {
			'try' => 13,
			'javascript' => 10,
			'filter' => 50,
			'directive' => 196,
			'switch' => 39,
			'atomdir' => 40,
			'mdir' => 236,
			'assign' => 69,
			'loop' => 23,
			'ident' => 122,
			'sterm' => 19,
			'lterm' => 18,
			'node' => 3,
			'expr' => 237,
			'term' => 60,
			'wrapper' => 16,
			'condition' => 57,
			'item' => 56,
			'setlist' => 2,
			'atomexpr' => 55
		}
	},
	{#State 157
		DEFAULT => -86
	},
	{#State 158
		ACTIONS => {
			";" => 238
		}
	},
	{#State 159
		DEFAULT => -84
	},
	{#State 160
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -85
	},
	{#State 161
		ACTIONS => {
			'ASSIGN' => 220
		},
		DEFAULT => -174
	},
	{#State 162
		DEFAULT => -35
	},
	{#State 163
		ACTIONS => {
			"\${" => 36,
			'COMMA' => 240,
			'IDENT' => 25,
			"\$" => 6,
			'LITERAL' => 165
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 166,
			'param' => 239
		}
	},
	{#State 164
		ACTIONS => {
			"}" => 241
		}
	},
	{#State 165
		ACTIONS => {
			'ASSIGN' => 242
		}
	},
	{#State 166
		ACTIONS => {
			'ASSIGN' => 243
		}
	},
	{#State 167
		DEFAULT => -123
	},
	{#State 168
		ACTIONS => {
			'OR' => 102,
			'BINOP' => 99,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'MOD' => 104,
			'AND' => 106,
			'CAT' => 103,
			";" => 244,
			'DIV' => 108,
			"/" => 105
		}
	},
	{#State 169
		ACTIONS => {
			";" => 245
		}
	},
	{#State 170
		ACTIONS => {
			";" => 246
		}
	},
	{#State 171
		DEFAULT => -75
	},
	{#State 172
		ACTIONS => {
			'IDENT' => 131,
			'COMMA' => 218
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 219
		}
	},
	{#State 173
		DEFAULT => -7
	},
	{#State 174
		ACTIONS => {
			'CATCH' => 248,
			'FINAL' => 247
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 249
		}
	},
	{#State 175
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NOT' => 43,
			'NUMBER' => 7,
			"(" => 32,
			'LITERAL' => 98,
			"[" => 31,
			"\$" => 6
		},
		GOTOS => {
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'ident' => 96,
			'expr' => 250,
			'node' => 3
		}
	},
	{#State 176
		ACTIONS => {
			'FILENAME' => 89,
			'IDENT' => 83,
			'NUMBER' => 88
		},
		GOTOS => {
			'filepart' => 251
		}
	},
	{#State 177
		ACTIONS => {
			";" => 203,
			'TEXT' => 201,
			"\"" => 252,
			"\$" => 6,
			'IDENT' => 25,
			"\${" => 36
		},
		GOTOS => {
			'ident' => 204,
			'node' => 3,
			'quotable' => 202,
			'item' => 56
		}
	},
	{#State 178
		ACTIONS => {
			'DOT' => 110
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 253
		}
	},
	{#State 179
		DEFAULT => -157,
		GOTOS => {
			'args' => 254
		}
	},
	{#State 180
		ACTIONS => {
			"\$" => 6,
			'LITERAL' => 255,
			'NOT' => 43,
			'NUMBER' => 7,
			"\"" => 27,
			'COMMA' => 258,
			'IDENT' => 25,
			"[" => 31,
			"(" => 32,
			'REF' => 54,
			"{" => 64,
			"\${" => 36
		},
		DEFAULT => -164,
		GOTOS => {
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'node' => 3,
			'expr' => 260,
			'item' => 256,
			'param' => 257,
			'ident' => 259
		}
	},
	{#State 181
		ACTIONS => {
			'FILENAME' => 89,
			'IDENT' => 83,
			"\"" => 84,
			'LITERAL' => 91,
			'NUMBER' => 88
		},
		GOTOS => {
			'filename' => 82,
			'filepart' => 85,
			'name' => 261
		}
	},
	{#State 182
		ACTIONS => {
			'DEFAULT' => 38,
			"\$" => 6,
			'LITERAL' => 41,
			'INSERT' => 44,
			'NUMBER' => 7,
			'NOT' => 43,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'RAW' => 46,
			'FOR' => 52,
			'PROCESS' => 11,
			"[" => 31,
			'WRAPPER' => 30,
			'IF' => 33,
			"(" => 32,
			";" => -19,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			'TEXT' => 37,
			'VIEW' => 67,
			'NEXT' => 68,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'rawperl' => 24,
			'GET' => 26,
			'USE' => 71,
			'IDENT' => 25,
			'FILTER' => 70,
			"\"" => 27,
			'META' => 73,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			"{" => 64,
			'INCLUDE' => 63
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 13,
			'statement' => 75,
			'anonblock' => 49,
			'javascript' => 10,
			'defblock' => 51,
			'block' => 262,
			'filter' => 50,
			'capture' => 48,
			'use' => 72,
			'directive' => 45,
			'defblockname' => 42,
			'chunk' => 5,
			'switch' => 39,
			'assign' => 69,
			'atomdir' => 40,
			'macro' => 66,
			'loop' => 23,
			'ident' => 21,
			'lterm' => 18,
			'sterm' => 19,
			'node' => 3,
			'view' => 62,
			'expr' => 17,
			'raw' => 35,
			'term' => 60,
			'condition' => 57,
			'wrapper' => 16,
			'item' => 56,
			'setlist' => 2,
			'atomexpr' => 55,
			'chunks' => 53
		}
	},
	{#State 183
		ACTIONS => {
			'DIV' => 108,
			"+" => 101,
			'MOD' => 104,
			"/" => 105
		},
		DEFAULT => -134
	},
	{#State 184
		ACTIONS => {
			'AND' => 106,
			'CAT' => 103,
			'OR' => 102,
			'BINOP' => 99,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'MOD' => 104,
			"/" => 105,
			":" => 263,
			'DIV' => 108
		}
	},
	{#State 185
		ACTIONS => {
			'DIV' => 108,
			"/" => 105,
			'MOD' => 104
		},
		DEFAULT => -136
	},
	{#State 186
		ACTIONS => {
			'DIV' => 108,
			'CMPOP' => 107,
			"+" => 101,
			'CAT' => 103,
			'BINOP' => 99,
			'MOD' => 104,
			"/" => 105
		},
		DEFAULT => -142
	},
	{#State 187
		ACTIONS => {
			'CMPOP' => 107,
			"+" => 101,
			"/" => 105,
			'MOD' => 104,
			'BINOP' => 99,
			'DIV' => 108
		},
		DEFAULT => -140
	},
	{#State 188
		DEFAULT => -138
	},
	{#State 189
		ACTIONS => {
			'MOD' => 104,
			'DIV' => 108
		},
		DEFAULT => -135
	},
	{#State 190
		ACTIONS => {
			"+" => 101,
			'CMPOP' => 107,
			'CAT' => 103,
			'MOD' => 104,
			'BINOP' => 99,
			"/" => 105,
			'DIV' => 108
		},
		DEFAULT => -141
	},
	{#State 191
		ACTIONS => {
			"+" => 101,
			"/" => 105,
			'MOD' => 104,
			'BINOP' => 99,
			'DIV' => 108
		},
		DEFAULT => -139
	},
	{#State 192
		ACTIONS => {
			'MOD' => 104
		},
		DEFAULT => -137
	},
	{#State 193
		ACTIONS => {
			";" => -19,
			'LAST' => 28,
			'TRY' => 1,
			'RETURN' => 29,
			'WRAPPER' => 30,
			"[" => 31,
			'IF' => 33,
			"(" => 32,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'TEXT' => 37,
			'DEFAULT' => 38,
			"\$" => 6,
			'LITERAL' => 41,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'RAW' => 46,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8,
			'PROCESS' => 11,
			'FOR' => 52,
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			'INCLUDE' => 63,
			"{" => 64,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'UNLESS' => 65,
			'NEXT' => 68,
			'VIEW' => 67,
			'rawperl' => 24,
			'IDENT' => 25,
			'FILTER' => 70,
			'GET' => 26,
			'USE' => 71,
			'META' => 73,
			"\"" => 27
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 60,
			'expr' => 17,
			'raw' => 35,
			'node' => 3,
			'view' => 62,
			'sterm' => 19,
			'lterm' => 18,
			'chunks' => 53,
			'atomexpr' => 55,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'block' => 264,
			'defblock' => 51,
			'filter' => 50,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'assign' => 69,
			'atomdir' => 40,
			'chunk' => 5,
			'switch' => 39,
			'defblockname' => 42
		}
	},
	{#State 194
		DEFAULT => -126
	},
	{#State 195
		DEFAULT => -127
	},
	{#State 196
		DEFAULT => -93
	},
	{#State 197
		ACTIONS => {
			";" => 265
		}
	},
	{#State 198
		DEFAULT => -90
	},
	{#State 199
		ACTIONS => {
			"/" => 105,
			"\$" => -151,
			'LITERAL' => -151,
			'IDENT' => -151,
			'CAT' => 103,
			'COMMA' => -151,
			'OR' => 102,
			'BINOP' => 99,
			'MOD' => 104,
			";" => -151,
			'DIV' => 108,
			'AND' => 106,
			"\${" => -151,
			"?" => 100,
			"+" => 101,
			'CMPOP' => 107
		},
		DEFAULT => -28
	},
	{#State 200
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 266
		}
	},
	{#State 201
		DEFAULT => -179
	},
	{#State 202
		DEFAULT => -176
	},
	{#State 203
		DEFAULT => -180
	},
	{#State 204
		ACTIONS => {
			'DOT' => 110
		},
		DEFAULT => -178
	},
	{#State 205
		DEFAULT => -112
	},
	{#State 206
		ACTIONS => {
			'INCLUDE' => 63,
			"{" => 64,
			'BLOCK' => 61,
			'MACRO' => 59,
			'CALL' => 58,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'META' => 73,
			"\"" => 27,
			'IDENT' => 25,
			'FILTER' => 70,
			'USE' => 71,
			'GET' => 26,
			'rawperl' => 24,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'NEXT' => 68,
			'VIEW' => 67,
			'TEXT' => 37,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			'WRAPPER' => 30,
			"[" => 31,
			'PROCESS' => 11,
			'FOR' => 52,
			'RAW' => 46,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'LITERAL' => 41,
			"\$" => 6,
			'DEFAULT' => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 57,
			'wrapper' => 16,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'sterm' => 19,
			'lterm' => 18,
			'raw' => 35,
			'expr' => 17,
			'node' => 3,
			'view' => 62,
			'term' => 60,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'chunk' => 5,
			'switch' => 39,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21,
			'statement' => 75,
			'try' => 13,
			'filter' => 50,
			'block' => 267,
			'defblock' => 51,
			'anonblock' => 49,
			'javascript' => 10,
			'capture' => 48,
			'use' => 72,
			'directive' => 45
		}
	},
	{#State 207
		ACTIONS => {
			'IDENT' => 25,
			'REF' => 54,
			"\${" => 36,
			'LITERAL' => 98,
			"\"" => 27,
			"\$" => 6,
			'NUMBER' => 7
		},
		GOTOS => {
			'node' => 3,
			'ident' => 96,
			'sterm' => 268,
			'item' => 56
		}
	},
	{#State 208
		DEFAULT => -107
	},
	{#State 209
		DEFAULT => -106
	},
	{#State 210
		DEFAULT => -115
	},
	{#State 211
		DEFAULT => -116
	},
	{#State 212
		DEFAULT => -146
	},
	{#State 213
		DEFAULT => -145
	},
	{#State 214
		ACTIONS => {
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 41,
			"\$" => 6,
			'RAW' => 46,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			'PROCESS' => 11,
			'FOR' => 52,
			'TRY' => 1,
			'LAST' => 28,
			'RETURN' => 29,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			"[" => 31,
			'WRAPPER' => 30,
			"\${" => 36,
			'STOP' => 4,
			'CLEAR' => 34,
			'TEXT' => 37,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'NEXT' => 68,
			'VIEW' => 67,
			'rawperl' => 24,
			'IDENT' => 25,
			'FILTER' => 70,
			'USE' => 71,
			'GET' => 26,
			'META' => 73,
			"\"" => 27,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'CALL' => 58,
			'BLOCK' => 61,
			'MACRO' => 59,
			'INCLUDE' => 63,
			"{" => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'javascript' => 10,
			'anonblock' => 49,
			'filter' => 50,
			'block' => 269,
			'defblock' => 51,
			'try' => 13,
			'statement' => 75,
			'ident' => 21,
			'macro' => 66,
			'loop' => 23,
			'chunk' => 5,
			'switch' => 39,
			'assign' => 69,
			'atomdir' => 40,
			'defblockname' => 42,
			'term' => 60,
			'view' => 62,
			'node' => 3,
			'raw' => 35,
			'expr' => 17,
			'lterm' => 18,
			'sterm' => 19,
			'chunks' => 53,
			'atomexpr' => 55,
			'item' => 56,
			'setlist' => 2,
			'wrapper' => 16,
			'condition' => 57
		}
	},
	{#State 215
		DEFAULT => -132
	},
	{#State 216
		ACTIONS => {
			"/" => 105,
			'CAT' => 103,
			'MOD' => 104,
			'BINOP' => 99,
			'OR' => 102,
			'DIV' => 108,
			'AND' => 106,
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100
		},
		DEFAULT => -152
	},
	{#State 217
		ACTIONS => {
			"\"" => 27,
			'META' => 73,
			'USE' => 71,
			'GET' => 26,
			'IDENT' => 25,
			'FILTER' => 70,
			'rawperl' => 24,
			'VIEW' => 67,
			'NEXT' => 68,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			"{" => 64,
			'INCLUDE' => 63,
			'BLOCK' => 61,
			'MACRO' => 59,
			'CALL' => 58,
			'REF' => 54,
			'SWITCH' => 15,
			'perl' => 14,
			'FOR' => 52,
			'PROCESS' => 11,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'RAW' => 46,
			'NUMBER' => 7,
			'INSERT' => 44,
			'NOT' => 43,
			"\$" => 6,
			'LITERAL' => 41,
			'DEFAULT' => 38,
			'TEXT' => 37,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			"(" => 32,
			'IF' => 33,
			'WRAPPER' => 30,
			"[" => 31,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 21,
			'macro' => 66,
			'loop' => 23,
			'assign' => 69,
			'use' => 72,
			'block' => 74,
			'statement' => 75,
			'chunks' => 53,
			'atomexpr' => 55,
			'item' => 56,
			'condition' => 57,
			'wrapper' => 16,
			'term' => 60,
			'view' => 62,
			'expr' => 17,
			'sterm' => 19,
			'lterm' => 18,
			'switch' => 39,
			'chunk' => 5,
			'atomdir' => 40,
			'defblockname' => 42,
			'directive' => 45,
			'capture' => 48,
			'anonblock' => 49,
			'javascript' => 10,
			'defblock' => 51,
			'filter' => 50,
			'try' => 13,
			'template' => 270,
			'setlist' => 2,
			'node' => 3,
			'raw' => 35
		}
	},
	{#State 218
		DEFAULT => -99
	},
	{#State 219
		DEFAULT => -98
	},
	{#State 220
		ACTIONS => {
			'NUMBER' => 272,
			'LITERAL' => 271,
			"\"" => 273
		}
	},
	{#State 221
		ACTIONS => {
			'FILENAME' => 89,
			'IDENT' => 83,
			'NUMBER' => 88,
			"\"" => 84,
			'LITERAL' => 91,
			"\$" => 87
		},
		GOTOS => {
			'names' => 92,
			'filename' => 82,
			'nameargs' => 274,
			'filepart' => 85,
			'name' => 90
		}
	},
	{#State 222
		ACTIONS => {
			'TEXT' => 201,
			";" => 203,
			"\$" => 6,
			"\"" => 275,
			'IDENT' => 25,
			"\${" => 36
		},
		GOTOS => {
			'ident' => 204,
			'node' => 3,
			'quotable' => 202,
			'item' => 56
		}
	},
	{#State 223
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 224
		ACTIONS => {
			'REF' => 54,
			'LITERAL' => 255,
			"[" => 31,
			"\$" => 6,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'IDENT' => 25,
			'COMMA' => 258,
			"\${" => 36,
			"\"" => 27,
			"{" => 64
		},
		DEFAULT => -66,
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'term' => 60,
			'node' => 3,
			'expr' => 260,
			'item' => 256,
			'param' => 257,
			'ident' => 259
		}
	},
	{#State 225
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 276
		}
	},
	{#State 226
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 98,
			"\$" => 6
		},
		GOTOS => {
			'term' => 277,
			'ident' => 96,
			'node' => 3,
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18
		}
	},
	{#State 227
		ACTIONS => {
			'REF' => 54,
			'NUMBER' => 7,
			"\$" => 6,
			'LITERAL' => 98,
			"[" => 31,
			'IDENT' => 25,
			"\${" => 36,
			"{" => 64,
			"\"" => 27
		},
		GOTOS => {
			'node' => 3,
			'ident' => 96,
			'term' => 278,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 228
		DEFAULT => -68
	},
	{#State 229
		ACTIONS => {
			'AND' => 106,
			'CAT' => 103,
			'BINOP' => 99,
			'OR' => 102,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'MOD' => 104,
			"/" => 105,
			'DIV' => 108
		},
		DEFAULT => -47
	},
	{#State 230
		DEFAULT => -60
	},
	{#State 231
		ACTIONS => {
			'DIV' => 108,
			"/" => 105,
			'BINOP' => 99,
			'OR' => 102,
			"?" => 100,
			'CMPOP' => 107,
			'MOD' => 104,
			"+" => 101,
			'AND' => 106,
			'CAT' => 103
		},
		DEFAULT => -49
	},
	{#State 232
		DEFAULT => -82
	},
	{#State 233
		ACTIONS => {
			'DIV' => 108,
			"/" => 105,
			'CMPOP' => 107,
			"+" => 101,
			'MOD' => 104,
			'OR' => 102,
			'BINOP' => 99,
			"?" => 100,
			'CAT' => 103,
			'AND' => 106
		},
		DEFAULT => -63
	},
	{#State 234
		ACTIONS => {
			'LITERAL' => 255,
			"[" => 31,
			"\$" => 6,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			")" => 279,
			'COMMA' => 258,
			"\${" => 36
		},
		GOTOS => {
			'term' => 60,
			'node' => 3,
			'expr' => 260,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 259,
			'item' => 256,
			'param' => 257
		}
	},
	{#State 235
		ACTIONS => {
			"{" => 64,
			"\"" => 27,
			"\${" => 36,
			'IDENT' => 280,
			"(" => 32,
			'NOT' => 43,
			'NUMBER' => 7,
			"[" => 31,
			'LITERAL' => 41,
			"\$" => 6,
			'REF' => 54
		},
		GOTOS => {
			'term' => 60,
			'expr' => 121,
			'node' => 3,
			'margs' => 281,
			'sterm' => 19,
			'lterm' => 18,
			'ident' => 122,
			'assign' => 123,
			'item' => 56
		}
	},
	{#State 236
		DEFAULT => -92
	},
	{#State 237
		ACTIONS => {
			'DIV' => 108,
			'AND' => 106,
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100,
			"/" => 105,
			'CAT' => 103,
			'MOD' => 104,
			'OR' => 102,
			'BINOP' => 99
		},
		DEFAULT => -28
	},
	{#State 238
		ACTIONS => {
			"[" => 31,
			'WRAPPER' => 30,
			"(" => 32,
			'IF' => 33,
			";" => -19,
			'LAST' => 28,
			'TRY' => 1,
			'RETURN' => 29,
			'TEXT' => 37,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			"\$" => 6,
			'LITERAL' => 41,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'DEFAULT' => 38,
			'FOR' => 52,
			'PROCESS' => 11,
			'SET' => 9,
			'THROW' => 47,
			'DEBUG' => 8,
			'RAW' => 46,
			'CALL' => 58,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			"{" => 64,
			'INCLUDE' => 63,
			'MACRO' => 59,
			'BLOCK' => 61,
			'rawperl' => 24,
			'NEXT' => 68,
			'VIEW' => 67,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'UNLESS' => 65,
			"\"" => 27,
			'META' => 73,
			'GET' => 26,
			'USE' => 71,
			'FILTER' => 70,
			'IDENT' => 25
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 75,
			'try' => 13,
			'filter' => 50,
			'block' => 282,
			'defblock' => 51,
			'javascript' => 10,
			'anonblock' => 49,
			'use' => 72,
			'capture' => 48,
			'directive' => 45,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'switch' => 39,
			'chunk' => 5,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21,
			'sterm' => 19,
			'lterm' => 18,
			'expr' => 17,
			'raw' => 35,
			'node' => 3,
			'view' => 62,
			'term' => 60,
			'wrapper' => 16,
			'condition' => 57,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53
		}
	},
	{#State 239
		DEFAULT => -121
	},
	{#State 240
		DEFAULT => -122
	},
	{#State 241
		DEFAULT => -109
	},
	{#State 242
		ACTIONS => {
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'REF' => 54,
			"{" => 64,
			"\"" => 27,
			"\${" => 36,
			'IDENT' => 25
		},
		GOTOS => {
			'item' => 56,
			'sterm' => 19,
			'lterm' => 18,
			'ident' => 96,
			'term' => 60,
			'node' => 3,
			'expr' => 283
		}
	},
	{#State 243
		ACTIONS => {
			'REF' => 54,
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32,
			'LITERAL' => 98,
			"[" => 31,
			"\$" => 6,
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27
		},
		GOTOS => {
			'term' => 60,
			'ident' => 96,
			'expr' => 284,
			'node' => 3,
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 244
		ACTIONS => {
			'FILTER' => 70,
			'IDENT' => 25,
			'GET' => 26,
			'USE' => 71,
			'META' => 73,
			"\"" => 27,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'NEXT' => 68,
			'VIEW' => 67,
			'rawperl' => 24,
			'MACRO' => 59,
			'BLOCK' => 61,
			'INCLUDE' => 63,
			"{" => 64,
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'RAW' => 46,
			'DEBUG' => 8,
			'SET' => 9,
			'THROW' => 47,
			'PROCESS' => 11,
			'FOR' => 52,
			'DEFAULT' => 38,
			'LITERAL' => 41,
			"\$" => 6,
			'NUMBER' => 7,
			'INSERT' => 44,
			'NOT' => 43,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'TEXT' => 37,
			";" => -19,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			'WRAPPER' => 30,
			"[" => 31,
			'IF' => 33,
			"(" => 32
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 45,
			'capture' => 48,
			'use' => 72,
			'defblock' => 51,
			'block' => 285,
			'filter' => 50,
			'javascript' => 10,
			'anonblock' => 49,
			'statement' => 75,
			'try' => 13,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'assign' => 69,
			'atomdir' => 40,
			'switch' => 39,
			'chunk' => 5,
			'defblockname' => 42,
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'view' => 62,
			'node' => 3,
			'sterm' => 19,
			'lterm' => 18,
			'chunks' => 53,
			'atomexpr' => 55,
			'setlist' => 2,
			'item' => 56,
			'condition' => 57,
			'wrapper' => 16
		}
	},
	{#State 245
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 286
		}
	},
	{#State 246
		ACTIONS => {
			'MACRO' => 59,
			'BLOCK' => 61,
			"{" => 64,
			'INCLUDE' => 63,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			'CALL' => 58,
			'GET' => 26,
			'USE' => 71,
			'IDENT' => 25,
			'FILTER' => 70,
			"\"" => 27,
			'META' => 73,
			'VIEW' => 67,
			'NEXT' => 68,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'UNLESS' => 65,
			'rawperl' => 24,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			'TEXT' => 37,
			"[" => 31,
			'WRAPPER' => 30,
			"(" => 32,
			'IF' => 33,
			";" => -19,
			'LAST' => 28,
			'TRY' => 1,
			'RETURN' => 29,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8,
			'RAW' => 46,
			'FOR' => 52,
			'PROCESS' => 11,
			'DEFAULT' => 38,
			'LITERAL' => 41,
			"\$" => 6,
			'INSERT' => 44,
			'NUMBER' => 7,
			'NOT' => 43
		},
		DEFAULT => -3,
		GOTOS => {
			'lterm' => 18,
			'sterm' => 19,
			'raw' => 35,
			'expr' => 17,
			'view' => 62,
			'node' => 3,
			'term' => 60,
			'condition' => 57,
			'wrapper' => 16,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'statement' => 75,
			'try' => 13,
			'filter' => 50,
			'defblock' => 51,
			'block' => 287,
			'javascript' => 10,
			'anonblock' => 49,
			'use' => 72,
			'capture' => 48,
			'directive' => 45,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'chunk' => 5,
			'switch' => 39,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21
		}
	},
	{#State 247
		ACTIONS => {
			";" => 288
		}
	},
	{#State 248
		ACTIONS => {
			'NUMBER' => 88,
			";" => 290,
			'DEFAULT' => 289,
			'FILENAME' => 89,
			'IDENT' => 83
		},
		GOTOS => {
			'filename' => 291,
			'filepart' => 85
		}
	},
	{#State 249
		ACTIONS => {
			'END' => 292
		}
	},
	{#State 250
		ACTIONS => {
			"/" => 105,
			'CAT' => 103,
			'MOD' => 104,
			'OR' => 102,
			'BINOP' => 99,
			'DIV' => 108,
			'AND' => 106,
			'CMPOP' => 107,
			"+" => 101,
			"?" => 100
		},
		DEFAULT => -151
	},
	{#State 251
		DEFAULT => -171
	},
	{#State 252
		DEFAULT => -168
	},
	{#State 253
		ACTIONS => {
			'IDENT' => 25,
			'COMMA' => 258,
			"\"" => 27,
			"\$" => 6,
			'LITERAL' => 255,
			'NUMBER' => 7,
			'NOT' => 43,
			"\${" => 36,
			"{" => 64,
			'REF' => 54,
			"[" => 31,
			"(" => 32
		},
		DEFAULT => -163,
		GOTOS => {
			'term' => 60,
			'node' => 3,
			'expr' => 260,
			'sterm' => 19,
			'lterm' => 18,
			'ident' => 259,
			'item' => 256,
			'param' => 257
		}
	},
	{#State 254
		ACTIONS => {
			'LITERAL' => 255,
			"\$" => 6,
			"[" => 31,
			'NUMBER' => 7,
			'NOT' => 43,
			"(" => 32,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			")" => 293,
			'COMMA' => 258,
			"\${" => 36
		},
		GOTOS => {
			'expr' => 260,
			'node' => 3,
			'term' => 60,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 259,
			'param' => 257,
			'item' => 256
		}
	},
	{#State 255
		ACTIONS => {
			'ASSIGN' => 242
		},
		DEFAULT => -113
	},
	{#State 256
		ACTIONS => {
			'ASSIGN' => 243,
			"(" => 154
		},
		DEFAULT => -129
	},
	{#State 257
		DEFAULT => -154
	},
	{#State 258
		DEFAULT => -156
	},
	{#State 259
		ACTIONS => {
			'ASSIGN' => 294,
			'DOT' => 110
		},
		DEFAULT => -110
	},
	{#State 260
		ACTIONS => {
			'DIV' => 108,
			'AND' => 106,
			"?" => 100,
			"+" => 101,
			'CMPOP' => 107,
			"/" => 105,
			'CAT' => 103,
			'BINOP' => 99,
			'OR' => 102,
			'MOD' => 104
		},
		DEFAULT => -153
	},
	{#State 261
		DEFAULT => -166
	},
	{#State 262
		ACTIONS => {
			'CASE' => 295
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 296
		}
	},
	{#State 263
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NOT' => 43,
			"(" => 32,
			'NUMBER' => 7,
			"[" => 31,
			"\$" => 6,
			'LITERAL' => 98
		},
		GOTOS => {
			'expr' => 297,
			'node' => 3,
			'term' => 60,
			'ident' => 96,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 264
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 265
		ACTIONS => {
			";" => -19,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			'WRAPPER' => 30,
			"[" => 31,
			"(" => 32,
			'IF' => 33,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'TEXT' => 37,
			'DEFAULT' => 38,
			'LITERAL' => 41,
			"\$" => 6,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'RAW' => 46,
			'THROW' => 47,
			'DEBUG' => 8,
			'SET' => 9,
			'PROCESS' => 11,
			'FOR' => 52,
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			'INCLUDE' => 63,
			"{" => 64,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'NEXT' => 68,
			'VIEW' => 67,
			'rawperl' => 24,
			'FILTER' => 70,
			'IDENT' => 25,
			'GET' => 26,
			'USE' => 71,
			'META' => 73,
			"\"" => 27
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 40,
			'assign' => 69,
			'switch' => 39,
			'chunk' => 5,
			'defblockname' => 42,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'filter' => 50,
			'defblock' => 51,
			'block' => 299,
			'javascript' => 10,
			'anonblock' => 49,
			'statement' => 75,
			'try' => 13,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'chunks' => 53,
			'atomexpr' => 55,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'expr' => 17,
			'raw' => 35,
			'view' => 62,
			'node' => 3
		}
	},
	{#State 266
		ACTIONS => {
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TEXT' => 37,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			'WRAPPER' => 30,
			"[" => 31,
			'RAW' => 46,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8,
			'PROCESS' => 11,
			'FOR' => 52,
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 41,
			"\$" => 6,
			'BLOCK' => 61,
			'MACRO' => 59,
			'INCLUDE' => 63,
			"{" => 64,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'CALL' => 58,
			'FILTER' => 70,
			'IDENT' => 25,
			'USE' => 71,
			'GET' => 26,
			'META' => 73,
			"\"" => 27,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'VIEW' => 67,
			'NEXT' => 68,
			'rawperl' => 24
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 56,
			'setlist' => 2,
			'condition' => 57,
			'wrapper' => 16,
			'chunks' => 53,
			'atomexpr' => 55,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'node' => 3,
			'view' => 62,
			'raw' => 35,
			'expr' => 17,
			'switch' => 39,
			'chunk' => 5,
			'atomdir' => 40,
			'assign' => 69,
			'defblockname' => 42,
			'ident' => 21,
			'macro' => 66,
			'loop' => 23,
			'javascript' => 10,
			'anonblock' => 49,
			'filter' => 50,
			'block' => 300,
			'defblock' => 51,
			'try' => 13,
			'statement' => 75,
			'directive' => 45,
			'capture' => 48,
			'use' => 72
		}
	},
	{#State 267
		ACTIONS => {
			'END' => 301
		}
	},
	{#State 268
		DEFAULT => -118
	},
	{#State 269
		ACTIONS => {
			'ELSE' => 303,
			'ELSIF' => 304
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 302
		}
	},
	{#State 270
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 271
		DEFAULT => -101
	},
	{#State 272
		DEFAULT => -103
	},
	{#State 273
		ACTIONS => {
			'TEXT' => 306
		}
	},
	{#State 274
		DEFAULT => -158
	},
	{#State 275
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 276
		ACTIONS => {
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			'LITERAL' => 41,
			"\$" => 6,
			'RAW' => 46,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			'PROCESS' => 11,
			'FOR' => 52,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			'WRAPPER' => 30,
			"[" => 31,
			"\${" => 36,
			'STOP' => 4,
			'CLEAR' => 34,
			'TEXT' => 37,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'VIEW' => 67,
			'NEXT' => 68,
			'rawperl' => 24,
			'IDENT' => 25,
			'FILTER' => 70,
			'USE' => 71,
			'GET' => 26,
			'META' => 73,
			"\"" => 27,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'CALL' => 58,
			'BLOCK' => 61,
			'MACRO' => 59,
			'INCLUDE' => 63,
			"{" => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 16,
			'condition' => 57,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'lterm' => 18,
			'sterm' => 19,
			'expr' => 17,
			'raw' => 35,
			'view' => 62,
			'node' => 3,
			'term' => 60,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'chunk' => 5,
			'switch' => 39,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21,
			'statement' => 75,
			'try' => 13,
			'filter' => 50,
			'defblock' => 51,
			'block' => 307,
			'anonblock' => 49,
			'javascript' => 10,
			'use' => 72,
			'capture' => 48,
			'directive' => 45
		}
	},
	{#State 277
		DEFAULT => -157,
		GOTOS => {
			'args' => 308
		}
	},
	{#State 278
		DEFAULT => -157,
		GOTOS => {
			'args' => 309
		}
	},
	{#State 279
		DEFAULT => -130
	},
	{#State 280
		ACTIONS => {
			")" => -97,
			'IDENT' => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 281
		ACTIONS => {
			")" => 311,
			'IDENT' => 310,
			'COMMA' => 312
		}
	},
	{#State 282
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 283
		ACTIONS => {
			'OR' => 102,
			'DIV' => 108,
			'BINOP' => 99,
			'MOD' => 104,
			'CAT' => 103,
			"/" => 105,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'AND' => 106
		},
		DEFAULT => -124
	},
	{#State 284
		ACTIONS => {
			'AND' => 106,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			"/" => 105,
			'CAT' => 103,
			'BINOP' => 99,
			'MOD' => 104,
			'DIV' => 108,
			'OR' => 102
		},
		DEFAULT => -125
	},
	{#State 285
		ACTIONS => {
			'ELSIF' => 304,
			'ELSE' => 303
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 314
		}
	},
	{#State 286
		ACTIONS => {
			'USE' => 71,
			'GET' => 26,
			'IDENT' => 25,
			'FILTER' => 70,
			"\"" => 27,
			'META' => 73,
			'NEXT' => 68,
			'VIEW' => 67,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'rawperl' => 24,
			'BLOCK' => 61,
			'MACRO' => 59,
			"{" => 64,
			'INCLUDE' => 63,
			'REF' => 54,
			'SWITCH' => 15,
			'perl' => 14,
			'CALL' => 58,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			'RAW' => 46,
			'FOR' => 52,
			'PROCESS' => 11,
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NUMBER' => 7,
			'NOT' => 43,
			"\$" => 6,
			'LITERAL' => 41,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TEXT' => 37,
			'IF' => 33,
			"(" => 32,
			"[" => 31,
			'WRAPPER' => 30,
			'RETURN' => 29,
			'TRY' => 1,
			'LAST' => 28,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'anonblock' => 49,
			'javascript' => 10,
			'defblock' => 51,
			'filter' => 50,
			'block' => 315,
			'try' => 13,
			'statement' => 75,
			'ident' => 21,
			'macro' => 66,
			'loop' => 23,
			'chunk' => 5,
			'switch' => 39,
			'assign' => 69,
			'atomdir' => 40,
			'defblockname' => 42,
			'term' => 60,
			'node' => 3,
			'view' => 62,
			'expr' => 17,
			'raw' => 35,
			'lterm' => 18,
			'sterm' => 19,
			'chunks' => 53,
			'atomexpr' => 55,
			'item' => 56,
			'setlist' => 2,
			'condition' => 57,
			'wrapper' => 16
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 288
		ACTIONS => {
			'USE' => 71,
			'GET' => 26,
			'FILTER' => 70,
			'IDENT' => 25,
			"\"" => 27,
			'META' => 73,
			'NEXT' => 68,
			'VIEW' => 67,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'rawperl' => 24,
			'BLOCK' => 61,
			'MACRO' => 59,
			"{" => 64,
			'INCLUDE' => 63,
			'REF' => 54,
			'SWITCH' => 15,
			'perl' => 14,
			'CALL' => 58,
			'THROW' => 47,
			'SET' => 9,
			'DEBUG' => 8,
			'RAW' => 46,
			'FOR' => 52,
			'PROCESS' => 11,
			'DEFAULT' => 38,
			'NOT' => 43,
			'INSERT' => 44,
			'NUMBER' => 7,
			"\$" => 6,
			'LITERAL' => 41,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TEXT' => 37,
			'IF' => 33,
			"(" => 32,
			"[" => 31,
			'WRAPPER' => 30,
			'TRY' => 1,
			'LAST' => 28,
			'RETURN' => 29,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'chunks' => 53,
			'atomexpr' => 55,
			'sterm' => 19,
			'lterm' => 18,
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'node' => 3,
			'view' => 62,
			'atomdir' => 40,
			'assign' => 69,
			'switch' => 39,
			'chunk' => 5,
			'defblockname' => 42,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'defblock' => 51,
			'filter' => 50,
			'block' => 317,
			'javascript' => 10,
			'anonblock' => 49,
			'statement' => 75,
			'try' => 13,
			'directive' => 45,
			'use' => 72,
			'capture' => 48
		}
	},
	{#State 289
		ACTIONS => {
			";" => 318
		}
	},
	{#State 290
		ACTIONS => {
			"(" => 32,
			'IF' => 33,
			'WRAPPER' => 30,
			"[" => 31,
			'RETURN' => 29,
			'TRY' => 1,
			'LAST' => 28,
			";" => -19,
			'TEXT' => 37,
			"\${" => 36,
			'STOP' => 4,
			'CLEAR' => 34,
			'NUMBER' => 7,
			'NOT' => 43,
			'INSERT' => 44,
			'LITERAL' => 41,
			"\$" => 6,
			'DEFAULT' => 38,
			'FOR' => 52,
			'PROCESS' => 11,
			'DEBUG' => 8,
			'SET' => 9,
			'THROW' => 47,
			'RAW' => 46,
			'CALL' => 58,
			'REF' => 54,
			'SWITCH' => 15,
			'perl' => 14,
			"{" => 64,
			'INCLUDE' => 63,
			'BLOCK' => 61,
			'MACRO' => 59,
			'rawperl' => 24,
			'NEXT' => 68,
			'VIEW' => 67,
			'UNLESS' => 65,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			"\"" => 27,
			'META' => 73,
			'USE' => 71,
			'GET' => 26,
			'IDENT' => 25,
			'FILTER' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'expr' => 17,
			'raw' => 35,
			'node' => 3,
			'view' => 62,
			'term' => 60,
			'wrapper' => 16,
			'condition' => 57,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55,
			'chunks' => 53,
			'statement' => 75,
			'try' => 13,
			'filter' => 50,
			'block' => 319,
			'defblock' => 51,
			'javascript' => 10,
			'anonblock' => 49,
			'use' => 72,
			'capture' => 48,
			'directive' => 45,
			'defblockname' => 42,
			'assign' => 69,
			'atomdir' => 40,
			'chunk' => 5,
			'switch' => 39,
			'loop' => 23,
			'macro' => 66,
			'ident' => 21
		}
	},
	{#State 291
		ACTIONS => {
			";" => 320,
			'DOT' => 176
		}
	},
	{#State 292
		DEFAULT => -69
	},
	{#State 293
		DEFAULT => -165
	},
	{#State 294
		ACTIONS => {
			'REF' => 54,
			"\$" => 6,
			'LITERAL' => 98,
			"[" => 31,
			'NUMBER' => 7,
			"(" => 32,
			'NOT' => 43,
			'IDENT' => 25,
			"\${" => 36,
			"\"" => 27,
			"{" => 64
		},
		GOTOS => {
			'item' => 56,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'ident' => 96,
			'expr' => 321,
			'node' => 3
		}
	},
	{#State 295
		ACTIONS => {
			"\"" => 27,
			"{" => 64,
			"\${" => 36,
			'IDENT' => 25,
			'LITERAL' => 98,
			"\$" => 6,
			"[" => 31,
			'NUMBER' => 7,
			";" => 324,
			'DEFAULT' => 323,
			'REF' => 54
		},
		GOTOS => {
			'node' => 3,
			'term' => 322,
			'ident' => 96,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 296
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 297
		ACTIONS => {
			'OR' => 102,
			'DIV' => 108,
			'CAT' => 103,
			'MOD' => 104,
			'BINOP' => 99,
			"/" => 105,
			'AND' => 106,
			"+" => 101,
			'CMPOP' => 107,
			"?" => 100
		},
		DEFAULT => -144
	},
	{#State 298
		DEFAULT => -80
	},
	{#State 299
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 300
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 301
		DEFAULT => -67
	},
	{#State 302
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 303
		ACTIONS => {
			";" => 329
		}
	},
	{#State 304
		ACTIONS => {
			"\${" => 36,
			'IDENT' => 25,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			'NOT' => 43,
			'NUMBER' => 7,
			"(" => 32,
			"\$" => 6,
			'LITERAL' => 98,
			"[" => 31
		},
		GOTOS => {
			'expr' => 330,
			'node' => 3,
			'term' => 60,
			'ident' => 96,
			'lterm' => 18,
			'sterm' => 19,
			'item' => 56
		}
	},
	{#State 305
		DEFAULT => -83
	},
	{#State 306
		ACTIONS => {
			"\"" => 331
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 332
		}
	},
	{#State 308
		ACTIONS => {
			'IDENT' => 25,
			"\${" => 36,
			'COMMA' => 258,
			"{" => 64,
			"\"" => 27,
			'REF' => 54,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 255
		},
		DEFAULT => -65,
		GOTOS => {
			'term' => 60,
			'expr' => 260,
			'node' => 3,
			'lterm' => 18,
			'sterm' => 19,
			'ident' => 259,
			'item' => 256,
			'param' => 257
		}
	},
	{#State 309
		ACTIONS => {
			"\$" => 6,
			"[" => 31,
			'LITERAL' => 255,
			"(" => 32,
			'NUMBER' => 7,
			'NOT' => 43,
			'REF' => 54,
			"\"" => 27,
			"{" => 64,
			'IDENT' => 25,
			'COMMA' => 258,
			"\${" => 36
		},
		DEFAULT => -64,
		GOTOS => {
			'param' => 257,
			'item' => 256,
			'ident' => 259,
			'sterm' => 19,
			'lterm' => 18,
			'node' => 3,
			'expr' => 260,
			'term' => 60
		}
	},
	{#State 310
		DEFAULT => -95
	},
	{#State 311
		ACTIONS => {
			"\"" => 27,
			'GET' => 26,
			'FILTER' => 70,
			'IDENT' => 25,
			'NEXT' => 68,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			"{" => 64,
			'INCLUDE' => 63,
			'BLOCK' => 197,
			'CALL' => 58,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			'FOR' => 52,
			'PROCESS' => 11,
			'SET' => 9,
			'THROW' => 47,
			'DEBUG' => 8,
			"\$" => 6,
			'LITERAL' => 41,
			'NOT' => 43,
			'INSERT' => 44,
			'NUMBER' => 7,
			'DEFAULT' => 38,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			"[" => 31,
			'WRAPPER' => 30,
			"(" => 32,
			'IF' => 33,
			'LAST' => 28,
			'RETURN' => 29,
			'TRY' => 1
		},
		GOTOS => {
			'try' => 13,
			'filter' => 50,
			'javascript' => 10,
			'directive' => 196,
			'atomdir' => 40,
			'mdir' => 333,
			'assign' => 69,
			'switch' => 39,
			'loop' => 23,
			'ident' => 122,
			'sterm' => 19,
			'lterm' => 18,
			'expr' => 237,
			'node' => 3,
			'term' => 60,
			'wrapper' => 16,
			'condition' => 57,
			'setlist' => 2,
			'item' => 56,
			'atomexpr' => 55
		}
	},
	{#State 312
		DEFAULT => -96
	},
	{#State 313
		DEFAULT => -89
	},
	{#State 314
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 315
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 316
		DEFAULT => -81
	},
	{#State 317
		DEFAULT => -73
	},
	{#State 318
		ACTIONS => {
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			'INCLUDE' => 63,
			"{" => 64,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'VIEW' => 67,
			'NEXT' => 68,
			'rawperl' => 24,
			'IDENT' => 25,
			'FILTER' => 70,
			'GET' => 26,
			'USE' => 71,
			'META' => 73,
			"\"" => 27,
			";" => -19,
			'RETURN' => 29,
			'TRY' => 1,
			'LAST' => 28,
			"[" => 31,
			'WRAPPER' => 30,
			'IF' => 33,
			"(" => 32,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			'TEXT' => 37,
			'DEFAULT' => 38,
			"\$" => 6,
			'LITERAL' => 41,
			'NOT' => 43,
			'INSERT' => 44,
			'NUMBER' => 7,
			'RAW' => 46,
			'THROW' => 47,
			'DEBUG' => 8,
			'SET' => 9,
			'PROCESS' => 11,
			'FOR' => 52
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 57,
			'wrapper' => 16,
			'item' => 56,
			'setlist' => 2,
			'atomexpr' => 55,
			'chunks' => 53,
			'lterm' => 18,
			'sterm' => 19,
			'node' => 3,
			'view' => 62,
			'raw' => 35,
			'expr' => 17,
			'term' => 60,
			'defblockname' => 42,
			'switch' => 39,
			'chunk' => 5,
			'assign' => 69,
			'atomdir' => 40,
			'macro' => 66,
			'loop' => 23,
			'ident' => 21,
			'try' => 13,
			'statement' => 75,
			'anonblock' => 49,
			'javascript' => 10,
			'block' => 336,
			'defblock' => 51,
			'filter' => 50,
			'capture' => 48,
			'use' => 72,
			'directive' => 45
		}
	},
	{#State 319
		ACTIONS => {
			'FINAL' => 247,
			'CATCH' => 248
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 337
		}
	},
	{#State 320
		ACTIONS => {
			'META' => 73,
			"\"" => 27,
			'IDENT' => 25,
			'FILTER' => 70,
			'GET' => 26,
			'USE' => 71,
			'rawperl' => 24,
			'JAVASCRIPT' => 20,
			'WHILE' => 22,
			'UNLESS' => 65,
			'NEXT' => 68,
			'VIEW' => 67,
			'INCLUDE' => 63,
			"{" => 64,
			'MACRO' => 59,
			'BLOCK' => 61,
			'CALL' => 58,
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'PROCESS' => 11,
			'FOR' => 52,
			'RAW' => 46,
			'DEBUG' => 8,
			'THROW' => 47,
			'SET' => 9,
			"\$" => 6,
			'LITERAL' => 41,
			'NUMBER' => 7,
			'NOT' => 43,
			'INSERT' => 44,
			'DEFAULT' => 38,
			'TEXT' => 37,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			";" => -19,
			'TRY' => 1,
			'LAST' => 28,
			'RETURN' => 29,
			"[" => 31,
			'WRAPPER' => 30,
			"(" => 32,
			'IF' => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 338,
			'defblock' => 51,
			'filter' => 50,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'atomdir' => 40,
			'assign' => 69,
			'chunk' => 5,
			'switch' => 39,
			'defblockname' => 42,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'view' => 62,
			'node' => 3,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'chunks' => 53,
			'atomexpr' => 55
		}
	},
	{#State 321
		ACTIONS => {
			"/" => 105,
			'OR' => 102,
			'BINOP' => 99,
			'MOD' => 104,
			'CAT' => 103,
			'DIV' => 108,
			"?" => 100,
			'CMPOP' => 107,
			"+" => 101,
			'AND' => 106
		},
		DEFAULT => -155
	},
	{#State 322
		ACTIONS => {
			";" => 339
		}
	},
	{#State 323
		ACTIONS => {
			";" => 340
		}
	},
	{#State 324
		ACTIONS => {
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TEXT' => 37,
			'RETURN' => 29,
			'TRY' => 1,
			'LAST' => 28,
			";" => -19,
			"(" => 32,
			'IF' => 33,
			'WRAPPER' => 30,
			"[" => 31,
			'RAW' => 46,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'PROCESS' => 11,
			'FOR' => 52,
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NOT' => 43,
			'NUMBER' => 7,
			"\$" => 6,
			'LITERAL' => 41,
			'BLOCK' => 61,
			'MACRO' => 59,
			'INCLUDE' => 63,
			"{" => 64,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'CALL' => 58,
			'FILTER' => 70,
			'IDENT' => 25,
			'USE' => 71,
			'GET' => 26,
			'META' => 73,
			"\"" => 27,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'VIEW' => 67,
			'NEXT' => 68,
			'rawperl' => 24
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 40,
			'assign' => 69,
			'switch' => 39,
			'chunk' => 5,
			'defblockname' => 42,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'block' => 341,
			'defblock' => 51,
			'filter' => 50,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'chunks' => 53,
			'atomexpr' => 55,
			'lterm' => 18,
			'sterm' => 19,
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'node' => 3,
			'view' => 62
		}
	},
	{#State 325
		DEFAULT => -53
	},
	{#State 326
		DEFAULT => -94
	},
	{#State 327
		DEFAULT => -62
	},
	{#State 328
		DEFAULT => -46
	},
	{#State 329
		ACTIONS => {
			'NUMBER' => 7,
			'INSERT' => 44,
			'NOT' => 43,
			'LITERAL' => 41,
			"\$" => 6,
			'DEFAULT' => 38,
			'PROCESS' => 11,
			'FOR' => 52,
			'RAW' => 46,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'RETURN' => 29,
			'LAST' => 28,
			'TRY' => 1,
			";" => -19,
			'IF' => 33,
			"(" => 32,
			"[" => 31,
			'WRAPPER' => 30,
			'TEXT' => 37,
			"\${" => 36,
			'STOP' => 4,
			'CLEAR' => 34,
			'rawperl' => 24,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'NEXT' => 68,
			'VIEW' => 67,
			'META' => 73,
			"\"" => 27,
			'FILTER' => 70,
			'IDENT' => 25,
			'USE' => 71,
			'GET' => 26,
			'CALL' => 58,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'INCLUDE' => 63,
			"{" => 64,
			'BLOCK' => 61,
			'MACRO' => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'view' => 62,
			'node' => 3,
			'sterm' => 19,
			'lterm' => 18,
			'chunks' => 53,
			'atomexpr' => 55,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'filter' => 50,
			'block' => 342,
			'defblock' => 51,
			'javascript' => 10,
			'anonblock' => 49,
			'statement' => 75,
			'try' => 13,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'atomdir' => 40,
			'assign' => 69,
			'chunk' => 5,
			'switch' => 39,
			'defblockname' => 42
		}
	},
	{#State 330
		ACTIONS => {
			'DIV' => 108,
			";" => 343,
			"/" => 105,
			"+" => 101,
			'MOD' => 104,
			'CMPOP' => 107,
			"?" => 100,
			'BINOP' => 99,
			'OR' => 102,
			'CAT' => 103,
			'AND' => 106
		}
	},
	{#State 331
		DEFAULT => -102
	},
	{#State 332
		DEFAULT => -59
	},
	{#State 333
		DEFAULT => -91
	},
	{#State 334
		DEFAULT => -48
	},
	{#State 335
		DEFAULT => -78
	},
	{#State 336
		ACTIONS => {
			'FINAL' => 247,
			'CATCH' => 248
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 344
		}
	},
	{#State 337
		DEFAULT => -72
	},
	{#State 338
		ACTIONS => {
			'CATCH' => 248,
			'FINAL' => 247
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 345
		}
	},
	{#State 339
		ACTIONS => {
			"\$" => 6,
			'LITERAL' => 41,
			'NUMBER' => 7,
			'INSERT' => 44,
			'NOT' => 43,
			'DEFAULT' => 38,
			'FOR' => 52,
			'PROCESS' => 11,
			'THROW' => 47,
			'DEBUG' => 8,
			'SET' => 9,
			'RAW' => 46,
			'WRAPPER' => 30,
			"[" => 31,
			'IF' => 33,
			"(" => 32,
			";" => -19,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			'TEXT' => 37,
			'CLEAR' => 34,
			"\${" => 36,
			'STOP' => 4,
			'rawperl' => 24,
			'NEXT' => 68,
			'VIEW' => 67,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			"\"" => 27,
			'META' => 73,
			'GET' => 26,
			'USE' => 71,
			'FILTER' => 70,
			'IDENT' => 25,
			'CALL' => 58,
			'REF' => 54,
			'perl' => 14,
			'SWITCH' => 15,
			"{" => 64,
			'INCLUDE' => 63,
			'MACRO' => 59,
			'BLOCK' => 61
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 45,
			'capture' => 48,
			'use' => 72,
			'defblock' => 51,
			'block' => 346,
			'filter' => 50,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66,
			'atomdir' => 40,
			'assign' => 69,
			'chunk' => 5,
			'switch' => 39,
			'defblockname' => 42,
			'term' => 60,
			'raw' => 35,
			'expr' => 17,
			'view' => 62,
			'node' => 3,
			'lterm' => 18,
			'sterm' => 19,
			'chunks' => 53,
			'atomexpr' => 55,
			'setlist' => 2,
			'item' => 56,
			'condition' => 57,
			'wrapper' => 16
		}
	},
	{#State 340
		ACTIONS => {
			'IDENT' => 25,
			'FILTER' => 70,
			'USE' => 71,
			'GET' => 26,
			'META' => 73,
			"\"" => 27,
			'UNLESS' => 65,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'NEXT' => 68,
			'VIEW' => 67,
			'rawperl' => 24,
			'BLOCK' => 61,
			'MACRO' => 59,
			'INCLUDE' => 63,
			"{" => 64,
			'SWITCH' => 15,
			'perl' => 14,
			'REF' => 54,
			'CALL' => 58,
			'RAW' => 46,
			'SET' => 9,
			'DEBUG' => 8,
			'THROW' => 47,
			'PROCESS' => 11,
			'FOR' => 52,
			'DEFAULT' => 38,
			'INSERT' => 44,
			'NUMBER' => 7,
			'NOT' => 43,
			'LITERAL' => 41,
			"\$" => 6,
			'STOP' => 4,
			"\${" => 36,
			'CLEAR' => 34,
			'TEXT' => 37,
			'LAST' => 28,
			'TRY' => 1,
			'RETURN' => 29,
			";" => -19,
			"(" => 32,
			'IF' => 33,
			"[" => 31,
			'WRAPPER' => 30
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 19,
			'lterm' => 18,
			'term' => 60,
			'expr' => 17,
			'raw' => 35,
			'view' => 62,
			'node' => 3,
			'setlist' => 2,
			'item' => 56,
			'wrapper' => 16,
			'condition' => 57,
			'chunks' => 53,
			'atomexpr' => 55,
			'defblock' => 51,
			'filter' => 50,
			'block' => 347,
			'anonblock' => 49,
			'javascript' => 10,
			'statement' => 75,
			'try' => 13,
			'directive' => 45,
			'use' => 72,
			'capture' => 48,
			'assign' => 69,
			'atomdir' => 40,
			'switch' => 39,
			'chunk' => 5,
			'defblockname' => 42,
			'ident' => 21,
			'loop' => 23,
			'macro' => 66
		}
	},
	{#State 341
		DEFAULT => -56
	},
	{#State 342
		DEFAULT => -51
	},
	{#State 343
		ACTIONS => {
			'perl' => 14,
			'SWITCH' => 15,
			'REF' => 54,
			'CALL' => 58,
			'MACRO' => 59,
			'BLOCK' => 61,
			'INCLUDE' => 63,
			"{" => 64,
			'WHILE' => 22,
			'JAVASCRIPT' => 20,
			'UNLESS' => 65,
			'VIEW' => 67,
			'NEXT' => 68,
			'rawperl' => 24,
			'FILTER' => 70,
			'IDENT' => 25,
			'GET' => 26,
			'USE' => 71,
			'META' => 73,
			"\"" => 27,
			";" => -19,
			'TRY' => 1,
			'RETURN' => 29,
			'LAST' => 28,
			"[" => 31,
			'WRAPPER' => 30,
			'IF' => 33,
			"(" => 32,
			'CLEAR' => 34,
			'STOP' => 4,
			"\${" => 36,
			'TEXT' => 37,
			'DEFAULT' => 38,
			"\$" => 6,
			'LITERAL' => 41,
			'NOT' => 43,
			'NUMBER' => 7,
			'INSERT' => 44,
			'RAW' => 46,
			'SET' => 9,
			'THROW' => 47,
			'DEBUG' => 8,
			'PROCESS' => 11,
			'FOR' => 52
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 66,
			'loop' => 23,
			'ident' => 21,
			'defblockname' => 42,
			'chunk' => 5,
			'switch' => 39,
			'atomdir' => 40,
			'assign' => 69,
			'use' => 72,
			'capture' => 48,
			'directive' => 45,
			'try' => 13,
			'statement' => 75,
			'javascript' => 10,
			'anonblock' => 49,
			'block' => 348,
			'filter' => 50,
			'defblock' => 51,
			'atomexpr' => 55,
			'chunks' => 53,
			'wrapper' => 16,
			'condition' => 57,
			'item' => 56,
			'setlist' => 2,
			'view' => 62,
			'node' => 3,
			'expr' => 17,
			'raw' => 35,
			'term' => 60,
			'lterm' => 18,
			'sterm' => 19
		}
	},
	{#State 344
		DEFAULT => -71
	},
	{#State 345
		DEFAULT => -70
	},
	{#State 346
		ACTIONS => {
			'CASE' => 295
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 349
		}
	},
	{#State 347
		DEFAULT => -55
	},
	{#State 348
		ACTIONS => {
			'ELSE' => 303,
			'ELSIF' => 304
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 349
		DEFAULT => -54
	},
	{#State 350
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
