## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Alias.pm
## Author: Bryan Jurish <moocow@uni-potsdam.de>
## Description: analyzer alias

##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::Alias;
use DTA::CAB::Analyzer;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer
##  + new keys
##     a => $subAnalyzer,     ##-- aliased sub-analyzer (workhorse)
sub new {
  my $that = shift;
  my $anl = $that->SUPER::new(
			      ##-- overrides
			      #tolower => 1,

			      ##-- analysis selection
			      label => undef,
			      a => undef,

			      ##-- user args
			      @_
			     );
  return $aut;
}

## $label = $anl->defaultLabel()
##  + default label for this class
##  + default is final component of perl class-name
sub defaultLabel {
  my $anl = shift;
  my $lab = $anl->SUPER::defaultLabel();
  $lab .= "->".$anl->{a}{label} if ($anl->{a});
  return $lab;
}

## $bool = $anl->ensureLoaded()
##  + ensures analysis data is loaded from default files
##  + default version always returns true
sub ensureLoaded {
  return $_[0]{a}->ensureLoaded() if ($_[0]{a});
  return 1;
}

## @keys = $class_or_obj->noSaveKeys()
##  + returns list of keys not to be saved
##  + default just greps for CODE-refs
sub noSaveKeys {
  my $anl = shift;
  return ($anl->SUPER::noSaveKeys(),'a');
}

## @keys = $class_or_obj->noSaveBinKeys()
##  + returns list of keys not to be saved for binary mode
##  + default just greps for CODE-refs
sub noSaveBinKeys {
  my $anl = shift;
  return ($anl->SUPER::noSaveBinKeys(),'a');
}

##------------------------------------------------------------------------
## Methods: Analysis: v1.x: Utils

## $bool = $anl->canAnalyze();
##  + returns true iff analyzer can perform its function (e.g. data is loaded & non-empty)
##  + default implementation always returns true
##  + override calls $anl->{a}->canAnalyze
sub canAnalyze {
  return $_[0]{a} ? $_[0]{a}->canAnalyze : 0;
}

## $bool = $anl->doAnalyze(\%opts, $name)
##  + alias for $anl->can("analyze${name}") && (!exists($opts{"doAnalyze${name}"}) || $opts{"doAnalyze${name}"})
##  + inherited from Analyzer

## $bool = $anl->enabled(\%opts)
##  + returns true if analyzer SHOULD operate, acording to %opts
##  + default returns:
##     (!defined($anl->{enabled}) || $anl->{enabled})                           ##-- globally enabled
##     &&
##     (!$opts || !defined($opts{"${lab}_enabled"} || $opts{"${lab}_enabled"})  ##-- ... and locally enabled
## + inherited from Analyzer


##------------------------------------------------------------------------
## Methods: Analysis: v1.x: API

## $val = $anl->analyzeAnything($methodName,$defaultReturnVal,\%opts,\@subMethodArgs)
##  + wrapper for Analyzer::analyzeXYZ() methods
sub analyzeAnything {
  my ($anl,$method,$x,$opts,$args) = @_;
  return $x    if (!$anl->{a} || !$anl->enabled($opts));
  return $anl->{a}->can($method)->(@$args);
}

## $doc = $anl->analyzeDocument($doc,\%opts)
sub analyzeDocument { return $_[0]->analyzeAnything('analyzeDocument',@_[1,2],[@_[1..$#_]]); }

## $doc = $anl->analyzeTypes($doc,\%types,\%opts)
sub analyzeTypes { return $_[0]->analyzeAnything('analyzeTypes',@_[1,3],[@_[1..$#_]]); }

## $doc = $anl->analyzeSentences($doc,\%opts)
sub analyzeSentences { return $_[0]->analyzeAnything('analyzeSentences',@_[1,2],[@_[1..$#_]]); }

## $doc = $anl->analyzeLocal($doc,\%opts)
sub analyzeLocal { return $_[0]->analyzeAnything('analyzeLocal',@_[1,2],[@_[1..$#_]]); }

## $doc = $anl->analyzeClean($doc,\%opts)
sub analyzClean { return $_[0]->analyzeClean('analyzeClean',@_[1,2],[@_[1..$#_]]); }


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Alias - analyzer alias

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES
 
 use DTA::CAB::Analyzer::Alias;
 
 ##========================================================================
 ## Methods: Analysis
 
 $bool = $anl->canAnalyze();
 $val = $anl->analyzeAnything($methodName,$defaultReturnVal,\%opts,\@subMethodArgs);
 $doc = $anl->analyzeDocument($doc,\%opts);
 $doc = $anl->analyzeTypes($doc,\%types,\%opts);
 $doc = $anl->analyzeSentences($doc,\%opts);
 $doc = $anl->analyzeLocal($doc,\%opts);
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

B<UNMAINTAINED>

DTA::CAB::Analyzer::Alias provides a wrapper class for accessing an
existing L<DTA::CAB::Analzyer|DTA::CAB::Analzyer> object in
$alias-E<gt>{a}
under a
different name ($alias-E<gt>{name} ne $alias-E<gt>{a}{name}).

=cut

##----------------------------------------------------------------
## DESCRIPTION: DTA::CAB::Analyzer::Alias: Methods: Analysis: v1.x: Utils
=pod

=head2 Methods: Analysis: Utils

=over 4

=item canAnalyze

 $bool = $anl->canAnalyze();

Returns true iff analyzer can perform its function (e.g. data is loaded & non-empty).
Override calls $anl-E<gt>{a}-E<gt>canAnalyze.

=item analyzeAnything

 $val = $anl->analyzeAnything($methodName,$defaultReturnVal,\%opts,\@subMethodArgs);

Wrapper for Analyzer::analyzeXYZ() methods.

=item analyzeDocument

 $doc = $anl->analyzeDocument($doc,\%opts);

Wrapper for $anl-E<gt>{a}-E<gt>analyzeDocument().

=item analyzeTypes

 $doc = $anl->analyzeTypes($doc,\%types,\%opts);

Wrapper for $anl-E<gt>{a}-E<gt>analyzeTypes().

=item analyzeSentences

 $doc = $anl->analyzeSentences($doc,\%opts);

Wrapper for $anl-E<gt>{a}-E<gt>analyzeSentences().

=item analyzeLocal

 $doc = $anl->analyzeLocal($doc,\%opts);

Wrapper for $anl-E<gt>{a}-E<gt>analyzeLocal().

=item analyzClean

Wrapper for $anl-E<gt>{a}-E<gt>analyzeClean().

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================
=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=head1 SEE ALSO

L<dta-cab-analyze.perl(1)|dta-cab-analyze.perl>,
L<DTA::CAB::Analyzer(3pm)|DTA::CAB::Analyzer>,
L<DTA::CAB::Chain(3pm)|DTA::CAB::Chain>,
L<DTA::CAB(3pm)|DTA::CAB>,
L<perl(1)|perl>,
...

=cut
