package Business::EDI::CodeList::DespatchPatternCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 2015;
my $usage       = 'C';

# 2015  Despatch pattern code                                   [C]
# Desc: Code specifying a despatch pattern.
# Repr: an..3

my %code_hash = (
'1' => [ '1st week of the month',
    'Despatch has or will occur in the first week of the month.' ],
'2' => [ '2nd week of the month',
    'Despatch has or will occur in the second week of the month.' ],
'3' => [ '3rd week of the month',
    'Despatch has or will occur in the third week of the month.' ],
'4' => [ '4th week of the month',
    'Despatch has or will occur in the fourth week of the month.' ],
'5' => [ '5th week of the month',
    'Despatch has or will occur in the fifth week of the month.' ],
'6' => [ '1st and 3rd weeks of the month',
    'Despatch has or will occur in the first and third week of the month.' ],
'7' => [ '2nd and 4th weeks of the month',
    'Despatch has or will occur in the second and fourth week of the month.' ],
'10' => [ 'Monday through Friday',
    'Despatch has or will occur between Monday and Friday (inclusive).' ],
'11' => [ 'Monday through Saturday',
    'Despatch has or will occur between Monday and Saturday (inclusive).' ],
'12' => [ 'Monday through Sunday',
    'Despatch has or will occur between Monday and Sunday (inclusive).' ],
'13' => [ 'Monday',
    'Despatch has or will occur on a Monday.' ],
'14' => [ 'Tuesday',
    'Despatch has or will occur on a Tuesday.' ],
'15' => [ 'Wednesday',
    'Despatch has or will occur on a Wednesday.' ],
'16' => [ 'Thursday',
    'Despatch has or will occur on a Thursday.' ],
'17' => [ 'Friday',
    'Despatch has or will occur on a Friday.' ],
'18' => [ 'Saturday',
    'Despatch has or will occur on a Saturday.' ],
'19' => [ 'Sunday',
    'Despatch has or will occur on a Sunday.' ],
'20' => [ 'Immediately',
    'At the earliest date/time within the defined lead time.' ],
'21' => [ 'As directed',
    'Despatch has or will occur as directed.' ],
'22' => [ 'Each week of the month',
    'Shipments/deliveries are anticipated weekly within the month specified.' ],
'23' => [ 'Daily Monday through Friday',
    'Shipments/deliveries are anticipated, five days per week.' ],
'24' => [ 'First decade of the month',
    'First ten days of a calendar month.' ],
'25' => [ 'Second decade of the month',
    'Eleventh through twentieth day of a calendar month.' ],
'26' => [ 'Third decade of the month',
    'Twenty-first through last day of a calendar month.' ],
'27' => [ 'Each working hour',
    'Routine despatches occur in cycles of 1 working hour.' ],
'28' => [ 'Each 2 working hours',
    'Routine despatches occur in cycles of 2 working hours.' ],
'29' => [ 'Each 3 working hours',
    'Routine despatches occur in cycles of 3 working hours.' ],
'30' => [ 'Each 4 working hours',
    'Routine despatches occur in cycles of 4 working hours.' ],
'31' => [ 'Each working day',
    'Routine despatches occur in cycles of 1 working day.' ],
'32' => [ 'Each 2 working days',
    'Routine despatches occur in cycles of 2 working days.' ],
'33' => [ 'Each 3 working days',
    'Routine despatches occur in cycles of 3 working days.' ],
'34' => [ 'Each 4 working days',
    'Routine despatches occur in cycles of 4 working days.' ],
'35' => [ 'Each 5 working days',
    'Routine despatches occur in cycles of 5 working days.' ],
'36' => [ 'Each 6 working days',
    'Routine despatches occur in cycles of 6 working days.' ],
'37' => [ 'Each 8 working days',
    'Routine despatches occur in cycles of 8 working days.' ],
'38' => [ 'Each 9 working days',
    'Routine despatches occur in cycles of 9 working days.' ],
'39' => [ 'Each 10 working days',
    'Routine despatches occur in cycles of 10 working days.' ],
'40' => [ 'Each 11 working days',
    'Routine despatches occur in cycles of 11 working days.' ],
'41' => [ 'Each 12 working days',
    'Routine despatches occur in cycles of 12 working days.' ],
'42' => [ 'Each 13 working days',
    'Routine despatches occur in cycles of 13 working days.' ],
'43' => [ 'Each working week',
    'Routine despatches occur in cycles of 1 working week.' ],
'44' => [ 'Each 2 working weeks',
    'Routine despatches occur in cycles of 2 working weeks.' ],
'45' => [ 'Each 3 working weeks',
    'Routine despatches occur in cycles of 3 working weeks.' ],
'46' => [ 'Each 4 working weeks',
    'Routine despatches occur in cycles of 4 working weeks.' ],
'47' => [ 'Each working month',
    'Routine despatches occur in cycles of 1 working month.' ],
'48' => [ 'Each 2 working months',
    'Routine despatches occur in cycles of 2 working months.' ],
'49' => [ 'Each 3 working months',
    'Routine despatches occur in cycles of 3 working months.' ],
'ZZZ' => [ 'Mutually defined',
    'Despatch pattern according to bilateral agreement.' ],
);
sub get_codes { return \%code_hash; }

1;
