package Daje::Workflow::Templates;
use Mojo::Base  -base, -signatures;

use Daje::Tools::Datasections;

#
# NAME
# ====
#
# Daje::Workflow::Templates - It's a template loader
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Templates;
#
#     my $templates = Daje::Workflow::Templates->new(
#         data_sections => $data_sections,
#         source        => $source,
#         error         => $error,
#     )->load_templates();
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Templates ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#


our $VERSION = "0.02";

has 'data_sections';
has 'source';
has 'error';

sub load_templates($self) {
    my $template;
    eval {
        $template = Daje::Tools::Datasections->new(
            data_sections => $self->data_sections(),
            source        => $self->source(),
        );
    };
    $self->error->add_error($@) if defined $@;

    $template->load_data_sections();
    $self->error->add_error($template->error());

    return $template;
}

1;
__END__






#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Templates - It's a template loader



=head1 SYNOPSIS


    use Daje::Workflow::Templates;

    my $templates = Daje::Workflow::Templates->new(
        data_sections => $data_sections,
        source        => $source,
        error         => $error,
    )->load_templates();



=head1 DESCRIPTION



Daje::Workflow::Templates ...



=head1 REQUIRES

L<Daje::Tools::Datasections> 

L<Mojo::Base> 


=head1 METHODS

=head2 load_templates($self)

 load_templates($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

