package SNMP::Insight::Utils;

# ABSTRACT: Support code for SNMP::Insight

use 5.010;
use strict;
use warnings FATAL => 'all';

our $VERSION = '0.002';    # TRIAL VERSION:

our ( @ISA, @EXPORT_OK );

BEGIN {
    require Exporter;
    @ISA       = qw(Exporter);
    @EXPORT_OK = qw( _debug _debug_level);
}

sub _debug {
    $ENV{SNMP_INSIGHT_DEBUG} and print STDERR @_;
}

sub _debug_level {
    $ENV{SNMP_INSIGHT_DEBUG};
}

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::Utils - Support code for SNMP::Insight

=head1 VERSION

version 0.002

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
