package App::Manoc::DB::Result::LanSegment;
#ABSTRACT:  A model object representing a LAN Segment

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('lan_segments');
__PACKAGE__->add_columns(
    id => {
        data_type         => 'int',
        is_nullable       => 0,
        is_auto_increment => 1,
    },
    name => {
        data_type   => 'varchar',
        size        => 64,
        is_nullable => 0
    },
    vtp_domain => {
        data_type   => 'varchar',
        size        => 64,
        is_nullable => 1
    },
    notes => {
        data_type   => 'text',
        is_nullable => 1,
    },
);
__PACKAGE__->set_primary_key(qw(id));
__PACKAGE__->add_unique_constraint( ['name'] );

__PACKAGE__->has_many(
    vlans => 'App::Manoc::DB::Result::Vlan',
    'lan_segment_id',
    { cascade_delete => 0 }
);

__PACKAGE__->has_many(
    vlan_ranges => 'App::Manoc::DB::Result::VlanRange',
    'lan_segment_id',
    { cascade_delete => 0 }
);

__PACKAGE__->has_many(
    devices => 'App::Manoc::DB::Result::Device',
    'lan_segment_id',
    { cascade_delete => 0 }
);

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::LanSegment - A model object representing a LAN Segment

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
