package App::Manoc::Controller::APIv1::Ping;
#ABSTRACT: Controller for Ping test API
use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'App::Manoc::ControllerBase::APIv1' }


sub ping : Chained('deserialize') PathPart('ping') Args(0) GET {
    my ( $self, $c ) = @_;

    my $data = {
        request   => $c->stash->{request_data},
        timestamp => time,
    };

    $c->stash( api_response_data => $data );
}


sub ping_post : Chained('deserialize') PathPart('ping') Args(0) POST {
    my ( $self, $c ) = @_;

    my $data = {
        request   => $c->stash->{api_request_data},
        timestamp => time,
    };

    $c->stash( api_response_data => $data );
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::APIv1::Ping - Controller for Ping test API

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 ping

GET /api/v1/ping

=head2 ping_post

POST /api/v1/ping

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
