package App::Manoc::Form::TraitFor::RackOptions;
#ABSTRACT: Role for populating rack selections

use HTML::FormHandler::Moose::Role;

our $VERSION = '2.99.3'; ##TRIAL VERSION


sub get_rack_options {
    my $self = shift;

    my $racks = $self->schema->resultset('Rack')->search(
        {},
        {
            join     => 'building',
            prefetch => 'building',
            order_by => [ 'me.building_id', 'me.name' ]
        }
    );

    return map +{
        value => $_->id,
        label => $_->label
        },
        $racks->all();
}

no HTML::FormHandler::Moose::Role;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::TraitFor::RackOptions - Role for populating rack selections

=head1 VERSION

version 2.99.3

=head1 METHDOS

=head2 get_rack_options

Return an array suitable for populating a Rack select menu

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
