package App::Manoc::Search::Widget::Group;

use Moose::Role;

our $VERSION = '2.99.2'; ##TRIAL VERSION

sub render {
    my ( $self, $ctx ) = @_;

    return $self->render_heading($ctx) . " " . $self->render_items($ctx);
}

sub render_heading {
    my ( $self, $ctx ) = @_;
    return "" if ( @{ $self->items } == 1 );
    return $self->match();
}

sub render_items {
    my ( $self, $ctx ) = @_;

    if ( @{ $self->items } == 1 ) {
        my $item = $self->items->[0];
        return $item->render($ctx);
    }

    my $ret = '<ul>';
    foreach ( @{ $self->items } ) {
        $ret .= '<li>' . $_->render($ctx) . '</li>';
    }
    $ret .= '</ul>';

    return $ret;
}

no Moose::Role;
1;

__END__

=pod

=head1 NAME

App::Manoc::Search::Widget::Group

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
