alarm.c                                                                                             000600  000000  000000  00000003727 04542747464 006046                                                                                                                                                                                                                                                                                                                                                                      #include <signal.h>

#define OSK_V2_3


#ifdef OSK_V2_2
/*
 * WARNING: Alarms don't work properly in OSK Version 2.2. Sometimes
 *          the kernel "forgets" an alarm.
 */

extern int setalarm(), delalarm();

/*
 * a l a r m
 */
int alarm(time)
  int time;
{
  if (_delalarm() < 0)      /* zunaechst Alarm loeschen */
    return(-1);

  if (time == 0)            /* Bei Time == 0 nur Alarm loeschen */
    return(0);
  
  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }

  return(_setalarm(time));
}  
  
/*
 * r a l a r m
 */
int ralarm(reptime)
  int reptime;
{
  if (_delalarm() < 0)      /* zunaechst Alarm loeschen */
    return(-1);

  if (reptime == 0)         /* Bei Time == 0 nur Alarm loeschen */
    return(0);
  
  if (!(reptime & 0x80000000)) {
    reptime <<= 8;          /* Zeit wird in 256tel Sekunden angegeben */
    reptime |= 0x80000000;  /* Flag fuer 1/256 Sekunden */
  }

  return(_setrepalarm(reptime));
}
#endif


#ifdef OSK_V2_3
static int alarm_id = 0;

/*
 * a l a r m
 */
int alarm(time)
  int time;
{
  if (alarm_id != 0) {
    alm_delete(alarm_id);
    alarm_id = 0;
  }

  if (time == 0)            /* only delete alarm */
    return(0);

  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }
  
  if ((alarm_id = alm_set(SIGALRM, time)) == -1) {
    alarm_id = 0;
    return(-1);
  }

  return(0);
}


/*
 * r a l a r m
 */
int ralarm(time)
  int time;
{
  if (alarm_id != 0) {
    alm_delete(alarm_id);
    alarm_id = 0;
  }

  if (time == 0)
    return(0);

  if (!(time & 0x80000000)) {
    time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
    time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
  }
  
  if ((alarm_id = alm_cycle(SIGALRM, time)) == -1) {
    alarm_id = 0;
    return(-1);
  }

  return(0);
}
#endif
ime)) == -1) {
    alarm_id = 0;
    retualloca.c                                                                                            000600  000000  000000  00000015756 04542747464 006212                                                                                                                                                                                                                                                                                                                                                                      /*
 * alloca -- (mostly) portable public-domain implementation -- D A Gwyn last
 * edit:        86/05/30        rms include config.h, since on VMS it renames
 * some symbols. Use xmalloc instead of malloc. CBARRON: xmalloc is just
 * malloc with a error message if malloc fails because of being out of
 * memory.Use malloc instead
 * 
 * David
 * 
 * This implementation of the PWB library alloca() function, which is used to
 * allocate space off the run-time stack so that it is automatically
 * reclaimed upon procedure exit, was inspired by discussions with J. Q.
 * Johnson of Cornell. It should work under any C implementation that uses an
 * actual procedure stack (as opposed to a linked list of frames).  There are
 * some preprocessor constants that can be defined when compiling for your
 * specific system, for improved efficiency; however, the defaults should be
 * okay. The general concept of this implementation is to keep track of all
 * alloca()-allocated blocks, and reclaim any that are found to be deeper in
 * the stack than the current invocation.  This heuristic does not reclaim
 * storage as soon as it becomes invalid, but it will do so eventually. As a
 * special case, alloca(0) reclaims storage without allocating any.  It is a
 * good idea to use alloca(0) in your main control loop, etc. to force
 * garbage collection.
 * 
 * $Id: alloca.c,v 1.2 89/02/20 20:15:36 dclemans Exp $
 * 
 * $Log:        alloca.c,v $ Revision 1.2  89/02/20  20:15:36  dclemans Add RCS
 * identifiers
 * 
 */

#ifdef MWC
#undef lint
#undef emacs
#undef XJ311
#endif

#ifdef NOTDEF
#ifndef lint
static char     SCCSid[] = "@(#)alloca.c        1.1";   /* for the "what" utilit
                                                         * y */
#endif
#endif

#ifdef emacs
#include "config.h"
#ifdef static
/*
 * actually, only want this if static is defined as "" -- this is for usg, in
 * which emacs must undefine static in order to make unexec workable
 */
#ifndef STACK_DIRECTION
you
lose
-- must know STACK_DIRECTION at compile - time
#endif                                            /* STACK_DIRECTION
                                                   * undefined */
#endif static
#endif emacs


#ifdef X3J11
typedef void   *pointer;                          /* generic pointer type */
#else
typedef char   *pointer;                          /* generic pointer type */
#endif

#define NULL    0                                 /* null pointer constant */
extern void     free();

extern char *malloc();


/*
 * Define STACK_DIRECTION if you know the direction of stack growth for your
 * system; otherwise it will be automatically deduced at run-time.
 * STACK_DIRECTION > 0 => grows toward higher addresses STACK_DIRECTION < 0
 * => grows toward lower addresses STACK_DIRECTION = 0 => direction of growth
 * unknown
 */
#ifdef OSK
#define STACK_DIRECTION -1
#endif

#ifdef MWC
#define STACK_DIRECTION 0
#define pointer char *
#endif

#ifndef STACK_DIRECTION
#define STACK_DIRECTION 0                         /* direction unknown */
#endif

#if STACK_DIRECTION != 0
#define STACK_DIR       STACK_DIRECTION           /* known at compile-time */
#else                                             /* STACK_DIRECTION == 0;
                                                   * need run-time code */
static int      stack_dir;                        /* 1 or -1 once known */

#define STACK_DIR stack_dir

/*
 * f i n d _ s t a c k _ d i r e c t i o n
 */
static void find_stack_direction( /* void */ )
{
  static char  *addr = NULL;                      /* address of first
                                                   * `dummy', once known */
  auto char    dummy;                             /* to get stack address */

  if (addr == NULL) {                             /* initial entry */
    addr = &dummy;
    find_stack_direction();                       /* recurse once */
  }
  else
   /*
    * second entry
    */
    if (&dummy > addr)
      stack_dir = 1;                              /* stack grew upward */
    else
      stack_dir = -1;                             /* stack grew downward */
}
#endif                                            /* STACK_DIRECTION == 0 */

/*
 * An "alloca header" is used to: (a) chain together all alloca()ed blocks;
 * (b) keep track of stack depth. It is very important that sizeof(header)
 * agree with malloc() alignment chunk size.  The following default should
 * work okay.
 */
#ifndef ALIGN_SIZE
#define ALIGN_SIZE sizeof(double)
#endif

typedef union hdr {
  char align[ALIGN_SIZE];                         /* to force sizeof(header) */

  struct {
    union hdr *next;                              /* for chaining headers */
    char      *deep;                              /* for stack depth measure */
  }    h;
} header;

char *get_frame();

#asm
get_frame
 move.l(a5),d0
 rts
#endasm

/*
 * alloca( size ) returns a pointer to at least `size' bytes of storage which
 * will be automatically reclaimed upon exit from the procedure that called
 * alloca().  Originally, this space was supposed to be taken from the
 * current stack frame of the caller, but that method cannot be made to work
 * for some implementations of C, for example under Gould's UTX/32.
 */
static header  *last_alloca_header = NULL;        /* -> last alloca header */


/*
 * a l l o c a
 */
pointer alloca(size)                              /* returns pointer to
                                                   * storage */
  unsigned size;                                  /* # bytes to allocate */
{
#ifdef OSK
  register char *depth = get_frame();
#else
  auto char     probe;                            /* probes stack depth: */
  register char *depth = &probe;
#endif

#if STACK_DIRECTION == 0
  if (STACK_DIR == 0)                             /* unknown growth direction */
    find_stack_direction();
#endif

  /*
   * Reclaim garbage, defined as all alloca()ed storage that was allocated
   * from deeper in the stack than currently.
   */
  {
    register header *hp;                          /* traverses linked list */

    for (hp = last_alloca_header; hp != NULL;)
      if (STACK_DIR > 0 && hp->h.deep > depth
          || STACK_DIR < 0 && hp->h.deep < depth) {
        register header *np = hp->h.next;

        free((pointer) hp);                       /* collect garbage */
        hp = np;                                  /* -> next header */
      }
      else
        break;                                    /* rest are not deeper */

    last_alloca_header = hp;                      /* -> last valid storage */
  }

  if (size == 0)
    return(NULL);                                 /* no allocation required */

  /*
   * Allocate combined header + user data storage.
   */
  {
    register pointer new = malloc(sizeof(header) + size);

    if (new == NULL)
      return(NULL);

    /*
     * address of header
     */
    ((header *) new)->h.next = last_alloca_header;
    ((header *) new)->h.deep = depth;

    last_alloca_header = (header *) new;

    /*
     * User storage begins just after header.
     */
    return((pointer) ((char *) new + sizeof(header)));
  }
}
                  atime.c                                                                                             000604  000000  000000  00000005075 04542747464 006053                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  atime()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim and
 |                           Ulli Dessauer, Germering
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */


#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <strings.h>

extern char *getenv();

static char *month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"} ;
static char *day[]   = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

/*
 * g e t t z
 */
char *gettz(tm)
  register struct tm *tm;
{
  char          *tz;
  static char   tzbuf[20];

  tzbuf[0] = '\0';
  
  if ((tz = getenv("TZ")) == NULL)
    return(tzbuf);
  
  (void) strncpy(tzbuf, tz, 3);
  tzbuf[3] = '\0';

  if (tm->tm_isdst == 1)
    (void) strcat(tzbuf, " DST");

  return(tzbuf);
}
  
/*
 * a t i m e
 */
char *atime(tp)
  time_t *tp;
{
  struct tm   *tm;
  static char timestr[40];
   
  tm = localtime(tp);
  
  (void) sprintf(timestr, "%3.3s %3.3s %2d, %4d %02d:%02d:%02d %s (%s)",
                          day[tm->tm_wday], month[tm->tm_mon], 
                          tm->tm_mday, tm->tm_year+1900, 
                          tm->tm_hour, tm->tm_min, tm->tm_sec,
                          gettz(tm), day[tm->tm_wday]);

  return(timestr);
}


/*
 * g t i m e
 */
char *gtime(tp)
  time_t *tp;
{
  struct tm   *tm;
  static char timestr[40];
   
  tm = gmtime(tp);
  
  (void) sprintf(timestr, "%3.3s %3.3s %2d, %4d %02d:%02d:%02d GMT",
                          day[tm->tm_wday], month[tm->tm_mon], 
                          tm->tm_mday, tm->tm_year+1900, 
                          tm->tm_hour, tm->tm_min, tm->tm_sec);
                          

  return(timestr);
}
ec,
                          gettz(tm), day[tm->tm_wday]);

  return(timestr);
}


/*
 * g t i m e
 */
char *gtime(tp)
  time_t *tp;
{
  struct tm   *tm;
  static char timestr[40];
   
  tm = gmtime(tp);
  
  (void) sprintf(timestr, "%3.3s %3.3s %2d, %4d %02d:%02d:%02d GMT",
                          day[tm->tm_wday], month[tm->tm_mon], 
                          tm->tm_mday, tm->tm_year+1900, 
                          tm->tm_hour, tm->tm_min, tbcopy.c                                                                                             000600  000000  000000  00000002666 04542747464 006067                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  bcopy(), bcmp(), bzero()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#include <stdio.h>

/*
 * b c o p y
 */
int bcopy(src, dest, size)
  char  *src, *dest;
  int   size;
{
  return(memcpy(dest, src, size));
}

/*
 * b c m p
 */
int bcmp(s1, s2, size)
  char *s1, *s2;
  int  size;
{
  return(memcmp(s1, s2, size));
}

/*
 * b z e r o
 */
int bzero(s, size)
  register char *s;
  register int  size;
{
  memset(s, 0, size);
}
           pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsysbootdrv.c                                                                                           000604  000000  000000  00000004052 04542747464 006425                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  _bootdrive(), ddfopen()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>

/*
 * _ b o o t d r i v e
 */
char *_bootdrive()
{
  static char    drv[33];
  register short *init_mod;
  register char  *drive;
	
  if ((init_mod = (short *) modlink("init", mktypelang(MT_SYSTEM, ML_ANY))) ==
      (short *) -1)
    return(NULL);

  if (drive = (char *) init_mod + *(init_mod + 0x20))
    strcpy(drv, drive);
  else {
    munlink(init_mod);
    return(NULL);
  }

  munlink(init_mod);
  return(drv);
}

/*
 * d d f o p e n
 */
FILE *ddfopen(fn, fname, mode, boot)
  register char *fn;
  register char *fname;
  register char *mode;
  int           boot;
{
  register FILE *fp;
  register char *drv;

  if (!boot) {
    strcpy(fname, "/dd/");
    strcat(fname, fn);

    if (fp = fopen(fname, mode))
      return(fp);
  }

  if (drv = _bootdrive()) {
    strcpy(fname, drv);
    strcat(fname, "/");
    strcat(fname, fn);
    return(fopen(fname, mode));
  }
  else
    return(NULL);
}
k(init_mod);
  return(drv);
}

/*
 * d d f o p e n
 */
FILE *ddfopen(fn, fname, mode, boot)
  register char *fn;
  register char *fname;
  register char *mode;
  int           boot;
{
  register FILE *fp;
  register char *drv;

  if (!boot) {
    strcpy(fname, "/dd/");
    strcat(fname, fn);

    if (fp = fopen(fname, mode))
      return(fp);
  }

  if (drv = _bootdrive()) {
    strcpy(fname, drv);
    strcat(fname, "/");
    strcat(fname, fn);
    return(fopen(fnambsearch.c                                                                                           000604  000000  000000  00000002064 04542747464 006356                                                                                                                                                                                                                                                                                                                                                                      /*  bsearch(3)
 *
 *  Author: Terrence Holm          Aug. 1988
 *
 *
 *  Performs a binary search for a given <key> within a sorted
 *  table. The table contains <count> entries of size <width>
 *  and starts at <base>.
 *
 *  Entries are compared using keycmp( key, entry ), each argument
 *  is a (char *), the function returns an int < 0, = 0 or > 0
 *  according to the order of the two arguments.
 *
 *  Bsearch(3) returns a pointer to the matching entry, if found,
 *  otherwise NULL is returned.
 */

#include <stdio.h>

char *bsearch(key, base, count, width, keycmp)
  char                  *key;
  register char         *base;
  register unsigned int count;
  unsigned int          width;
  int                   (*keycmp)();
{
  register char *mid_point;
  register int  cmp;

  while (count > 0) {
    mid_point = base + width * (count >> 1);

    cmp = keycmp(key, mid_point);

    if (cmp == 0)
      return(mid_point);

    if (cmp < 0)
      count >>= 1;
    else {
      base  = mid_point + width;
      count = (count - 1) >> 1;
    }
  }

  return(NULL);
}

h, keycmp)
  char                  *key;
  register char         *base;
  register unsigned int count;
  unsigned int          width;
  int                   (*keycmp)();
{
  register char *mid_point;
  register int  cmp;

  while (count > 0) {
    mid_point = base + width * (count >> 1);

    cmp = keycmp(key, mid_point);

    if (cmp == 0)
      return(mid_point);

    if (cmp < 0)
      count >>= 1;
    else {
      base  = mid_point + width;
      counchgrppass.c                                                                                         000604  000000  000000  00000007132 04542747464 006742                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  change_grppasswd()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <grp.h>
#include <strings.h>

extern struct group  *_getgr();
extern char          *crypt();

static struct group  group;
static char	     line[256];

/*
 * c h a n g e _ g r p p a s s w d
 */
change_grppasswd (name, password)
  char *name, *password;
{
  char          *cryptpw;
  int           found, pos, Count;
  struct group  *gr;
  int           grfd, tmpfd;
  char          tmpname[256], tmp[256];
  char          *cp1, *cp2;

  /*
   * Group-File fuer Update oeffnen
   */
  if ((grfd = open(GROUP, S_IREAD+S_IWRITE)) < 0)
    return(-1);

  found = 0;

  /*
   * zunaechst suchen wir im Password-File den Eintrag fuer den User
   */
  while (pos = lseek(grfd, 0, 1), (Count = readln(grfd, line, BUFSIZ)) > 0) {
    line[Count] = '\0';
    gr = _getgr(&group, line);

    if (gr && (!_strccmp(name, gr->gr_name))) {
      found = 1;
      break;
    }
  }

  if (!found)
    return(-1);

  /*
   * erstes Colon suchen (danach steht das Passwort)
   */
  if (!(cp1 = index(line, ':'))) {
    close(grfd);
    return(-1);
  }

  if (!(cp2 = index(cp1+1, ':'))) {
    close(grfd);
    return(-1);
  }

  if (strlen(password))
    if (strlen(gr->gr_passwd) < 2)
      cryptpw = crypt(password, _rnd_salt());
    else
      cryptpw = crypt(password, gr->gr_passwd);

  if (cp2-cp1 == 15) {
    /*
     * Passwort einkopieren
     */
    for (cp1 += 1; cp1 < cp2; cp1++)
      *cryptpw++ = *cp1;

    lseek(grfd, -Count, 1);
    writeln(grfd, line, strlen(line));
    close(grfd);
    return(0);
  }
  else {
    _ss_lock(grfd, -1);
    lseek(grfd, 0, 0);

    sprintf(tmpname, "/dd/grXXXXXX");
    mktemp(tmpname);

    if ((tmpfd = creat(tmpname, S_IREAD+S_IWRITE)) < 0) {
      close(grfd);
      return(-1);
    }

    while (lseek(grfd, 0, 1) != pos) {
      Count = readln(grfd, tmp, BUFSIZ);
      writeln(tmpfd, tmp, Count);
    }

    write(tmpfd, line, cp1-line+1);
    if (strlen(password))
      write(tmpfd, cryptpw, strlen(cryptpw));

    /*
     * ein bisschen trickreich: wir schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(grfd, tmp, BUFSIZ);

    while ((Count = readln(grfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(grfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(grfd, tmp, Count);
    close(tmpfd);
    _ss_size(grfd, lseek(grfd, 0, 1));
    close(grfd);

    unlink(tmpname);
    return(0);
  }
}
schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(grfd, tmp, BUFSIZ);

    while ((Count = readln(grfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(grfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(grfd, tmp, Count);
    close(tmpfd);
    _ss_schpass.c                                                                                            000604  000000  000000  00000007202 04542747464 006227                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  change_passwd()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <pwd.h>
#include <strings.h>

extern struct passwd *_getpw();
extern char          *crypt();

static char          *PASS = "/h0/SYS/password";
static struct passwd passwd;
static char	     line[256];

/*
 * c h a n g e _ p a s s w d
 */
change_passwd(name, password)
  char *name, *password;
{
  char          *cryptpw;
  int           found, pos, Count;
  struct passwd *pw;
  int           pwfd, tmpfd;
  char          tmpname[256], tmp[256];
  char          *cp1, *cp2;

  /*
   * Passwort-File fuer Update oeffnen
   */
  if ((pwfd = open(PASS, S_IREAD+S_IWRITE)) < 0)
    return(-1);

  found = 0;

  /*
   * zunaechst suchen wir im Password-File den Eintrag fuer den User
   */
  while (pos = lseek(pwfd, 0, 1), (Count = readln(pwfd, line, BUFSIZ)) > 0) {
    line[Count] = '\0';
    pw = _getpw(&passwd, line);

    if (pw && (!_strccmp(name, pw->pw_name))) {
      found = 1;
      break;
    }
  }

  if (!found)
    return(-1);

  /*
   * erstes Komma suchen (danach steht das Passwort)
   */
  if (!(cp1 = index(line, ','))) {
    close(pwfd);
    return(-1);
  }

  if (!(cp2 = index(cp1+1, ','))) {
    close(pwfd);
    return(-1);
  }

  if (strlen(password))
    if (strlen(pw->pw_passwd) < 2)
      cryptpw = crypt(password, _rnd_salt());
    else
      cryptpw = crypt(password, pw->pw_passwd);

  if (cp2-cp1 == 15) {
    /*
     * Passwort einkopieren
     */
    for (cp1 += 1; cp1 < cp2; cp1++)
      *cryptpw++ = *cp1;

    lseek(pwfd, -Count, 1);
    writeln(pwfd, line, strlen(line));
    close(pwfd);
    return(0);
  }
  else {
    _ss_lock(pwfd, -1);
    lseek(pwfd, 0, 0);

    sprintf(tmpname, "/dd/pwXXXXXX");
    mktemp(tmpname);

    if ((tmpfd = creat(tmpname, S_IREAD+S_IWRITE)) < 0) {
      close(pwfd);
      return(-1);
    }

    while (lseek(pwfd, 0, 1) != pos) {
      Count = readln(pwfd, tmp, BUFSIZ);
      writeln(tmpfd, tmp, Count);
    }

    write(tmpfd, line, cp1-line+1);
    if (strlen(password))
      write(tmpfd, cryptpw, strlen(cryptpw));

    /*
     * ein bisschen trickreich: wir schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(pwfd, tmp, BUFSIZ);

    while ((Count = readln(pwfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(pwfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(pwfd, tmp, Count);
    close(tmpfd);
    _ss_size(pwfd, lseek(pwfd, 0, 1));
    close(pwfd);

    unlink(tmpname);
    return(0);
  }
}
schreiben bis zum CR!!
     */
    writeln(tmpfd, cp2, strlen(line));
 
    Count = readln(pwfd, tmp, BUFSIZ);

    while ((Count = readln(pwfd, tmp, BUFSIZ)) > 0)
      writeln(tmpfd, tmp, Count);
    close(tmpfd);
    
    if ((tmpfd = open(tmpname, S_IREAD)) < 0)
      return(-1);

    lseek(pwfd, 0, 0);
    while ((Count = readln(tmpfd, tmp, BUFSIZ)) > 0)
      writeln(pwfd, crypt.c                                                                                             000604  000000  000000  00000015077 04542747464 006120                                                                                                                                                                                                                                                                                                                                                                      /*	From Andy Tanenbaum's book "Computer Networks",
	rewritten in C
*/

struct block {
	unsigned char b_data[64];
};

struct ordering {
	unsigned char o_data[64];
};

static struct block key;

static struct ordering InitialTr = {
	58,50,42,34,26,18,10, 2,60,52,44,36,28,20,12, 4,
	62,54,46,38,30,22,14, 6,64,56,48,40,32,24,16, 8,
	57,49,41,33,25,17, 9, 1,59,51,43,35,27,19,11, 3,
	61,53,45,37,29,21,13, 5,63,55,47,39,31,23,15, 7,
};

static struct ordering FinalTr = {
	40, 8,48,16,56,24,64,32,39, 7,47,15,55,23,63,31,
	38, 6,46,14,54,22,62,30,37, 5,45,13,53,21,61,29,
	36, 4,44,12,52,20,60,28,35, 3,43,11,51,19,59,27,
	34, 2,42,10,50,18,58,26,33, 1,41, 9,49,17,57,25,
};

static struct ordering swap = {
	33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
	49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
	 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
	17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
};

static struct ordering KeyTr1 = {
	57,49,41,33,25,17, 9, 1,58,50,42,34,26,18,
	10, 2,59,51,43,35,27,19,11, 3,60,52,44,36,
	63,55,47,39,31,23,15, 7,62,54,46,38,30,22,
	14, 6,61,53,45,37,29,21,13, 5,28,20,12, 4,
};

static struct ordering KeyTr2 = {
	14,17,11,24, 1, 5, 3,28,15, 6,21,10,
	23,19,12, 4,26, 8,16, 7,27,20,13, 2,
	41,52,31,37,47,55,30,40,51,45,33,48,
	44,49,39,56,34,53,46,42,50,36,29,32,
};

static struct ordering etr = {
	32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9,
	 8, 9,10,11,12,13,12,13,14,15,16,17,
	16,17,18,19,20,21,20,21,22,23,24,25,
	24,25,26,27,28,29,28,29,30,31,32, 1,
};

static struct ordering ptr = {
	16, 7,20,21,29,12,28,17, 1,15,23,26, 5,18,31,10,
	 2, 8,24,14,32,27, 3, 9,19,13,30, 6,22,11, 4,25,
};

static unsigned char s_boxes[8][64] = {
{	14, 4,13, 1, 2,15,11, 8, 3,10, 6,12, 5, 9, 0, 7,
	 0,15, 7, 4,14, 2,13, 1,10, 6,12,11, 9, 5, 3, 8,
	 4, 1,14, 8,13, 6, 2,11,15,12, 9, 7, 3,10, 5, 0,
	15,12, 8, 2, 4, 9, 1, 7, 5,11, 3,14,10, 0, 6,13,
},

{	15, 1, 8,14, 6,11, 3, 4, 9, 7, 2,13,12, 0, 5,10,
	 3,13, 4, 7,15, 2, 8,14,12, 0, 1,10, 6, 9,11, 5,
	 0,14, 7,11,10, 4,13, 1, 5, 8,12, 6, 9, 3, 2,15,
	13, 8,10, 1, 3,15, 4, 2,11, 6, 7,12, 0, 5,14, 9,
},

{	10, 0, 9,14, 6, 3,15, 5, 1,13,12, 7,11, 4, 2, 8,
	13, 7, 0, 9, 3, 4, 6,10, 2, 8, 5,14,12,11,15, 1,
	13, 6, 4, 9, 8,15, 3, 0,11, 1, 2,12, 5,10,14, 7,
	 1,10,13, 0, 6, 9, 8, 7, 4,15,14, 3,11, 5, 2,12,
},

{	 7,13,14, 3, 0, 6, 9,10, 1, 2, 8, 5,11,12, 4,15,
	13, 8,11, 5, 6,15, 0, 3, 4, 7, 2,12, 1,10,14, 9,
	10, 6, 9, 0,12,11, 7,13,15, 1, 3,14, 5, 2, 8, 4,
	 3,15, 0, 6,10, 1,13, 8, 9, 4, 5,11,12, 7, 2,14,
},

{	 2,12, 4, 1, 7,10,11, 6, 8, 5, 3,15,13, 0,14, 9,
	14,11, 2,12, 4, 7,13, 1, 5, 0,15,10, 3, 9, 8, 6,
	 4, 2, 1,11,10,13, 7, 8,15, 9,12, 5, 6, 3, 0,14,
	11, 8,12, 7, 1,14, 2,13, 6,15, 0, 9,10, 4, 5, 3,
},

{	12, 1,10,15, 9, 2, 6, 8, 0,13, 3, 4,14, 7, 5,11,
	10,15, 4, 2, 7,12, 9, 5, 6, 1,13,14, 0,11, 3, 8,
	 9,14,15, 5, 2, 8,12, 3, 7, 0, 4,10, 1,13,11, 6,
	 4, 3, 2,12, 9, 5,15,10,11,14, 1, 7, 6, 0, 8,13,
},

{	 4,11, 2,14,15, 0, 8,13, 3,12, 9, 7, 5,10, 6, 1,
	13, 0,11, 7, 4, 9, 1,10,14, 3, 5,12, 2,15, 8, 6,
	 1, 4,11,13,12, 3, 7,14,10,15, 6, 8, 0, 5, 9, 2,
	 6,11,13, 8, 1, 4,10, 7, 9, 5, 0,15,14, 2, 3,12,
},

{	13, 2, 8, 4, 6,15,11, 1,10, 9, 3,14, 5, 0,12, 7,
	 1,15,13, 8,10, 3, 7, 4,12, 5, 6,11, 0,14, 9, 2,
	 7,11, 4, 1, 9,12,14, 2, 0, 6,10,13,15, 3, 5, 8,
	 2, 1,14, 7, 4,10, 8,13,15,12, 9, 0, 3, 5, 6,11,
},
};

static short rots[] = {
	1,1,2,2,2,2,2,2,1,2,2,2,2,2,2,1,
};

static
transpose(data, t, n)
	register struct block *data;
	register struct ordering *t;
	register short n;
{
	struct block x;

	x = *data;

	while (n-- > 0) {
		data->b_data[n] = x.b_data[t->o_data[n] - 1];
	}
}

static
rotate(key)
	register struct block *key;
{
	register unsigned char *p = key->b_data;
	register unsigned char *ep = &(key->b_data[55]);
	register short data0 = key->b_data[0], data28 = key->b_data[28];

	while (p++ < ep) *(p-1) = *p;
	key->b_data[27] = data0;
	key->b_data[55] = data28;
}

static struct ordering *EP = &etr;

static
f(i, key, a, x)
	struct block *key, *a;
	register struct block *x;
{
	struct block e, ikey, y;
	register short k;
	register unsigned char *p, *q, *r;

	e = *a;
	transpose(&e, EP, 48);
	for (k = rots[i]; k; k--) rotate(key);
	ikey = *key;
	transpose(&ikey, &KeyTr2, 48);
	p = &(y.b_data[48]);
	q = &(e.b_data[48]);
	r = &(ikey.b_data[48]);
	while (p > y.b_data) {
		*--p = *--q ^ *--r;
	}
	q = x->b_data;
	for (k = 0; k < 8; k++) {
		register short xb, r;

		r = *p++ << 5;
		r += *p++ << 3;
		r += *p++ << 2;
		r += *p++ << 1;
		r += *p++;
		r += *p++ << 4;

		xb = s_boxes[k][r];

		*q++ = (xb >> 3) & 1;
		*q++ = (xb>>2) & 1;
		*q++ = (xb>>1) & 1;
		*q++ = (xb & 1);
	}
	transpose(x, &ptr, 32);
}

setkey(k)
	register char *k;
{

	key = *((struct block *) k);
	transpose(&key, &KeyTr1, 56);
}

encrypt(blck, edflag)
	char *blck;
{
	register struct block *p = (struct block *) blck;
	register short i;

	transpose(p, &InitialTr, 64);
	for (i = 15; i>= 0; i--) {
		register short j = edflag ? i : 15 - i;
		register short k;
		struct block b, x;

		b = *p;
		for (k = 31; k >= 0; k--) {
			p->b_data[k] = b.b_data[k + 32];
		}
		f(j, &key, p, &x);
		for (k = 31; k >= 0; k--) {
			p->b_data[k+32] = b.b_data[k] ^ x.b_data[k];
		}
	}
	transpose(p, &swap, 64);
	transpose(p, &FinalTr, 64);
}

char *
crypt(pw,salt)
	register char *pw;
	char *salt;
{
	/*	Unfortunately, I had to look at the sources of V7 crypt.
		There was no other way to find out what this routine
		actually does.
	*/
	
	char pwb[66];
	static char result[16];
	register char *p = pwb;
	struct ordering new_etr;
	register short i;

	while (*pw && p < &pwb[64]) {
		register short j = 7;

		while (j--) {
			*p++ = (*pw >> j) & 01;
		}
		pw++;
		*p++ = 0;
	}
	while (p < &pwb[64]) *p++ = 0;

	setkey(p = pwb);

	while (p < &pwb[66]) *p++ = 0;

	new_etr = etr;
	EP = &new_etr;
	for (i = 0; i < 2; i++) {
		register char c = *salt++;
		register short j;

		result[i] = c;
		if ( c > 'Z') c -= 6 + 7 + '.';	/* c was a lower case letter */
		else if ( c > '9') c -= 7 + '.';/* c was upper case letter */
		else c -= '.';			/* c was digit, '.' or '/'. */
						/* now, 0 <= c <= 63 */
		for (j = 0; j < 6; j++) {
			if ((c >> j) & 01) {
				short t = 6*i + j;
				short temp = new_etr.o_data[t];
				new_etr.o_data[t] = new_etr.o_data[t+24];
				new_etr.o_data[t+24] = temp;
			}
		}
	}

	if (result[1] == 0) result[1] = result[0];

	for (i = 0; i < 25; i++) encrypt(pwb,0);
	EP = &etr;

	p = pwb;
	pw = result+2;
	while (p < &pwb[66]) {
		register short c = 0;
		register short j = 6;

		while (j--) {
			c <<= 1;
			c |= *p++;
		}
		c += '.';		/* becomes >= '.' */
		if (c > '9') c += 7;	/* not in [./0-9], becomes upper */
		if (c > 'Z') c += 6;	/* not in [A-Z], becomes lower */
		*pw++ = c;
	}
	*pw = 0;
	return result;
}
t] = new_etr.o_data[t+24];
				new_etr.o_data[t+24] = temp;
			}
		}
	}

	if (result[1] == 0) result[1] = result[0];

	for (i = 0; i < 25; i++) encrypt(pwb,0);
	EP = &etr;

	p = pwb;
	pw = result+2;
	while (p < &pwb[66]) {
		register short c = 0;
		register short j = 6;

		while (j--) {
			c <<= 1;
			c |= *p++;
		}
		c += '.';		/* becomes >= '.' */
		if (c > '9') c += 7;	/* not in [./0-9], becomes upper */
		if (c > 'Z') c += 6;	/* not in [A-Z]cuserid.c                                                                                           000604  000000  000000  00000003237 04542747464 006410                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  cuserid(), chome()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <pwd.h>

extern char *getenv();

/*
 * c u s e r i d
 */
char *cuserid()
{
  static                 char username[40];
  register struct passwd *pw;
  
  if (pw = getpwuid(getuid() & 0x0ffff)) {
    strcpy(username, pw->pw_name);
    return(username);
  }
  else
    return(NULL);   /* Fehler */
}


/*
 * c h o m e
 */
char *chome()
{
  static                 char home[200];
  register struct passwd *pw;

  if (pw = getpwuid(getuid() & 0x0ffff)) {
    strcpy(home, pw->pw_dir);
    return(home);
  }
  else
    return(NULL);   /* Fehler */
}

*
 * c u s e r i d
 */
char *cuserid()
{
  static                 char username[40];
  register struct passwd *pw;
  
  if (pw = getpwuid(getuid() & 0x0ffff)) {
    strcpy(username, pw->pw_name);
    return(username);
  }
  else
    return(NULL);   /* Fehler */
}


/*
 * c h o m e
 */
char *chome()
{
  static                 char home[200];
  registerdbm.c                                                                                               000604  000000  000000  00000021114 04542747464 005506                                                                                                                                                                                                                                                                                                                                                                      /*
 * DBM database functions.
 *
 * This source is distributed with the X-Windows system.
 *
 * Adapted to OS-9/68000 by reccoware systems, Wolfgang Ocker, Puchheim
 * January 1989
 *
 * Changes:
 *    parameter "createflag" added to dbminit. Only if set the database
 *    is created, else we only try to open it.
 */


#include	"dbm.h"
#include	<types.h>
#include	<stat.h>
#include	<modes.h>

dbminit(file, createflag)
char *file;
int createflag;
{
	struct stat statb;

	if(dirf == pagf){	/* first call */
		dbrdonly = 0;
		strcpy(pagbuf, file);
		strcat(pagbuf, ".pag");
		if (createflag)
			pagf = create(pagbuf, S_IREAD+S_IWRITE,
			              S_IREAD+S_IWRITE+S_IOREAD+S_IOWRITE);
		else
			pagf = -1;

		if (pagf < 0)
			pagf = open(pagbuf, S_IREAD+S_IWRITE);

		if (pagf < 0) {
			pagf = open(pagbuf, S_IREAD);
			dbrdonly = 1;
		}

		strcpy(pagbuf, file);
		strcat(pagbuf, ".dir");
		if (createflag)
			dirf = create(pagbuf, S_IREAD+S_IWRITE,
			              S_IREAD+S_IWRITE+S_IOREAD+S_IOWRITE);
		else
			dirf = -1;

		if (dirf < 0)
			dirf = open(pagbuf, S_IREAD+S_IWRITE);
		if (dirf < 0) {
			dirf = open(pagbuf, S_IREAD);
			dbrdonly = 1;
		}
		if(pagf < 0 || dirf < 0) {
#ifdef DEBUG
			printf("cannot open database %s\n", file);
#endif
			return(-1);
		}
	}
	fstat(dirf, &statb);
	maxbno = statb.st_size*BYTESIZ-1;
	return(0);
}

static long
forder(key)
datum key;
{
	long hash;

	hash = calchash(key);
	for(hmask=0;; hmask=(hmask<<1)+1) {
		blkno = hash & hmask;
		bitno = blkno + hmask;
		if(getbit() == 0)
			break;
	}
	return(blkno);
}

datum
fetch(key)
datum key;
{
	register i;
	datum item;

	dbm_access(calchash(key));
	for(i=0;; i+=2) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			return(item);
		if(cmpdatum(key, item) == 0) {
			item = makdatum(pagbuf, i+1);
#ifdef DEBUG
			if(item.dptr == NULL)
				printf("items not in pairs\n");
#endif
			return(item);
		}
	}
}

delete(key)
datum key;
{
	register i;
	datum item;

	if (dbrdonly)
		return -1;
	dbm_access(calchash(key));
	for(i=0;; i+=2) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			return(-1);
		if(cmpdatum(key, item) == 0) {
			delitem(pagbuf, i);
			delitem(pagbuf, i);
			break;
		}
	}
	lseek(pagf, blkno*PBLKSIZ, 0);
	write(pagf, pagbuf, PBLKSIZ);
	return(0);
}

store(key, dat)
datum key, dat;
{
	register i;
	datum item;
	char ovfbuf[PBLKSIZ];

	if (dbrdonly)
		return -1;
loop:
	dbm_access(calchash(key));
	for(i=0;; i+=2) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			break;
		if(cmpdatum(key, item) == 0) {
			delitem(pagbuf, i);
			delitem(pagbuf, i);
			break;
		}
	}
	i = additem(pagbuf, key);
	if(i < 0)
		goto split;
	if(additem(pagbuf, dat) < 0) {
		delitem(pagbuf, i);
		goto split;
	}
	lseek(pagf, blkno*PBLKSIZ, 0);
	write(pagf, pagbuf, PBLKSIZ);
	return (0);

split:
	if(key.dsize+dat.dsize+2*sizeof(short) >= PBLKSIZ) {
#ifdef DEBUG
		printf("entry too big\n");
#endif
		return (-1);
	}
	clrbuf(ovfbuf, PBLKSIZ);
	for(i=0;;) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			break;
		if(calchash(item) & (hmask+1)) {
			additem(ovfbuf, item);
			delitem(pagbuf, i);
			item = makdatum(pagbuf, i);
			if(item.dptr == NULL) {
#ifdef DEBUG
				printf("split not paired\n");
#endif
				break;
			}
			additem(ovfbuf, item);
			delitem(pagbuf, i);
			continue;
		}
		i += 2;
	}
	lseek(pagf, blkno*PBLKSIZ, 0);
	write(pagf, pagbuf, PBLKSIZ);
	lseek(pagf, (blkno+hmask+1)*PBLKSIZ, 0);
	write(pagf, ovfbuf, PBLKSIZ);
	setbit();
	goto loop;
}

datum
firstkey()
{
	return(firsthash(0L));
}

datum
nextkey(key)
datum key;
{
	register i;
	datum item, bitem;
	long hash;
	int f;

	hash = calchash(key);
	dbm_access(hash);
	f = 1;
	for(i=0;; i+=2) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			break;
		if(cmpdatum(key, item) <= 0)
			continue;
		if(f || cmpdatum(bitem, item) < 0) {
			bitem = item;
			f = 0;
		}
	}
	if(f == 0)
		return(bitem);
	hash = hashinc(hash);
	if(hash == 0)
		return(item);
	return(firsthash(hash));
}

static datum
firsthash(hash)
long hash;
{
	register i;
	datum item, bitem;

loop:
	dbm_access(hash);
	bitem = makdatum(pagbuf, 0);
	for(i=2;; i+=2) {
		item = makdatum(pagbuf, i);
		if(item.dptr == NULL)
			break;
		if(cmpdatum(bitem, item) < 0)
			bitem = item;
	}
	if(bitem.dptr != NULL)
		return(bitem);
	hash = hashinc(hash);
	if(hash == 0)
		return(item);
	goto loop;
}

static dbm_access(hash)
long hash;
{
	static long oldb = -1;

	for(hmask=0;; hmask=(hmask<<1)+1) {
		blkno = hash & hmask;
		bitno = blkno + hmask;
		if(getbit() == 0)
			break;
	}
	if(blkno != oldb) {
		clrbuf(pagbuf, PBLKSIZ);
		lseek(pagf, blkno*PBLKSIZ, 0);
		read(pagf, pagbuf, PBLKSIZ);
		chkblk(pagbuf);
		oldb = blkno;
	}
}

static
getbit()
{
	long bn;
	register b, i, n;
	static oldb = -1;

	if(bitno > maxbno)
		return(0);
	n = bitno % BYTESIZ;
	bn = bitno / BYTESIZ;
	i = bn % DBLKSIZ;
	b = bn / DBLKSIZ;
	if(b != oldb) {
		clrbuf(dirbuf, DBLKSIZ);
		lseek(dirf, (long)b*DBLKSIZ, 0);
		read(dirf, dirbuf, DBLKSIZ);
		oldb = b;
	}
	if(dirbuf[i] & (1<<n))
		return(1);
	return(0);
}

static
setbit()
{
	long bn;
	register i, n, b;

	if (dbrdonly)
		return -1;
	if(bitno > maxbno) {
		maxbno = bitno;
		getbit();
	}
	n = bitno % BYTESIZ;
	bn = bitno / BYTESIZ;
	i = bn % DBLKSIZ;
	b = bn / DBLKSIZ;
	dirbuf[i] |= 1<<n;
	lseek(dirf, (long)b*DBLKSIZ, 0);
	write(dirf, dirbuf, DBLKSIZ);
}

static
clrbuf(cp, n)
register char *cp;
register n;
{

	do
		*cp++ = 0;
	while(--n);
}

static datum
makdatum(buf, n)
char buf[PBLKSIZ];
{
	register short *sp;
	register t;
	datum item;

	sp = (short *)buf;
	if(n < 0 || n >= sp[0])
		goto null;
	t = PBLKSIZ;
	if(n > 0)
		t = sp[n+1-1];
	item.dptr = buf+sp[n+1];
	item.dsize = t - sp[n+1];
	return(item);

null:
	item.dptr = NULL;
	item.dsize = 0;
	return(item);
}

static
cmpdatum(d1, d2)
datum d1, d2;
{
	register n;
	register char *p1, *p2;

	n = d1.dsize;
	if(n != d2.dsize)
		return(n - d2.dsize);
	if(n == 0)
		return(0);
	p1 = d1.dptr;
	p2 = d2.dptr;
	do
		if(*p1++ != *p2++)
			return(*--p1 - *--p2);
	while(--n);
	return(0);
}


static int	hitab[16]
/* ken's
{
	055,043,036,054,063,014,004,005,
	010,064,077,000,035,027,025,071,
};
*/
 = {	61, 57, 53, 49, 45, 41, 37, 33,
	29, 25, 21, 17, 13,  9,  5,  1,
};
long	hltab[64]
 = {
	06100151277L,06106161736L,06452611562L,05001724107L,
	02614772546L,04120731531L,04665262210L,07347467531L,
	06735253126L,06042345173L,03072226605L,01464164730L,
	03247435524L,07652510057L,01546775256L,05714532133L,
	06173260402L,07517101630L,02431460343L,01743245566L,
	00261675137L,02433103631L,03421772437L,04447707466L,
	04435620103L,03757017115L,03641531772L,06767633246L,
	02673230344L,00260612216L,04133454451L,00615531516L,
	06137717526L,02574116560L,02304023373L,07061702261L,
	05153031405L,05322056705L,07401116734L,06552375715L,
	06165233473L,05311063631L,01212221723L,01052267235L,
	06000615237L,01075222665L,06330216006L,04402355630L,
	01451177262L,02000133436L,06025467062L,07121076461L,
	03123433522L,01010635225L,01716177066L,05161746527L,
	01736635071L,06243505026L,03637211610L,01756474365L,
	04723077174L,03642763134L,05750130273L,03655541561L,
};


static long
hashinc(hash)
long hash;
{
	long bit;

	hash &= hmask;
	bit = hmask+1;
	for(;;) {
		bit >>= 1;
		if(bit == 0)
			return(0L);
		if((hash&bit) == 0)
			return(hash|bit);
		hash &= ~bit;
	}
}

static long
calchash(item)
datum item;
{
	register i, j, f;
	long hashl;
	int hashi;

	hashl = 0;
	hashi = 0;
	for(i=0; i<item.dsize; i++) {
		f = item.dptr[i];
		for(j=0; j<BYTESIZ; j+=4) {
			hashi += hitab[f&017];
			hashl += hltab[hashi&63];
			f >>= 4;
		}
	}
	return(hashl);
}

static delitem(buf, n)
char buf[PBLKSIZ];
{
	register short *sp;
	register i1, i2, i3;

	sp = (short *)buf;
	if(n < 0 || n >= sp[0])
		goto bad;
	i1 = sp[n+1];
	i2 = PBLKSIZ;
	if(n > 0)
		i2 = sp[n+1-1];
	i3 = sp[sp[0]+1-1];
	if(i2 > i1)
	while(i1 > i3) {
		i1--;
		i2--;
		buf[i2] = buf[i1];
		buf[i1] = 0;
	}
	i2 -= i1;
	for(i1=n+1; i1<sp[0]; i1++)
		sp[i1+1-1] = sp[i1+1] + i2;
	sp[0]--;
	sp[sp[0]+1] = 0;
	return;

bad:
#ifdef DEBUG
	printf("bad delitem\n");
#endif
	abort();
}

static additem(buf, item)
char buf[PBLKSIZ];
datum item;
{
	register short *sp;
	register i1, i2;

	sp = (short *)buf;
	i1 = PBLKSIZ;
	if(sp[0] > 0)
		i1 = sp[sp[0]+1-1];
	i1 -= item.dsize;
	i2 = (sp[0]+2) * sizeof(short);
	if(i1 <= i2)
		return(-1);
	sp[sp[0]+1] = i1;
	for(i2=0; i2<item.dsize; i2++) {
		buf[i1] = item.dptr[i2];
		i1++;
	}
	sp[0]++;
	return(sp[0]-1);
}

static chkblk(buf)
char buf[PBLKSIZ];
{
	register short *sp;
	register t, i;

	sp = (short *)buf;
	t = PBLKSIZ;
	for(i=0; i<sp[0]; i++) {
		if(sp[i+1] > t)
			goto bad;
		t = sp[i+1];
	}
	if(t < (sp[0]+1)*sizeof(short))
		goto bad;
	return;

bad:
#ifdef DEBUG
	printf("bad block\n");
#endif
	abort();
	clrbuf(buf, PBLKSIZ);
}
e;
	i2 = (sp[0]+2) * sizeof(short);
	if(i1 <= i2)
		return(-1);
	sp[sp[0]+1] = i1;
	for(i2=0; i2<item.dsize; i2++) {
		buf[i1] = item.dptr[i2];
		i1++;
	}
	sp[0]++;
	return(sp[0]-1);
}

static chkblk(buf)
char buf[PBLKSIZ];
{
	register short *sp;
	register t, i;

	sp = (short *)buf;
	t = PBLKSIZ;
	for(i=0; i<sp[0]; i++) {
		if(sp[i+1] > t)
			goto bad;
		t = sp[i+1];
	}
	if(t < (sp[0]+1)*sizeof(short))
		goto bad;
	return;

bad:
#iffindmod.c                                                                                           000604  000000  000000  00000003437 04542747464 006374                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  findmod()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>

extern char *info_str();

/*
 * f i n d m o d
 */
char *findmod(modname, infoname)
  register char *modname;
  char          *infoname;
{
  static char   path[256];
  register char *mod, *cp;

  if ((cp = rindex(infoname, '/')) != NULL)
    infoname = cp + 1;

  if (info_str(infoname, path, sizeof(path)) != NULL)
    modname = path;

  if ((cp = rindex(modname, '/')) != NULL)
    cp++;
  else
    cp = modname;

  if ((mod = (char *) modlink(cp,
                              mktypelang(MT_PROGRAM, ML_ANY))) == (char *) -1)
    (void) strcpy(path, modname);
  else {
    (void) strcpy(path, cp);
    (void) munlink(mod);
  }
  
  return(path);
}
  static char   path[256];
  register char *mod, *cp;

  if ((cp = rindex(infoname, '/')) != NULL)
    infoname = cp + 1;

  if (info_str(infoname, path, sizeof(path)) != NULL)
    modname = path;

  if ((cp = rindex(modname,getargs.c                                                                                           000604  000000  000000  00000004370 04542747464 006405                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getargs()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>

#define sp _sp

#define TRUE  1
#define FALSE 0

/*
 * g e t a r g s
 */
getargs(s, args)
  register char *s;
  char     ***args;
{
  register int  i;
  register char *sp;
  register char qchar;
  int           argsnum;
  
  i = 0;
  argsnum = 40;

  if ((*args = (char **) malloc(argsnum * sizeof(char *))) == NULL)
    return(-1);

  while (TRUE) {
    if (i >= argsnum-1) {
      argsnum += 40;
      if ((*args = (char **) realloc(*args, argsnum * sizeof(char *))) == NULL)
        return(-1);
    }

    while (*s == ' ' || *s == '\t')
      ++s;
    if (*s == '\n' || *s == '\0')
      break;

    (*args)[i++] = sp = s;

    qchar = 0;
    while (*s != '\0' && *s != '\n') {
      if (qchar == 0 && (*s == ' ' || *s == '\t')) {
        ++s;
        break;
      }

      switch (*s) {
        case '"':
        case '\'':
          if (qchar == *s) {
            qchar = 0;
            ++s;
            break;
          }

          if (qchar)
            *sp++ = *s++;
          else
            qchar = *s++;
          break;

        default:
          *sp++ = *s++;
          break;
      }
    }
    *sp++ = 0;
  }

  (*args)[i] = NULL;
  return(i);
}
 (*s != '\0' && *s != '\n') {
      if (qchar == 0 && (*s == ' ' || *s == '\t')) {
        ++s;
        break;
      }

      switch (*s) {
        case '"':
        case '\'':
          if (qchar == *s) {
            qchar = 0;
            ++s;
            break;gethname.c                                                                                          000604  000000  000000  00000002551 04542747464 006540                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  gethostname()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <hostname.h>

extern char *info_str();

/*
 * g e t h o s t n a m e
 *
 * gets the name of the host from SYSINFO (fairly simple, isn't it?)
 */
char *gethostname(hostname, len)
  char *hostname;
  int  len;	
{
  return(info_str("hostname", hostname, len));
}

, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * getinfo.c                                                                                           000600  000000  000000  00000014273 04542747464 006403                                                                                                                                                                                                                                                                                                                                                                      /*
 *                          GETINFO for SYSINFO
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/06/88   Corrected modlink parameters                          weo
 *
 */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>
#include <procid.h>
#include <errno.h>
#include "infomod.h"

extern int errno;

extern char *getmodname();

static void display_info();
static void usage();

int disp_all, disp_locks;

static char Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

/*
 * l i n k _ i n f o _ m o d
 */
static INFO *
link_info_mod()
{
  register mod_exec *info_module;

  if ((info_module = (mod_exec *) modlink(INFO_MODULE_NAME,
                                          mktypelang(MT_DATA, ML_ANY))) ==
      (mod_exec *) -1)
    return(NULL);

  return((INFO *) (((char *) info_module) + info_module->_mexec));
}

/*
 * u n l i n k _ i n f o _ m o d
 */
static void 
unlink_info_mod()
{
  munload(INFO_MODULE_NAME, 0x0400);
}

/*
 * m a i n
 */
main(argc, argv)
  int  argc;
  char *argv[];
{
  register INFO *info;
  register int  i, j;
  int           clear_event, unlock;
  int           arg_count;
  int           EvID;

  clear_event = unlock = disp_all = disp_locks = FALSE;
  arg_count = 0;

  /*
   * Parse command line arguments
   */  
  for (i = 1; i< argc; i++)
    if (argv[i][0] == '-')
      for (j = 1; j < strlen(argv[i]); j++)
        switch(tolower(argv[i][j])) {
          case '?':
            usage();
            exit(1);
          case 'c':       /* clear event */
            clear_event = TRUE;
            break;
          case 'a':
            disp_all = TRUE;
            break;
          case 'l':
            disp_locks = TRUE;
            break;
          case 'u':       /* unlock device */
            unlock = TRUE;
            break;
          default:
            usage();
            exit(_errmsg(1, "unknown option '%c'\n", argv[i][j]));
        }
    else
      arg_count++;

  if ((info = link_info_mod()) == NULL)
    exit(_errmsg(errno, "can't link to sysinfo data module\n"));

  if (info->rev != REVISION) {
    unlink_info_mod();
    exit(_errmsg(1, "Revision mismatch, (mod = %d, getinfo = %d)\n",
                 info->rev, REVISION));
  }

  if (clear_event) {    /* Reset the SYSINFO event */
    if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
      unlink_info_mod();
      exit(_errmsg(errno, "can't link to event\n"));
    }

    if (_ev_set(EvID, 0, 0) == -1) {
      unlink_info_mod();
      exit(_errmsg(errno, "can't set event\n"));
    }
    _ev_unlink(EvID);
  }
  
  if (unlock)     /* Unlock an entry */
    for (i = 1; i < argc; i++)
      if (argv[i][0] != '-')
        if (info_lock(argv[i], 0) != -1)
          info_unlock(argv[i], 0);
        else
          fprintf(stderr, "can't unlock %s\n", argv[i]);

  if ((!clear_event && !unlock) || disp_locks || disp_all) {
    printf("SYSINFO Rev. %d\n\n", info->rev);
    printf("%-20.20s  %-10.10s  %-40.40s\n\n", "Name", "Type", "Parameter");
    for (i = 0; i < info->num; i++)
      display_info(&(info->entry[i]));      /* Display entries */
  }

  unlink_info_mod();
}

/*
 * d i s p l a y _ i n f o
 */
static void 
display_info(entry)
  register ENTRY *entry;
{
  register LOCK     *lock;
  register procid   procdesc;
  register mod_exec *modhdr;
  register char     *mod_name;

  if (disp_all || entry->type == T_LOCK) {  
    printf("%-20.20s  %-10.10s  ", entry->name,
           entry->type == T_UNKNOWN ? "*unknown*" :
           entry->type == T_STRING ? "String" :
           entry->type == T_NUM ? "Num" :
           entry->type == T_LOCK ? "Lock" : "* ??? *");
  }

  switch (entry->type) {
    case T_UNKNOWN:
      break;

    case T_STRING:
      if (!disp_all)
        break;
      printf("%-40.40s", entry->data);
      break;

    case T_NUM:
      if (!disp_all)
        break;
      printf("not supported yet");
      break;

    case T_LOCK:
      lock = (LOCK *) entry->data;
      if (lock->status == ST_FREE)
        printf("not locked");
      else {
        if ((_get_process_desc(lock->pid, sizeof(procdesc),
                                           &procdesc)) == -1 ||
            lock->timbeg != procdesc._timbeg ||
            lock->datbeg != procdesc._datbeg) 
                                            /* Locking proc. still existing? */
          printf("not locked, orphaned lock (process id %d)", lock->pid);
        else {
          mod_name = getmodname(procdesc._pmodul);
          printf("locked by process %d (%s)", lock->pid, mod_name);
        }
      }
      break;

    default:
      printf("possible damage of sysinfo data (invalid type)");
  }

  if (disp_all || entry->type == T_LOCK)  
    printf("\n");
}

/*
 * u s a g e
 */
static void 
usage()
{
  fputs("Syntax: getinfo [<opts>] {<parm> [<opts>]}\n", stderr);
  fputs("Function: display or modify sysinfo data\n", stderr);
  fputs("Options:\n", stderr);
  fputs("     -l   display locks (default)\n", stderr);
  fputs("     -a   display not only locks\n", stderr);
  fputs("     -c   clear sysinfo event\n", stderr);
  fputs("     -u   unlock devices (given as parm)\n", stderr);
}
lid type)");
  }

  if (disp_all || entry->type == T_LOCK)  
    printf("\n");
}

/*
 * u s a g e
 */
static void 
usage()
{
  fputs("Syntax: getinfo [<opts>] {<parm> [<opts>]}\n", stderr);
  fputs("Function: display or modify sysinfo data\n", stderr);
  fputs("Options:\n", stderr);
  fputs("     -l   display locks (defaultgetlog.c                                                                                            000604  000000  000000  00000003763 04542747464 006237                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getlogin()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <strings.h>
#include <utmp.h>
#include <pwd.h>

static char *chkpw();

/*
 * g e t l o g i n
 */
char *getlogin()
{
  register char        *cp;
  static char          user[33];
  char                 line[33];
  register int         res;
  register struct utmp *utmp;
	
  if (_gs_devn(0, line+1) < 0)
    return (NULL);

  line[0] = '/';
  setwhoent();
  res = 0;

  while ((!res) && (utmp = getwhoent()) != NULL)
    res = !strcmp(line, utmp->ut_line);

  if (res) {
    strcpy(user, utmp->ut_user);
    cp = user;
  }
  else
    cp = NULL;
  endwhoent ();

  if (cp == NULL && (cp = chkpw()) != NULL) {
    strcpy(user, cp);
    cp = user;
  }

  return(cp);
}

/*
 * c h k p w
 */
static char *chkpw()
{
  register struct passwd *pw;
	
  if (pw = getpwuid(getuid() & 0x0ffff)) {
    endpwent();
    return(pw->pw_name);
  }
  else {
    endpwent();
    return(NULL);
  }
}

  while ((!rgetmuid.c                                                                                           000604  000000  000000  00000002405 04542747464 006404                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getmuid()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <procid.h>

/*
 * g e t m u i d
 */
int getmuid()
{
  procid pbuf;

  _get_process_desc(getpid(), sizeof(procid), &pbuf);

  return((pbuf._pmodul)->_mh._mowner);
}
-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----getopt.c                                                                                            000600  000000  000000  00000004624 04542747464 006251                                                                                                                                                                                                                                                                                                                                                                      /*
**	@(#)getopt.c	2.5 (smail) 9/15/87
*/

/*
 * Here's something you've all been waiting for:  the AT&T public domain
 * source for getopt(3).  It is the code which was given out at the 1985
 * UNIFORUM conference in Dallas.  I obtained it by electronic mail
 * directly from AT&T.  The people there assure me that it is indeed
 * in the public domain.
 * 
 * There is no manual page.  That is because the one they gave out at
 * UNIFORUM was slightly different from the current System V Release 2
 * manual page.  The difference apparently involved a note about the
 * famous rules 5 and 6, recommending using white space between an option
 * and its first argument, and not grouping options that have arguments.
 * Getopt itself is currently lenient about both of these things White
 * space is allowed, but not mandatory, and the last option in a group can
 * have an argument.  That particular version of the man page evidently
 * has no official existence, and my source at AT&T did not send a copy.
 * The current SVR2 man page reflects the actual behavor of this getopt.
 * However, I am not about to post a copy of anything licensed by AT&T.
 */
/*
 * Ported to OS-9/68000:	Wolfgang Ocker	January 1988
 */


#include <types.h>

/*LINTLIBRARY*/
#define NULL	0
#define EOF	(-1)
#define ERR(s, c)	if(opterr){\
	extern int write();\
	char errbuf[2];\
	errbuf[0] = c; errbuf[1] = '\n';\
	(void) write(2, argv[0], (unsigned)strlen(argv[0]));\
	(void) write(2, s, (unsigned)strlen(s));\
	(void) write(2, errbuf, 2);}

extern char *index();

int	opterr = 1;
int	optind = 1;
int	optopt;
char	*optarg;

int
getopt(argc, argv, opts)
int	argc;
char	**argv, *opts;
{
	static int sp = 1;
	register int c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
		   argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
		else if(strcmp(argv[optind], "--") == NULL) {
			optind++;
			return(EOF);
		}
	optopt = c = argv[optind][sp];
	if(c == ':' || (cp=index(opts, c)) == NULL) {
		ERR(": illegal option -- ", c);
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
			ERR(": option requires an argument -- ", c);
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}

;
	if(c == ':' || (cp=index(opts, c)) == NULL) {
		ERR(": illegal option -- ", c);
		if(argv[optind][++sp] =getpass.c                                                                                           000604  000000  000000  00000003161 04542747464 006414                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getpass()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <sgstat.h>

static char pwline[81];

/*
 * g e t p a s s
 */
char *getpass(prompt)
  char *prompt;

{
  struct sgbuf optbuf;
  int          echo, Count;
	
  _gs_opt(0, &optbuf);
  echo           = optbuf.sg_echo;
  optbuf.sg_echo = 0;
  _ss_opt(0, &optbuf);
  
  write (1, prompt, strlen(prompt));
  Count = readln(0, pwline, 80);
  if (!Count)
    *pwline = '\0';
  else
    if (pwline[Count-1] == '\n')
      pwline[Count-1] = '\0';

  optbuf.sg_echo = echo;
  _ss_opt(0, &optbuf);
  writeln(1, "\n", 1);
  return(pwline);
}

ic char pwline[81];

/*
 * g e t p a s s
 */
char *getpass(prompt)
  char *prompt;

{
  struct sgbuf optbuf;
  int          echo, Count;
	
  _gs_opt(0, &optbuf);
  echo           = optbuf.sg_echo;
  optbuf.sg_echo = 0;
  _ss_opt(0, &optbuf);
  
  write (1, prompt, strlen(prompt));
  Count = readln(0, pwline, 80);
  if (!Count)
    *pwline = '\0';
  else
    if (pwline[Count-1] == '\n')
      pwligetwd.c                                                                                             000604  000000  000000  00000003501 04542747464 006056                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  getwd(), getx()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>

FILE *xpopen();

/*
 * g e t w x d
 */
static char *getwxd(wd, opt)
  register char *wd;
  register char *opt;
{
  register FILE *fp;
  char          tmp[40];
  register char *cp;
  
  wd[0] = '\0';

  (void) strcpy(tmp, "/h0/CMDS/pd");
  if (opt != NULL)
    (void) strcat(tmp, opt);

  if ((fp = xpopen(tmp, "r")) == NULL)
    return(NULL);

  if (fgets(wd, 200, fp) == NULL)
    return(NULL);

  if ((cp = index(wd, '\n')) != NULL)
    *cp = '\0';

  while (fgets(tmp, sizeof(tmp)-1, fp) != NULL) ;
  
  pclose(fp);
  return(wd);
}

/*
 * g e t w d
 */
char *getwd(wd)
  char *wd;
{
  return(getwxd(wd, NULL));
}

/*
 * g e t x d
 */
char *getxd(wd)
  char *wd;
{
  return(getwxd(wd, " -x"));
}
d[0] = '\0';

  (void) strcpy(tmp, "/h0/CMDS/pd");
  if (opt != NULL)
    (void) strcat(tmp, opt);

  if ((fp = xpopen(tmp, "r")) == NULL)
    return(NULL);

  if (fgets(wd, 200, fp) == NULL)grp.c                                                                                               000604  000000  000000  00000010263 04542747464 005537                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  group routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <ctype.h>
#include <grp.h>

static FILE         *grpf = NULL;
static char         line[BUFSIZ+1];
static char         *member[MAX_MEM+1];
static struct group group;

#define TRUE  (-1)
#define FALSE (0)

int _grp_secure = 0;

extern FILE *ddfopen();

/*
 * s e t g r e n t
 */
int setgrent()
{
  char fn[100];

  if (!grpf) {
    if (!(grpf = ddfopen(GROUP, fn, "r", _grp_secure)))
      return(-1);
  }
  else
    rewind(grpf);
  
  return(0);
}

/*
 * e n d g r e n t
 */
void endgrent()
{
  if (grpf) {
    fclose (grpf);
    grpf = NULL;
  }
}

/*
 * g r s k i p
 */
static char *grskip(p)
  register char *p;

{
  while (*p && *p != ':')
    ++p;
  if (*p)
    *p++ = '\0';
  return(p);
}

/*
 * g r s k i p 2
 */
static char *grskip2 (p)
  register char *p;

{
  while (*p && (*p != ',') && (*p != '\n'))
    ++p;

  if (*p) 
    if (*p != '\n')
      *p++ = '\0';
    else
      *p = '\0';

  return(p);
}

/*
 * _ g e t g r
 */
struct group *_getgr(gr, grline)
  register struct group *gr;
  char                  *grline;

{
  register char *p;
  char          *cp;
  int           t;
  static char   tmp[BUFSIZ+1];

  strcpy(tmp, grline);
  
  p = tmp;
  gr->gr_name = p;

  p = grskip(p);
  gr->gr_passwd = p;

  p = grskip(p);
  cp = p;

  p = grskip(p);
  gr->gr_gid = atoi(cp);
  t = 0;
  while ((t < MAX_MEM) && *p) {
    member[t++] = p;
    p = grskip2(p);
  }

  member[t] = NULL;
  gr->gr_mem = member;
  while(*p && *p != '\n')
    p++;
  *p = '\0';
  return(gr);
}

/*
 * g e t g r e n t
 */
struct group *getgrent()
{
  if (!grpf)
    if (setgrent() < 0)
      return(NULL);
    
  do {
    if (!fgets(line, BUFSIZ,grpf))
      return(NULL);
  } while (line[0] == '#' || line[0] == '*');

  if (!_getgr(&group, line))
    return(NULL);

  return(&group);
}

/*
 * g e t g r g i d
 */
struct group *getgrgid (gid)
  int gid;

{
  int found = 0;
	
  if (setgrent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, grpf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getgr(&group, line))
      found = (group.gr_gid == gid);
  }

  if (found)
    return(&group);
  else
    return(NULL);
}

/*
 * g e t g r n a m
 */
struct group *getgrnam(name)
  char *name;

{
  int found = 0;
	
  if (setgrent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, grpf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getgr(&group, line)) 
      found = (!_strccmp(group.gr_name, name));
  }

  if (found)
    return(&group);
  else
    return(NULL);
}

/*
 * f g e t g r e n t
 */
struct group *fgetgrent(f)
  FILE *f;

{
  struct group *gr = NULL;
	
  do {
    if (fgets(line, BUFSIZ, f))
      gr = _getgr(line, &group);
    else
      gr = NULL;
  } while (gr && (line[0] == '#' || line[0] == '*'));

  return(gr);
}

/*
 * g e t g r o u p s
 */
int getgroups(num, gids)
  int num;
  int *gids;
{
  struct group *gr;
  int          i;

  if (setgrent() < 0)
    return(-1);
  
  for (i = 0; i < num; i++)
    if (!(gr = getgrent())) {
      endgrent();
      return(i);
    }
    else
      gids[i] = gr->gr_gid;

  endgrent();
  return(num);
}
 *gr = NULL;
	
  do {
    if (fgets(line, BUFSIZ, f))
      gr = _getgr(line, &group);
    else
      gr = NULL;
  } while (gr && (line[0] == '#' || line[0] == '*'));

  return(gr);
}

/*
 * g e t g r o u p s
 */
int getgroups(num, gids)
  int num;
  int *gids;
{
  struct group *gr;
  int          i;

  if (setgrent() < 0)
    retuinfo.c                                                                                              000604  000000  000000  00000026230 04542747464 005703                                                                                                                                                                                                                                                                                                                                                                      /*
 *                            SYSINFO Library
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/06/88   Corrected modlink parameters                          weo
 * 02  11/21/88   Added info_kill(), changed info_signal() to
 *                info_do_signal() (as proposed by Ulli)                weo
 */

#define PATCHLEVEL 2

#include <stdio.h>
#include <module.h>
#include <strings.h>
#include <procid.h>
#include <errno.h>
#include "infomod.h"

extern int errno;
static char *Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

/*
 * l i n k _ i n f o _ m o d
 *
 * Link to SYSINFO data module
 */
static INFO *
link_info_mod()
{
  register mod_exec *info_module;

  if ((info_module = (mod_exec *) modlink(INFO_MODULE_NAME, 
                                          mktypelang(MT_DATA, ML_ANY))) ==
      (mod_exec *) -1)
    return(NULL);   /* can't link */

  return((INFO *) (((char *) info_module) + info_module->_mexec));
}

/*
 * u n l i n k _ i n f o _ m o d
 *
 * unlink from SYSINFO data module
 */
static void 
unlink_info_mod()
{
  (void) munload(INFO_MODULE_NAME, 0x0400);
}

/*
 * i n f o _ e n t r y
 *
 * Get pointer to an entry within the SYSINFO data module. Needs
 * name of the entry (case sensitiv) and its type.
 */
static ENTRY *
info_entry(name, type)
  register char *name;
  register int  type;
{
  register INFO *info;
  register int  i;

  if ((info = link_info_mod()) == NULL) /* Link to data module */
    return(NULL);

  /*
   * Check revision (for compatiblity reasons)
   */
  if (info->rev != REVISION) {
    unlink_info_mod();
    return(NULL);
  }

  for (i = 0; i < info->num; i++)         /* search entry by name */
    if (!strcmp(info->entry[i].name, name) &&
        (info->entry[i].type == type))    /* desired type? */
      return(&(info->entry[i]));          /* all ok, return pointer */
  
  unlink_info_mod();
  errno = E_PNNF;
  return(NULL);
}

/*
 * i n f o _ t y p e
 *
 * Determine type of SYSINFO entry. Needs only the name of the entry.
 */
int 
info_type(name)
  char *name;
{
  register INFO *info;
  register int  i;
  register int  type;

  if ((info = link_info_mod()) == NULL)     /* Link to data module */
    return(NULL);

  for (i = 0; i < info->num; i++)           /* Search entry */
    if (!strcmp(info->entry[i].name, name)) {
      type = info->entry[i].type;
      unlink_info_mod();
      return(type);                         /* found, return type */
    }
  
  unlink_info_mod();
  errno = E_PNNF;
  return(FAILED);
}  

/*
 * i n f o _ s t r
 *
 * Get a string from SYSINFO. Needs name, buffer, and max. length.
 */
char *
info_str(name, str, len)
  register char *name;
  register char *str;
  register int  len;
{
  register ENTRY *entry;

  /*
   * Get a pointer to the desired entry
   */
  if ((entry = info_entry(name, T_STRING)) == NULL)
    return(NULL);       /* Not found */ 

  (void) strncpy(str, entry->data, len-1);   /* Copy */
  str[len-1] = '\0';
  unlink_info_mod();
  return(str);
}

/*
 * i n f o _ n u m
 *
 * Get number from SYSINFO
 */
int 
info_num(name)
  register char *name;
{
  register ENTRY *entry;

  /*
   * Get a pointer to the entry
   */
  if ((entry = info_entry(name, T_NUM)) == NULL)
    return(FAILED);

  unlink_info_mod();
  return(*((int *) entry->data));
}

/*
 * i n f o _ i s _ l o c k e d
 *
 * Check, if a lock entry is locked. Needs name.
 */
int 
info_is_locked(name)
  register char *name;
{
  int            EvID;
  int            status;
  procid         procdesc;
  register LOCK  *lock;
  register ENTRY *entry;

  /*
   * Remove a leading slash ("/t7" is equal to "t7")
   */
  if (name[0] == '/')
    name++;

  /*
   * Get pointer to entry
   */
  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  /*
   * Link to the SYSINFO event
   */
  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  /*
   * Wait, until we can access the entry.
   * We should check for a timeout here ... (perhaps alarms?)
   */
  while (_ev_wait(EvID, 0, 0) != 0) ;

  /*
   * Now we can access the entry
   */
  lock   = (LOCK *) entry->data;
  status = lock->status;            /* Get status */

  if (status == ST_LOCKED)          /* Locked? */
    if (lock->pid == 0)             /* Process ID? */
      status = ST_FREE;             /* NOT LOCKED! */
    else
      /* 
       * Now we have to check, whether the existing process
       * still exists. We do this by checking the PID and the
       * start time of the locking process
       */
      if (_get_process_desc(lock->pid, sizeof(procdesc), 
                            &procdesc) == -1 ||
          lock->timbeg != procdesc._timbeg ||
          lock->datbeg != procdesc._datbeg)
        status = ST_FREE;     /* Meanwhile, the process has died! */

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();

  return(status == ST_FREE ? OK : FAILED);
}

/*
 * i n f o _ l o c k
 *
 * Lock a SYSINFO entry
 */
int 
info_lock(name, signal)
  register char *name;
  int           signal;
{
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register int   timeout;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  /*
   * Now we can access the entry
   */
  lock = (LOCK *) entry->data;
  
  if (lock->status == ST_LOCKED) {    /* locked? */
    if (lock->pid != 0) {             /* Process ID given? */
        timeout = 0;
        while (lock->status == ST_LOCKED &&
               _get_process_desc(lock->pid, sizeof(procdesc), 
                                 &procdesc) != -1 &&
            lock->timbeg == procdesc._timbeg &&
            lock->datbeg == procdesc._datbeg) {
  
          if (timeout++ > 20) {   /* Timeout? */
            (void) _ev_signal(EvID, 0);
            _ev_unlink(EvID);
            unlink_info_mod();
            return(FAILED);
          }

          if (lock->signal != -1)           /* May we send a signal to the */
                                            /* locking process? */
            (void) kill(lock->pid, lock->signal);

          (void) _ev_signal(EvID, 0);    /* Now others may access */
          (void) sleep(5);               /* Wait a bit ... */
          while (_ev_wait(EvID, 0, 0) != 0) ;
        }
    }
  }

  lock->status    = ST_LOCKED;
  lock->timestamp = time(NULL);
  lock->pid       = getpid();
  lock->signal    = signal;     /* A process which want lock may send us */
                                /* this signal */

  if (_get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1) {
    lock->timbeg = procdesc._timbeg;    /* Our start time */
    lock->datbeg = procdesc._datbeg;
  }
  else {
    lock->timbeg = 0;
    lock->datbeg = 0;
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(OK);
}

/*
 * i n f o _ u n l o c k
 *
 * Unlock
 */
int 
info_unlock(name)
  register char *name;
{
  int            EvID;
  procid         procdesc;
  register LOCK  *lock;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0);

  lock = (LOCK *) entry->data;

  if (lock->status == ST_LOCKED && lock->pid == getpid() &&
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg)     /* IS it "our" lock? */
    lock->status = ST_FREE;     /* Unlock */
  
  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(OK);
}

/*
 * i n f o _ c h a n g e
 *
 * Change signal number of a lock
 */
int 
info_change(name, signal)
  register char *name;
  int           signal;
{
  int            err;
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  lock = (LOCK *) entry->data;

  err = FAILED;

  if (lock->status == ST_LOCKED && lock->pid == getpid() && 
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg) {   /* Locking proc. still existing? */
    err = OK;
    lock->signal = signal;    /* new signal code */
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(err);
}


/*
 * i n f o _ d o _ s i g n a l
 *
 * Send a signal to a locking process
 */
static int
info_do_signal(name, offset)
  register char *name;
  register int  offset;
{
  int            err;
  int            EvID;
  register LOCK  *lock;
  procid         procdesc;
  register ENTRY *entry;

  if (name[0] == '/')
    name++;

  if ((entry = info_entry(name, T_LOCK)) == NULL)
    return(FAILED);

  if ((EvID = _ev_link(INFO_EVENT_NAME)) == -1) {
    unlink_info_mod();
    return(FAILED);
  }
  
  while (_ev_wait(EvID, 0, 0) != 0) ;

  lock = (LOCK *) entry->data;

  err = FAILED;

  if (lock->status == ST_LOCKED &&
      _get_process_desc(lock->pid, sizeof(procdesc), &procdesc) != -1 &&
      lock->timbeg == procdesc._timbeg &&
      lock->datbeg == procdesc._datbeg) {   /* Locking proc. still existing? */

    if (lock->signal != -1) {           /* May we send a signal? */
      err = OK;
      (void) kill(lock->pid, lock->signal + offset);    /* Yes, "kill" him! */
    }
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(err);
}

/*
 * i n f o _ s i g n a l
 *
 * Send a signal to a locking process
 */
int
info_signal(name)
  register char *name;
{
  return info_do_signal(name, 0);
}

/*
 * i n f o _ k i l l
 *
 * Send a signal+1 to locking process
 */
int
info_kill(name)
  register char *name;
{
  return info_do_signal(name, 1);
}

gnal? */
      err = OK;
      (void) kill(lock->pid, lock->signal + offset);    /* Yes, "kill" him! */
    }
  }

  (void) _ev_signal(EvID, 0);
  _ev_unlink(EvID);
  unlink_info_mod();
  return(err);
}

/*
 * i n f o _ s i g n a l
 *
 * Send a signal to a locking process
 */
int
info_signal(name)
  register char *name;
{
  return info_do_signal(name, 0);
}
infomod.h                                                                                           000604  000000  000000  00000002601 04542747464 006404                                                                                                                                                                                                                                                                                                                                                                      typedef struct {
  int status;     /* Status (locked/unlocked) */
  int flags;      /* Flags */
  int timestamp;  /* Wann wurde gelocked */
  int pid;        /* Prozessid */
  int signal;     /* Signal zu killen */
  int datbeg;     /* Startzeit des Prozesses */
  int timbeg;
  int future[4];
} LOCK;

typedef struct {
  char *name;     /* Name des Eintrags */
  char *data;     /* Zeiger auf Daten */
  int  type;      /* Typ, noch nicht benutzt */
  int  datasize;  /* Groesse des Datenbereichs */
  int  future[4];
} ENTRY;

typedef struct {
  int   num;      /* Anzahl Eintraege */
  int   size;     /* Gesamtgroesse, unbenutzt */
  int   rev;      /* Revision */
  int   future[8];
  LOCK  ev_lock;  /* Lock-Info fuer das Event, unbenutzt */
  ENTRY entry[1]; /* Eintraege */
} INFO;

#define INFO_MODULE_NAME "SysInfo"        /* Name des Daten-Moduls */
#define INFO_EVENT_NAME "SysInfo"         /* Name des Events */
#define INFO_FILE_NAME "/dd/SYS/sysinfo"  /* Default-Path der sysinfo-Datei */

#define TRUE  1
#define FALSE 0

#define OK      0
#define FAILED -1

#define T_UNKNOWN 0   /* ??? */
#define T_STRING 1    /* String (s) */
#define T_NUM 2       /* Zahl (n), unbenutzt */
#define T_DATA 3      /* Daten (allgemein) */
#define T_LOCK 4      /* Lock-Info */

#define ST_LOCKED 1   /* Device ist gelocked */
#define ST_FREE 0     /* Device ist frei */

#define REVISION 1    /* Revision */
      /* Name des Events */
#define INFO_FILE_NAME "/dd/SYS/sysinfo"  /* Default-Path der sysinfo-Datei */

#define TRUE  1
#deisatty.c                                                                                            000604  000000  000000  00000003006 04542747464 006261                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  isatty(), isapipe()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <sgstat.h>

/*
 * i s w h a t
 */
static int iswhat(p)
  int p;
{
  struct  _sgs  opt;

  if (_gs_opt(p, &opt) < 0)
    return(-1);
  return(opt._sgs_class);
}

/*
 * i s a t t y
 */
int isatty(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 0);
}


/*
 * i s a p i p e
 */
int isapipe(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 1);
}

----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <sgstat.h>

/*
 * i s w h a t
 */
static int iswhat(p)
  int p;
{
  struct  _sgs  opt;

  if (_gs_opt(p, &opt) < 0)
    return(-1);
  return(opt._sgs_class);
}

/*
 * i s a t t y
 */
int isatty(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 0);
}


/*
 * i s a p i p e
 */
int isapipe(f)
  int f;
{
  int t;
  
  if ((t = iswhat(f)) < 0)
    return(0);

  return(t == 1makefile                                                                                            000604  000000  000000  00000003476 04542747464 006313                                                                                                                                                                                                                                                                                                                                                                      * 
* Makefile for OS9LIB
*

RDIR      = RELS
LDIR      = /h0/LIB
ODIR      = /h0/ETC/CMDS
UDIR      = /h0/USR/CMDS

CFLAGS    = -qt=/dd/TMP
CC        = cc
LINTFLAGS = -DLINT
DDIR      = /dd/DEFS

all: $(LDIR)/os9lib.l $(ODIR)/setup $(ODIR)/getinfo $(UDIR)/man
     touch all

OBJS1 = dbm.r tptype.r rename.r shell.r getwd.r popen.r findmod.r getlog.r\
 cuserid.r chpass.r chgrppass.r grp.r pw.r perror.r signal.r pipe.r\
 isatty.r atime.r getmuid.r utime.r stat.r ttynam.r regexp.r regsub.r

OBJS2 =  regerror.r utmp.r mdir.r getpass.r rndsalt.r crypt.r rnd.r\
 gethname.r info.r getargs.r bootdrv.r umask.r strings.r bsearch.r\
 alarm.r utls.r getopt.r scandir.r bcopy.r alloca.r rand.r

SRCS = dbm.c tptype.c rename.c shell.c getwd.c popen.c findmod.c getlog.c \
       cuserid.c chpass.c chgrppass.c grp.c pw.c perror.c pipe.c \
       isatty.c atime.c getmuid.c utime.c stat.c ttynam.c regexp.c regsub.c \
       regerror.c utmp.c mdir.c getpass.c rndsalt.c crypt.c rnd.c \
       gethname.c info.c getargs.c bootdrv.c umask.c strings.c bsearch.c \
       alarm.c getopt.c scandir.c

$(LDIR)/os9lib.l: $(OBJS1) $(OBJS2)
  chd $(RDIR); merge -b50 $(OBJS1) >-$(LDIR)/os9lib.l
  chd $(RDIR); merge -b50 $(OBJS2) >+$(LDIR)/os9lib.l
  attr $(LDIR)/os9lib.l -npwpr

$(ODIR)/setup: setup.r
               chd $(RDIR); $(CC) $(CFLAGS) setup.r -f=$(ODIR)/setup
               attr $(ODIR)/setup -npenpwnpr

$(ODIR)/getinfo: getinfo.r
                 chd $(RDIR); $(CC) $(CFLAGS) getinfo.r -l=$(LDIR)/os9lib.l \
                                    -f=$(ODIR)/getinfo
                 attr $(ODIR)/getinfo -npwnprpe

$(UDIR)/man: man.r
             chd $(RDIR); $(CC) $(CFLAGS) man.r -l=$(LDIR)/os9lib.l \
                                -f=$(UDIR)/man
             attr $(UDIR)/man -npwnprpe

os9lib.lint: $(SRCS)
  lint $(LINTFLAGS) $(SRCS) >>>-os9lib.lint

$(ODIR)/setup
               attr $(ODIR)/setup -npenpwnpr

$(ODIR)/getinfo: getinfo.r
                 chd $(RDIR); $(CC) $(CFLAGS) getinfo.r -l=$(LDIR)/os9lib.l \
                             man.c                                                                                               000600  000000  000000  00000014343 04542747464 005521                                                                                                                                                                                                                                                                                                                                                                      /************************************************************************
 *                                                                      *
 *   Copyrighted (C) 1987, 1988 by Ulrich Dessauer, Germering           *
 *                                                  (W-Germany)         *
 *                                                                      *
 *   This program can be copied and distributed freely for any          *
 *   non-commercial purposes. This program can only be incorporated     *
 *   into commercial software with the permission of the author.        *
 *                                                                      *
 *   If you should modify this program, the author would appreciate     *
 *   informations about the changes. Please send a (context) diff or    *
 *   the complete source to:                                            *
 *   address:     Ulrich Dessauer                                       *
 *                Kerschensteinerstr. 45                                *
 *                D-8034 Germering                                      *
 *                West Germany                                          *
 *                                                                      *
 *   e-mail:      ud@mutec.UUCP, ud@altger.UUCP                         *
 *                                                                      *
 *   Program:     man                                                   *
 *   Version:     0.98                                                  *
 *   Module:      man.c                                                 *
 *   Description: Prints an manual entry using the favorite pager       *
 *   Functions:   usage ()                                              *
 *                main (int, **char)                                    *
 *                manual (*char, **char)                                *
 *                                                                      *
 *   Auther(s):                                                         *
 *         Ulrich Dessauer    (ud)                                      *
 *                                                                      *
 *   Edition History                                                    *
 *    # | Date   | By  | Changes                                        *
 *   ===+========+=====+==============================================  *
 *    1 |03.10.88| ud  | Seperated includefiles for man and mwb         *
 *                                                                      *
 ************************************************************************/
# ifndef LINT
static char *copyright = "Copyrighted (C) 1987, 1988 by Ulrich Dessauer, Germering, W-Germany";
# endif LINT

# include "man.h"
# include <modes.h>
# include <ctype.h>

extern void	exit ();
extern void	free ();
extern char	*fgets ();
extern char	*getenv ();
extern char	*info_str ();
extern char	*malloc ();
extern char	*strcat ();
extern char	*strcpy ();
extern FILE	*fopen ();

extern int	errno;

# define 	MANEXT		".man"

char		*mandir,*proff,*mindex,*pager;

char		*help[] = {
	"Syntax: man [<opts>]\n",
	"Function: Prints a manual entry\n",
	"Options:\n",
	"     none.\n",
	NULL
};

/*
 *	u s a g e
 */
usage ()
{
	int t;

	for (t=0;help[t];++t)
		(void) fputs(help[t],stderr);
}

/*
 *	m a i n
 */
main (argc,argv,envp)
int argc;
char *argv[];
char *envp[];
{
	int		t;
	int		noargs;
	char		*x;
	char 		s[256];
	register char	*entry,*file;
	char		lastfile[40];
	FILE		*fp;
	char		*mn;
	
	noargs = 1;
	
	/* Parse arguments */
	for (t=1;t<argc;++t)
		if (*argv[t] == '-') {
			x = argv[t] + 1;
			while (*x) {
				switch (*x) {
					case '?':
					default:
						usage ();
						if (*x != '?')
							(void) fprintf (stderr, "Unknown flag '%c'\n",*x);
						exit (1);
				}
				if (*x) ++x;
			}
		} else
			noargs = 0;
	if (noargs) {
		usage ();
		exit(_errmsg(1, "No manual entry\n"));
	}
	
	/* Get some sysinfo entries */
	if (!(mn = malloc (80)))
		exit (_errmsg (errno,"Out of memory\n"));
	if (!(mandir = getenv ("MANDIR"))) {
		if (!info_str ("mwb.mandir",mn,80))
			mandir = MANDIR;
		else {
			mandir = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory\n"));
		}
	}
	if (!(proff = getenv ("PROFF"))) {
		if (!info_str ("mwb.proff",mn,80))
			proff = PROFF;
		else {
			proff = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory!\n"));
		}
	}
	if (!(mindex = getenv ("INDEX"))) {
		if (!info_str ("mwb.index",mn,80))
			mindex = INDEX;
		else {
			mindex = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory\n"));
		}
	}
	if (!(pager = getenv ("PAGER"))) {
		if (!info_str ("mwb.pager",mn,80))
			pager = PAGER;
		else {
			pager = mn;
			if (!(mn = malloc (80)))
				exit (_errmsg (errno,"Out of memory!\n"));
		}
	}
	free (mn);
	if (chdir (mandir) < 0)
		exit (_errmsg (errno,"Can't change to '%s'!\n",mandir));
	*lastfile = '\0';
	fp = NULL;
	for (t=1;t<argc;++t)
		if (*argv[t] != '-') {
			x = argv[t];
			if (fp)
				(void) fseek (fp, 0, 0);
			else
				if (!(fp = fopen (mindex,"r")))
					exit (_errmsg (errno,"Can't open index file!\n"));
			while (fgets (s,80,fp)) {
				s[strlen (s) - 1] = '\0';
				entry = s;
				file = s;
				while (*file && (!isspace (*file)))
					++file;
				if (*file) {
					*file++ = '\0';
					while (isspace (*file))
						++file;
				}
				if (!*file) continue;
				if ((!_cmpnam (entry,x,strlen (x))) && (strcmp (lastfile,file))) {
					if (manual (file,envp))
						break;
					(void) strcpy (lastfile,file);
				}
			}
		}
	if (fp)
		(void) fclose (fp);
}

/*
 *	m a n u a l
 */
manual (x,en)
char *x;
char *en[];
{
	char	*args[6];
	char	format[256];
	int	pid, t, status;

	(void) strcpy (format,x);
	(void) strcat (format,MANEXT);
	if (access (format,S_IREAD)) {
		if (access (x,S_IREAD)) {
			printf ("Entry %s not found\n",x);
			return (0);
		}
		args[0] = "shell";
		args[1] = proff;
		args[2] = x;
		args[3] = "!";
		args[4] = pager;
		args[5] = NULL;
	} else {
		args[0] = pager;
		args[1] = format;
		args[2] = NULL;
	}
	if ((pid = os9exec (os9forkc,args[0],args,en,0,0,3)) < 0)
		exit (_errmsg (errno,"Can't fork '%s'\n", args[1]));
	status = 0;
	while (((t = wait (&status)) != pid) && (t != -1))
		;
	if ((t == pid) && status)
		return (1);
	else
		return (0);
}
{
		if (access (x,S_IREAD)) {
			printf ("Entry %s not found\n",x);
			return (0);
		}
		args[0] = "shell";
		args[1] = proff;
		args[2] = x;
		args[3] = "!";
		args[4] = pager;
		args[5] = NULL;
	} else {
		args[0] = pager;
		args[1] = format;
		args[2] = NULL;
	}
	if ((pid = os9execman.h                                                                                               000600  000000  000000  00000000533 04542747464 005522                                                                                                                                                                                                                                                                                                                                                                      # include <stdio.h>

extern int	os9forkc ();

/* Some static datas */
# define PROFF		"proff"
# define PAGER		"less"
# define INDEX		"/h0/USR/DOC/.MAN/.index"
# define MANDIR		"/h0/USR/DOC/.MAN"
# define WORKSPACE	"SOURCE"
# define PRINTERPORT	"/p"
# define PRINTER	"dumb"
# define EDITOR		"me"
# define SHELL		"shell"
# define STRINGS	"strings"

proff;
		args[2] = x;
		args[3] = "!";
		args[4] = pager;
		args[5] = NULL;
	} else {
		args[0] = pager;
		args[1] = format;
		args[2] = NULL;
	}
	if ((pid = os9execmdir.c                                                                                              000604  000000  000000  00000007655 04542747464 005715                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  module directory routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1


#include <stdio.h>
#include <mdir.h>

/* Module-Directory entry */
typedef struct {
  struct modhcom *md_mptr;
  long           md_group;
  long           md_static;
  short          md_link;
  short          md_mchk;
} ModDir;

#define TRUE  1
#define FALSE 0

static mentry  ret;
static ModDir  *head = NULL;
static int     pos;
static int     count, max;
static int     size;

/*
 * _ m o p e n
 */
int _mopen()
{
  register int maxcount;

  size     = sizeof(ModDir);
  maxcount = 0;
  if (head)
    _mclose();

  head = NULL;

  do {
    maxcount += 80;
    if (!(head = (ModDir *) realloc(head, maxcount * size + 2)))
      return(-1);
  } while ((count = _get_module_dir(head, maxcount * size + 2)) >
           maxcount * size);
           
  max = count / size;
  pos = 0;
  return(0);
}

/*
 * _ m c l o s e
 */
int _mclose()
{
  if (head) {
    free(head);
    head = NULL;
    return(0);
  }
  else
    return(-1);
}

/*
 * _ m r e a d
 */
mentry *_mread()
{
  register struct modhcom *md;

  if ((!head) || (pos >= max))
    return(NULL);

  while ((pos < max) && (head[pos].md_mptr == NULL))
    ++pos;

  if (pos >= max)
    return(NULL);

  md         = head[pos].md_mptr;
  ret.m_ptr  = md;
  _cpymem(0, sizeof(struct modhcom), md, &ret.m_head);
  _cpymem(0, sizeof(ret.m_name), (char *) md + ret.m_head._mname, ret.m_name);

  ret.m_link = head[pos].md_link;
  ++pos;
  return(&ret);
}

/*
 * _ m s e e k
 */
int _mseek(position, place)
  int position, place;
{
  int t;

  if ((place < 0) || (place > 2) || (!head))
    return(-1);

  switch (place) {
    case 0:
      if ((position >= 0) && (position < max))
        pos = position;
      else
        return(-1);
      break;

    case 1:
      t = pos + position;
      if ((t >= 0) && (t < max))
        pos = t;
      else
        return(-1);
      break;

    case 2:
      t = max -1 + position;
      if ((t >= 0) && (t < max))
        pos = t;
      else
        return(-1);
      break;

    default:
      return(-1);
  }
  return(pos);
}

/*
 * _ m t e l l
 */
int _mtell()
{
  if (!head)
    return(-1);
  else
    return(pos);
}

/*
 * _ m r e w i n d
 */
int _mrewind()
{
  if (!head)
    return(-1);

  pos = 0;
  return(0);
}

/*
 * _ m e x i s t
 */
mentry *_mexist(name)
  register char *name;
{
  register mentry *scan;
  register int    siz;
  int             found;

  found = FALSE;
  if (_mopen() < 0)
    return(NULL);

  siz = strlen(name);
  while (scan = _mread())
    if (!_cmpnam(scan->m_name, name, siz)) {
      found = TRUE;
      break;
    }

  _mclose();
  return(found ? scan : NULL);
}

/*
 * g e t m o d n a m e
 */
char *getmodname(mod_addr)
  register struct modhcom *mod_addr;
{
  register mentry *mentry;

  if (_mopen() == -1)
    return(NULL);

  while ((mentry = _mread()) != NULL)
    if (mod_addr == mentry->m_ptr)
      return(mentry->m_name);
  
  return(NULL);
}
SE;
  if (_mopen() < 0)
    return(NULL);

  siz = strlen(name);
  while (scan = _mperror.c                                                                                            000604  000000  000000  00000017055 04542747464 006266                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  perror(), sys_errlist
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

/*
 * perror(s): print an error message
 */

#ifdef LINT
#define remote
#endif

#include <stdio.h>

extern int errno;

remote char *sys_errlist[] = {
  "",
  "000:001 aborted with an error",
  "000:002 keyboard quit",
  "000:003 keyboard interrupt",
  "000:004 ",
  "000:005 ",
  "000:006 ",
  "000:007 ",
  "000:008 ",
  "000:009 ",
  "000:010 ",
  "000:011 ",
  "000:012 ",
  "000:013 ",
  "000:014 ",
  "000:015 ",
  "000:016 ",
  "000:017 ",
  "000:018 ",
  "000:019 ",
  "000:020 ",
  "000:021 ",
  "000:022 ",
  "000:023 ",
  "000:024 ",
  "000:025 ",
  "000:026 ",
  "000:027 ",
  "000:028 ",
  "000:029 ",
  "000:030 ",
  "000:031 ",
  "000:032 ",
  "000:033 ",
  "000:034 ",
  "000:035 ",
  "000:036 ",
  "000:037 ",
  "000:038 ",
  "000:039 ",
  "000:040 ",
  "000:041 ",
  "000:042 ",
  "000:043 ",
  "000:044 ",
  "000:045 ",
  "000:046 ",
  "000:047 ",
  "000:048 ",
  "000:049 ",
  "000:050 ",
  "000:051 ",
  "000:052 ",
  "000:053 ",
  "000:054 ",
  "000:055 ",
  "000:056 ",
  "000:057 ",
  "000:058 ",
  "000:059 ",
  "000:060 ",
  "000:061 ",
  "000:062 ",
  "000:063 ",
  "000:064 illegal function code (math)",
  "000:065 ascii->numeric format conversion error (math)",
  "000:066 not a number (math)",
  "000:067 illegal argument (usually math)",
  "000:068 ",
  "000:069 ",
  "000:070 ",
  "000:071 ",
  "000:072 ",
  "000:073 ",
  "000:074 ",
  "000:075 ",
  "000:076 ",
  "000:077 ",
  "000:078 ",
  "000:079 ",
  "000:080 ",
  "000:081 ",
  "000:082 ",
  "000:083 ",
  "000:084 ",
  "000:085 ",
  "000:086 ",
  "000:087 ",
  "000:088 ",
  "000:089 ",
  "000:090 ",
  "000:091 ",
  "000:092 ",
  "000:093 ",
  "000:094 ",
  "000:095 ",
  "000:096 ",
  "000:097 ",
  "000:098 ",
  "000:099 ",
  "000:100 ",
  "000:101 ",
  "000:102 bus trap",
  "000:103 address trap",
  "000:104 illegal instruction",
  "000:105 divide by zero",
  "000:106 \"chk\" instruction trap",
  "000:107 \"trapv\" instruction trap",
  "000:108 privileged instruction",
  "000:109 trace exception",
  "000:110 illegal instruction (1010)",
  "000:111 illegal instruction (1111)",
  "000:112 exception 12",
  "000:113 coprocessor protocol violation",
  "000:114 system stack frame format error",
  "000:115 uninitialized interrupt",
  "000:116 exception 16",
  "000:117 exception 17",
  "000:118 exception 18",
  "000:119 exception 19",
  "000:120 exception 20",
  "000:121 exception 21",
  "000:122 exception 22",
  "000:123 exception 23",
  "000:124 spurious interrupt",
  "000:125 ",
  "000:126 ",
  "000:127 ",
  "000:128 ",
  "000:129 ",
  "000:130 ",
  "000:131 ",
  "000:132 ",
  "000:133 an uninitialized user TRAP (1-15) was executed",
  "000:134 ",
  "000:135 ",
  "000:136 ",
  "000:137 ",
  "000:138 ",
  "000:139 ",
  "000:140 ",
  "000:141 ",
  "000:142 ",
  "000:143 ",
  "000:144 ",
  "000:145 ",
  "000:146 ",
  "000:147 ",
  "000:148 fpcp unordered condition",
  "000:149 fpcp inexact result",
  "000:150 fpcp divide by zero",
  "000:151 fpcp underflow",
  "000:152 fpcp operand error",
  "000:153 fpcp overflow",
  "000:154 fpcp not a number",
  "000:155 exception 55",
  "000:156 pmmu configuration",
  "000:157 pmmu illegal operation",
  "000:158 pmmu access level violation",
  "000:159 exception 59",
  "000:160 exception 60",
  "000:161 exception 61",
  "000:162 exception 62",
  "000:163 exception 63",
  "000:164 no permission",
  "000:165 arguments to F$ChkNam didn't match",
  "000:166 system stack overflow",
  "000:167 invalid event ID number",
  "000:168 event not found",
  "000:169 the event is busy",
  "000:170 impossible event parameters",
  "000:171 system data structures have been damaged",
  "000:172 module revision is incompatable with operating system",
  "000:173 path became lost because network node was down",
  "000:174 bad disk partition, or no active partition",
  "000:175 ",
  "000:176 ",
  "000:177 ",
  "000:178 ",
  "000:179 ",
  "000:180 ",
  "000:181 ",
  "000:182 ",
  "000:183 ",
  "000:184 ",
  "000:185 ",
  "000:186 ",
  "000:187 ",
  "000:188 ",
  "000:189 ",
  "000:190 ",
  "000:191 ",
  "000:192 ",
  "000:193 ",
  "000:194 ",
  "000:195 ",
  "000:196 ",
  "000:197 ",
  "000:198 ",
  "000:189 ",
  "000:200 the path table is full",
  "000:201 bad path number",
  "000:202 system IRQ table is full",
  "000:203 bad I/O mode",
  "000:204 system device table is full",
  "000:205 bad module header",
  "000:206 system module directory is full",
  "000:207 memory full",
  "000:208 unknown service code ",
  "000:209 non-sharable module is busy",
  "000:210 bad page address",
  "000:211 end of file",
  "000:212 IRQ vector is busy",
  "000:213 non-existing segment",
  "000:214 file not accessible",
  "000:215 bad pathlist",
  "000:216 file not found",
  "000:217 file segment list is full",
  "000:218 creating an existing file",
  "000:219 illegal memory block address",
  "000:220 modem data carrier lost",
  "000:221 module not found",
  "000:222 system clock not running",
  "000:223 deleting stack memory",
  "000:224 illegal process ID",
  "000:225 bad IRQ parameter",
  "000:226 no children",
  "000:227 invalid trap number",
  "000:228 process has aborted",
  "000:229 system process table is full",
  "000:230 illegal fork parameter",
  "000:231 known module",
  "000:232 bad module CRC",
  "000:233 unprocessed signal pending",
  "000:234 non executable module",
  "000:235 bad name",
  "000:236 bad module header parity",
  "000:237 no RAM available",
  "000:238 directory is not empty",
  "000:239 no available task number",
  "000:240 illegal unit (drive) number",
  "000:241 bad sector number",
  "000:242 media is write protected",
  "000:243 I/O error - bad check sum",
  "000:244 read error",
  "000:245 write error",
  "000:246 device not ready",
  "000:247 seek error",
  "000:248 media full",
  "000:249 incompatable media",
  "000:250 device busy",
  "000:251 disk media has changed",
  "000:252 record is busy",
  "000:253 non-sharable file/device is busy",
  "000:254 I/O deadlock error",
  "000:255 device is format protected" };

int sys_nerr = 256;

int perror(s)
  char *s;
{
  fprintf(stderr, "%s: %s\n", _prgname(), s);
  if (errno > sys_nerr)   /* zu grosse Fehlernummer? */
    fprintf(stderr, "%03d.%03d \n", errno >> 8, errno & 0xFF);
  else {
    fputs(sys_errlist[errno], stderr);
    fputs("\n", stderr);
  }
  
  return(errno);
}

/*
 * s t r e r r o r
 */
char *strerror(err)
  int err;
{
  static char errbuf[40];

  if (err > sys_nerr) {   /* zu grosse Fehlernummer? */
    sprintf(errbuf, "%03d.%03d \n", err >> 8, err & 0xFF);
    return(errbuf);
  }
  else
    return(sys_errlist[errno]);
}  
  
s\n", _prgname(), s);
  if (errno > sys_nerr)   /* zu grosse Fehlernummer? */
    fprintf(stderr, "%03d.%03d \n", errno >> 8, errno & 0xFF);
  else {
    fputs(sys_errlist[errno], stderr);
    fputs("\n", stderr);
  }
  
  return(errno);
}

/*
 * s t r e r r o r
 */
char *strerror(err)
  int err;
{
  static char errbuf[40];

  if (err > sys_nerr) {   /* zu grosse Fehlernummer? */
    sprintf(errbuf, "%03d.%03d \n", err >> 8, err & 0xFF);
    return(errbuf);
  }
 pipe.c                                                                                              000600  000000  000000  00000003667 04542747464 005712                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  pipe(), dup2()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 2

#include <stdio.h>
#include <modes.h>

/*
 * p i p e
 *
 * simulate the pipe() function of UN*X for OS9
 * very simple here ....
 */
int pipe(pv)
  register int *pv;
{
  if ((pv[0] = creat("/pipe", S_IREAD+S_IWRITE)) < 0)
    return(-1);

  if ((pv[1] = dup(pv[0])) < 0) {
    close(pv[0]);
    return(-1);
  }

  return(0);
}

/*
 * d u p 2
 *
 * simulate the dup2() function of UN*X for OS9
 * the following should do it ...
 */
int dup2(src, dest)
  register int src, dest;
{
  register int i, newfd;
  int          p[_NFILE];

  if (src == dest)
    return(dest);

  close(dest);

  for (i = 0; i < _NFILE; p[i++] = 0);

  do {
    if ((i = dup(src)) >= 0)
      p[i] = 1;
  } while(i != dest && i >= 0);

  if (i >= 0)
    p[i] = 0;

  newfd = i;

  for (i = 0; i < _NFILE; i++)
    if (p[i])
      close(i);

  return((dest == newfd) ? newfd : -1);
}

* simulate the dup2() function of UN*X for OS9
 * the following should dopopen.c                                                                                             000604  000000  000000  00000011232 04542747464 006065                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  popen(), xpopen(), pclose()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <strings.h>
#include <errno.h>

extern FILE *fdopen();

extern char **environ;
extern int  os9forkc();

extern char *findmod(), *getenv(), *info_str();

static char  cmd_name[256];

struct pid_stat {
  int used;
  int pid;
  int status;
} ;

static int pids[_NFILE] = { 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0 };

int _popen_secure = 0;

/*
 * c h e c k _ s h e l l
 *
 * check for valid shells
 */
static int check_shell()
{
  char *shell, *cp, *cp2, *cp3, val_shell[200];
  
  errno = E_FNA;

  if ((shell = getenv("SHELL")) == NULL)
    return(0);
  
  if (info_str("valid.shells", val_shell, sizeof(val_shell)) == NULL)
    strcpy(val_shell, "shell,sh,csh");
  
  for (cp = val_shell; cp != NULL && *cp != '\0'; ) {
    cp2 = cp;
    if ((cp = index(cp, ',')) != NULL)
      *cp++ = '\0';

    while (*cp2 == ' ')
      cp2++;
    if ((cp3 = index(cp2, ' ')) != NULL)
      *cp3 = '\0';

    if (!strcmp(shell, cp2))
      return(1);
  }
  
  return(0);
}

/* 
 * p o p e n
 */
FILE *popen(name, mode)
  register char *name, *mode;
{
  register int  fd, fd2, fdsav, pid;
  static char   *argv[] = {NULL, NULL, NULL };
  static char   cmd[200];
  static char   cmd_path[200];
  register char *cp;

  if (_popen_secure)
    if (!check_shell())
      return(NULL);

  cp = name;
  while (*cp == ' ')
    cp++;
  strcpy(cmd_path, cp);

  if (cp = index(cmd_path, ' '))
    *cp++ = '\0';

  strcpy(cmd, "ex ");
  strcat(cmd, findmod(cmd_path, cmd_path));
  if (cp) {
    strcat(cmd, " ");
    strcat(cmd, cp);
  }

  argv[1] = cmd;

/*
 * mode kann "r" (stdout) oder "w" (stdin) sein
 */
  switch(mode[0]) {
    case 'w':
      fd = 0;
      break;

    case 'r':
      fd = 1;
      break;
  }

  if (fd == 1)
    fflush(stdout);

  fdsav = dup(fd);
  close(fd);
 
  creat("/pipe", S_IWRITE+S_IREAD);
  argv[0] = findmod("shell", "SYSTEM.SHELL");
  pid = os9exec(os9forkc, argv[0], argv, environ, 0, 0, 3);

  fd2 = dup(fd);
  close(fd);
  dup(fdsav);
  close(fdsav);

  if (pid > 0) {
    pids[fd2] = pid;
    return(fdopen(fd2, mode));
  }
  else {
    close(fd2);
    return(NULL);
  }
}


/*
 * x p o p e n
 */
FILE *xpopen(name, mode)
  register char *name, *mode;
{
  register int fd, fd2, fdsav, pid;
  char         **argv;

  if (_popen_secure)
    if (!check_shell())
      return(NULL);

  strcpy(cmd_name, name);

  if (getargs(cmd_name, &argv) == -1)
    return(NULL);

/*
 * mode kann "r" (stdout) oder "w" (stdin) sein
 */
  switch(mode[0]) {
    case 'w':
      fd = 0;
      break;

    case 'r':
      fd = 1;
      break;
  }

  if (fd == 1 && fileno(stdout) == 1)
    fflush(stdout);

  fdsav = dup(fd);
  close(fd);

  creat("/pipe", S_IWRITE+S_IREAD);
  pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 0, 0, 3);

  free(argv);

  fd2 = dup(fd);
  close(fd);
  dup(fdsav);
  close(fdsav);

  if (pid > 0) {
    pids[fd2] = pid;
    return(fdopen(fd2, mode));
  }
  else {
    close(fd2);
    return(NULL);
  }
}

/*
 * p c l o s e
 */
unsigned int pclose(fp)
  register FILE *fp;
{
  unsigned int status;
  register int pid;
  register int fd, i;

  fd = fileno(fp);

  if (pids[fd] == 0)
    return(-1);
  fflush(fp);
  fclose(fp);

  while ((pid = wait(&status)) != -1)
    if (pid == pids[fd])
      break;
    else
      for (i = 0; i < _NFILE; i++)
        if (pids[i] == pid) {
          pids[i] = 0;
          break;
        }

  if (pid == -1)
    status = -1;

  pids[fd] = 0;
  return(status);
}


rn(NULL);
  }
}

/*
 * p c l o s e
 */
unsigned int pclose(fp)
  register FILE *fp;
{
  unsigned int status;
  register int pid;
  register int fd, i;

  fd = fileno(fp);

  if (pids[fd] == 0)
    return(-1);
  fflush(fp);
  fclose(fp);

  while ((pid = wait(&status)) != -1)
    if (pid == pids[fd])
      break;
    else
      for (i = 0; i < _NFILE; i++)
printertype.c                                                                                       000600  000000  000000  00000002653 04542747464 007334                                                                                                                                                                                                                                                                                                                                                                      #include <stdio.h>

#define DEFAULT_PTYPES "/dd/SYS/printertypes"
#define DEFAULT_TTYPES "/dd/SYS/termtypes"

/*
 * g e t e n t r y
 */
static char *getentry(fp, port)
  FILE *fp;
  char *port;
{
  char buf[100];

  if (port[0] == '/')
    port++;
  
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    if ((cp = index(buf, '\n')) != NULL)
      *cp = '\0';

    if (buf[0] == '\0' || buf[0] == '#' || buf[0] == '*')
      continue;
    
    for (cp = buf; *cp != '\0' && *cp != ' ' && *cp != '\t'; cp++) ;
    
    if (*cp == '\0')
      continue;

    *cp = '\0';
    if (strcmp(buf, port))
      continue;
    
    for (; *cp == ' ' || *cp == '\t'; cp++) ;

    if (cp == '\0')
      return(NULL);
    
    return(cp);
  }
  
  return(NULL);
}

/*
 * t e r m t y p e
 */
char *termtype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("termtypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_TTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);
  

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

/*
 * p r i n t e r t y p e
 */
char *printertype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("printertypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, "DEFAULT_PTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);
  

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

ename, DEFAULT_TTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULLpw.c                                                                                                000600  000000  000000  00000015346 04542747464 005400                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  password routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 2

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <sgstat.h>

static char           EMPTY[] = "";
static FILE           *pwf = NULL;
static char           line[BUFSIZ+1];
static struct passwd  passwd;

#define TRUE  (-1)
#define FALSE (0)

extern FILE *ddfopen();

int _pw_secure = 0;

/*
 * s e t p w e n t
 */
int setpwent()
{
  char fn[100];

  if (!pwf) {
    if ((pwf = ddfopen(PASSWD, fn, "r", _pw_secure)) == NULL)
      return(-1);
  }
  else
    rewind(pwf);

  return(0);    /* OK */
}

/*
 *  e n d p w e n t
 */
void endpwent()
{
  if (pwf) {
    fclose (pwf);
    pwf = NULL;
  }
}

/*
 * p w s k i p
 */
static char *pwskip(p)
  register char *p;

{
  while (*p && *p != ',' && *p != '\n')
    ++p;

  if (*p)
    *p++ = 0;

  return(p);
}

/*
 * _ g e t p w
 */
struct passwd *_getpw(pwd, pwline)
  register struct passwd *pwd;
  char                   *pwline;
{
  register char *p;
  char          *cp;
  static char   tmp[BUFSIZ+1];
  static char   comment[81];
  static char   gecos[81];
  
  strcpy(tmp, pwline);

  p = tmp;
  pwd->pw_name = p;

  p = pwskip(p);
  pwd->pw_passwd = p;

  p = pwskip(p);
  cp = p;
  while (*cp && (*cp != '.'))
    ++cp;

  if (*cp)
    *cp++ = '\0';
 
  pwd->pw_gid = atoi(p);

  p = cp;
  p = pwskip(p);
  pwd->pw_uid = atoi(cp);

  cp = p;

  p = pwskip(p);
  pwd->pw_prio = atoi(cp);

  pwd->pw_comment = EMPTY;
  pwd->pw_gecos   = EMPTY;
  pwd->pw_age     = EMPTY;
  pwd->pw_xdir    = p;

  p = pwskip(p);
  pwd->pw_dir = p;

  p = pwskip(p);
  pwd->pw_shell = p;

  p = pwskip(p);
  pwd->pw_junk = p;

  p = pwskip(p);

  getpwopt(pwd->pw_junk, comment, PW_COMMENT, sizeof(comment));
  pwd->pw_comment = comment;
  getpwopt(pwd->pw_junk, gecos, PW_GECOS, sizeof(gecos));
  pwd->pw_gecos = gecos;
  return(pwd);
}

/*
 * g e t p w e n t
 */
struct passwd *getpwent()
{
  if (!pwf)
    if (setpwent() < 0)
      return(NULL);

  do {
    if (!fgets(line, BUFSIZ, pwf))
      return(NULL);
  } while (line[0] == '#' || line[0] == '*');

  if (!_getpw(&passwd,  line))
    return(NULL);

  return(&passwd);
}

/*
 * g e t p w u i d
 */
struct passwd *getpwuid(uid)
  int uid;

{
  int found = 0;
	
  if (setpwent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, pwf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;

    if (_getpw(&passwd, line))
      found = (passwd.pw_uid == uid);
  }

  if (found)
    return(&passwd);
  else
    return(NULL);
}

/*
 * _ s t r c c m p
 */
int _strccmp(a, b)
  register char *a,*b;
{
  register int equal = TRUE;

  while (equal && *a && *b)
    equal = (tolower(*a++) == tolower(*b++));

  if (!equal)
    --a,--b;

  return(tolower(*b) - tolower(*a));
}

/*
 * _ s t r n c c m p
 */
int _strnccmp(a, b, n)
  register char *a,*b;
  register int  n;
{
  register int equal = TRUE;

  while (equal && *a && *b && (--n > 0))
    equal = (tolower(*a++) == tolower(*b++));

  if (!equal)
    --a, --b;

  return(tolower(*b) - tolower(*a));
}


/*
 * g e t p w n a m
 */
struct passwd *getpwnam(name)
  char *name;
{
  int found = 0;
	
  if (setpwent() < 0)
    return(NULL);

  while ((!found) && fgets(line, BUFSIZ, pwf)) {
    if (line[0] == '#' || line[0] == '*')
      continue;
    if (_getpw(&passwd, line)) 
      found = !_strccmp(passwd.pw_name, name);
  }

  if (found)
    return(&passwd);
  else
    return(NULL);
}

/*
 * f g e t p w e n t
 */
struct passwd *fgetpwent (f)
  FILE *f;

{
  struct passwd *pw = NULL;
	
  do {
    if (fgets (line, BUFSIZ, f))
      pw = _getpw(line, &passwd);
    else
      pw = NULL;
  } while (pw && (line[0] == '#' || line[0] == '*'));

  return(pw);
}

/*
 * g e t p w
 */
int getpw(uid, name)
{
  struct passwd *pw;

  if ((pw = getpwuid(uid)) == NULL)
    return(-1);

  strcpy(name, pw->pw_name);
  return(0);
}

/*
 * _ c m p u i d
 */
int _cmpuid(uidstr, uid)
  char  *uidstr;
  int   *uid;
{
  int i;

  i = 0;
  while (*uidstr && *uidstr != '.')
    if (isdigit(*uidstr))
      i = i * 10 + *uidstr++ - '0';
    else
      return(-1);
  
  if (!*uidstr++) {
    *uid = i;
    return(0);
  }

  *uid = i << 16;

    
  i = 0;
  while (*uidstr && *uidstr != '.')
    if (isdigit(*uidstr))
      i = i * 10 + *uidstr++ - '0';
    else
      return(-1);
  
  *uid |= i;
  
  if (*uidstr)
    return(0);
  return(-1);
}


/*
 * o p t s k i p
 */
static char *optskip(s)
  register char *s;
{
  while (*s && *s != '|')
    s++;
  
  if (*s)
    s++;
  return(s);
}


/*
 * g e t p w o p t
 */
int getpwopt(junk, buf, opt, max)
  register char *junk;
  char          *buf;
  register char opt;
  register int  max;
{
  register char *cp;
  int           res;

  res = -1;
  --max;
  buf[0] = '\0';
  
  while (*junk != '\0' && res)
    if (*junk != '-' || *(junk+1) != opt)
      junk = optskip(junk);
    else {
      cp   = buf;
      junk += *(junk+2) == '=' ? 3 : 2;

      while (*junk != '\0' && *junk != '|' && --max > 0)
        *cp++ = *junk++;

      *cp = '\0';
      res = 0;
      break;
    }
  
  return(res);
}

/*
 * g e c o s s k i p
 */
static char *gecosskip(s)
  register char *s;
{
  while (*s && *s != ':')
    s++;

  if (*s != '\0')
    *s++ = '\0';

  return(*s == '\0' ? NULL : s);
}

/*
 * g e t g e c o s
 */
struct gecos *getgecos(gecos_field)
  register char *gecos_field;
{
  static struct gecos gecos;
  
  if (gecos_field == NULL || gecos_field[0] == '\0')
    return(NULL);

  gecos.fullname     = gecos.organization =
  gecos.office_phone = gecos.home_phone   = NULL;

  gecos.fullname = gecos_field;

  if ((gecos.organization = gecosskip(gecos.fullname)) == NULL)
    return(&gecos);

  if ((gecos.office_phone = gecosskip(gecos.organization)) == NULL)
    return(&gecos);

  gecos.home_phone = gecosskip(gecos.office_phone);
  return(&gecos);
}
)
  register char *gecos_field;
{
  static struct gecos gecos;
  
  if (gecos_field == NULL || gecos_field[0] == '\0')
    return(NULL);

  gecos.fullname     = gecos.organization =
  gecos.office_phone = gecos.home_phone   = NULL;

  gecos.fullname = gecos_field;

  if ((gecos.orgrand.c                                                                                              000600  000000  000000  00000004001 04542747464 005660                                                                                                                                                                                                                                                                                                                                                                      /*
 * A very random generator, period approx 6.8064e16.
 * 
 * Uses algorithm M, "Art of Computer Programming", Vol 2. 1969, D.E.Knuth.
 * 
 * Two generators are used to derive the high and low parts of sequence X, and
 * another for sequence Y. These were derived by Michael Mauldin.
 * 
 * Usage:  initialize by calling srand(seed), then rand() returns a random
 * number from 0..2147483647. srand(0) uses the current time as the seed.
 * 
 * Author: Michael Mauldin, June 14, 1983. adapted to OS-9/68000 C-Library by
 * Christian Engel, Sat Oct 17 01:39:27 1987
 */

/*
 * Rand 1, period length 444674
 */
#define MUL1  1156
#define OFF1  312342
#define MOD1  1334025
#define RAND1 (seed1=((seed1*MUL1+OFF1)%MOD1))
#define Y     RAND1

/*
 * Rand 2, period length 690709
 */
#define MUL2  1366
#define OFF2  827291
#define MOD2  1519572
#define RAND2 (seed2=((seed2*MUL2+OFF2)%MOD2))

/*
 * Rand 3, period length 221605
 */
#define MUL3  1156
#define OFF3  198273
#define MOD3  1329657
#define RAND3 (seed3=((seed3*MUL3+OFF3)%MOD3))

/*
 * RAND2 generates 19 random bits, RAND3 generates 17. The X sequence is made
 * up off both, and thus has 31 random bits.
 */

#define X ((RAND2<<13 ^ RAND3>>3) & 017777777777)

#define AUXLEN 97

static int seed1 = 872978, seed2 = 518652, seed3 = 226543;
static int auxtab[AUXLEN];

/*
 * s r a n d
 */
srand(seed)
  int seed;
{
  register int i;

  if (seed == 0)
    seed = time();

  /*
   * Set the three random number seeds
   */
  seed1 = (seed1 + seed) % MOD1;
  seed2 = (seed2 + seed) % MOD2;
  seed3 = (seed3 + seed) % MOD3;

  for (i = AUXLEN; i--;)
    auxtab[i] = X;
}

/*
 * r a n d
 */
int rand()
{
  register int j, result;

  j = AUXLEN * Y / MOD1;			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result);
}

/*
 * r a n d i n t
 */
int randint(max)
  register int max;
{
  register int j, result;

  j = AUXLEN * Y / MOD1;			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result % max);
}
MOD2;
  seed3 = (seed3 + seed) % MOD3;

  for (i = AUXLEN; i--;)
    auxtab[i] = X;
}

/*
 * r a n d
 */
int rand()
{
  register int j, result;

  j = AUXLEN * Y / MOD1;			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result);
}

/*
 * r a n d i n t
 */
int randint(max)
  register int max;
{
  register int j, result;

  j = AUXLEN * Y / MOD1;			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result % max);
}regerror.c                                                                                          000604  000000  000000  00000000252 04542747464 006573                                                                                                                                                                                                                                                                                                                                                                      #include <stdio.h>

void
regerror(s)
char *s;
{
#ifdef ERRAVAIL
	error("regexp: %s", s);
#else
	fprintf(stderr, "regexp(3): %s", s);
	exit(1);
#endif
	/* NOTREACHED */
}
			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result);
}

/*
 * r a n d i n t
 */
int randint(max)
  register int max;
{
  register int j, result;

  j = AUXLEN * Y / MOD1;			  /* j random from
						   * 0..AUXLEN-1 */
  result    = auxtab[j];
  auxtab[j] = X;

  return(result % max);
}regexp.c                                                                                            000604  000000  000000  00000066212 04542747464 006246                                                                                                                                                                                                                                                                                                                                                                      /*
 * regcomp and regexec -- regsub and regerror are elsewhere
 *
 *	Copyright (c) 1986 by University of Toronto.
 *	Written by Henry Spencer.  Not derived from licensed software.
 *
 *	Permission is granted to anyone to use this software for any
 *	purpose on any computer system, and to redistribute it freely,
 *	subject to the following restrictions:
 *
 *	1. The author is not responsible for the consequences of use of
 *		this software, no matter how awful, even if they arise
 *		from defects in it.
 *
 *	2. The origin of this software must not be misrepresented, either
 *		by explicit claim or by omission.
 *
 *	3. Altered versions must be plainly marked as such, and must not
 *		be misrepresented as being the original software.
 *
 * Beware that some of this code is subtly aware of the way operator
 * precedence is structured in regular expressions.  Serious changes in
 * regular-expression syntax might require a total rethink.
 */
#ifdef OSK
#define	sp sp_		/* only for some compilers	*/
#define STRCSPN
#define strchr index
#define STATIC extern
#endif

#include <stdio.h>
#include "regexp.h"
#include "regmagic.h"

/*
 * The "internal use only" fields in regexp.h are present to pass info from
 * compile to execute that permits the execute phase to run lots faster on
 * simple cases.  They are:
 *
 * regstart	char that must begin a match; '\0' if none obvious
 * reganch	is the match anchored (at beginning-of-line only)?
 * regmust	string (pointer into program) that match must include, or NULL
 * regmlen	length of regmust string
 *
 * Regstart and reganch permit very fast decisions on suitable starting points
 * for a match, cutting down the work a lot.  Regmust permits fast rejection
 * of lines that cannot possibly match.  The regmust tests are costly enough
 * that regcomp() supplies a regmust only if the r.e. contains something
 * potentially expensive (at present, the only such thing detected is * or +
 * at the start of the r.e., which can involve a lot of backup).  Regmlen is
 * supplied because the test in regexec() needs it and regcomp() is computing
 * it anyway.
 */

/*
 * Structure for regexp "program".  This is essentially a linear encoding
 * of a nondeterministic finite-state machine (aka syntax charts or
 * "railroad normal form" in parsing technology).  Each node is an opcode
 * plus a "next" pointer, possibly plus an operand.  "Next" pointers of
 * all nodes except BRANCH implement concatenation; a "next" pointer with
 * a BRANCH on both ends of it is connecting two alternatives.  (Here we
 * have one of the subtle syntax dependencies:  an individual BRANCH (as
 * opposed to a collection of them) is never concatenated with anything
 * because of operator precedence.)  The operand of some types of node is
 * a literal string; for others, it is a node leading into a sub-FSM.  In
 * particular, the operand of a BRANCH node is the first node of the branch.
 * (NB this is *not* a tree structure:  the tail of the branch connects
 * to the thing following the set of BRANCHes.)  The opcodes are:
 */

#ifdef OSK
#ifdef EOL
#undef EOL
#endif
#endif

/* definition	number	opnd?	meaning */
#define	END	0	/* no	End of program. */
#define	BOL	1	/* no	Match "" at beginning of line. */
#define	EOL	2	/* no	Match "" at end of line. */
#define	ANY	3	/* no	Match any one character. */
#define	ANYOF	4	/* str	Match any character in this string. */
#define	ANYBUT	5	/* str	Match any character not in this string. */
#define	BRANCH	6	/* node	Match this alternative, or the next... */
#define	BACK	7	/* no	Match "", "next" ptr points backward. */
#define	EXACTLY	8	/* str	Match this string. */
#define	NOTHING	9	/* no	Match empty string. */
#define	STAR	10	/* node	Match this (simple) thing 0 or more times. */
#define	PLUS	11	/* node	Match this (simple) thing 1 or more times. */
#define	OPEN	20	/* no	Mark this point in input as start of #n. */
			/*	OPEN+1 is number 1, etc. */
#define	CLOSE	30	/* no	Analogous to OPEN. */

/*
 * Opcode notes:
 *
 * BRANCH	The set of branches constituting a single choice are hooked
 *		together with their "next" pointers, since precedence prevents
 *		anything being concatenated to any individual branch.  The
 *		"next" pointer of the last BRANCH in a choice points to the
 *		thing following the whole choice.  This is also where the
 *		final "next" pointer of each individual branch points; each
 *		branch starts with the operand node of a BRANCH node.
 *
 * BACK		Normal "next" pointers all implicitly point forward; BACK
 *		exists to make loop structures possible.
 *
 * STAR,PLUS	'?', and complex '*' and '+', are implemented as circular
 *		BRANCH structures using BACK.  Simple cases (one character
 *		per match) are implemented with STAR and PLUS for speed
 *		and to minimize recursive plunges.
 *
 * OPEN,CLOSE	...are numbered at compile time.
 */

/*
 * A node is one char of opcode followed by two chars of "next" pointer.
 * "Next" pointers are stored as two 8-bit pieces, high order first.  The
 * value is a positive offset from the opcode of the node containing it.
 * An operand, if any, simply follows the node.  (Note that much of the
 * code generation knows about this implicit relationship.)
 *
 * Using two bytes for the "next" pointer is vast overkill for most things,
 * but allows patterns to get big without disasters.
 */
#define	OP(p)	(*(p))
#define	NEXT(p)	(((*((p)+1)&0377)<<8) + *((p)+2)&0377)
#define	OPERAND(p)	((p) + 3)

/*
 * See regmagic.h for one further detail of program structure.
 */


/*
 * Utility definitions.
 */
#ifndef CHARBITS
#define	UCHARAT(p)	((int)*(unsigned char *)(p))
#else
#define	UCHARAT(p)	((int)*(p)&CHARBITS)
#endif

#define	FAIL(m)	{ regerror(m); return(NULL); }
#define	ISMULT(c)	((c) == '*' || (c) == '+' || (c) == '?')
#define	META	"^$.[()|?+*\\"

/*
 * Flags to be passed up and down.
 */
#define	HASWIDTH	01	/* Known never to match null string. */
#define	SIMPLE		02	/* Simple enough to be STAR/PLUS operand. */
#define	SPSTART		04	/* Starts with * or +. */
#define	WORST		0	/* Worst case. */

/*
 * Global work variables for regcomp().
 */
static char *regparse;		/* Input-scan pointer. */
static int regnpar;		/* () count. */
static char regdummy;
static char *regcode;		/* Code-emit pointer; &regdummy = don't. */
static long regsize;		/* Code size. */

/*
 * Forward declarations for regcomp()'s friends.
 */
#ifndef STATIC
#define	STATIC	static
#endif
STATIC char *reg();
STATIC char *regbranch();
STATIC char *regpiece();
STATIC char *regatom();
STATIC char *regnode();
STATIC char *regnext();
STATIC void regc();
STATIC void reginsert();
STATIC void regtail();
STATIC void regoptail();
#ifdef STRCSPN
STATIC int strcspn();
#endif

/*
 - regcomp - compile a regular expression into internal code
 *
 * We can't allocate space until we know how big the compiled form will be,
 * but we can't compile it (and thus know how big it is) until we've got a
 * place to put the code.  So we cheat:  we compile it twice, once with code
 * generation turned off and size counting turned on, and once "for real".
 * This also means that we don't allocate space until we are sure that the
 * thing really will compile successfully, and we never have to move the
 * code and thus invalidate pointers into it.  (Note that it has to be in
 * one piece because free() must be able to free it all.)
 *
 * Beware that the optimization-preparation code in here knows about some
 * of the structure of the compiled regexp.
 */
regexp *
regcomp(exp)
char *exp;
{
	register regexp *r;
	register char *scan;
	register char *longest;
	register int len;
	int flags;
	extern char *malloc();

	if (exp == NULL)
		FAIL("NULL argument");

	/* First pass: determine size, legality. */
	regparse = exp;
	regnpar = 1;
	regsize = 0L;
	regcode = &regdummy;
	regc(MAGIC);
	if (reg(0, &flags) == NULL)
		return(NULL);

	/* Small enough for pointer-storage convention? */
	if (regsize >= 32767L)		/* Probably could be 65535L. */
		FAIL("regexp too big");

	/* Allocate space. */
	r = (regexp *)malloc(sizeof(regexp) + (unsigned)regsize);
	if (r == NULL)
		FAIL("out of space");

	/* Second pass: emit code. */
	regparse = exp;
	regnpar = 1;
	regcode = r->program;
	regc(MAGIC);
	if (reg(0, &flags) == NULL)
		return(NULL);

	/* Dig out information for optimizations. */
	r->regstart = '\0';	/* Worst-case defaults. */
	r->reganch = 0;
	r->regmust = NULL;
	r->regmlen = 0;
	scan = r->program+1;			/* First BRANCH. */
	if (OP(regnext(scan)) == END) {		/* Only one top-level choice. */
		scan = OPERAND(scan);

		/* Starting-point info. */
		if (OP(scan) == EXACTLY)
			r->regstart = *OPERAND(scan);
		else if (OP(scan) == BOL)
			r->reganch++;

		/*
		 * If there's something expensive in the r.e., find the
		 * longest literal string that must appear and make it the
		 * regmust.  Resolve ties in favor of later strings, since
		 * the regstart check works with the beginning of the r.e.
		 * and avoiding duplication strengthens checking.  Not a
		 * strong reason, but sufficient in the absence of others.
		 */
		if (flags&SPSTART) {
			longest = NULL;
			len = 0;
			for (; scan != NULL; scan = regnext(scan))
				if (OP(scan) == EXACTLY && strlen(OPERAND(scan)) >= len) {
					longest = OPERAND(scan);
					len = strlen(OPERAND(scan));
				}
			r->regmust = longest;
			r->regmlen = len;
		}
	}

	return(r);
}

/*
 - reg - regular expression, i.e. main body or parenthesized thing
 *
 * Caller must absorb opening parenthesis.
 *
 * Combining parenthesis handling with the base level of regular expression
 * is a trifle forced, but the need to tie the tails of the branches to what
 * follows makes it hard to avoid.
 */
static char *
reg(paren, flagp)
int paren;			/* Parenthesized? */
int *flagp;
{
	register char *ret;
	register char *br;
	register char *ender;
	register int parno;
	int flags;

	*flagp = HASWIDTH;	/* Tentatively. */

	/* Make an OPEN node, if parenthesized. */
	if (paren) {
		if (regnpar >= NSUBEXP)
			FAIL("too many ()");
		parno = regnpar;
		regnpar++;
		ret = regnode(OPEN+parno);
	} else
		ret = NULL;

	/* Pick up the branches, linking them together. */
	br = regbranch(&flags);
	if (br == NULL)
		return(NULL);
	if (ret != NULL)
		regtail(ret, br);	/* OPEN -> first. */
	else
		ret = br;
	if (!(flags&HASWIDTH))
		*flagp &= ~HASWIDTH;
	*flagp |= flags&SPSTART;
	while (*regparse == '|') {
		regparse++;
		br = regbranch(&flags);
		if (br == NULL)
			return(NULL);
		regtail(ret, br);	/* BRANCH -> BRANCH. */
		if (!(flags&HASWIDTH))
			*flagp &= ~HASWIDTH;
		*flagp |= flags&SPSTART;
	}

	/* Make a closing node, and hook it on the end. */
	ender = regnode((paren) ? CLOSE+parno : END);	
	regtail(ret, ender);

	/* Hook the tails of the branches to the closing node. */
	for (br = ret; br != NULL; br = regnext(br))
		regoptail(br, ender);

	/* Check for proper termination. */
	if (paren && *regparse++ != ')') {
		FAIL("unmatched ()");
	} else if (!paren && *regparse != '\0') {
		if (*regparse == ')') {
			FAIL("unmatched ()");
		} else
			FAIL("junk on end");	/* "Can't happen". */
		/* NOTREACHED */
	}

	return(ret);
}

/*
 - regbranch - one alternative of an | operator
 *
 * Implements the concatenation operator.
 */
static char *
regbranch(flagp)
int *flagp;
{
	register char *ret;
	register char *chain;
	register char *latest;
	int flags;

	*flagp = WORST;		/* Tentatively. */

	ret = regnode(BRANCH);
	chain = NULL;
	while (*regparse != '\0' && *regparse != '|' && *regparse != ')') {
		latest = regpiece(&flags);
		if (latest == NULL)
			return(NULL);
		*flagp |= flags&HASWIDTH;
		if (chain == NULL)	/* First piece. */
			*flagp |= flags&SPSTART;
		else
			regtail(chain, latest);
		chain = latest;
	}
	if (chain == NULL)	/* Loop ran zero times. */
		(void) regnode(NOTHING);

	return(ret);
}

/*
 - regpiece - something followed by possible [*+?]
 *
 * Note that the branching code sequences used for ? and the general cases
 * of * and + are somewhat optimized:  they use the same NOTHING node as
 * both the endmarker for their branch list and the body of the last branch.
 * It might seem that this node could be dispensed with entirely, but the
 * endmarker role is not redundant.
 */
static char *
regpiece(flagp)
int *flagp;
{
	register char *ret;
	register char op;
	register char *next;
	int flags;

	ret = regatom(&flags);
	if (ret == NULL)
		return(NULL);

	op = *regparse;
	if (!ISMULT(op)) {
		*flagp = flags;
		return(ret);
	}

	if (!(flags&HASWIDTH) && op != '?')
		FAIL("*+ operand could be empty");
	*flagp = (op != '+') ? (WORST|SPSTART) : (WORST|HASWIDTH);

	if (op == '*' && (flags&SIMPLE))
		reginsert(STAR, ret);
	else if (op == '*') {
		/* Emit x* as (x&|), where & means "self". */
		reginsert(BRANCH, ret);			/* Either x */
		regoptail(ret, regnode(BACK));		/* and loop */
		regoptail(ret, ret);			/* back */
		regtail(ret, regnode(BRANCH));		/* or */
		regtail(ret, regnode(NOTHING));		/* null. */
	} else if (op == '+' && (flags&SIMPLE))
		reginsert(PLUS, ret);
	else if (op == '+') {
		/* Emit x+ as x(&|), where & means "self". */
		next = regnode(BRANCH);			/* Either */
		regtail(ret, next);
		regtail(regnode(BACK), ret);		/* loop back */
		regtail(next, regnode(BRANCH));		/* or */
		regtail(ret, regnode(NOTHING));		/* null. */
	} else if (op == '?') {
		/* Emit x? as (x|) */
		reginsert(BRANCH, ret);			/* Either x */
		regtail(ret, regnode(BRANCH));		/* or */
		next = regnode(NOTHING);		/* null. */
		regtail(ret, next);
		regoptail(ret, next);
	}
	regparse++;
	if (ISMULT(*regparse))
		FAIL("nested *?+");

	return(ret);
}

/*
 - regatom - the lowest level
 *
 * Optimization:  gobbles an entire sequence of ordinary characters so that
 * it can turn them into a single node, which is smaller to store and
 * faster to run.  Backslashed characters are exceptions, each becoming a
 * separate node; the code is simpler that way and it's not worth fixing.
 */
static char *
regatom(flagp)
int *flagp;
{
	register char *ret;
	int flags;

	*flagp = WORST;		/* Tentatively. */

	switch (*regparse++) {
	case '^':
		ret = regnode(BOL);
		break;
	case '$':
		ret = regnode(EOL);
		break;
	case '.':
		ret = regnode(ANY);
		*flagp |= HASWIDTH|SIMPLE;
		break;
	case '[': {
			register int class;
			register int classend;

			if (*regparse == '^') {	/* Complement of range. */
				ret = regnode(ANYBUT);
				regparse++;
			} else
				ret = regnode(ANYOF);
			if (*regparse == ']' || *regparse == '-')
				regc(*regparse++);
			while (*regparse != '\0' && *regparse != ']') {
				if (*regparse == '-') {
					regparse++;
					if (*regparse == ']' || *regparse == '\0')
						regc('-');
					else {
						class = UCHARAT(regparse-2)+1;
						classend = UCHARAT(regparse);
						if (class > classend+1)
							FAIL("invalid [] range");
						for (; class <= classend; class++)
							regc(class);
						regparse++;
					}
				} else
					regc(*regparse++);
			}
			regc('\0');
			if (*regparse != ']')
				FAIL("unmatched []");
			regparse++;
			*flagp |= HASWIDTH|SIMPLE;
		}
		break;
	case '(':
		ret = reg(1, &flags);
		if (ret == NULL)
			return(NULL);
		*flagp |= flags&(HASWIDTH|SPSTART);
		break;
	case '\0':
	case '|':
	case ')':
		FAIL("internal urp");	/* Supposed to be caught earlier. */
		break;
	case '?':
	case '+':
	case '*':
		FAIL("?+* follows nothing");
		break;
	case '\\':
		if (*regparse == '\0')
			FAIL("trailing \\");
		ret = regnode(EXACTLY);
		regc(*regparse++);
		regc('\0');
		*flagp |= HASWIDTH|SIMPLE;
		break;
	default: {
			register int len;
			register char ender;

			regparse--;
			len = strcspn(regparse, META);
			if (len <= 0)
				FAIL("internal disaster");
			ender = *(regparse+len);
			if (len > 1 && ISMULT(ender))
				len--;		/* Back off clear of ?+* operand. */
			*flagp |= HASWIDTH;
			if (len == 1)
				*flagp |= SIMPLE;
			ret = regnode(EXACTLY);
			while (len > 0) {
				regc(*regparse++);
				len--;
			}
			regc('\0');
		}
		break;
	}

	return(ret);
}

/*
 - regnode - emit a node
 */
static char *			/* Location. */
regnode(op)
char op;
{
	register char *ret;
	register char *ptr;

	ret = regcode;
	if (ret == &regdummy) {
		regsize += 3;
		return(ret);
	}

	ptr = ret;
	*ptr++ = op;
	*ptr++ = '\0';		/* Null "next" pointer. */
	*ptr++ = '\0';
	regcode = ptr;

	return(ret);
}

/*
 - regc - emit (if appropriate) a byte of code
 */
static void
regc(b)
char b;
{
	if (regcode != &regdummy)
		*regcode++ = b;
	else
		regsize++;
}

/*
 - reginsert - insert an operator in front of already-emitted operand
 *
 * Means relocating the operand.
 */
static void
reginsert(op, opnd)
char op;
char *opnd;
{
	register char *src;
	register char *dst;
	register char *place;

	if (regcode == &regdummy) {
		regsize += 3;
		return;
	}

	src = regcode;
	regcode += 3;
	dst = regcode;
	while (src > opnd)
		*--dst = *--src;

	place = opnd;		/* Op node, where operand used to be. */
	*place++ = op;
	*place++ = '\0';
	*place++ = '\0';
}

/*
 - regtail - set the next-pointer at the end of a node chain
 */
static void
regtail(p, val)
char *p;
char *val;
{
	register char *scan;
	register char *temp;
	register int offset;

	if (p == &regdummy)
		return;

	/* Find last node. */
	scan = p;
	for (;;) {
		temp = regnext(scan);
		if (temp == NULL)
			break;
		scan = temp;
	}

	if (OP(scan) == BACK)
		offset = scan - val;
	else
		offset = val - scan;
	*(scan+1) = (offset>>8)&0377;
	*(scan+2) = offset&0377;
}

/*
 - regoptail - regtail on operand of first argument; nop if operandless
 */
static void
regoptail(p, val)
char *p;
char *val;
{
	/* "Operandless" and "op != BRANCH" are synonymous in practice. */
	if (p == NULL || p == &regdummy || OP(p) != BRANCH)
		return;
	regtail(OPERAND(p), val);
}

/*
 * regexec and friends
 */

/*
 * Global work variables for regexec().
 */
static char *reginput;		/* String-input pointer. */
static char *regbol;		/* Beginning of input, for ^ check. */
static char **regstartp;	/* Pointer to startp array. */
static char **regendp;		/* Ditto for endp. */

/*
 * Forwards.
 */
STATIC int regtry();
STATIC int regmatch();
STATIC int regrepeat();

#ifdef DEBUG
int regnarrate = 0;
void regdump();
STATIC char *regprop();
#endif

/*
 - regexec - match a regexp against a string
 */
int
regexec(prog, string)
register regexp *prog;
register char *string;
{
	register char *s;
	extern char *strchr();

	/* Be paranoid... */
	if (prog == NULL || string == NULL) {
		regerror("NULL parameter");
		return(0);
	}

	/* Check validity of program. */
	if (UCHARAT(prog->program) != MAGIC) {
		regerror("corrupted program");
		return(0);
	}

	/* If there is a "must appear" string, look for it. */
	if (prog->regmust != NULL) {
		s = string;
		while ((s = strchr(s, prog->regmust[0])) != NULL) {
			if (strncmp(s, prog->regmust, prog->regmlen) == 0)
				break;	/* Found it. */
			s++;
		}
		if (s == NULL)	/* Not present. */
			return(0);
	}

	/* Mark beginning of line for ^ . */
	regbol = string;

	/* Simplest case:  anchored match need be tried only once. */
	if (prog->reganch)
		return(regtry(prog, string));

	/* Messy cases:  unanchored match. */
	s = string;
	if (prog->regstart != '\0')
		/* We know what char it must start with. */
		while ((s = strchr(s, prog->regstart)) != NULL) {
			if (regtry(prog, s))
				return(1);
			s++;
		}
	else
		/* We don't -- general case. */
		do {
			if (regtry(prog, s))
				return(1);
		} while (*s++ != '\0');

	/* Failure. */
	return(0);
}

/*
 - regtry - try match at specific point
 */
static int			/* 0 failure, 1 success */
regtry(prog, string)
regexp *prog;
char *string;
{
	register int i;
	register char **sp;
	register char **ep;

	reginput = string;
	regstartp = prog->startp;
	regendp = prog->endp;

	sp = prog->startp;
	ep = prog->endp;
	for (i = NSUBEXP; i > 0; i--) {
		*sp++ = NULL;
		*ep++ = NULL;
	}
	if (regmatch(prog->program + 1)) {
		prog->startp[0] = string;
		prog->endp[0] = reginput;
		return(1);
	} else
		return(0);
}

/*
 - regmatch - main matching routine
 *
 * Conceptually the strategy is simple:  check to see whether the current
 * node matches, call self recursively to see whether the rest matches,
 * and then act accordingly.  In practice we make some effort to avoid
 * recursion, in particular by going through "ordinary" nodes (that don't
 * need to know whether the rest of the match failed) by a loop instead of
 * by recursion.
 */
static int			/* 0 failure, 1 success */
regmatch(prog)
char *prog;
{
	register char *scan;	/* Current node. */
	char *next;		/* Next node. */
	extern char *strchr();

	scan = prog;
#ifdef DEBUG
	if (scan != NULL && regnarrate)
		fprintf(stderr, "%s(\n", regprop(scan));
#endif
	while (scan != NULL) {
#ifdef DEBUG
		if (regnarrate)
			fprintf(stderr, "%s...\n", regprop(scan));
#endif
		next = regnext(scan);

		switch (OP(scan)) {
		case BOL:
			if (reginput != regbol)
				return(0);
			break;
		case EOL:
			if (*reginput != '\0')
				return(0);
			break;
		case ANY:
			if (*reginput == '\0')
				return(0);
			reginput++;
			break;
		case EXACTLY: {
				register int len;
				register char *opnd;

				opnd = OPERAND(scan);
				/* Inline the first character, for speed. */
				if (*opnd != *reginput)
					return(0);
				len = strlen(opnd);
				if (len > 1 && strncmp(opnd, reginput, len) != 0)
					return(0);
				reginput += len;
			}
			break;
		case ANYOF:
			if (*reginput == '\0' || strchr(OPERAND(scan), *reginput) == NULL)
				return(0);
			reginput++;
			break;
		case ANYBUT:
			if (*reginput == '\0' || strchr(OPERAND(scan), *reginput) != NULL)
				return(0);
			reginput++;
			break;
		case NOTHING:
			break;
		case BACK:
			break;
		case OPEN+1:
		case OPEN+2:
		case OPEN+3:
		case OPEN+4:
		case OPEN+5:
		case OPEN+6:
		case OPEN+7:
		case OPEN+8:
		case OPEN+9: {
				register int no;
				register char *save;

				no = OP(scan) - OPEN;
				save = reginput;

				if (regmatch(next)) {
					/*
					 * Don't set startp if some later
					 * invocation of the same parentheses
					 * already has.
					 */
					if (regstartp[no] == NULL)
						regstartp[no] = save;
					return(1);
				} else
					return(0);
			}
			break;
		case CLOSE+1:
		case CLOSE+2:
		case CLOSE+3:
		case CLOSE+4:
		case CLOSE+5:
		case CLOSE+6:
		case CLOSE+7:
		case CLOSE+8:
		case CLOSE+9: {
				register int no;
				register char *save;

				no = OP(scan) - CLOSE;
				save = reginput;

				if (regmatch(next)) {
					/*
					 * Don't set endp if some later
					 * invocation of the same parentheses
					 * already has.
					 */
					if (regendp[no] == NULL)
						regendp[no] = save;
					return(1);
				} else
					return(0);
			}
			break;
		case BRANCH: {
				register char *save;

				if (OP(next) != BRANCH)		/* No choice. */
					next = OPERAND(scan);	/* Avoid recursion. */
				else {
					do {
						save = reginput;
						if (regmatch(OPERAND(scan)))
							return(1);
						reginput = save;
						scan = regnext(scan);
					} while (scan != NULL && OP(scan) == BRANCH);
					return(0);
					/* NOTREACHED */
				}
			}
			break;
		case STAR:
		case PLUS: {
				register char nextch;
				register int no;
				register char *save;
				register int min;

				/*
				 * Lookahead to avoid useless match attempts
				 * when we know what character comes next.
				 */
				nextch = '\0';
				if (OP(next) == EXACTLY)
					nextch = *OPERAND(next);
				min = (OP(scan) == STAR) ? 0 : 1;
				save = reginput;
				no = regrepeat(OPERAND(scan));
				while (no >= min) {
					/* If it could work, try it. */
					if (nextch == '\0' || *reginput == nextch)
						if (regmatch(next))
							return(1);
					/* Couldn't or didn't -- back up. */
					no--;
					reginput = save + no;
				}
				return(0);
			}
			break;
		case END:
			return(1);	/* Success! */
			break;
		default:
			regerror("memory corruption");
			return(0);
			break;
		}

		scan = next;
	}

	/*
	 * We get here only if there's trouble -- normally "case END" is
	 * the terminating point.
	 */
	regerror("corrupted pointers");
	return(0);
}

/*
 - regrepeat - repeatedly match something simple, report how many
 */
static int
regrepeat(p)
char *p;
{
	register int count = 0;
	register char *scan;
	register char *opnd;

	scan = reginput;
	opnd = OPERAND(p);
	switch (OP(p)) {
	case ANY:
		count = strlen(scan);
		scan += count;
		break;
	case EXACTLY:
		while (*opnd == *scan) {
			count++;
			scan++;
		}
		break;
	case ANYOF:
		while (*scan != '\0' && strchr(opnd, *scan) != NULL) {
			count++;
			scan++;
		}
		break;
	case ANYBUT:
		while (*scan != '\0' && strchr(opnd, *scan) == NULL) {
			count++;
			scan++;
		}
		break;
	default:		/* Oh dear.  Called inappropriately. */
		regerror("internal foulup");
		count = 0;	/* Best compromise. */
		break;
	}
	reginput = scan;

	return(count);
}

/*
 - regnext - dig the "next" pointer out of a node
 */
static char *
regnext(p)
register char *p;
{
	register int offset;

	if (p == &regdummy)
		return(NULL);

	offset = NEXT(p);
	if (offset == 0)
		return(NULL);

	if (OP(p) == BACK)
		return(p-offset);
	else
		return(p+offset);
}

#ifdef DEBUG

STATIC char *regprop();

/*
 - regdump - dump a regexp onto stdout in vaguely comprehensible form
 */
void
regdump(r)
regexp *r;
{
	register char *s;
	register char op = EXACTLY;	/* Arbitrary non-END op. */
	register char *next;
	extern char *strchr();


	s = r->program + 1;
	while (op != END) {	/* While that wasn't END last time... */
		op = OP(s);
		printf("%2d%s", s-r->program, regprop(s));	/* Where, what. */
		next = regnext(s);
		if (next == NULL)		/* Next ptr. */
			printf("(0)");
		else 
			printf("(%d)", (s-r->program)+(next-s));
		s += 3;
		if (op == ANYOF || op == ANYBUT || op == EXACTLY) {
			/* Literal string, where present. */
			while (*s != '\0') {
				putchar(*s);
				s++;
			}
			s++;
		}
		putchar('\n');
	}

	/* Header fields of interest. */
	if (r->regstart != '\0')
		printf("start `%c' ", r->regstart);
	if (r->reganch)
		printf("anchored ");
	if (r->regmust != NULL)
		printf("must have \"%s\"", r->regmust);
	printf("\n");
}

/*
 - regprop - printable representation of opcode
 */
static char *
regprop(op)
char *op;
{
	register char *p;
	static char buf[50];

	(void) strcpy(buf, ":");

	switch (OP(op)) {
	case BOL:
		p = "BOL";
		break;
	case EOL:
		p = "EOL";
		break;
	case ANY:
		p = "ANY";
		break;
	case ANYOF:
		p = "ANYOF";
		break;
	case ANYBUT:
		p = "ANYBUT";
		break;
	case BRANCH:
		p = "BRANCH";
		break;
	case EXACTLY:
		p = "EXACTLY";
		break;
	case NOTHING:
		p = "NOTHING";
		break;
	case BACK:
		p = "BACK";
		break;
	case END:
		p = "END";
		break;
	case OPEN+1:
	case OPEN+2:
	case OPEN+3:
	case OPEN+4:
	case OPEN+5:
	case OPEN+6:
	case OPEN+7:
	case OPEN+8:
	case OPEN+9:
		sprintf(buf+strlen(buf), "OPEN%d", OP(op)-OPEN);
		p = NULL;
		break;
	case CLOSE+1:
	case CLOSE+2:
	case CLOSE+3:
	case CLOSE+4:
	case CLOSE+5:
	case CLOSE+6:
	case CLOSE+7:
	case CLOSE+8:
	case CLOSE+9:
		sprintf(buf+strlen(buf), "CLOSE%d", OP(op)-CLOSE);
		p = NULL;
		break;
	case STAR:
		p = "STAR";
		break;
	case PLUS:
		p = "PLUS";
		break;
	default:
		regerror("corrupted opcode");
		break;
	}
	if (p != NULL)
		(void) strcat(buf, p);
	return(buf);
}
#endif

/*
 * The following is provided for those people who do not have strcspn() in
 * their C libraries.  They should get off their butts and do something
 * about it; at least one public-domain implementation of those (highly
 * useful) string routines has been published on Usenet.
 */
#ifdef STRCSPN
/*
 * strcspn - find length of initial segment of s1 consisting entirely
 * of characters not from s2
 */

static int
strcspn(s1, s2)
char *s1;
char *s2;
{
	register char *scan1;
	register char *scan2;
	register int count;

	count = 0;
	for (scan1 = s1; *scan1 != '\0'; scan1++) {
		for (scan2 = s2; *scan2 != '\0';)	/* ++ moved down. */
			if (*scan1 == *scan2++)
				return(count);
		count++;
	}
	return(count);
}
#endif
hose (highly
 * useful) string routines has been published on Usenet.
 */
#ifdef STRCSPN
/*
 * strcspn - find length of initial segment of s1 consisting entirely
 * of characters not from s2
 */

static int
strcspn(s1, s2)
char *s1;
char *s2;
{
	register char *scan1;
	register char *scan2;
	register int count;

	count = 0;
	for (scan1 = s1; *scan1 != '\0'; scan1++) {
		foregexp.h                                                                                            000604  000000  000000  00000001076 04542747464 006250                                                                                                                                                                                                                                                                                                                                                                      /*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */
#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

extern regexp *regcomp();
extern int regexec();
extern void regsub();
extern void regerror();
this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */
#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

extern regexp *regcomp();
externregmagic.h                                                                                          000604  000000  000000  00000000231 04542747464 006524                                                                                                                                                                                                                                                                                                                                                                      /*
 * The first byte of the regexp internal "program" is actually this magic
 * number; the start node begins in the second byte.
 */
#define	MAGIC	0234
define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

extern regexp *regcomp();
externregsub.c                                                                                            000604  000000  000000  00000003541 04542747464 006237                                                                                                                                                                                                                                                                                                                                                                      /*
 * regsub
 *
 *	Copyright (c) 1986 by University of Toronto.
 *	Written by Henry Spencer.  Not derived from licensed software.
 *
 *	Permission is granted to anyone to use this software for any
 *	purpose on any computer system, and to redistribute it freely,
 *	subject to the following restrictions:
 *
 *	1. The author is not responsible for the consequences of use of
 *		this software, no matter how awful, even if they arise
 *		from defects in it.
 *
 *	2. The origin of this software must not be misrepresented, either
 *		by explicit claim or by omission.
 *
 *	3. Altered versions must be plainly marked as such, and must not
 *		be misrepresented as being the original software.
 */

#include <stdio.h>
#include "regexp.h"
#include "regmagic.h"

#ifndef CHARBITS
#define	UCHARAT(p)	((int)*(unsigned char *)(p))
#else
#define	UCHARAT(p)	((int)*(p)&CHARBITS)
#endif

/*
 - regsub - perform substitutions after a regexp match
 */
void
regsub(prog, source, dest)
regexp *prog;
char *source;
char *dest;
{
	register char *src;
	register char *dst;
	register char c;
	register int no;
	register int len;
	extern char *strncpy();

	if (prog == NULL || source == NULL || dest == NULL) {
		regerror("NULL parm to regsub");
		return;
	}
	if (UCHARAT(prog->program) != MAGIC) {
		regerror("damaged regexp fed to regsub");
		return;
	}

	src = source;
	dst = dest;
	while ((c = *src++) != '\0') {
		if (c == '&')
			no = 0;
		else if (c == '\\' && '0' <= *src && *src <= '9')
			no = *src++ - '0';
		else
			no = -1;

		if (no < 0)	/* Ordinary character. */
			*dst++ = c;
		else if (prog->startp[no] != NULL && prog->endp[no] != NULL) {
			len = prog->endp[no] - prog->startp[no];
			(void) strncpy(dst, prog->startp[no], len);
			dst += len;
			if (len != 0 && *(dst-1) == '\0') {		/* strncpy hit NUL. */
				regerror("damaged match string");
				return;
			}
		}
	}
	*dst++ = '\0';
}
 = *src++) != '\0') {
		if (c == '&')
			no = 0;
		else if (c == '\\' && '0' <= *src && *src <= '9')
			no = *src++ - '0';
		else
			no = -1;

		if (no < 0)	/*rename.c                                                                                            000604  000000  000000  00000003373 04542747464 006222                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  rename(), copy()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>

extern char *malloc();
extern int xshell();


/*
 * r e n a m e
 */
int rename(old, new)
  register char *old, *new;
{
  register char *tmp;
  register char *cp;
  register int  ret;

  if ((cp = rindex(new, '/')) != NULL)
    new = cp + 1;

  if ((tmp = malloc(strlen(old)+strlen(new)+10)) == NULL)
    return(-1);
  
  sprintf(tmp, "rename %s %s", old, new);

  ret = xshell(tmp);

  free(tmp);
  return(ret);
}

/*
 * c o p y
 */
int copy(src, dest, over)
  register char *src, *dest;
  register int  over;
{
  char          tmp[300];

  sprintf(tmp, "copy %s %s%s", src, dest, over ? " -r" : "");
  return(xshell(tmp));
}

;
{
  register char *tmp;
  register char *cp;
  register int  ret;

  if ((cp = rindex(new, '/')) != NULL)
    new = cp + 1;

  if ((tmp = malloc(strlen(old)+strlen(new)+10)) == NULL)
    return(-1);
  
  sprintf(tmp, "rename %s %s", old, new);

  ret = xshellrnd.c                                                                                               000604  000000  000000  00000027172 04542747464 005541                                                                                                                                                                                                                                                                                                                                                                      #ifndef lint
/*	static char sccsid[] = "@(#)random.c	4.2	(Berkeley)	83/01/02";	*/
#endif

#include	<stdio.h>

/*
 * random.c:
 * An improved random number generation package.  In addition to the standard
 * rand()/srand() like interface, this package also has a special state info
 * interface.  The initstate() routine is called with a seed, an array of
 * bytes, and a count of how many bytes are being passed in; this array is then
 * initialized to contain information for random number generation with that
 * much state information.  Good sizes for the amount of state information are
 * 32, 64, 128, and 256 bytes.  The state can be switched by calling the
 * setstate() routine with the same array as was initiallized with initstate().
 * By default, the package runs with 128 bytes of state information and
 * generates far better random numbers than a linear congruential generator.
 * If the amount of state information is less than 32 bytes, a simple linear
 * congruential R.N.G. is used.
 * Internally, the state information is treated as an array of longs; the
 * zeroeth element of the array is the type of R.N.G. being used (small
 * integer); the remainder of the array is the state information for the
 * R.N.G.  Thus, 32 bytes of state information will give 7 longs worth of
 * state information, which will allow a degree seven polynomial.  (Note: the 
 * zeroeth word of state information also has some other information stored
 * in it -- see setstate() for details).
 * The random number generation technique is a linear feedback shift register
 * approach, employing trinomials (since there are fewer terms to sum up that
 * way).  In this approach, the least significant bit of all the numbers in
 * the state table will act as a linear feedback shift register, and will have
 * period 2^deg - 1 (where deg is the degree of the polynomial being used,
 * assuming that the polynomial is irreducible and primitive).  The higher
 * order bits will have longer periods, since their values are also influenced
 * by pseudo-random carries out of the lower bits.  The total period of the
 * generator is approximately deg*(2**deg - 1); thus doubling the amount of
 * state information has a vast influence on the period of the generator.
 * Note: the deg*(2**deg - 1) is an approximation only good for large deg,
 * when the period of the shift register is the dominant factor.  With deg
 * equal to seven, the period is actually much longer than the 7*(2**7 - 1)
 * predicted by this formula.
 */



/*
 * For each of the currently supported random number generators, we have a
 * break value on the amount of state information (you need at least this
 * many bytes of state info to support this random number generator), a degree
 * for the polynomial (actually a trinomial) that the R.N.G. is based on, and
 * the separation between the two lower order coefficients of the trinomial.
 */

#define		TYPE_0		0		/* linear congruential */
#define		BREAK_0		8
#define		DEG_0		0
#define		SEP_0		0

#define		TYPE_1		1		/* x**7 + x**3 + 1 */
#define		BREAK_1		32
#define		DEG_1		7
#define		SEP_1		3

#define		TYPE_2		2		/* x**15 + x + 1 */
#define		BREAK_2		64
#define		DEG_2		15
#define		SEP_2		1

#define		TYPE_3		3		/* x**31 + x**3 + 1 */
#define		BREAK_3		128
#define		DEG_3		31
#define		SEP_3		3

#define		TYPE_4		4		/* x**63 + x + 1 */
#define		BREAK_4		256
#define		DEG_4		63
#define		SEP_4		1


/*
 * Array versions of the above information to make code run faster -- relies
 * on fact that TYPE_i == i.
 */

#define		MAX_TYPES	5		/* max number of types above */

static  int		degrees[ MAX_TYPES ]	= { DEG_0, DEG_1, DEG_2,
								DEG_3, DEG_4 };

static  int		seps[ MAX_TYPES ]	= { SEP_0, SEP_1, SEP_2,
								SEP_3, SEP_4 };



/*
 * Initially, everything is set up as if from :
 *		initstate( 1, &randtbl, 128 );
 * Note that this initialization takes advantage of the fact that srandom()
 * advances the front and rear pointers 10*rand_deg times, and hence the
 * rear pointer which starts at 0 will also end up at zero; thus the zeroeth
 * element of the state information, which contains info about the current
 * position of the rear pointer is just
 *	MAX_TYPES*(rptr - state) + TYPE_3 == TYPE_3.
 */

static  long		randtbl[ DEG_3 + 1 ]	= { TYPE_3,
			    0x9a319039, 0x32d9c024, 0x9b663182, 0x5da1f342, 
			    0xde3b81e0, 0xdf0a6fb5, 0xf103bc02, 0x48f340fb, 
			    0x7449e56b, 0xbeb1dbb0, 0xab5c5918, 0x946554fd, 
			    0x8c2e680f, 0xeb3d799f, 0xb11ee0b7, 0x2d436b86, 
			    0xda672e2a, 0x1588ca88, 0xe369735d, 0x904f35f7, 
			    0xd7158fd6, 0x6fa6f051, 0x616e6b96, 0xac94efdc, 
			    0x36413f93, 0xc622c298, 0xf5a42ab8, 0x8a88d77b, 
					0xf5ad9d0e, 0x8999220b, 0x27fb47b9 };

/*
 * fptr and rptr are two pointers into the state info, a front and a rear
 * pointer.  These two pointers are always rand_sep places aparts, as they cycle
 * cyclically through the state information.  (Yes, this does mean we could get
 * away with just one pointer, but the code for random() is more efficient this
 * way).  The pointers are left positioned as they would be from the call
 *			initstate( 1, randtbl, 128 )
 * (The position of the rear pointer, rptr, is really 0 (as explained above
 * in the initialization of randtbl) because the state table pointer is set
 * to point to randtbl[1] (as explained below).
 */

static  long		*fptr			= &randtbl[ SEP_3 + 1 ];
static  long		*rptr			= &randtbl[ 1 ];



/*
 * The following things are the pointer to the state information table,
 * the type of the current generator, the degree of the current polynomial
 * being used, and the separation between the two pointers.
 * Note that for efficiency of random(), we remember the first location of
 * the state information, not the zeroeth.  Hence it is valid to access
 * state[-1], which is used to store the type of the R.N.G.
 * Also, we remember the last location, since this is more efficient than
 * indexing every time to find the address of the last element to see if
 * the front and rear pointers have wrapped.
 */

static  long		*state			= &randtbl[ 1 ];

int			rand_type		= TYPE_3;
static  int		rand_deg		= DEG_3;
static  int		rand_sep		= SEP_3;

static  long		*end_ptr		= &randtbl[ DEG_3 + 1 ];



/*
 * srandom:
 * Initialize the random number generator based on the given seed.  If the
 * type is the trivial no-state-information type, just remember the seed.
 * Otherwise, initializes state[] based on the given "seed" via a linear
 * congruential generator.  Then, the pointers are set to known locations
 * that are exactly rand_sep places apart.  Lastly, it cycles the state
 * information a given number of times to get rid of any initial dependencies
 * introduced by the L.C.R.N.G.
 * Note that the initialization of randtbl[] for default usage relies on
 * values produced by this routine.
 */

srandom( x )

    unsigned		x;
{
    	register  int		i, j;

	if(  rand_type  ==  TYPE_0  )  {
	    state[ 0 ] = x;
	}
	else  {
	    j = 1;
	    state[ 0 ] = x;
	    for( i = 1; i < rand_deg; i++ )  {
		state[i] = 1103515245*state[i - 1] + 12345;
	    }
	    fptr = &state[ rand_sep ];
	    rptr = &state[ 0 ];
	    for( i = 0; i < 10*rand_deg; i++ )  random();
	}
}



/*
 * initstate:
 * Initialize the state information in the given array of n bytes for
 * future random number generation.  Based on the number of bytes we
 * are given, and the break values for the different R.N.G.'s, we choose
 * the best (largest) one we can and set things up for it.  srandom() is
 * then called to initialize the state information.
 * Note that on return from srandom(), we set state[-1] to be the type
 * multiplexed with the current value of the rear pointer; this is so
 * successive calls to initstate() won't lose this information and will
 * be able to restart with setstate().
 * Note: the first thing we do is save the current state, if any, just like
 * setstate() so that it doesn't matter when initstate is called.
 * Returns a pointer to the old state.
 */

char  *
initstate( seed, arg_state, n )

    unsigned		seed;			/* seed for R. N. G. */
    char		*arg_state;		/* pointer to state array */
    int			n;			/* # bytes of state info */
{
	register  char		*ostate		= (char *)( &state[ -1 ] );

	if(  rand_type  ==  TYPE_0  )  state[ -1 ] = rand_type;
	else  state[ -1 ] = MAX_TYPES*(rptr - state) + rand_type;
	if(  n  <  BREAK_1  )  {
	    if(  n  <  BREAK_0  )  {
		fprintf( stderr, "initstate: not enough state (%d bytes) with which to do jack; ignored.\n" );
		return;
	    }
	    rand_type = TYPE_0;
	    rand_deg = DEG_0;
	    rand_sep = SEP_0;
	}
	else  {
	    if(  n  <  BREAK_2  )  {
		rand_type = TYPE_1;
		rand_deg = DEG_1;
		rand_sep = SEP_1;
	    }
	    else  {
		if(  n  <  BREAK_3  )  {
		    rand_type = TYPE_2;
		    rand_deg = DEG_2;
		    rand_sep = SEP_2;
		}
		else  {
		    if(  n  <  BREAK_4  )  {
			rand_type = TYPE_3;
			rand_deg = DEG_3;
			rand_sep = SEP_3;
		    }
		    else  {
			rand_type = TYPE_4;
			rand_deg = DEG_4;
			rand_sep = SEP_4;
		    }
		}
	    }
	}
	state = &(  ( (long *)arg_state )[1]  );	/* first location */
	end_ptr = &state[ rand_deg ];	/* must set end_ptr before srandom */
	srandom( seed );
	if(  rand_type  ==  TYPE_0  )  state[ -1 ] = rand_type;
	else  state[ -1 ] = MAX_TYPES*(rptr - state) + rand_type;
	return( ostate );
}



/*
 * setstate:
 * Restore the state from the given state array.
 * Note: it is important that we also remember the locations of the pointers
 * in the current state information, and restore the locations of the pointers
 * from the old state information.  This is done by multiplexing the pointer
 * location into the zeroeth word of the state information.
 * Note that due to the order in which things are done, it is OK to call
 * setstate() with the same state as the current state.
 * Returns a pointer to the old state information.
 */

char  *
setstate( arg_state )

    char		*arg_state;
{
	register  long		*new_state	= (long *)arg_state;
	register  int		type		= new_state[0]%MAX_TYPES;
	register  int		rear		= new_state[0]/MAX_TYPES;
	char			*ostate		= (char *)( &state[ -1 ] );

	if(  rand_type  ==  TYPE_0  )  state[ -1 ] = rand_type;
	else  state[ -1 ] = MAX_TYPES*(rptr - state) + rand_type;
	switch(  type  )  {
	    case  TYPE_0:
	    case  TYPE_1:
	    case  TYPE_2:
	    case  TYPE_3:
	    case  TYPE_4:
		rand_type = type;
		rand_deg = degrees[ type ];
		rand_sep = seps[ type ];
		break;

	    default:
		fprintf( stderr, "setstate: state info has been munged; not changed.\n" );
	}
	state = &new_state[ 1 ];
	if(  rand_type  !=  TYPE_0  )  {
	    rptr = &state[ rear ];
	    fptr = &state[ (rear + rand_sep)%rand_deg ];
	}
	end_ptr = &state[ rand_deg ];		/* set end_ptr too */
	return( ostate );
}



/*
 * random:
 * If we are using the trivial TYPE_0 R.N.G., just do the old linear
 * congruential bit.  Otherwise, we do our fancy trinomial stuff, which is the
 * same in all ther other cases due to all the global variables that have been
 * set up.  The basic operation is to add the number at the rear pointer into
 * the one at the front pointer.  Then both pointers are advanced to the next
 * location cyclically in the table.  The value returned is the sum generated,
 * reduced to 31 bits by throwing away the "least random" low bit.
 * Note: the code takes advantage of the fact that both the front and
 * rear pointers can't wrap on the same call by not testing the rear
 * pointer if the front one has wrapped.
 * Returns a 31-bit random number.
 */

long
random()
{
	long		i;
	
	if(  rand_type  ==  TYPE_0  )  {
	    i = state[0] = ( state[0]*1103515245 + 12345 )&0x7fffffff;
	}
	else  {
	    *fptr += *rptr;
	    i = (*fptr >> 1)&0x7fffffff;	/* chucking least random bit */
	    if(  ++fptr  >=  end_ptr  )  {
		fptr = state;
		++rptr;
	    }
	    else  {
		if(  ++rptr  >=  end_ptr  )  rptr = state;
	    }
	}
	return( i );
}



n't wrap on the same call by not testing the rear
 * pointer if the front one has wrapped.
 * Returns a 31-bit random number.
 */

long
random()
{
	long		i;
	
	if(  rand_type  ==  TYPE_0  )  {
	    i = state[0] = ( state[0]*1103515245 + 12345 )&0x7fffffff;
	}
	else  {
	    *fptr += *rptr;
	    i = (*fptr >> 1)&0x7fffffff;	/* chucking least random bit */
	    if(  ++fptr  >=  end_ptr  )  rndsalt.c                                                                                           000604  000000  000000  00000001076 04542747464 006420                                                                                                                                                                                                                                                                                                                                                                      # include <time.h>

static char salt[3];

rnd(num)
{
  return(random() % num);
}

srnd(num)
{
  srandom(num);
}



static char make_char(r)
  int r;
{
  if (r == 0)
    return ('.');
  else
    if (r == 1)
      return ('/');
    else
      if (r < 12)
        return(r - 2 + '0');
      else
        if (r < 38)
          return(r - 12 + 'A');
        else
          return(r - 38 + 'a');
}

char *_rnd_salt()
{
  int t;
  int r;
	
  time(&t);
  srnd(t);
  r = rnd(63);
  salt[0] = make_char(r);
  r = rnd(63);
  salt[1] = make_char(r);
  salt[2] = '\0';
  return(salt);
}
random() % num);
}

srnd(num)
{
  srandom(num);
}



static char make_char(r)
  int r;
{
  if (r == 0)
    return ('.');
  else
    if (r == 1)
      return ('/');
    else
      if (r < 12)
        return(r - 2 + '0');
      else
        if (r < 38)
          return(r - 12 + 'A');
        else
          return(r - 38 + 'a');
}

char *_rnd_salt()
{
  int t;
  int r;
	
  time(&t);
  srnd(t);
  r = rnd(63);
  salt[0] = make_char(r);
  r = rnd(63);
scandir.c                                                                                           000600  000000  000000  00000004006 04542747464 006364                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  scandir()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#include <stdio.h>
#include <dir.h>
#include <direct.h>

/*
 * s c a n d i r
 */
int scandir(path, entries, select, dir_sort)
  char          *path;
  struct direct ***entries;
  int           (*select)();
  int           (*dir_sort)();
{
  DIR           *dirp;
  int           size, cnt;
  struct direct *direntry;

  if ((dirp = opendir(path)) == NULL)
    return(-1);
  
  if ((size = _gs_size(dirp->dd_fd)) < 0)
    return(-1);
  
  if ((*entries = (struct direct **) malloc(size/sizeof(struct dirent) *
                                            sizeof(struct direct *))) == NULL)
    return(-1);
  
  
  for (cnt = 0; (direntry = readdir(dirp)) != NULL; ) {
    if ((*select)(direntry)) {
      if (((*entries)[cnt] =
           (struct direct *) malloc(sizeof(struct direct))) == NULL)
        return(-1);
      
      *((*entries)[cnt]) = *direntry;
      cnt++;
    }
  }
  
  qsort(*entries, cnt, sizeof(struct direct *), dir_sort);
  
  return(cnt);
}
 (struct direct **) malloc(size/sizeof(struct dirent) *
                                            sizeof(struct direct *))) == NULL)
    return(-1);
  
  
  for (cnt = 0; (direntry = readdir(dirp)) != NULL; ) {
    if ((*select)(direntry)) {
      if (((*entries)[cnt] =
           (struct direct *) malloc(sizeof(struct direct))) == NULL)
        return(-1);
      
      *((*entries)[cnt]) = *direntry;
      cnt++;
    }
  }
  
  qsort(*entries, cnt, sizeof(struct direct *), dir_sort);
  
  return(cnsetup.c                                                                                             000600  000000  000000  00000017546 04542747464 006116                                                                                                                                                                                                                                                                                                                                                                      /*
 *                          SETUP for SYSINFO
 *
 *  Copyrights (c) 1988 by reccoware systems, Wolfgang Ocker, Puchheim
 *
 *
 *
 *                           IMPORTANT NOTICE
 * =====================================================================
 *
 * I  would  like to  establish the SYSINFO  concept as a  STANDARD  for
 * OS-9/68000.  So  please  DON'T CHANGE  ANYTHING.  Please send any bug
 * reports or suggestions to
 *
 *
 *            Wolfgang Ocker
 *            Lochhauserstrasse 35a
 *            D-8039 Puchheim
 *            Tel. +49 89 / 80 77 02
 *
 *            e-mail: weo@recco    (...!pyramid!tmpmbx!recco!weo)
 *                    weo@altger   (...!altnet!altger!weo)
 *                    ocker@lan.informatik.tu-muenchen.dbp.de
 *
 *
 * I will maintain the  SYSINFO package and keep it (upward) compatible!
 * You may not distribute any modified  versions, or programs which rely 
 * on a modified version.
 *
 *              If you don't like SYSINFO, don't use it!
 */

/*
 * Revision history
 *
 *  #    Date     Comments                                              By
 * -------------------------------------------------------------------- ---
 * 00  09/16/88   Prepared for net release                              weo
 * 01  10/07/88   After "linting" corrected some errors ...             weo
 *
 */

#define PATCHLEVEL 1

#include <stdio.h>
#include <strings.h>
#include <module.h>
#include <ctype.h>

#include "infomod.h"

extern int errno;

int debug;

#define DEBUG(l,s,v) if (debug>=l) (void) fprintf(stderr, s, v);

static char *Copyright = "Copyrights (c) 1988 by reccoware systems puchheim";

void usage();

/*
 * g e t _ l i n e
 *
 * "Parse" a line of the SYSINFO file
 */
static int
get_line(buf, name, type, len, data)
  register char *buf;     /* Zeile */
  char          *name;    /* Name, der gefunden wurde */
  char          *type;    /* Type (s/d/l) */
  int           *len;     /* Laenge */
  char          *data;    /* Daten */
{
  register char *cp;

  /*
   * A line of the SYSINFO file looks like
   * <name>,<type>[=[<data>|<length>]
   *
   * <data> is ignored on lock entries and should be omitted
   */
  if ((cp = index(buf, ',')) == NULL)
    return(FAILED);
  
  *cp++ = '\0';
  (void) strcpy(name, buf);  /* Name of the entry */

  /*
   * Need a '=' if not a lock entry
   */
  if (*cp != 'l' && *(cp+1) != '=')
    return(FAILED);

  *type = *cp;
  buf   = cp+2;

  switch (*type) {
    case 's':       /* String */
      (void) strcpy(data, buf);
      *len = strlen(data) + 1;
      break;

    case 'l':       /* Lock */
      *len = sizeof(LOCK);
      break;

    case 'd':       /* Data */
      *len = atoi(buf);
      break;

    case 'n':           /* Number, not supported */
      return(FAILED);

    default:
      return(FAILED);
  }

  *len = ((*len + 1) >> 1) << 1;    /* Word alignment */

  return(OK);
}

/*
 * i n f o _ s e t u p
 * 
 * Read SYSINFO file and setup SYSINFO data module
 */
int 
info_setup(info_fp)
  FILE *info_fp;
{
  char     buf[200];
  char     name[200], data[200];
  char     type;
  int      len;
  char     *data_ptr;
  char     *cp;
  mod_exec *info_module;
  int      info_event;
  int      info_size, info_num;
  INFO     *info;
  int      i, j;

  info_size = info_num  = 0;

  /*
   * 1st pass: determine required size of data module
   */
  while (fgets(buf, sizeof(buf), info_fp)) {
    /*
     * Ignore comments
     */
    if (buf[0] == '*' || buf[0] == '#')
      continue;
    if (cp = index(buf, '\n'))
      *cp = '\0';
    
    DEBUG(2, "Line = '%s'\n", buf);

    if (get_line(buf, name, &type, &len, data) == FAILED)
      continue;     /* Ignore incorrect lines */

    DEBUG(2, "name = '%s', ", name);
    DEBUG(2, "type = '%c', ", type);
    DEBUG(2, "len  = %d", len);
    if (type == 's') {
      DEBUG(2, ", data = '%s'\n", data);
    }
    else {
      DEBUG(2, "\n", 0);
    }

    info_size += (((strlen(name)+2)>>1)<<1) + len;    /* Alignment */
    info_num++;
  }

  info_size += sizeof(INFO) + (info_num-1)*sizeof(ENTRY);

  /*
   * Create the data module
   */
  if ((info_module = (mod_exec *) _mkdata_module(INFO_MODULE_NAME,
                     info_size, 0x8001, 0x0333)) == (mod_exec *) -1)
    return(FAILED);

  info = (INFO *) (((char *) info_module) + info_module->_mexec);
  info->num = info_num;
  info->rev = REVISION;   /* Revision number */

  data_ptr = ((char *) info) + (info_num-1) * sizeof(ENTRY) + sizeof(INFO);

  DEBUG(1, "info_num  = %d\n", info_num);
  DEBUG(1, "info_size = %d\n", info_size);
  DEBUG(1, "info      = %x\n", info);
  DEBUG(1, "data_ptr  = %x\n", data_ptr);

  /*
   * 2nd pass: fill the data module
   */
  (void) fseek(info_fp, 0, 0);     /* Rewind */

  i = 0;

  while (fgets(buf, sizeof(buf), info_fp)) {
    /*
     * Ignore comments
     */
    if (buf[0] == '*' || buf[0] == '#')
      continue;
    if (cp = index(buf, '\n'))
      *cp = '\0';

    DEBUG(1, "Line = '%s'\n", buf);

    if (get_line(buf, name, &type, &len, data) == FAILED)
      continue;

    DEBUG(1, "name = '%s', ", name);
    DEBUG(1, "type = '%c', ", type);
    DEBUG(1, "len  = %d", len);
    if (type == 's') {
      DEBUG(1, ", data = '%s'\n", data);
    }
    else {
      DEBUG(1, "\n", 0);
    }
  
    info->entry[i].type = type == 's' ? T_STRING : 
                          type == 'n' ? T_NUM :
                          type == 'd' ? T_DATA :
                          type == 'l' ? T_LOCK : T_UNKNOWN;

    info->entry[i].name  = data_ptr;

    /*
     * Remove leading slash of lock entry names
     */
    if (type == 'l' && name[0] == '/')
      (void) strcpy(name, name+1);

    (void) strcpy(data_ptr, name);
    data_ptr            += ((strlen(name) + 2) >> 1) << 1;
    info->entry[i].data  = data_ptr;

    switch (type) {
      case 's':
        (void) strcpy(data_ptr, data);
        break;

      case 'l':
        for (j = 0; j < sizeof(LOCK); j++)    /* Clear lock entry */
          data_ptr[j] = '\0';
        break;

      case 'd':
        for (j = 0; j < len; j++)             /* Clear data entry */
          data_ptr[j] = '\0';
        break;
    }

    data_ptr = data_ptr + len;
    i++;
  }
  
  (void) fclose(info_fp);

  /*
   * Create the event for SYSINFO
   */
  if ((info_event = _ev_creat(0, 1, -1, INFO_EVENT_NAME)) == -1) {
    (void) munload(INFO_MODULE_NAME, 0x0400);
    return(FAILED);
  }
}

/*
 * m a i n
 */
main(argc, argv)
  int  argc;
  char *argv[];
{
  int  i, j;
  FILE *info_fp;
  char *filename;
  
  filename = NULL;
  
  debug = 0;
  
  /*
   * Parse command line arguments
   */
  for (i = 1 ; i < argc; i++)
    if (argv[i][0] == '-')
      for (j = 1; j < strlen(argv[i]); j++)
        switch (tolower(argv[i][j])) {
          case '?':     /* Usage */
            usage();
            exit(1);

          case 'd':     /* Debug */
            debug = 1;
            if (argv[i][j+1] == '=')
              j += 2;
            else
              j += 1;
   
            if (isdigit(argv[i][j])) {
              debug = atoi(argv[i] + j);
              while (isdigit(argv[i][j+1]))
                j++;
            }
            break;

          default:
            usage();
            exit(_errmsg(1, "unknown option '%c'\n", argv[i][j]));
        }
    else 
      if (filename != NULL) {
        usage();
        exit(_errmsg(1, "only one path allowed\n"));
      }
      else
        filename = argv[i];

  if (filename == NULL)
    filename = INFO_FILE_NAME;

  if ((info_fp = fopen(filename, "r")) == NULL)
    exit(_errmsg(errno, "can't open sysinfo file '%s'\n", filename));
  
  if (info_setup(info_fp) == -1)
    exit(_errmsg(errno, "can't create sysinfo\n"));
}

/*
 * u s a g e
 */
void
usage()
{
  (void) fputs("Syntax: setup {<opts>} [<path>] {<opts>}\n", stderr);
  (void) fputs("Function: setup sysinfo module with data from <path>\n", stderr);
  (void) fputs("Options:\n", stderr);
  (void) fputs("     -d[=][<num>]        debug mode (<num> is debug level)\n",
               stderr);
}

ame, "r")) == NULL)
    exit(_errmsg(errno, "can't open sysinfo file '%s'\n", filename));
  
  if (info_setup(info_fp) == -1)
    exit(_errmsg(errno, "canshell.c                                                                                             000604  000000  000000  00000006321 04542747464 006056                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  shell(), xshell()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <modes.h>
#include <strings.h>
#include <errno.h>


extern char **environ;
extern int  os9forkc();

extern char *findmod(), *getenv(), *info_str();

static char cmd_name[600];

int _shell_secure = 0;

static int check_shell()
{
  char *shell, *cp, *cp2, *cp3, val_shell[200];
  
  errno = E_FNA;

  if ((shell = getenv("SHELL")) == NULL)
    return(0);
  
  if (info_str("valid.shells", val_shell, sizeof(val_shell)) == NULL)
    strcpy(val_shell, "shell,sh,csh");
  
  for (cp = val_shell; cp != NULL && *cp != '\0'; ) {
    cp2 = cp;
    if ((cp = index(cp, ',')) != NULL)
      *cp++ = '\0';

    while (*cp2 == ' ')
      cp2++;
    if ((cp3 = index(cp2, ' ')) != NULL)
      *cp3 = '\0';

    if (!strcmp(shell, cp2))
      return(1);
  }
  
  return(0);
}

/*
 * s h e l l 
 */
int shell(name)
  char *name;
{
  static char   *argv[] = {NULL, NULL, NULL };
  static char   cmd[300], cmd_path[100];
  register char *cp;
  int           pid, status;

  if (_shell_secure)
    if (!check_shell())
      return(-1);

  cp = name;
  while (*cp == ' ')
    cp++;

  strcpy(cmd_path, cp);

  if (cp = index(cmd_path, ' '))
    *cp++ = '\0';

  strcpy(cmd, "ex ");
  strcat(cmd, findmod(cmd_path, cmd_path));
  if (cp) {
    strcat(cmd, " ");
    strcat(cmd, name+(cp-cmd_path));
  }

  argv[1] = cmd;

  argv[0] = findmod("shell", "SYSTEM.SHELL");
  if ((pid = os9exec(os9forkc, argv[0], argv, environ, 0, 0, 3)) == -1)
    return(-1);


  while (wait(&status) != pid) ;
  
  if (status &= 0x0ffff) {
    errno = status;
    return(-1);
  }
  else
    return(0);
}

/*
 * x s h e l l
 */
int xshell(name)
  register char *name;
{
  register int pid;
  int          status;
  char         **argv;

  if (_shell_secure)
    if (!check_shell())
      return(-1);

  strcpy(cmd_name, name);
  if (getargs(cmd_name, &argv) == -1)
    return(-1);

  if ((pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 
                     0, 0, 3)) == -1) {
    free(argv);
    return(-1);
  }

  free(argv);

  while (wait(&status) != pid) ;

  if (status &= 0x0ffff) {
    errno = status;
    return(-1);
  }
  else
    return(0);
}

name;
{
  register int pid;
  int          status;
  char         **argv;

  if (_shell_secure)
    if (!check_shell())
      return(-1);

  strcpy(cmd_name, name);
  if (getargs(cmd_name, &argv) == -1)
    return(-1);

  if ((pid = os9exec(os9forkc, findmod(argv[0], argv[0]), argv, environ, 
         signal.a                                                                                            000600  000000  000000  00000014126 04542747464 006220                                                                                                                                                                                                                                                                                                                                                                      * Author:     Reimer Mellin
* Date:       01/18/89
* Version:    1.4
*
*
* Revisions:
* 1.2   _sigini -> _siginit() (weo)
* 1.3   _siginit() called by signal(), if not installed yet
* 1.4   space for 32 signals. signal(0,func) now simulates an 
*       intercept(). func() will be called if the signal-handler 
*       recognizes an unknown signal (number not found in the 
*       table (i.e. SIG_DFL state for the signal).
* 1.5   fixed corrupt _icptexep(). always restore regs from (a5)
*
*
* Description:
* The following functions are provided :
*
* - _siginit()
*
* to initialize (no more required since 1.3 (weo))
*
*
* - int (signal(signum, sig_handler)) ()
*     int signum;
*     int (sig_handler()) ();
*
* as the signal() function of UNIX (tm) (intercept() still possible
* with signal(0,func)) !!
*
*
* - _icptexep(excp_handler)
*     (void) excp_handler();
*
* to install the exeception handler function excp_handler() for certain
* traps (see at the end of this source ..).
*
* excp_handler() should be defined like this:
*
* #include <machine/reg.h>
* (void) excp_handler(excp_num, reg_frame)
*   int          exep_num;
*   REGISTERS    *reg_frame;
*
*
* Exception Vector address definitions
 org 0
T_ColdSP: do.l 1 (0) reset initial SSP
T_ColdPC: do.l 1 (1) reset initial PC
T_BusErr: do.l 1 (2) bus error
T_AddErr: do.l 1 (3) address error
T_IllIns: do.l 1 (4) illegal instruction
T_ZerDiv: do.l 1 (5) zero divide
T_CHK: do.l 1 (6) CHK instruction
T_TRAPV: do.l 1 (7) TRAPV instruction
T_Priv: do.l 1 (8) privelage violation
T_Trace: do.l 1 (9) trace
T_1010: do.l 1 (10) line 1010 emulator
T_1111: do.l 1 (11) line 1111 emulator
 do.l 3 (12-14) reserved
T_UnIRQ: do.l 1 (15) unitialized interrupt vector
 do.l 8 (16-23) reserved
T_SpurIO: do.l 1 (24) spurious interrupt
T_AutIRQ: do.l 7 (25-31) level 1-7 interrupt autovectors
T_TRAP: do.l 16 (32-47) TRAP instruction vectors
T_FPUnordC: do.l 1 (48) FPCP bra or set on unordered condition
T_FPInxact: do.l 1 (49) FPCP inexact result
T_FPDivZer: do.l 1 (50) FPCP divide by zero
T_FPUndrFl: do.l 1 (51) FPCP underflow
T_FPOprErr: do.l 1 (52) FPCP operand error
T_FPOverFl: do.l 1 (53) FPCP overflow
T_FPNotNum: do.l 1 (54) FPCP signaling not a number
 do.l 9 (55-63) reserved
T_VctIRQ: do.l 192 vectored interrupt vectors
T_End: equ .

 psect signals_a,0,0,0,0,0

SIG_NUM equ 32

 vsect
_siglist ds.w (SIG_NUM*3)+1
_exerout ds.l 1
_defaddr dc.l 0 ; muss mit signal(0,newaddr) gesetzt werden.
_isinit dc.b 0
 ends

_siginit:
 tst.b _isinit(a6)
 bne.s _siginit99

 movem.l d0/d1/a0,-(a7)

 lea _siglist(a6),a0 ; Adresse der Signal-Tabelle
 moveq #1,d0 ; Merker fuer ungenutzt
 moveq #SIG_NUM-1,d1 ; Anzahl der Signale

sig01
 move.w d0,(a0)+ ; markieren als unbenutzt
 clr.l (a0)+ ; Adresse der Routine auf Null
 dbra d1,sig01

 clr.w (a0) ; Ende der Tabelle
 lea _sighand(pc),a0 ; die Intercept-Routine ...
 OS9 F$Icpt ; installieren

 st _isinit(a6) ; jetzt initialisiert

 movem.l (a7)+,d0/d1/a0

_siginit99
 rts

signal:
 movem.l a0-a1/d2-d3,-(a7) ; Register retten

 tst.b _isinit(a6) ; initialisiert?
 bne.s sig02 ; ja!
 bsr.s _siginit

sig02
 move.w d0,d3 ; kopiere Signal
 andi.l #$fffe,d3 ; maskiere Bit 1-15
 beq.s sig051 ; signal(0,addr) setzt _defaddr auf addr

 moveq.l #1,d3 ; Default-Aktion ist 1
 bsr.s _siglook ; Signal-Nummer in Tabelle suchen
 tst.l d2 ; Tabelle voll?
 beq.s sig05 ; ja!

 tst.l d1 ; Default Aktion verlangt?
 beq.s sig03 ; ja, der Eintrag kann geloescht werden

sig04
 move.w d0,(a0)+ ; Signal-Nummer
 move.l (a0),d3 ; vorherige Adresse
 move.l d1,(a0)+ ; neue Adresse des Handlers

sig05
 move.l d3,d0 ; Return-Wert ist die alte Adresse
 movem.l (a7)+,a0-a1/d2-d3 ; Register restaurieren
 rts

sig051
 move.l _defaddr(a6),d3 ; alten wert zurueckgeben
 move.l d1,_defaddr(a6) ; setze neue addresse
 bra.s sig05

sig03
 move.l 2(a0),d3 ; alte Adresse
 movea.l a0,a1
 addq.l #6,a1

sig06
 move.w #1,(a0) ; altes Signal loeschen
 move.l #0,2(a0) ; auch alte Adresse loeschen
 tst.w (a1) ; am Ende der Tabelle?
 beq.s sig05 ; ja!

 move.w (a1)+,(a0)+ ; Signal-Nummer eintragen
 move.l (a1)+,(a0)+ ; dazugehoerige Handler-Adresse
 bra.s sig06

_siglook
 lea _siglist(a6),a0 ; Signal-Tabelle

sig07
 move.w (a0),d2 Signal-Nummer
 cmp.w d0,d2 ; die gesuchte?
 beq.s sig08 ; ja!

 cmpi.w #1,d2 ; freier Eintrag?
 beq.s sig08 ; ja!

 tst.w d2 ; Tabellenende?
 beq.s sig08 ; ja!

 addq.l #6,a0 ; naechster Eintrag
 bra.s sig07

sig08
 ext.l d2
 rts

_sighand
 movem.l a0-a1/d2,-(a7) ; Register retten
 move.l d1,d0 ; Signalnummer ist in d1
 bsr.s _siglook ; Eintrag vorhanden?
 subq.l #1,d2
 ble.s sig09 ; keinen Eintrag gefunden --> default action

 addq.l #2,a0 ; Adresse der Adresse

 cmpi.l #1,(a0) ; Signal ignorieren?
 beq.s sig10 ; ja!

 movea (a0),a0 ; zu dieser Adresse springen

sig101
 jsr (a0)

sig10
 movem.l (a7)+,a0-a1/d2 Register restaurieren
 OS9 F$RTE ; Ende der Intercept-Routine

sig09
 tst.l _defaddr(a6) ; wollen wir intercept() simulieren ?
 beq.s sig091 ; nein --> STIRB Fremder :-)
 move.l _defaddr(a6),a0
 bra.s sig101 ;ok dann fuehre default action aus ...

sig091
 move.l d0,d1 ; Signal-Nummer fuer exit
 OS9 F$Exit

_exetab
 dc.w T_BusErr,_exehand-*-4 ; Tabelle fuer Exceptions
 dc.w T_AddErr,_exehand-*-4
 dc.w T_IllIns,_exehand-*-4
 dc.w T_ZerDiv,_exehand-*-4
 dc.w T_CHK,_exehand-*-4
 dc.w T_TRAPV,_exehand-*-4
 dc.w T_Priv,_exehand-*-4
 dc.w T_1010,_exehand-*-4
 dc.w T_1111,_exehand-*-4
 dc.w -1

_icptexep:
 move.l d0,_exerout(a6) ; Adresse der Routine
 lea _exetab(pc),a1 ; Trap-Tabelle
 movea.l #0,a0 ; a0 = 0 fuer Default-Stack
 OS9 F$STrap ; Trap installieren
 rts

_exehand
 move.w d7,d0
 ext.l d0
 move.l a5,d1 ; Registerframe
 movea _exerout(a6),a0 ; Handler-Routine
 jsr (a0) ; aufrufen
 movem.l (a5)+,d0-d7/a0-a4	; es muessen IMMER die regs wiederher
* move.l (a5)+,d0		; gestellt werden (ueber A5) und dann
* move.l (a5)+,d1		; auf PC gesprungen werden !!!!!
* move.l (a5)+,d2
* move.l (a5)+,d3
* move.l (a5)+,d4
* move.l (a5)+,d5
* move.l (a5)+,d6
* move.l (a5)+,d7
* move.l (a5)+,a0
* move.l (a5)+,a1
* move.l (a5)+,a2
* move.l (a5)+,a3
* move.l (a5)+,a4
 move.l 8(a5),a7
 move.l 14(a5),-(sp)	; PC
 move.w 12(a5),-(sp)	; CC
 move.l (a5),a5
 rtr			; hole cc und pc incl. ruecksprung
 ends
 end
n
 movem.l (a5)+,d0-d7/a0-a4	; es muessen IMMER die regs wiederher
* move.l (a5)+,d0		; gestellt werden (ueber A5) und dann
* move.l (a5)+,d1		; auf PC gesprungen werden !!!!!
* move.l (a5)+,d2
* move.l (a5)+,d3
* move.l (a5)+,d4
* move.l (a5)+,d5
* move.l (a5)+,d6
* move.l (a5)+,d7
* move.l (a5)+,a0
* move.l (a5)+,a1
* move.l (a5)+,a2
* move.l (a5)+,a3
* move.l (a5)+,a4
 move.l 8(a5),a7
 move.l 14(a5),-(sp)	; PC
 move.w 1stat.c                                                                                              000604  000000  000000  00000005155 04542747464 005726                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  stat(), fstat()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <direct.h>
#include <stat.h>
#include <modes.h>
#include <sgstat.h>

/*
 * f s t a t
 */
int fstat(fd, buff)
  int         fd;
  struct stat *buff;
{
  struct fildes ftmp;
  struct tm     ttmp;
  struct _sgr   fopt;

  if (_gs_gfd(fd, &ftmp, sizeof(struct fildes)) < 0)
    return(-1);

  if (_gs_opt(fd, &fopt) < 0)
    return(-1);

  ttmp.tm_year  = (int) ftmp.fd_date[0];
  ttmp.tm_mon   = (int) ftmp.fd_date[1] - 1;
  ttmp.tm_mday  = (int) ftmp.fd_date[2];	
  ttmp.tm_hour  = (int) ftmp.fd_date[3];
  ttmp.tm_min   = (int) ftmp.fd_date[4];
  ttmp.tm_sec   = 0;
  ttmp.tm_isdst = -1;

  buff->st_atime = buff->st_mtime = mktime(&ttmp);

  ttmp.tm_year  = (int) ftmp.fd_dcr[0];
  ttmp.tm_mon   = (int) ftmp.fd_dcr[1] - 1;
  ttmp.tm_mday  = (int) ftmp.fd_dcr[2];	
  ttmp.tm_hour  = ttmp.tm_min = ttmp.tm_sec = 0;
  ttmp.tm_isdst = -1;
  
  buff->st_ctime = mktime(&ttmp);

  memcpy(&(buff->st_size), ftmp.fd_fsize, sizeof(long));  /* misalignment! */
  buff->st_uid   = ftmp.fd_own[1];
  buff->st_gid   = ftmp.fd_own[0];
  buff->st_mode  = ftmp.fd_att;
  buff->st_nlink = ftmp.fd_link;

  buff->st_ino   = fopt._sgr_fdpsn;
  buff->st_dev   = fopt._sgr_dvt;

  return(0);
}

/*
 * s t a t
 */	
int stat(filename, buff)
  char        *filename;
  struct stat *buff;
{
  register int i, ret;

  if ((i = open(filename, 0)) < 0)
    if ((i = open(filename, S_IFDIR)) < 0)
      return(-1);

  ret = fstat(i, buff);
  close(i);

  return(ret);
}

/*
 * g e t d t a b l e s i z e
 */
int getdtablesize()
{
  return(_NFILE);
}


fd_own[0];
  buff->st_mode  = ftmp.fd_att;
  buff->st_nlink = ftmp.fd_link;

  buff->st_ino   = fopt._sgr_fdpsn;
  buff->st_dev   = fopt._sgr_dvt;

  return(0);
}

/*
 * s t a t
 */	
int stat(filename, buff)
  char        *filename;
  struct stat *buff;
{
  register int i, ret;

  if ((i = open(filename, 0)) < 0)
    if ((i = open(filename, S_IFDIR)) < 0)
      return(-1);

  ret = fstat(i, buff);
  strings.c                                                                                           000604  000000  000000  00000010422 04542747464 006435                                                                                                                                                                                                                                                                                                                                                                      #include <stdio.h>
#include <strings.h>

/*  strcspn(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  This function determines the length of a span from the
 *  beginning of <string> which contains none of the
 *  characters specified in <char_set>. The length of the
 *  span is returned.
 */


int strcspn(string, char_set)
  char *string;
  char *char_set;
{
  register char *str;
  register char *chr;

  if (string == NULL)
    return(0);

  if (char_set == NULL)
    return(strlen(string));

  for (str = string; *str != '\0'; ++str)
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*str == *chr)
        return(str - string);

  return(str - string);
}



/*  strpbrk(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  Strpbrk(3) scans <string> for the first occurrence of a
 *  character from the string <char_set>. If a character from
 *  the <char_set> was found then a pointer to it within
 *  <string> is returned, otherwise NULL is returned.
 */

char *strpbrk(string, char_set)
  char *string;
  char *char_set;
{
  register char  c;
  register char *p;

  if (string == NULL || char_set == NULL)
    return(NULL);

  while ((c = *string++) != '\0')
    for (p = char_set; *p != '\0'; ++p)
      if (c == *p)
        return(string - 1);

  return(NULL);
}



/*  strspn(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  This function determines the length of a span from the
 *  beginning of <string> which contains only characters
 *  specified in <char_set>. The length of the span is
 *  returned.
 */

int strspn(string, char_set)
  char *string;
  char *char_set;
{
  register char *str;
  register char *chr;

  if (string == NULL || char_set == NULL)
    return(0);

  for (str = string; *str != '\0'; ++str) {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*str == *chr)
        break;

    if (*chr == '\0')
      return(str - string);
  }

  return(str - string);
}


/*  strstr(3)
 *
 *  Author: Terrence W. Holm          July 1988
 *
 *
 *  Finds the first occurrence of a substring, pointed to by
 *  <substr>, within a string pointed to by <string>.
 *  If the substring is found then a pointer to it within
 *  <string> is returned, otherwise NULL is returned.
 */


char *strstr(string, substr)
  char *string;
  char *substr;
{
  register char head_string;
  register char head_substr;

  if (string == NULL || substr == NULL)
    return(NULL);

  head_substr = *substr++;

  while ((head_string = *string++) != '\0')
    if (head_string == head_substr) {
      register char *tail_string = string;
      register char *tail_substr = substr;

      do {
        if (*tail_substr == '\0')
          return(string - 1);
      } while (*tail_string++ == *tail_substr++);
  }

  return(NULL);
}

/*  strtok(3)
 *
 *  Author: Terrence W. Holm          July 1988
 *
 *
 *  This function is used to divide up a string into tokens.
 *  Strtok(3) is called with <string> pointing to the string
 *  to be scanned and <char_set> pointing to a string which
 *  consists of the set of separator characters. Tokens are
 *  substrings bordered by separator characters. A pointer to
 *  the first token encountered is returned. If <string> is
 *  NULL then the scan is continued from the last token
 *  returned. Each token is terminated by a '\0'. If there are
 *  no tokens remaining in the string then NULL is returned.
 */

char *strtok(string, char_set)
  char *string;
  char *char_set;
{
  static char   *last_string = "";
  register char *chr;
  char          *next_token;

  if (string == NULL)
    string = last_string;

  if (char_set == NULL)
    return(NULL);


  /*  First skip over any separator characters  */

  while (*string != '\0') {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*string == *chr)
        break;

      if (*chr == '\0')
        break;

      ++string;
  }


  /*  Check if we have reached the end of the string  */

  if (*string == '\0')
    return(NULL);

  /*  If not, then we have found the next token  */

  next_token = string;


  /*  Scan for the end of this token  */

  while (*string != '\0') {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*string == *chr) {
        *string = '\0';
        last_string = string + 1;
        return(next_token);
      }

      ++string;
  }

  last_string = string;
  return(next_token);
 }


      ++string;
  }


  /*  Check if we have reached the end of the string  */

  if (*string == '\0')
    return(NULL);

  /*  If not, then we have found the next token  */

  next_token = string;


  /*  Scan for the end of this tokentptype.c                                                                                            000600  000000  000000  00000003035 04542747464 006267                                                                                                                                                                                                                                                                                                                                                                      #include <stdio.h>
#include <strings.h>

#define DEFAULT_PTYPES "/dd/SYS/printertypes"
#define DEFAULT_TTYPES "/dd/SYS/termtypes"

/*
 * g e t e n t r y
 */
static char *getentry(fp, port)
  FILE *fp;
  char *port;
{
  char          buf[100];
  register char *cp;

  if (port[0] == '/')
    port++;
  
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    if ((cp = index(buf, '\n')) != NULL)
      *cp = '\0';

    if (buf[0] == '\0' || buf[0] == '#' || buf[0] == '*')
      continue;
    
    for (cp = buf; *cp != '\0' && *cp != ' ' && *cp != '\t'; cp++) ;
    
    if (*cp == '\0')
      if (!strcmp(buf, port))
        return(NULL);
      else
        continue;

    *cp++ = '\0';
    if (strcmp(buf, port))
      continue;
    
    for (; *cp == ' ' || *cp == '\t'; cp++) ;

    if (*cp == '\0')
      return(NULL);
    
    return(cp);
  }
  
  return(NULL);
}

/*
 * t e r m t y p e
 */
char *termtype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("termtypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_TTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);  

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

/*
 * p r i n t e r t y p e
 */
char *printertype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("printertypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_PTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

y(filename, DEFAULT_TTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);  

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

/*
 * p r i n t e r t y p e
 */
char *printertype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("printertypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_PTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);

  type = getentry(fp, port);
  fcttynam.c                                                                                            000604  000000  000000  00000003063 04542747464 006263                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  ttynam()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <sgstat.h>

static char line[80];

/*
 * t t y n a m e
 */
char *ttyname(path)
  int path;
{
  struct _sgs OptBuf;

  /*
   * Devicenamen holen. Wenn die Device-Class nicht 0 (SCF) ist,
   * dann auch Fehler
   */
  if (_gs_devn(path, line) < 0)
    return(NULL);
  else
    if (_gs_opt(path, &OptBuf) < 0)
      return(NULL);
    else
      if (OptBuf._sgs_class != 0)   /* SCF-Device?? */
        return(NULL);
      else
        return(line);
}
--------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <sgstat.h>

static char line[80];

/*
 * t t y n a m e
 */
char *ttyname(path)
  int path;
{
  struct _sgs OptBuf;

  /*
   * Devicenamen holen. Wenn die Device-Class nicht 0 (SCF) ist,
   * dann auch Fehler
   */
  if (_gs_devn(path, line) < 0)
    return(NULL);
  else
    if (_gs_opt(path, &OptBuf) < 0)
      return(NULL);
    else
      if (OptBuf._sgs_class != 0)   /* SCF-Device?? */
      umask.c                                                                                             000604  000000  000000  00000000110 04542747464 006055                                                                                                                                                                                                                                                                                                                                                                      /*
 * u m a s k
 *
 * Only a dummy ...
 */
int umask()
{
  return(0);
}
 PATCHLEVEL 1

#include <stdio.h>
#include <sgstat.h>

static char line[80];

/*
 * t t y n a m e
 */
char *ttyname(path)
  int path;
{
  struct _sgs OptBuf;

  /*
   * Devicenamen holen. Wenn die Device-Class nicht 0 (SCF) ist,
   * dann auch Fehler
   */
  if (_gs_devn(path, line) < 0)
    return(NULL);
  else
    if (_gs_opt(path, &OptBuf) < 0)
      return(NULL);
    else
      if (OptBuf._sgs_class != 0)   /* SCF-Device?? */
      utime.c                                                                                             000604  000000  000000  00000002004 04542747464 006064                                                                                                                                                                                                                                                                                                                                                                      /*
 * Copyright (c) 1988 by Michael Hoffmann, Muenchen
 */

#include <stdio.h>
#include <direct.h>
#include <stat.h>
#include <modes.h>

/*
 * u t i m e
 */
int utime(file, timep)
  char   *file;
  time_t timep[2];
{
  struct tm     *localtime();
  struct tm     *tbuf;
  int           fd;
  struct fildes buf;
  struct stat   st;
  int           flag;

  flag = 0;

  stat(file, &st);
  if (st.st_mode & S_IFDIR)
    flag = S_IFDIR;

  if ((fd = open (file, S_IREAD | S_IWRITE | flag)) < 0)
    return -1;

  if (_gs_gfd(fd, &buf, sizeof(struct fildes)) < 0) {
    close (fd);
    return(-1);
  }

  tbuf = localtime(&(timep[1]));

  sprintf(buf.fd_date, "%c%c%c%c%c", (char) tbuf->tm_year,
                                     (char) tbuf->tm_mon+1,
                                     (char) tbuf->tm_mday,
                                     (char) tbuf->tm_hour,
                                     (char) tbuf->tm_min);

  if (_ss_pfd(fd, &buf) < 0) {
    close(fd);
    return(-1);
  }

  close(fd);
  return(0);
}



s_gfd(fd, &buf, sizeof(struct fildes)) < 0) {
    close (fd);
    return(-1);
  }

  tbuf = localtime(&(timep[1]));

  sprintf(buf.fd_date, "%c%c%c%c%c", (char) tbuf->tm_year,
                                     (char) tbuf->tm_mon+1,
                                     (char) tbuf->tm_mday,
                                     (char) tbuf->tm_hour,
                                     (char) tbuf->tm_min);

  if (_ss_pfd(fd, &buf) < 0) {
    close(fd);
    return(-1);
  }

  close(fd);
  return(0);
}utls.a                                                                                              000600  000000  000000  00000001477 04542747464 005737                                                                                                                                                                                                                                                                                                                                                                      S$Alarm equ 5

 psect utls,0,0,0,0,0

 ifdef OSK_V2.2
_setalarm:
 movem.l d2/d3,-(a7)
 move.l d0,d3 ; Zeit
 moveq.l #0,d0
 moveq.l #A$Set,d1
 moveq.l #S$Alarm,d2 ; Signal-Code
 bra.s alarm

_setrepalarm:
 movem.l d2/d3,-(a7)
 move.l d0,d3 ; Zeit
 moveq.l #0,d0
 moveq.l #A$Cycle,d1
 moveq.l #S$Alarm,d2 ; Signal-Code
 bra.s alarm


_delalarm:
 movem.l d2/d3,-(a7)
 moveq.l #0,d0
 moveq.l #A$Delete,d1
 
alarm
 OS9 F$Alarm
 bcs.s err

 moveq.l #0,d0
 movem.l (a7)+,d2/d3
 rts 

err
 movem.l (a7)+,d2/d3

err2
 and.l #$00ffff,d1
 move.l d1,errno(a6)

 moveq.l #-1,d0
 rts

**********
* sigmask
*
* only needed on 2.2 systems
*
sigmask:
 move.l d0,d1
 moveq.l #0,d0
 OS9 F$SigMask
 bcs.s err2
 moveq.l #0,d0
 rts

 endc

***********
* _ss_break
*
_ss_break:
 moveq.l #SS_Break,d1
 OS9 I$SetStt
 bcs.s err2

 moveq.l #0,d0
 rts
 ends

ra.s alarm


_delalarm:
 movem.l d2/d3,-(a7)
 moveq.l #0,d0
 moveq.l #A$Delete,d1
 
alarm
 OS9 F$Alarm
 bcs.s err

 moveq.l #0,d0
 movem.l (a7)+,d2/d3
 rts 

err
 movem.l (a7)+,d2/d3

err2
 andutmp.c                                                                                              000600  000000  000000  00000016112 04542747464 005727                                                                                                                                                                                                                                                                                                                                                                      /* ------------------------------------------------------------------- *
 |
 | OS9Lib:  utmp and wtmp routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <utmp.h>
#include <strings.h>
#include <ctype.h>
#include <sgstat.h>

static struct utmp ut;
static FILE        *_fpw = NULL;
static char        *utmp_file = UTMP_FILE;

#define PID  1
#define LINE 2

#define TRUE  1
#define FALSE 0

extern char *gethostname();

/*
 * _ i n s e r t
 */
static int _insert(utmp, stat, flag)
  register struct utmp *utmp;
  char                 *stat;
  int                  flag;
{
  register FILE *fp;
  register int  pos;
  int           itmp;
  int           new, ok;
  struct utmp   u;
  int           first;
  char          line[33];
  register char *status, *cp;
	
  pos = first = 0;

  if ((fp = fopen(utmp_file, "r+")) == NULL)
    if ((fp = fopen(utmp_file, "w")) == NULL)
      return(-1);
    else
      first = TRUE;
  else {
    new = ok = FALSE;

    if (flag != LINE) {
      _gs_devn(0, line+1);
      line[0] = '/';
    }
    else
      strcpy(line, utmp->ut_line);

    while (!new && !(new = !fread(&u, sizeof(struct utmp), 1, fp)))
      switch (flag) {
        case NULL:
          if (u.ut_type == EMPTY)
            new = 1;
          else
            pos += sizeof(struct utmp);
          break;

        case PID:
          if (u.ut_pid == utmp->ut_pid)
            new = ok = 1;
          else
            pos += sizeof(struct utmp);
          break;

        case LINE:
        default:
          if (!strcmp(u.ut_line, line)) 
            new = ok = 1;
          else
            pos += sizeof(struct utmp);
          break;
      }

    fseek(fp, pos, 0);
  }

  if (stat) {
    if (!ok) {
      fclose(fp);
      return(-1);
    }

    status = u.ut_status;
    while (*stat) {
      if (cp = index(status, tolower(*stat)))
        *cp = *stat;
      else 
        if (cp = index(status, toupper(*stat)))
          *cp = *stat;
        else 
          if (strlen(status) < 9) {
            itmp = strlen(status);
            status[itmp]   = *stat;
            status[itmp+1] = '\0';
          }
      ++stat;
    }
    fwrite (&u, sizeof(struct utmp), 1, fp);
  }
  else
    fwrite(utmp, sizeof(struct utmp), 1, fp);

  fclose(fp);
  if (first)
    chmod(utmp_file, 013);
  return(0);
}

/*
 * _ c l e a r
 */
static _clear(utmp)
  register struct utmp *utmp;
{
  struct        utmp u;
  register FILE *fp;
  register int  pos;
  register int  ok, found;
	
  ok = found = FALSE;
  endwhoent();

  if (!(fp = fopen(utmp_file, "r+")))
    return(-1);

  pos = 0;
  while (!ok && !(ok = !fread(&u, sizeof(struct utmp), 1, fp)))
    if (u.ut_type == USER_PROCESS && u.ut_pid == utmp->ut_pid)
      ok = found = TRUE;
    else
      pos += sizeof(struct utmp);

  if (!found) {
    fclose(fp);
    return(-1);
  }

  fseek(fp, pos, 0);
  u.ut_type = EMPTY;
  fwrite(&u, sizeof(struct utmp), 1, fp);
  fclose(fp);
  return(0);
}

/*
 * _ u t m p _ s t a t
 */
_utmp_stat(stat)
  register char *stat;
{
  if (stat)
    return(_insert(&ut, stat, LINE+1));
  else
    return(-1);
}

/*
 * _ u t m p _ w r i t e
 */
_utmp_write(type, name, line, pid, status, uid, gid)
  register      int type;
  register char *name, *line;
  int           pid;
  register char *status;
  int           uid, gid;
{
  char          hostname[20];
  register char *cp;
  struct sgbuf  buf;
	
  if (type == BOOT_TIME) {
    if ((cp = gethostname(hostname, sizeof(hostname))) != NULL)
      strcpy(ut.ut_user, cp);
    else
      strcpy(ut.ut_user, BOOT_MSG);

    strcpy(ut.ut_line, "boot-time");
    ut.ut_pid     = 0;
    ut.ut_type    = type;
    strcpy(ut.ut_id, "btt");
    ut.ut_uid     = ut.ut_gid = 0;
    ut.ut_baud    = -1;
    *ut.ut_status = '\0';
  }
  else
    if (type == RUN_LVL) {
      strcpy (ut.ut_line, "run-level");
      strcpy (ut.ut_user, name);
      ut.ut_pid = getpid ();
      ut.ut_type = type;
      strcpy (ut.ut_id, "rlv");
      ut.ut_uid     = ut.ut_gid = 0;
      ut.ut_baud    = -1;
      *ut.ut_status = '\0';
    }
    else {
      strcpy(ut.ut_user, name);
      strcpy(ut.ut_line, line);
      ut.ut_pid  = pid;
      ut.ut_type = type;
      cp = line;

      while (*cp && !isdigit(*cp))
        ++cp;

      if (*cp == '\0') {
        cp = "0";
        ut.ut_baud = -1;
      }
      else {
        _gs_opt(0, &buf);
        ut.ut_baud = buf.sg_baud;
      }

      if (type == USER_PROCESS) {
        ut.ut_uid = uid;
        ut.ut_gid = gid;
      }
      else
        ut.ut_uid = ut.ut_gid = 0;

      strncpy(ut.ut_id, cp, 3);
      strncpy(ut.ut_status, status, 9);
    }

  time(&ut.ut_time);

  if (type == EMPTY)
    return(_clear(&ut));
  else
    if (*ut.ut_line)
      return(_insert(&ut, NULL, LINE));
    else
      return(_insert(&ut, NULL, NULL));
}

/*
 * s e t w h o e n t
 */
setwhoent()
{
  if (_fpw == NULL) {
    if (!(_fpw = fopen(utmp_file, "r")))
      return(-1);
    else
      return(0);
  } 
  else 
    return(fseek(_fpw, 0, 0));
}

/*
 * g e t w h o e n t
 */
struct utmp *getwhoent()
{
  if (_fpw == NULL)
    if (setwhoent())
      return(NULL);

  if (!fread(&ut, sizeof(struct utmp), 1, _fpw))
    return(NULL);
  return(&ut);
}

/*
 * e n d w h o e n t
 */
int endwhoent()
{
  if (_fpw)
    fclose(_fpw);
  _fpw = NULL;
  return(0);
}

/*
 * g e t u t e n t
 */
struct utmp *getutent()
{
  return(getwhoent());
}

/*
 * s e t u t e n t
 */
setutent()
{
  return(setwhoent());
}

/*
 * e n d u t e n t
 */
int endutent()
{
  return(endwhoent());
}

/*
 * g e t u t i d
 */
struct utmp *getutid(id)
  register struct utmp *id;
{
  register struct utmp *utmp;
	
  setutent();
  while (utmp = getutent()) 
    if (utmp->ut_type == id->ut_type)
      break;

   return(utmp);
}

/*
 * g e t u t l i n e
 */
struct utmp *getutline(line)
  register struct utmp *line;
{
  register struct utmp *utmp;
	
  while (utmp = getutent())
    if (!strcmp(utmp->ut_line, line->ut_line))
      break;

  return(utmp);
}

/*
 * p u t u t l i n e
 */
pututline(utmp)
  register struct utmp *utmp;
{
  return(_insert(utmp, NULL, LINE));
}

/*
 * u t m p n a m e
 */
int utmpname (file)
  register char *file;
{
  utmp_file = file;

  if (_fpw)
    fclose (_fpw);
  return(0);
}

break;

   return(utmp);
}

/*
 * g e t u t l i n e
 */
struct utmp *getutline(line)
  register struct utmp *line;
{
  register struct utmp *utmp;
	
  while (utmp = getutent())
    if (!strcmp(utmp->ut_line, line->ut_line))
      break;

  return(utmp);
}

/*
 * p u t u t l i n e
 */
pututline(utmp)
  register struct utmp *utmp;
{
  return(_insert(utmp, NULL, LINE));
}

/*
 * u t m p n a m e
 */
int utmpname (file)
  register char *fi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                