/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  utmp and wtmp routines
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <time.h>
#include <utmp.h>
#include <strings.h>
#include <ctype.h>
#include <sgstat.h>

static struct utmp ut;
static FILE        *_fpw = NULL;
static char        *utmp_file = UTMP_FILE;

#define PID  1
#define LINE 2

#define TRUE  1
#define FALSE 0

extern char *gethostname();

/*
 * _ i n s e r t
 */
static int _insert(utmp, stat, flag)
  register struct utmp *utmp;
  char                 *stat;
  int                  flag;
{
  register FILE *fp;
  register int  pos;
  int           itmp;
  int           new, ok;
  struct utmp   u;
  int           first;
  char          line[33];
  register char *status, *cp;
	
  pos = first = 0;

  if ((fp = fopen(utmp_file, "r+")) == NULL)
    if ((fp = fopen(utmp_file, "w")) == NULL)
      return(-1);
    else
      first = TRUE;
  else {
    new = ok = FALSE;

    if (flag != LINE) {
      _gs_devn(0, line+1);
      line[0] = '/';
    }
    else
      strcpy(line, utmp->ut_line);

    while (!new && !(new = !fread(&u, sizeof(struct utmp), 1, fp)))
      switch (flag) {
        case NULL:
          if (u.ut_type == EMPTY)
            new = 1;
          else
            pos += sizeof(struct utmp);
          break;

        case PID:
          if (u.ut_pid == utmp->ut_pid)
            new = ok = 1;
          else
            pos += sizeof(struct utmp);
          break;

        case LINE:
        default:
          if (!strcmp(u.ut_line, line)) 
            new = ok = 1;
          else
            pos += sizeof(struct utmp);
          break;
      }

    fseek(fp, pos, 0);
  }

  if (stat) {
    if (!ok) {
      fclose(fp);
      return(-1);
    }

    status = u.ut_status;
    while (*stat) {
      if (cp = index(status, tolower(*stat)))
        *cp = *stat;
      else 
        if (cp = index(status, toupper(*stat)))
          *cp = *stat;
        else 
          if (strlen(status) < 9) {
            itmp = strlen(status);
            status[itmp]   = *stat;
            status[itmp+1] = '\0';
          }
      ++stat;
    }
    fwrite (&u, sizeof(struct utmp), 1, fp);
  }
  else
    fwrite(utmp, sizeof(struct utmp), 1, fp);

  fclose(fp);
  if (first)
    chmod(utmp_file, 013);
  return(0);
}

/*
 * _ c l e a r
 */
static _clear(utmp)
  register struct utmp *utmp;
{
  struct        utmp u;
  register FILE *fp;
  register int  pos;
  register int  ok, found;
	
  ok = found = FALSE;
  endwhoent();

  if (!(fp = fopen(utmp_file, "r+")))
    return(-1);

  pos = 0;
  while (!ok && !(ok = !fread(&u, sizeof(struct utmp), 1, fp)))
    if (u.ut_type == USER_PROCESS && u.ut_pid == utmp->ut_pid)
      ok = found = TRUE;
    else
      pos += sizeof(struct utmp);

  if (!found) {
    fclose(fp);
    return(-1);
  }

  fseek(fp, pos, 0);
  u.ut_type = EMPTY;
  fwrite(&u, sizeof(struct utmp), 1, fp);
  fclose(fp);
  return(0);
}

/*
 * _ u t m p _ s t a t
 */
_utmp_stat(stat)
  register char *stat;
{
  if (stat)
    return(_insert(&ut, stat, LINE+1));
  else
    return(-1);
}

/*
 * _ u t m p _ w r i t e
 */
_utmp_write(type, name, line, pid, status, uid, gid)
  register      int type;
  register char *name, *line;
  int           pid;
  register char *status;
  int           uid, gid;
{
  char          hostname[20];
  register char *cp;
  struct sgbuf  buf;
	
  if (type == BOOT_TIME) {
    if ((cp = gethostname(hostname, sizeof(hostname))) != NULL)
      strcpy(ut.ut_user, cp);
    else
      strcpy(ut.ut_user, BOOT_MSG);

    strcpy(ut.ut_line, "boot-time");
    ut.ut_pid     = 0;
    ut.ut_type    = type;
    strcpy(ut.ut_id, "btt");
    ut.ut_uid     = ut.ut_gid = 0;
    ut.ut_baud    = -1;
    *ut.ut_status = '\0';
  }
  else
    if (type == RUN_LVL) {
      strcpy (ut.ut_line, "run-level");
      strcpy (ut.ut_user, name);
      ut.ut_pid = getpid ();
      ut.ut_type = type;
      strcpy (ut.ut_id, "rlv");
      ut.ut_uid     = ut.ut_gid = 0;
      ut.ut_baud    = -1;
      *ut.ut_status = '\0';
    }
    else {
      strcpy(ut.ut_user, name);
      strcpy(ut.ut_line, line);
      ut.ut_pid  = pid;
      ut.ut_type = type;
      cp = line;

      while (*cp && !isdigit(*cp))
        ++cp;

      if (*cp == '\0') {
        cp = "0";
        ut.ut_baud = -1;
      }
      else {
        _gs_opt(0, &buf);
        ut.ut_baud = buf.sg_baud;
      }

      if (type == USER_PROCESS) {
        ut.ut_uid = uid;
        ut.ut_gid = gid;
      }
      else
        ut.ut_uid = ut.ut_gid = 0;

      strncpy(ut.ut_id, cp, 3);
      strncpy(ut.ut_status, status, 9);
    }

  time(&ut.ut_time);

  if (type == EMPTY)
    return(_clear(&ut));
  else
    if (*ut.ut_line)
      return(_insert(&ut, NULL, LINE));
    else
      return(_insert(&ut, NULL, NULL));
}

/*
 * s e t w h o e n t
 */
setwhoent()
{
  if (_fpw == NULL) {
    if (!(_fpw = fopen(utmp_file, "r")))
      return(-1);
    else
      return(0);
  } 
  else 
    return(fseek(_fpw, 0, 0));
}

/*
 * g e t w h o e n t
 */
struct utmp *getwhoent()
{
  if (_fpw == NULL)
    if (setwhoent())
      return(NULL);

  if (!fread(&ut, sizeof(struct utmp), 1, _fpw))
    return(NULL);
  return(&ut);
}

/*
 * e n d w h o e n t
 */
int endwhoent()
{
  if (_fpw)
    fclose(_fpw);
  _fpw = NULL;
  return(0);
}

/*
 * g e t u t e n t
 */
struct utmp *getutent()
{
  return(getwhoent());
}

/*
 * s e t u t e n t
 */
setutent()
{
  return(setwhoent());
}

/*
 * e n d u t e n t
 */
int endutent()
{
  return(endwhoent());
}

/*
 * g e t u t i d
 */
struct utmp *getutid(id)
  register struct utmp *id;
{
  register struct utmp *utmp;
	
  setutent();
  while (utmp = getutent()) 
    if (utmp->ut_type == id->ut_type)
      break;

   return(utmp);
}

/*
 * g e t u t l i n e
 */
struct utmp *getutline(line)
  register struct utmp *line;
{
  register struct utmp *utmp;
	
  while (utmp = getutent())
    if (!strcmp(utmp->ut_line, line->ut_line))
      break;

  return(utmp);
}

/*
 * p u t u t l i n e
 */
pututline(utmp)
  register struct utmp *utmp;
{
  return(_insert(utmp, NULL, LINE));
}

/*
 * u t m p n a m e
 */
int utmpname (file)
  register char *file;
{
  utmp_file = file;

  if (_fpw)
    fclose (_fpw);
  return(0);
}

