/*
 * Copyright (c) 1988 by Michael Hoffmann, Muenchen
 */

#include <stdio.h>
#include <direct.h>
#include <stat.h>
#include <modes.h>

/*
 * u t i m e
 */
int utime(file, timep)
  char   *file;
  time_t timep[2];
{
  struct tm     *localtime();
  struct tm     *tbuf;
  int           fd;
  struct fildes buf;
  struct stat   st;
  int           flag;

  flag = 0;

  stat(file, &st);
  if (st.st_mode & S_IFDIR)
    flag = S_IFDIR;

  if ((fd = open (file, S_IREAD | S_IWRITE | flag)) < 0)
    return -1;

  if (_gs_gfd(fd, &buf, sizeof(struct fildes)) < 0) {
    close (fd);
    return(-1);
  }

  tbuf = localtime(&(timep[1]));

  sprintf(buf.fd_date, "%c%c%c%c%c", (char) tbuf->tm_year,
                                     (char) tbuf->tm_mon+1,
                                     (char) tbuf->tm_mday,
                                     (char) tbuf->tm_hour,
                                     (char) tbuf->tm_min);

  if (_ss_pfd(fd, &buf) < 0) {
    close(fd);
    return(-1);
  }

  close(fd);
  return(0);
}



