#include <stdio.h>
#include <strings.h>

#define DEFAULT_PTYPES "/dd/SYS/printertypes"
#define DEFAULT_TTYPES "/dd/SYS/termtypes"

/*
 * g e t e n t r y
 */
static char *getentry(fp, port)
  FILE *fp;
  char *port;
{
  char          buf[100];
  register char *cp;

  if (port[0] == '/')
    port++;
  
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    if ((cp = index(buf, '\n')) != NULL)
      *cp = '\0';

    if (buf[0] == '\0' || buf[0] == '#' || buf[0] == '*')
      continue;
    
    for (cp = buf; *cp != '\0' && *cp != ' ' && *cp != '\t'; cp++) ;
    
    if (*cp == '\0')
      if (!strcmp(buf, port))
        return(NULL);
      else
        continue;

    *cp++ = '\0';
    if (strcmp(buf, port))
      continue;
    
    for (; *cp == ' ' || *cp == '\t'; cp++) ;

    if (*cp == '\0')
      return(NULL);
    
    return(cp);
  }
  
  return(NULL);
}

/*
 * t e r m t y p e
 */
char *termtype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("termtypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_TTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);  

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

/*
 * p r i n t e r t y p e
 */
char *printertype(port)
  char *port;
{
  FILE *fp;
  char filename[200];
  char *type;

  if (info_str("printertypes", filename, sizeof(filename)) == NULL)
    strcpy(filename, DEFAULT_PTYPES);
  
  if ((fp = fopen(filename, "r")) == NULL)
    return(NULL);

  type = getentry(fp, port);
  fclose(fp);
  return(type);
}

