#include <stdio.h>
#include <strings.h>

/*  strcspn(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  This function determines the length of a span from the
 *  beginning of <string> which contains none of the
 *  characters specified in <char_set>. The length of the
 *  span is returned.
 */


int strcspn(string, char_set)
  char *string;
  char *char_set;
{
  register char *str;
  register char *chr;

  if (string == NULL)
    return(0);

  if (char_set == NULL)
    return(strlen(string));

  for (str = string; *str != '\0'; ++str)
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*str == *chr)
        return(str - string);

  return(str - string);
}



/*  strpbrk(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  Strpbrk(3) scans <string> for the first occurrence of a
 *  character from the string <char_set>. If a character from
 *  the <char_set> was found then a pointer to it within
 *  <string> is returned, otherwise NULL is returned.
 */

char *strpbrk(string, char_set)
  char *string;
  char *char_set;
{
  register char  c;
  register char *p;

  if (string == NULL || char_set == NULL)
    return(NULL);

  while ((c = *string++) != '\0')
    for (p = char_set; *p != '\0'; ++p)
      if (c == *p)
        return(string - 1);

  return(NULL);
}



/*  strspn(3)
 *
 *  Author:  Terrence W. Holm          July 1988
 *
 *
 *  This function determines the length of a span from the
 *  beginning of <string> which contains only characters
 *  specified in <char_set>. The length of the span is
 *  returned.
 */

int strspn(string, char_set)
  char *string;
  char *char_set;
{
  register char *str;
  register char *chr;

  if (string == NULL || char_set == NULL)
    return(0);

  for (str = string; *str != '\0'; ++str) {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*str == *chr)
        break;

    if (*chr == '\0')
      return(str - string);
  }

  return(str - string);
}


/*  strstr(3)
 *
 *  Author: Terrence W. Holm          July 1988
 *
 *
 *  Finds the first occurrence of a substring, pointed to by
 *  <substr>, within a string pointed to by <string>.
 *  If the substring is found then a pointer to it within
 *  <string> is returned, otherwise NULL is returned.
 */


char *strstr(string, substr)
  char *string;
  char *substr;
{
  register char head_string;
  register char head_substr;

  if (string == NULL || substr == NULL)
    return(NULL);

  head_substr = *substr++;

  while ((head_string = *string++) != '\0')
    if (head_string == head_substr) {
      register char *tail_string = string;
      register char *tail_substr = substr;

      do {
        if (*tail_substr == '\0')
          return(string - 1);
      } while (*tail_string++ == *tail_substr++);
  }

  return(NULL);
}

/*  strtok(3)
 *
 *  Author: Terrence W. Holm          July 1988
 *
 *
 *  This function is used to divide up a string into tokens.
 *  Strtok(3) is called with <string> pointing to the string
 *  to be scanned and <char_set> pointing to a string which
 *  consists of the set of separator characters. Tokens are
 *  substrings bordered by separator characters. A pointer to
 *  the first token encountered is returned. If <string> is
 *  NULL then the scan is continued from the last token
 *  returned. Each token is terminated by a '\0'. If there are
 *  no tokens remaining in the string then NULL is returned.
 */

char *strtok(string, char_set)
  char *string;
  char *char_set;
{
  static char   *last_string = "";
  register char *chr;
  char          *next_token;

  if (string == NULL)
    string = last_string;

  if (char_set == NULL)
    return(NULL);


  /*  First skip over any separator characters  */

  while (*string != '\0') {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*string == *chr)
        break;

      if (*chr == '\0')
        break;

      ++string;
  }


  /*  Check if we have reached the end of the string  */

  if (*string == '\0')
    return(NULL);

  /*  If not, then we have found the next token  */

  next_token = string;


  /*  Scan for the end of this token  */

  while (*string != '\0') {
    for (chr = char_set; *chr != '\0'; ++chr)
      if (*string == *chr) {
        *string = '\0';
        last_string = string + 1;
        return(next_token);
      }

      ++string;
  }

  last_string = string;
  return(next_token);
 }
