/* ------------------------------------------------------------------- *
 |
 | OS9Lib:  stat(), fstat()
 |
 |
 |     Copyright (c) 1988 by Wolfgang Ocker, Puchheim,
 |                           Ulli Dessauer, Germering and
 |                           Reimer Mellin, Muenchen
 |                           (W-Germany)
 |
 |  This  programm can  be  copied and  distributed freely  for any
 |  non-commercial  purposes.   It can only  be  incorporated  into
 |  commercial software with the written permission of the authors.
 |
 |  If you should modify this program, the authors would appreciate
 |  a notice about the changes. Please send a (context) diff or the
 |  complete source to:
 |
 |  address:     Wolfgang Ocker
 |               Lochhauserstrasse 35a
 |               D-8039 Puchheim
 |               West Germany
 |
 |  e-mail:      weo@altger.UUCP, ud@altger.UUCP, ram@altger.UUCP
 |               pyramid!tmpmbx!recco!weo
 |               pyramid!tmpmbx!nitmar!ud
 |               pyramid!tmpmbx!ramsys!ram
 |
 * ----------------------------------------------------------------- */

#define PATCHLEVEL 1

#include <stdio.h>
#include <direct.h>
#include <stat.h>
#include <modes.h>
#include <sgstat.h>

/*
 * f s t a t
 */
int fstat(fd, buff)
  int         fd;
  struct stat *buff;
{
  struct fildes ftmp;
  struct tm     ttmp;
  struct _sgr   fopt;

  if (_gs_gfd(fd, &ftmp, sizeof(struct fildes)) < 0)
    return(-1);

  if (_gs_opt(fd, &fopt) < 0)
    return(-1);

  ttmp.tm_year  = (int) ftmp.fd_date[0];
  ttmp.tm_mon   = (int) ftmp.fd_date[1] - 1;
  ttmp.tm_mday  = (int) ftmp.fd_date[2];	
  ttmp.tm_hour  = (int) ftmp.fd_date[3];
  ttmp.tm_min   = (int) ftmp.fd_date[4];
  ttmp.tm_sec   = 0;
  ttmp.tm_isdst = -1;

  buff->st_atime = buff->st_mtime = mktime(&ttmp);

  ttmp.tm_year  = (int) ftmp.fd_dcr[0];
  ttmp.tm_mon   = (int) ftmp.fd_dcr[1] - 1;
  ttmp.tm_mday  = (int) ftmp.fd_dcr[2];	
  ttmp.tm_hour  = ttmp.tm_min = ttmp.tm_sec = 0;
  ttmp.tm_isdst = -1;
  
  buff->st_ctime = mktime(&ttmp);

  memcpy(&(buff->st_size), ftmp.fd_fsize, sizeof(long));  /* misalignment! */
  buff->st_uid   = ftmp.fd_own[1];
  buff->st_gid   = ftmp.fd_own[0];
  buff->st_mode  = ftmp.fd_att;
  buff->st_nlink = ftmp.fd_link;

  buff->st_ino   = fopt._sgr_fdpsn;
  buff->st_dev   = fopt._sgr_dvt;

  return(0);
}

/*
 * s t a t
 */	
int stat(filename, buff)
  char        *filename;
  struct stat *buff;
{
  register int i, ret;

  if ((i = open(filename, 0)) < 0)
    if ((i = open(filename, S_IFDIR)) < 0)
      return(-1);

  ret = fstat(i, buff);
  close(i);

  return(ret);
}

/*
 * g e t d t a b l e s i z e
 */
int getdtablesize()
{
  return(_NFILE);
}


